/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.project.MavenIgnoredFilesConfigurable;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.actions.MavenAction;
import org.jetbrains.idea.maven.utils.actions.MavenActionUtil;

public class ToggleIgnoredProjectsAction
extends MavenAction {
    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ToggleIgnoredProjectsAction.$$$reportNull$$$0(0);
        }
        super.update(e);
        if (!this.isAvailable(e)) {
            return;
        }
        DataContext context = e.getDataContext();
        MavenProjectsManager projectsManager = MavenActionUtil.getProjectsManager(context);
        if (projectsManager == null) {
            return;
        }
        List<MavenProject> projects = MavenActionUtil.getMavenProjects(context);
        if (ToggleIgnoredProjectsAction.isIgnoredInSettings(projectsManager, projects)) {
            e.getPresentation().setText(MavenProjectBundle.messagePointer("maven.ignore.edit", new Object[0]));
        } else if (ToggleIgnoredProjectsAction.isIgnored(projectsManager, projects)) {
            e.getPresentation().setText(MavenProjectBundle.messagePointer("maven.unignore", new Object[0]));
        } else {
            e.getPresentation().setText(MavenProjectBundle.messagePointer("maven.ignore", new Object[0]));
        }
    }

    @Override
    protected boolean isAvailable(@NotNull AnActionEvent e) {
        if (e == null) {
            ToggleIgnoredProjectsAction.$$$reportNull$$$0(1);
        }
        if (!super.isAvailable(e)) {
            return false;
        }
        DataContext context = e.getDataContext();
        MavenProjectsManager projectsManager = MavenActionUtil.getProjectsManager(context);
        if (projectsManager == null) {
            return false;
        }
        List<MavenProject> projects = MavenActionUtil.getMavenProjects(context);
        if (projects == null || projects.isEmpty()) {
            return false;
        }
        int ignoredStatesCount = 0;
        int ignoredCount = 0;
        for (MavenProject each : projects) {
            if (projectsManager.getIgnoredState(each)) {
                ++ignoredStatesCount;
            }
            if (!projectsManager.isIgnored(each)) continue;
            ++ignoredCount;
        }
        return !(ignoredCount != 0 && ignoredCount != projects.size() || ignoredStatesCount != 0 && ignoredStatesCount != projects.size());
    }

    private static boolean isIgnored(@NotNull MavenProjectsManager projectsManager, List<MavenProject> projects) {
        if (projectsManager == null) {
            ToggleIgnoredProjectsAction.$$$reportNull$$$0(2);
        }
        return projectsManager.getIgnoredState(projects.get(0));
    }

    private static boolean isIgnoredInSettings(@NotNull MavenProjectsManager projectsManager, List<MavenProject> projects) {
        if (projectsManager == null) {
            ToggleIgnoredProjectsAction.$$$reportNull$$$0(3);
        }
        return projectsManager.isIgnored(projects.get(0)) && !ToggleIgnoredProjectsAction.isIgnored(projectsManager, projects);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        DataContext context;
        MavenProjectsManager projectsManager;
        if (e == null) {
            ToggleIgnoredProjectsAction.$$$reportNull$$$0(4);
        }
        if ((projectsManager = MavenActionUtil.getProjectsManager(context = e.getDataContext())) == null) {
            return;
        }
        List<MavenProject> projects = MavenActionUtil.getMavenProjects(context);
        Project project = MavenActionUtil.getProject(context);
        if (project == null) {
            return;
        }
        if (ToggleIgnoredProjectsAction.isIgnoredInSettings(projectsManager, projects)) {
            ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)new MavenIgnoredFilesConfigurable(project));
        } else {
            projectsManager.setIgnoredState(projects, !ToggleIgnoredProjectsAction.isIgnored(projectsManager, projects));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectsManager";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/maven/project/actions/ToggleIgnoredProjectsAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isIgnored";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isIgnoredInSettings";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

