/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.converters.MavenConsumerPomUtil;
import org.jetbrains.idea.maven.model.MavenBuild;
import org.jetbrains.idea.maven.model.MavenBuildBase;
import org.jetbrains.idea.maven.model.MavenExplicitProfiles;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenModel;
import org.jetbrains.idea.maven.model.MavenModelBase;
import org.jetbrains.idea.maven.model.MavenParent;
import org.jetbrains.idea.maven.model.MavenProfile;
import org.jetbrains.idea.maven.model.MavenProfileActivation;
import org.jetbrains.idea.maven.model.MavenProfileActivationFile;
import org.jetbrains.idea.maven.model.MavenProfileActivationOS;
import org.jetbrains.idea.maven.model.MavenProfileActivationProperty;
import org.jetbrains.idea.maven.model.MavenProjectProblem;
import org.jetbrains.idea.maven.model.MavenResource;
import org.jetbrains.idea.maven.project.MavenConsole;
import org.jetbrains.idea.maven.project.MavenEmbeddersManager;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenImportingSettings;
import org.jetbrains.idea.maven.project.MavenParentDesc;
import org.jetbrains.idea.maven.project.MavenParentProjectFileProcessor;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.project.MavenProjectReaderProjectLocator;
import org.jetbrains.idea.maven.project.MavenProjectReaderResult;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.server.MavenEmbedderWrapper;
import org.jetbrains.idea.maven.server.MavenServerExecutionResult;
import org.jetbrains.idea.maven.server.MavenServerManager;
import org.jetbrains.idea.maven.server.ProfileApplicationResult;
import org.jetbrains.idea.maven.utils.MavenJDOMUtil;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;
import org.jetbrains.idea.maven.utils.MavenUtil;

public class MavenProjectReader {
    private static final String UNKNOWN = "Unknown";
    private final Map<VirtualFile, RawModelReadResult> myRawModelsCache;
    private final Project myProject;
    private SettingsProfilesCache mySettingsProfilesCache;

    public MavenProjectReader(@NotNull Project project) {
        if (project == null) {
            MavenProjectReader.$$$reportNull$$$0(0);
        }
        this.myRawModelsCache = new THashMap();
        this.myProject = project;
    }

    public MavenProjectReaderResult readProject(MavenGeneralSettings generalSettings, VirtualFile file, MavenExplicitProfiles explicitProfiles, MavenProjectReaderProjectLocator locator) {
        Pair<RawModelReadResult, MavenExplicitProfiles> readResult = this.doReadProjectModel(generalSettings, file, explicitProfiles, (Set<VirtualFile>)new THashSet(), locator);
        File basedir = MavenUtil.getBaseDir(file);
        MavenModel model2 = MavenServerManager.getInstance().getConnector(this.myProject).interpolateAndAlignModel(((RawModelReadResult)readResult.first).model, basedir);
        HashMap<String, String> modelMap = new HashMap<String, String>();
        modelMap.put("groupId", model2.getMavenId().getGroupId());
        modelMap.put("artifactId", model2.getMavenId().getArtifactId());
        modelMap.put("version", model2.getMavenId().getVersion());
        modelMap.put("build.outputDirectory", model2.getBuild().getOutputDirectory());
        modelMap.put("build.testOutputDirectory", model2.getBuild().getTestOutputDirectory());
        modelMap.put("build.finalName", model2.getBuild().getFinalName());
        modelMap.put("build.directory", model2.getBuild().getDirectory());
        return new MavenProjectReaderResult(model2, modelMap, (MavenExplicitProfiles)readResult.second, null, ((RawModelReadResult)readResult.first).problems, (Set<MavenId>)new THashSet());
    }

    private Pair<RawModelReadResult, MavenExplicitProfiles> doReadProjectModel(MavenGeneralSettings generalSettings, VirtualFile file, MavenExplicitProfiles explicitProfiles, Set<VirtualFile> recursionGuard, MavenProjectReaderProjectLocator locator) {
        RawModelReadResult cachedModel = this.myRawModelsCache.get(file);
        if (cachedModel == null) {
            cachedModel = this.doReadProjectModel(file, false);
            this.myRawModelsCache.put(file, cachedModel);
        }
        MavenModel model2 = cachedModel.model;
        Set<String> alwaysOnProfiles = cachedModel.alwaysOnProfiles;
        Collection<MavenProjectProblem> problems = cachedModel.problems;
        model2 = this.resolveInheritance(generalSettings, model2, file, explicitProfiles, recursionGuard, locator, problems);
        this.addSettingsProfiles(generalSettings, model2, alwaysOnProfiles, problems);
        ProfileApplicationResult applied = this.applyProfiles(model2, MavenUtil.getBaseDir(file), explicitProfiles, alwaysOnProfiles);
        model2 = applied.getModel();
        this.repairModelBody(model2);
        return Pair.create((Object)new RawModelReadResult(model2, problems, alwaysOnProfiles), (Object)applied.getActivatedProfiles());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RawModelReadResult doReadProjectModel(VirtualFile file, boolean headerOnly) {
        MavenParent parent;
        MavenModel result = null;
        Collection problems = MavenProjectProblem.createProblemsList();
        THashSet alwaysOnProfiles = new THashSet();
        String fileExtension = file.getExtension();
        if (!"pom".equalsIgnoreCase(fileExtension) && !"xml".equalsIgnoreCase(fileExtension)) {
            File basedir = MavenUtil.getBaseDir(file);
            MavenEmbeddersManager manager = MavenProjectsManager.getInstance(this.myProject).getEmbeddersManager();
            MavenEmbedderWrapper embedder = manager.getEmbedder(MavenEmbeddersManager.FOR_MODEL_READ, basedir.getPath(), basedir.getPath());
            try {
                result = embedder.readModel(VfsUtilCore.virtualToIoFile((VirtualFile)file));
            }
            catch (MavenProcessCanceledException mavenProcessCanceledException) {
            }
            finally {
                manager.release(embedder);
            }
            if (result == null) {
                result = new MavenModel();
                result.setPackaging("jar");
            }
            return new RawModelReadResult(result, problems, (Set<String>)alwaysOnProfiles);
        }
        result = new MavenModel();
        Element xmlProject = MavenProjectReader.readXml(file, problems, MavenProjectProblem.ProblemType.SYNTAX);
        if (xmlProject == null || !"project".equals(xmlProject.getName())) {
            result.setPackaging("jar");
            return new RawModelReadResult(result, problems, (Set<String>)alwaysOnProfiles);
        }
        if (MavenJDOMUtil.hasChildByPath(xmlProject, "parent")) {
            parent = new MavenParent(new MavenId(MavenJDOMUtil.findChildValueByPath(xmlProject, "parent.groupId", UNKNOWN), MavenJDOMUtil.findChildValueByPath(xmlProject, "parent.artifactId", UNKNOWN), this.calculateParentVersion(xmlProject, problems, file)), MavenJDOMUtil.findChildValueByPath(xmlProject, "parent.relativePath", "../pom.xml"));
            result.setParent(parent);
        } else {
            parent = new MavenParent(new MavenId(UNKNOWN, UNKNOWN, UNKNOWN), "../pom.xml");
        }
        result.setMavenId(new MavenId(MavenJDOMUtil.findChildValueByPath(xmlProject, "groupId", parent.getMavenId().getGroupId()), MavenJDOMUtil.findChildValueByPath(xmlProject, "artifactId", UNKNOWN), MavenJDOMUtil.findChildValueByPath(xmlProject, "version", parent.getMavenId().getVersion())));
        if (headerOnly) {
            return new RawModelReadResult(result, problems, (Set<String>)alwaysOnProfiles);
        }
        result.setPackaging(MavenJDOMUtil.findChildValueByPath(xmlProject, "packaging", "jar"));
        result.setName(MavenJDOMUtil.findChildValueByPath(xmlProject, "name"));
        MavenProjectReader.readModelBody((MavenModelBase)result, (MavenBuildBase)result.getBuild(), xmlProject);
        result.setProfiles(this.collectProfiles(file, xmlProject, problems, (Set<String>)alwaysOnProfiles));
        return new RawModelReadResult(result, problems, (Set<String>)alwaysOnProfiles);
    }

    @NotNull
    private String calculateParentVersion(Element xmlProject, Collection<MavenProjectProblem> problems, VirtualFile file) {
        String version = MavenJDOMUtil.findChildValueByPath(xmlProject, "parent.version");
        if (version != null || !MavenConsumerPomUtil.isConsumerPomResolutionApplicable(this.myProject)) {
            String string = StringUtil.notNullize((String)version, (String)UNKNOWN);
            if (string == null) {
                MavenProjectReader.$$$reportNull$$$0(1);
            }
            return string;
        }
        String parentGroupId = MavenJDOMUtil.findChildValueByPath(xmlProject, "parent.groupId");
        String parentArtifactId = MavenJDOMUtil.findChildValueByPath(xmlProject, "parent.artifactId");
        if (parentGroupId == null || parentArtifactId == null) {
            problems.add(new MavenProjectProblem(file.getPath(), MavenProjectBundle.message("consumer.pom.cannot.determine.parent.version", new Object[0]), MavenProjectProblem.ProblemType.STRUCTURE));
            return UNKNOWN;
        }
        VirtualFile parentFile = file.findFileByRelativePath("../../pom.xml");
        if (parentFile == null) {
            problems.add(new MavenProjectProblem(file.getPath(), MavenProjectBundle.message("consumer.pom.cannot.determine.parent.version", new Object[0]), MavenProjectProblem.ProblemType.STRUCTURE));
            return UNKNOWN;
        }
        Element parentXmlProject = MavenProjectReader.readXml(parentFile, problems, MavenProjectProblem.ProblemType.SYNTAX);
        version = MavenJDOMUtil.findChildValueByPath(parentXmlProject, "version");
        if (version != null) {
            String string = version;
            if (string == null) {
                MavenProjectReader.$$$reportNull$$$0(2);
            }
            return string;
        }
        return this.calculateParentVersion(parentXmlProject, problems, parentFile);
    }

    private static void readModelBody(MavenModelBase mavenModelBase, MavenBuildBase mavenBuildBase, Element xmlModel) {
        mavenModelBase.setModules(MavenJDOMUtil.findChildrenValuesByPath(xmlModel, "modules", "module"));
        MavenProjectReader.collectProperties(MavenJDOMUtil.findChildByPath(xmlModel, "properties"), mavenModelBase);
        Element xmlBuild = MavenJDOMUtil.findChildByPath(xmlModel, "build");
        mavenBuildBase.setFinalName(MavenJDOMUtil.findChildValueByPath(xmlBuild, "finalName"));
        mavenBuildBase.setDefaultGoal(MavenJDOMUtil.findChildValueByPath(xmlBuild, "defaultGoal"));
        mavenBuildBase.setDirectory(MavenJDOMUtil.findChildValueByPath(xmlBuild, "directory"));
        mavenBuildBase.setResources(MavenProjectReader.collectResources(MavenJDOMUtil.findChildrenByPath(xmlBuild, "resources", "resource")));
        mavenBuildBase.setTestResources(MavenProjectReader.collectResources(MavenJDOMUtil.findChildrenByPath(xmlBuild, "testResources", "testResource")));
        mavenBuildBase.setFilters(MavenJDOMUtil.findChildrenValuesByPath(xmlBuild, "filters", "filter"));
        if (mavenBuildBase instanceof MavenBuild) {
            String testSource;
            MavenBuild mavenBuild = (MavenBuild)mavenBuildBase;
            String source = MavenJDOMUtil.findChildValueByPath(xmlBuild, "sourceDirectory");
            if (!StringUtil.isEmptyOrSpaces((String)source)) {
                mavenBuild.addSource(source);
            }
            if (!StringUtil.isEmptyOrSpaces((String)(testSource = MavenJDOMUtil.findChildValueByPath(xmlBuild, "testSourceDirectory")))) {
                mavenBuild.addTestSource(testSource);
            }
            mavenBuild.setOutputDirectory(MavenJDOMUtil.findChildValueByPath(xmlBuild, "outputDirectory"));
            mavenBuild.setTestOutputDirectory(MavenJDOMUtil.findChildValueByPath(xmlBuild, "testOutputDirectory"));
        }
    }

    private static List<MavenResource> collectResources(List<Element> xmlResources) {
        ArrayList<MavenResource> result = new ArrayList<MavenResource>();
        for (Element each : xmlResources) {
            result.add(new MavenResource(MavenJDOMUtil.findChildValueByPath(each, "directory"), "true".equals(MavenJDOMUtil.findChildValueByPath(each, "filtering")), MavenJDOMUtil.findChildValueByPath(each, "targetPath"), MavenJDOMUtil.findChildrenValuesByPath(each, "includes", "include"), MavenJDOMUtil.findChildrenValuesByPath(each, "excludes", "exclude")));
        }
        return result;
    }

    private void repairModelBody(MavenModel model2) {
        MavenBuild build = model2.getBuild();
        if (StringUtil.isEmptyOrSpaces((String)build.getFinalName())) {
            build.setFinalName("${project.artifactId}-${project.version}");
        }
        if (build.getSources().isEmpty()) {
            build.addSource("src/main/java");
        }
        if (build.getTestSources().isEmpty()) {
            build.addTestSource("src/test/java");
        }
        build.setResources(this.repairResources(build.getResources(), "src/main/resources"));
        build.setTestResources(this.repairResources(build.getTestResources(), "src/test/resources"));
        build.setDirectory(StringUtil.isEmptyOrSpaces((String)build.getDirectory()) ? "target" : build.getDirectory());
        build.setOutputDirectory(StringUtil.isEmptyOrSpaces((String)build.getOutputDirectory()) ? "${project.build.directory}/classes" : build.getOutputDirectory());
        build.setTestOutputDirectory(StringUtil.isEmptyOrSpaces((String)build.getTestOutputDirectory()) ? "${project.build.directory}/test-classes" : build.getTestOutputDirectory());
    }

    private List<MavenResource> repairResources(List<MavenResource> resources, String defaultDir) {
        ArrayList<MavenResource> result = new ArrayList<MavenResource>();
        if (resources.isEmpty()) {
            result.add(this.createResource(defaultDir));
            return result;
        }
        for (MavenResource each : resources) {
            if (StringUtil.isEmptyOrSpaces((String)each.getDirectory())) continue;
            result.add(each);
        }
        return result;
    }

    private MavenResource createResource(String directory) {
        return new MavenResource(directory, false, null, Collections.emptyList(), Collections.emptyList());
    }

    private List<MavenProfile> collectProfiles(VirtualFile projectFile, Element xmlProject, Collection<MavenProjectProblem> problems, Set<String> alwaysOnProfiles) {
        ArrayList<MavenProfile> result = new ArrayList<MavenProfile>();
        this.collectProfiles(MavenJDOMUtil.findChildrenByPath(xmlProject, "profiles", "profile"), result, "pom");
        VirtualFile profilesFile = MavenUtil.findProfilesXmlFile(projectFile);
        if (profilesFile != null) {
            this.collectProfilesFromSettingsXmlOrProfilesXml(profilesFile, "profilesXml", true, "profiles.xml", result, alwaysOnProfiles, problems);
        }
        return result;
    }

    private void addSettingsProfiles(MavenGeneralSettings generalSettings, MavenModel model2, Set<String> alwaysOnProfiles, Collection<MavenProjectProblem> problems) {
        if (this.mySettingsProfilesCache == null) {
            ArrayList<MavenProfile> settingsProfiles = new ArrayList<MavenProfile>();
            Collection settingsProblems = MavenProjectProblem.createProblemsList();
            THashSet settingsAlwaysOnProfiles = new THashSet();
            for (VirtualFile each : generalSettings.getEffectiveSettingsFiles()) {
                this.collectProfilesFromSettingsXmlOrProfilesXml(each, "settings", false, "settings.xml", settingsProfiles, (Set<String>)settingsAlwaysOnProfiles, settingsProblems);
            }
            this.mySettingsProfilesCache = new SettingsProfilesCache(settingsProfiles, (Set<String>)settingsAlwaysOnProfiles, settingsProblems);
        }
        ArrayList<MavenProfile> modelProfiles = new ArrayList<MavenProfile>(model2.getProfiles());
        for (MavenProfile each : this.mySettingsProfilesCache.profiles) {
            this.addProfileIfDoesNotExist(each, modelProfiles);
        }
        model2.setProfiles(modelProfiles);
        problems.addAll(this.mySettingsProfilesCache.problems);
        alwaysOnProfiles.addAll(this.mySettingsProfilesCache.alwaysOnProfiles);
    }

    private void collectProfilesFromSettingsXmlOrProfilesXml(VirtualFile profilesFile, String rootElementName, boolean wrapRootIfNecessary, String profilesSource, List<MavenProfile> result, Set<String> alwaysOnProfiles, Collection<MavenProjectProblem> problems) {
        Element rootElement = MavenProjectReader.readXml(profilesFile, problems, MavenProjectProblem.ProblemType.SETTINGS_OR_PROFILES);
        if (rootElement == null) {
            return;
        }
        if (wrapRootIfNecessary && !rootElementName.equals(rootElement.getName())) {
            Element wrapper = new Element(rootElementName);
            wrapper.addContent(rootElement);
            rootElement = wrapper;
        }
        List<Element> xmlProfiles = MavenJDOMUtil.findChildrenByPath(rootElement, "profiles", "profile");
        this.collectProfiles(xmlProfiles, result, profilesSource);
        alwaysOnProfiles.addAll(MavenJDOMUtil.findChildrenValuesByPath(rootElement, "activeProfiles", "activeProfile"));
    }

    private void collectProfiles(List<Element> xmlProfiles, List<MavenProfile> result, String source) {
        for (Element each : xmlProfiles) {
            MavenProfile profile;
            String id = MavenJDOMUtil.findChildValueByPath(each, "id");
            if (StringUtil.isEmptyOrSpaces((String)id) || !this.addProfileIfDoesNotExist(profile = new MavenProfile(id, source), result)) continue;
            Element xmlActivation = MavenJDOMUtil.findChildByPath(each, "activation");
            if (xmlActivation != null) {
                Element xmlFile;
                MavenProfileActivation activation = new MavenProfileActivation();
                activation.setActiveByDefault("true".equals(MavenJDOMUtil.findChildValueByPath(xmlActivation, "activeByDefault")));
                Element xmlOS = MavenJDOMUtil.findChildByPath(xmlActivation, "os");
                if (xmlOS != null) {
                    activation.setOs(new MavenProfileActivationOS(MavenJDOMUtil.findChildValueByPath(xmlOS, "name"), MavenJDOMUtil.findChildValueByPath(xmlOS, "family"), MavenJDOMUtil.findChildValueByPath(xmlOS, "arch"), MavenJDOMUtil.findChildValueByPath(xmlOS, "version")));
                }
                activation.setJdk(MavenJDOMUtil.findChildValueByPath(xmlActivation, "jdk"));
                Element xmlProperty = MavenJDOMUtil.findChildByPath(xmlActivation, "property");
                if (xmlProperty != null) {
                    activation.setProperty(new MavenProfileActivationProperty(MavenJDOMUtil.findChildValueByPath(xmlProperty, "name"), MavenJDOMUtil.findChildValueByPath(xmlProperty, "value")));
                }
                if ((xmlFile = MavenJDOMUtil.findChildByPath(xmlActivation, "file")) != null) {
                    activation.setFile(new MavenProfileActivationFile(MavenJDOMUtil.findChildValueByPath(xmlFile, "exists"), MavenJDOMUtil.findChildValueByPath(xmlFile, "missing")));
                }
                profile.setActivation(activation);
            }
            MavenProjectReader.readModelBody((MavenModelBase)profile, profile.getBuild(), each);
        }
    }

    private boolean addProfileIfDoesNotExist(MavenProfile profile, List<MavenProfile> result) {
        for (MavenProfile each : result) {
            if (!Objects.equals(each.getId(), profile.getId())) continue;
            return false;
        }
        result.add(profile);
        return true;
    }

    private static void collectProperties(Element xmlProperties, MavenModelBase mavenModelBase) {
        if (xmlProperties == null) {
            return;
        }
        Properties props = mavenModelBase.getProperties();
        for (Element each : xmlProperties.getChildren()) {
            String name = each.getName();
            String value = each.getTextTrim();
            if (props.containsKey(name) || StringUtil.isEmptyOrSpaces((String)name)) continue;
            props.setProperty(name, value);
        }
    }

    private ProfileApplicationResult applyProfiles(MavenModel model2, File basedir, MavenExplicitProfiles explicitProfiles, Collection<String> alwaysOnProfiles) {
        return MavenServerManager.getInstance().getConnector(this.myProject).applyProfiles(model2, basedir, explicitProfiles, alwaysOnProfiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MavenModel resolveInheritance(final MavenGeneralSettings generalSettings, MavenModel model2, VirtualFile file, final MavenExplicitProfiles explicitProfiles, final Set<VirtualFile> recursionGuard, final MavenProjectReaderProjectLocator locator, Collection<MavenProjectProblem> problems) {
        if (recursionGuard.contains(file)) {
            problems.add(MavenProjectProblem.createProblem((String)file.getPath(), (String)MavenProjectBundle.message("maven.project.problem.recursiveInheritance", new Object[0]), (MavenProjectProblem.ProblemType)MavenProjectProblem.ProblemType.PARENT));
            return model2;
        }
        recursionGuard.add(file);
        try {
            Pair parentModelWithProblems;
            final MavenParentDesc[] parentDesc = new MavenParentDesc[1];
            MavenParent parent = model2.getParent();
            if (parent != null) {
                if (model2.getMavenId().equals((Object)parent.getMavenId())) {
                    problems.add(MavenProjectProblem.createProblem((String)file.getPath(), (String)MavenProjectBundle.message("maven.project.problem.selfInheritance", new Object[0]), (MavenProjectProblem.ProblemType)MavenProjectProblem.ProblemType.PARENT));
                    MavenModel mavenModel = model2;
                    return mavenModel;
                }
                parentDesc[0] = new MavenParentDesc(parent.getMavenId(), parent.getRelativePath());
            }
            if ((parentModelWithProblems = (Pair)new MavenParentProjectFileProcessor<Pair<VirtualFile, RawModelReadResult>>(){

                @Override
                @Nullable
                protected VirtualFile findManagedFile(@NotNull MavenId id) {
                    if (id == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return locator.findProjectFile(id);
                }

                @Override
                @Nullable
                protected Pair<VirtualFile, RawModelReadResult> processRelativeParent(VirtualFile parentFile) {
                    MavenModel parentModel = MavenProjectReader.this.doReadProjectModel((VirtualFile)parentFile, (boolean)true).model;
                    MavenId parentId = parentDesc[0].getParentId();
                    if (!parentId.equals((Object)parentModel.getMavenId())) {
                        return null;
                    }
                    return (Pair)super.processRelativeParent(parentFile);
                }

                @Override
                protected Pair<VirtualFile, RawModelReadResult> processSuperParent(VirtualFile parentFile) {
                    return null;
                }

                @Override
                protected Pair<VirtualFile, RawModelReadResult> doProcessParent(VirtualFile parentFile) {
                    RawModelReadResult result = (RawModelReadResult)MavenProjectReader.this.doReadProjectModel((MavenGeneralSettings)generalSettings, (VirtualFile)parentFile, (MavenExplicitProfiles)explicitProfiles, (Set<VirtualFile>)recursionGuard, (MavenProjectReaderProjectLocator)locator).first;
                    return Pair.create((Object)parentFile, (Object)result);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "org/jetbrains/idea/maven/project/MavenProjectReader$1", "findManagedFile"));
                }
            }.process(generalSettings, file, parentDesc[0])) == null) {
                MavenModel mavenModel = model2;
                return mavenModel;
            }
            MavenModel parentModel = ((RawModelReadResult)parentModelWithProblems.second).model;
            if (!((RawModelReadResult)parentModelWithProblems.second).problems.isEmpty()) {
                problems.add(MavenProjectProblem.createProblem((String)((VirtualFile)parentModelWithProblems.first).getPath(), (String)MavenProjectBundle.message("maven.project.problem.parentHasProblems", parentModel.getMavenId()), (MavenProjectProblem.ProblemType)MavenProjectProblem.ProblemType.PARENT));
            }
            model2 = MavenServerManager.getInstance().getConnector(this.myProject).assembleInheritance(model2, parentModel);
            List profiles = model2.getProfiles();
            for (MavenProfile each : parentModel.getProfiles()) {
                MavenProfile copyProfile = new MavenProfile(each.getId(), each.getSource());
                if (each.getActivation() != null) {
                    copyProfile.setActivation(each.getActivation().clone());
                }
                this.addProfileIfDoesNotExist(copyProfile, profiles);
            }
            MavenModel mavenModel = model2;
            return mavenModel;
        }
        finally {
            recursionGuard.remove(file);
        }
    }

    public Collection<MavenProjectReaderResult> resolveProject(MavenGeneralSettings generalSettings, MavenEmbedderWrapper embedder, Collection<VirtualFile> files, MavenExplicitProfiles explicitProfiles, MavenProjectReaderProjectLocator locator) throws MavenProcessCanceledException {
        try {
            Collection<MavenServerExecutionResult> executionResults = embedder.resolveProject(files, (Collection<String>)explicitProfiles.getEnabledProfiles(), (Collection<String>)explicitProfiles.getDisabledProfiles());
            THashMap filesMap = new THashMap(FileUtil.PATH_HASHING_STRATEGY);
            filesMap.putAll(files.stream().collect(Collectors.toMap(VirtualFile::getPath, Function.identity())));
            ArrayList<MavenProjectReaderResult> readerResults = new ArrayList<MavenProjectReaderResult>();
            for (MavenServerExecutionResult result : executionResults) {
                MavenServerExecutionResult.ProjectData projectData = result.projectData;
                if (projectData == null) {
                    VirtualFile file2 = MavenProjectReader.detectPomFile((Map<String, VirtualFile>)filesMap, result);
                    if (file2 == null) continue;
                    MavenProjectReaderResult temp = this.readProject(generalSettings, file2, explicitProfiles, locator);
                    temp.readingProblems.addAll(result.problems);
                    temp.unresolvedArtifactIds.addAll(result.unresolvedArtifacts);
                    readerResults.add(temp);
                    continue;
                }
                readerResults.add(new MavenProjectReaderResult(projectData.mavenModel, projectData.mavenModelMap, new MavenExplicitProfiles(projectData.activatedProfiles, explicitProfiles.getDisabledProfiles()), projectData.nativeMavenProject, result.problems, result.unresolvedArtifacts));
            }
            return readerResults;
        }
        catch (MavenProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            MavenLog.LOG.info(e);
            MavenLog.printInTests(e);
            return ContainerUtil.mapNotNull(files, file -> {
                MavenProjectReaderResult result = this.readProject(generalSettings, (VirtualFile)file, explicitProfiles, locator);
                String message = e.getMessage();
                if (message != null) {
                    result.readingProblems.add(MavenProjectProblem.createStructureProblem((String)file.getPath(), (String)message));
                } else {
                    result.readingProblems.add(MavenProjectProblem.createSyntaxProblem((String)file.getPath(), (MavenProjectProblem.ProblemType)MavenProjectProblem.ProblemType.SYNTAX));
                }
                return result;
            });
        }
    }

    @Nullable
    private static VirtualFile detectPomFile(Map<String, VirtualFile> filesMap, MavenServerExecutionResult result) {
        String path;
        if (filesMap.size() == 1) {
            return (VirtualFile)ContainerUtil.getFirstItem(filesMap.values());
        }
        if (!result.problems.isEmpty() && (path = ((MavenProjectProblem)ContainerUtil.getFirstItem((Collection)result.problems)).getPath()) != null) {
            return filesMap.get(FileUtil.toSystemIndependentName((String)path));
        }
        return null;
    }

    @Nullable
    public static MavenProjectReaderResult generateSources(MavenEmbedderWrapper embedder, MavenImportingSettings importingSettings, VirtualFile file, MavenExplicitProfiles profiles, MavenConsole console) throws MavenProcessCanceledException {
        try {
            List<String> goals = Collections.singletonList(importingSettings.getUpdateFoldersOnImportPhase());
            MavenServerExecutionResult result = embedder.execute(file, profiles.getEnabledProfiles(), profiles.getDisabledProfiles(), goals);
            MavenServerExecutionResult.ProjectData projectData = result.projectData;
            if (projectData == null) {
                return null;
            }
            return new MavenProjectReaderResult(projectData.mavenModel, projectData.mavenModelMap, new MavenExplicitProfiles(projectData.activatedProfiles, profiles.getDisabledProfiles()), projectData.nativeMavenProject, result.problems, result.unresolvedArtifacts);
        }
        catch (Throwable e) {
            console.printException(e);
            MavenLog.LOG.warn(e);
            return null;
        }
    }

    private static Element readXml(final VirtualFile file, final Collection<MavenProjectProblem> problems, final MavenProjectProblem.ProblemType type) {
        return MavenJDOMUtil.read(file, new MavenJDOMUtil.ErrorHandler(){

            @Override
            public void onReadError(IOException e) {
                MavenLog.LOG.warn("Cannot read the pom file: " + e);
                problems.add(MavenProjectProblem.createProblem((String)file.getPath(), (String)e.getMessage(), (MavenProjectProblem.ProblemType)type));
            }

            @Override
            public void onSyntaxError() {
                problems.add(MavenProjectProblem.createSyntaxProblem((String)file.getPath(), (MavenProjectProblem.ProblemType)type));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/project/MavenProjectReader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/project/MavenProjectReader";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateParentVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class RawModelReadResult {
        public MavenModel model;
        public Collection<MavenProjectProblem> problems;
        public Set<String> alwaysOnProfiles;

        private RawModelReadResult(MavenModel model2, Collection<MavenProjectProblem> problems, Set<String> alwaysOnProfiles) {
            this.model = model2;
            this.problems = problems;
            this.alwaysOnProfiles = alwaysOnProfiles;
        }
    }

    private static final class SettingsProfilesCache {
        final List<MavenProfile> profiles;
        final Set<String> alwaysOnProfiles;
        final Collection<MavenProjectProblem> problems;

        private SettingsProfilesCache(List<MavenProfile> profiles, Set<String> alwaysOnProfiles, Collection<MavenProjectProblem> problems) {
            this.profiles = profiles;
            this.alwaysOnProfiles = alwaysOnProfiles;
            this.problems = problems;
        }
    }
}

