/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.buildtool;

import com.intellij.build.BuildContentDescriptor;
import com.intellij.build.BuildDescriptor;
import com.intellij.build.BuildProgressListener;
import com.intellij.build.DefaultBuildDescriptor;
import com.intellij.build.FilePosition;
import com.intellij.build.SyncViewManager;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.EventResult;
import com.intellij.build.events.MessageEvent;
import com.intellij.build.events.MessageEventResult;
import com.intellij.build.events.impl.BuildIssueEventImpl;
import com.intellij.build.events.impl.DerivedResultImpl;
import com.intellij.build.events.impl.FailureResultImpl;
import com.intellij.build.events.impl.FileMessageEventImpl;
import com.intellij.build.events.impl.FinishBuildEventImpl;
import com.intellij.build.events.impl.FinishEventImpl;
import com.intellij.build.events.impl.MessageEventImpl;
import com.intellij.build.events.impl.OutputBuildEventImpl;
import com.intellij.build.events.impl.ProgressBuildEventImpl;
import com.intellij.build.events.impl.StartBuildEventImpl;
import com.intellij.build.events.impl.StartEventImpl;
import com.intellij.build.events.impl.SuccessResultImpl;
import com.intellij.build.issue.BuildIssue;
import com.intellij.build.issue.BuildIssueQuickFix;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.util.ExceptionUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.buildtool.ArtifactSyncListener;
import org.jetbrains.idea.maven.buildtool.MavenSyncConsole;
import org.jetbrains.idea.maven.buildtool.MavenSyncConsole$WhenMappings;
import org.jetbrains.idea.maven.buildtool.quickfix.OffMavenOfflineModeQuickFix;
import org.jetbrains.idea.maven.buildtool.quickfix.OpenMavenSettingsQuickFix;
import org.jetbrains.idea.maven.buildtool.quickfix.UseBundledMavenQuickFix;
import org.jetbrains.idea.maven.execution.SyncBundle;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenWorkspaceSettingsComponent;
import org.jetbrains.idea.maven.server.CannotStartServerException;
import org.jetbrains.idea.maven.server.MavenServerManager;
import org.jetbrains.idea.maven.server.MavenServerProgressIndicator;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenUtil;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002UVB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0019H\u0007J\"\u0010!\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u00012\b\b\u0001\u0010#\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\u000eH\u0002J\u0010\u0010!\u001a\u00020\u000b2\b\b\u0001\u0010#\u001a\u00020\u0007J\u001a\u0010%\u001a\u00020\u000b2\b\b\u0001\u0010#\u001a\u00020\u00072\b\b\u0001\u0010&\u001a\u00020\u0007J\"\u0010'\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u00012\b\b\u0001\u0010(\u001a\u00020\u00072\u0006\u0010)\u001a\u00020*H\u0002J\u0010\u0010+\u001a\u00020\u000b2\u0006\u0010,\u001a\u00020\u0007H\u0002J\u0010\u0010-\u001a\u00020.2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u001c\u0010/\u001a\u00020\u000b2\u0006\u00100\u001a\u00020\u00072\n\b\u0002\u00101\u001a\u0004\u0018\u00010\u001fH\u0002J\b\u00102\u001a\u00020\u000bH\u0002J\u0017\u00103\u001a\u00020\u000b2\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0082\bJ\u0018\u00105\u001a\u00020\u000b2\u0006\u0010,\u001a\u00020\u00072\u0006\u00106\u001a\u00020\u0007H\u0002J0\u00107\u001a\u00020\u000b2\u0006\u0010,\u001a\u00020\u00072\b\b\u0001\u00106\u001a\u00020\u00072\b\b\u0001\u00108\u001a\u00020\u00072\n\b\u0001\u00109\u001a\u0004\u0018\u00010\u0007H\u0002J\u0018\u0010:\u001a\u00020\u000b2\u0006\u0010,\u001a\u00020\u00072\u0006\u00106\u001a\u00020\u0007H\u0002J\u0006\u0010;\u001a\u00020\u000bJ\u0012\u0010<\u001a\u00020\u000b2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u001fJ\u000e\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020@J\u0010\u0010A\u001a\u00020\u000e2\u0006\u00106\u001a\u00020\u0007H\u0002J\u000e\u0010B\u001a\u00020\u000b2\u0006\u0010C\u001a\u00020DJ\u0006\u0010E\u001a\u00020FJ\u0018\u0010G\u001a\u00020\u000b2\u0006\u0010,\u001a\u00020\u00072\u0006\u00106\u001a\u00020\u0007H\u0002J\u0016\u0010H\u001a\u00020\u000b2\u0006\u0010I\u001a\u00020\u00072\u0006\u0010J\u001a\u00020KJ\u000e\u0010L\u001a\u00020\u000b2\u0006\u0010M\u001a\u00020\u0007J\u000e\u0010N\u001a\u00020\u000b2\u0006\u0010O\u001a\u00020\u0019J\u001a\u0010P\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u00012\b\b\u0001\u0010(\u001a\u00020\u0007H\u0002J\u0006\u0010Q\u001a\u00020\u000bJ\u000e\u0010R\u001a\u00020\u000b2\u0006\u0010S\u001a\u00020TR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\b\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\tj\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\u0011\u001a*\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00070\u00130\u0012j\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00070\u0013`\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0015\u001a\u00070\u0016\u00a2\u0006\u0002\b\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0018\u00010\u001cR\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006W"}, d2={"Lorg/jetbrains/idea/maven/buildtool/MavenSyncConsole;", "", "myProject", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "JAVADOC_AND_SOURCE_CLASSIFIERS", "", "", "delayedActions", "Ljava/util/ArrayList;", "Lkotlin/Function0;", "", "Lkotlin/collections/ArrayList;", "finished", "", "hasErrors", "hasUnresolved", "myStartedSet", "Ljava/util/LinkedHashSet;", "Lkotlin/Pair;", "Lkotlin/collections/LinkedHashSet;", "mySyncId", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;", "Lorg/jetbrains/annotations/NotNull;", "mySyncView", "Lcom/intellij/build/BuildProgressListener;", "started", "wrapperProgressIndicator", "Lorg/jetbrains/idea/maven/buildtool/MavenSyncConsole$WrapperProgressIndicator;", "addException", "e", "", "progressListener", "addText", "parentId", "text", "stdout", "addWarning", "description", "completeTask", "taskName", "result", "Lcom/intellij/build/events/EventResult;", "completeUmbrellaEvents", "keyPrefix", "createMessageEvent", "Lcom/intellij/build/events/impl/MessageEventImpl;", "debugLog", "s", "exception", "doFinish", "doIfImportInProcess", "action", "downloadEventCompleted", "dependency", "downloadEventFailed", "error", "stackTrace", "downloadEventStarted", "finishImport", "finishWrapperResolving", "getListener", "Lorg/jetbrains/idea/maven/buildtool/ArtifactSyncListener;", "type", "Lorg/jetbrains/idea/maven/server/MavenServerProgressIndicator$ResolveType;", "isJavadocOrSource", "notifyReadingProblems", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "progressIndicatorForWrapper", "Lcom/intellij/openapi/progress/ProgressIndicator;", "showError", "showQuickFixBadMaven", "message", "kind", "Lcom/intellij/build/events/MessageEvent$Kind;", "showQuickFixJDK", "version", "startImport", "syncView", "startTask", "startWrapperResolving", "terminated", "exitCode", "", "ArtifactSyncListenerImpl", "WrapperProgressIndicator", "intellij.maven"})
public final class MavenSyncConsole {
    private volatile BuildProgressListener mySyncView;
    private ExternalSystemTaskId mySyncId;
    private boolean finished;
    private boolean started;
    private WrapperProgressIndicator wrapperProgressIndicator;
    private boolean hasErrors;
    private boolean hasUnresolved;
    private final Set<String> JAVADOC_AND_SOURCE_CLASSIFIERS;
    private final ArrayList<Function0<Unit>> delayedActions;
    private LinkedHashSet<Pair<Object, String>> myStartedSet;
    private final Project myProject;

    public final synchronized void startImport(@NotNull BuildProgressListener syncView) {
        Intrinsics.checkNotNullParameter((Object)syncView, (String)"syncView");
        if (this.started) {
            return;
        }
        AnAction restartAction2 = new AnAction(this){
            final /* synthetic */ MavenSyncConsole this$0;

            public void update(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Presentation presentation = e.getPresentation();
                Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
                presentation.setEnabled(!MavenSyncConsole.access$getStarted$p(this.this$0) || MavenSyncConsole.access$getFinished$p(this.this$0));
                Presentation presentation2 = e.getPresentation();
                Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"e.presentation");
                presentation2.setIcon(AllIcons.Actions.Refresh);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    Project project = e.getProject();
                    if (project == null) break block0;
                    Project project2 = project;
                    boolean bl = false;
                    boolean bl2 = false;
                    Project it = project2;
                    boolean bl3 = false;
                    MavenProjectsManager.getInstance(it).forceUpdateAllProjectsOrFindAllAvailablePomFiles();
                }
            }
            {
                this.this$0 = this$0;
            }
        };
        this.started = true;
        this.finished = false;
        this.hasErrors = false;
        this.hasUnresolved = false;
        this.wrapperProgressIndicator = new WrapperProgressIndicator();
        this.mySyncView = syncView;
        ExternalSystemTaskId externalSystemTaskId = ExternalSystemTaskId.create((ProjectSystemId)MavenUtil.SYSTEM_ID, (ExternalSystemTaskType)ExternalSystemTaskType.RESOLVE_PROJECT, (Project)this.myProject);
        Intrinsics.checkNotNullExpressionValue((Object)externalSystemTaskId, (String)"ExternalSystemTaskId.cre\u2026SOLVE_PROJECT, myProject)");
        this.mySyncId = externalSystemTaskId;
        BuildContentDescriptor runDescr2 = new BuildContentDescriptor(null, null, new JComponent(){}, SyncBundle.message("maven.sync.title", new Object[0]));
        runDescr2.setActivateToolWindowWhenFailed(true);
        runDescr2.setActivateToolWindowWhenAdded(false);
        String string = SyncBundle.message("maven.sync.title", new Object[0]);
        String string2 = this.myProject.getBasePath();
        Intrinsics.checkNotNull((Object)string2);
        DefaultBuildDescriptor descriptor2 = new DefaultBuildDescriptor((Object)this.mySyncId, string, string2, System.currentTimeMillis()).withRestartAction(restartAction2).withContentDescriptor((Supplier)new Supplier<RunContentDescriptor>(runDescr2){
            final /* synthetic */ BuildContentDescriptor $runDescr;

            public final RunContentDescriptor get() {
                return (RunContentDescriptor)this.$runDescr;
            }
            {
                this.$runDescr = buildContentDescriptor;
            }
        });
        this.mySyncView.onEvent((Object)this.mySyncId, (BuildEvent)new StartBuildEventImpl((BuildDescriptor)descriptor2, SyncBundle.message("maven.sync.project.title", this.myProject.getName())));
        MavenSyncConsole.debugLog$default(this, "maven sync: started importing " + this.myProject, null, 2, null);
    }

    public final synchronized void addText(@Nls @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        MavenSyncConsole this_$iv = this;
        boolean $i$f$doIfImportInProcess = false;
        if (this_$iv.started && !this_$iv.finished) {
            boolean bl = false;
            this.addText(this.mySyncId, text, true);
        }
    }

    private final synchronized void addText(Object parentId, @Nls String text, boolean stdout) {
        MavenSyncConsole this_$iv = this;
        boolean $i$f$doIfImportInProcess = false;
        if (this_$iv.started && !this_$iv.finished) {
            boolean bl = false;
            if (StringUtil.isEmpty((String)text)) {
                return;
            }
            String toPrint = StringsKt.endsWith$default((CharSequence)text, (char)'\n', (boolean)false, (int)2, null) ? text : text + '\n';
            this.mySyncView.onEvent((Object)this.mySyncId, (BuildEvent)new OutputBuildEventImpl(parentId, toPrint, stdout));
        }
    }

    public final synchronized void addWarning(@Nls @NotNull String text, @Nls @NotNull String description) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        MavenSyncConsole this_$iv = this;
        boolean $i$f$doIfImportInProcess = false;
        if (this_$iv.started && !this_$iv.finished) {
            boolean bl = false;
            this.mySyncView.onEvent((Object)this.mySyncId, (BuildEvent)new MessageEventImpl((Object)this.mySyncId, MessageEvent.Kind.WARNING, SyncBundle.message("maven.sync.group.compiler", new Object[0]), text, description));
        }
    }

    public final synchronized void finishImport() {
        MavenSyncConsole.debugLog$default(this, "Maven sync: finishImport", null, 2, null);
        this.doFinish();
    }

    public final synchronized void terminated(int exitCode) {
        MavenSyncConsole this_$iv = this;
        boolean $i$f$doIfImportInProcess = false;
        if (this_$iv.started && !this_$iv.finished) {
            boolean bl = false;
            List tasks = CollectionsKt.asReversed((List)CollectionsKt.toList((Iterable)this.myStartedSet));
            MavenSyncConsole.debugLog$default(this, "Tasks " + tasks + " are not completed! Force complete", null, 2, null);
            Iterable $this$forEach$iv = tasks;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Pair it = (Pair)element$iv;
                boolean bl2 = false;
                this.completeTask(it.getFirst(), (String)it.getSecond(), (EventResult)new FailureResultImpl(SyncBundle.message("maven.sync.failure.terminated", exitCode)));
            }
            this.mySyncView.onEvent((Object)this.mySyncId, (BuildEvent)new FinishBuildEventImpl((Object)this.mySyncId, null, System.currentTimeMillis(), "", (EventResult)new FailureResultImpl(SyncBundle.message("maven.sync.failure.terminated", exitCode))));
            this.finished = true;
            this.started = false;
        }
    }

    public final synchronized void startWrapperResolving() {
        if (!this.started || this.finished) {
            Object object = ServiceManager.getService((Project)this.myProject, SyncViewManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ServiceManager.getServic\u2026cViewManager::class.java)");
            this.startImport((BuildProgressListener)object);
        }
        String string = SyncBundle.message("maven.sync.wrapper", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SyncBundle.message(\"maven.sync.wrapper\")");
        this.startTask(this.mySyncId, string);
    }

    public final synchronized void finishWrapperResolving(@Nullable Throwable e) {
        if (e != null) {
            String string = SyncBundle.message("maven.sync.wrapper.failure", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SyncBundle.message(\"maven.sync.wrapper.failure\")");
            String string2 = e.getLocalizedMessage();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"e.localizedMessage");
            this.addWarning(string, string2);
        }
        String string = SyncBundle.message("maven.sync.wrapper", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SyncBundle.message(\"maven.sync.wrapper\")");
        this.completeTask(this.mySyncId, string, (EventResult)new SuccessResultImpl());
    }

    public static /* synthetic */ void finishWrapperResolving$default(MavenSyncConsole mavenSyncConsole, Throwable throwable, int n, Object object) {
        if ((n & 1) != 0) {
            throwable = null;
        }
        mavenSyncConsole.finishWrapperResolving(throwable);
    }

    @NotNull
    public final ProgressIndicator progressIndicatorForWrapper() {
        WrapperProgressIndicator wrapperProgressIndicator = this.wrapperProgressIndicator;
        return wrapperProgressIndicator != null ? (ProgressIndicator)wrapperProgressIndicator : (ProgressIndicator)new EmptyProgressIndicator();
    }

    public final synchronized void notifyReadingProblems(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        MavenSyncConsole this_$iv = this;
        boolean $i$f$doIfImportInProcess = false;
        if (this_$iv.started && !this_$iv.finished) {
            boolean bl = false;
            MavenSyncConsole.debugLog$default(this, "reading problems in " + file, null, 2, null);
            this.hasErrors = true;
            String desc = SyncBundle.message("maven.sync.failure.error.reading.file", file.getPath());
            this.mySyncView.onEvent((Object)this.mySyncId, (BuildEvent)new FileMessageEventImpl((Object)this.mySyncId, MessageEvent.Kind.ERROR, SyncBundle.message("maven.sync.group.error", new Object[0]), desc, desc, new FilePosition(new File(file.getPath()), -1, -1)));
        }
    }

    @ApiStatus.Internal
    public final synchronized void addException(@NotNull Throwable e, @NotNull BuildProgressListener progressListener) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)progressListener, (String)"progressListener");
        if (this.started && !this.finished) {
            MavenLog.LOG.warn(e);
            this.hasErrors = true;
            this.mySyncView.onEvent((Object)this.mySyncId, (BuildEvent)this.createMessageEvent(e));
        } else {
            this.startImport(progressListener);
            this.addException(e, progressListener);
            this.finishImport();
        }
    }

    private final MessageEventImpl createMessageEvent(Throwable e) {
        ExecutionException cause;
        if (e instanceof CannotStartServerException && (cause = (ExecutionException)ExceptionUtil.findCause((Throwable)e, ExecutionException.class)) != null) {
            return new MessageEventImpl((Object)this.mySyncId, MessageEvent.Kind.ERROR, SyncBundle.message("build.event.title.internal.server.error", new Object[0]), cause.getLocalizedMessage(), ExceptionUtil.getThrowableText((Throwable)((Throwable)cause)));
        }
        return new MessageEventImpl((Object)this.mySyncId, MessageEvent.Kind.ERROR, SyncBundle.message("build.event.title.error", new Object[0]), e.getLocalizedMessage(), ExceptionUtil.getThrowableText((Throwable)e));
    }

    @NotNull
    public final ArtifactSyncListener getListener(@NotNull MavenServerProgressIndicator.ResolveType type) {
        ArtifactSyncListener artifactSyncListener;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        switch (MavenSyncConsole$WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                artifactSyncListener = new ArtifactSyncListenerImpl("maven.sync.plugins");
                break;
            }
            case 2: {
                artifactSyncListener = new ArtifactSyncListenerImpl("maven.sync.dependencies");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return artifactSyncListener;
    }

    private final synchronized void doFinish() {
        List tasks = CollectionsKt.asReversed((List)CollectionsKt.toList((Iterable)this.myStartedSet));
        MavenSyncConsole.debugLog$default(this, "Tasks " + tasks + " are not completed! Force complete", null, 2, null);
        Iterable $this$forEach$iv = tasks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair it = (Pair)element$iv;
            boolean bl = false;
            this.completeTask(it.getFirst(), (String)it.getSecond(), (EventResult)new DerivedResultImpl());
        }
        this.mySyncView.onEvent((Object)this.mySyncId, (BuildEvent)new FinishBuildEventImpl((Object)this.mySyncId, null, System.currentTimeMillis(), "", this.hasErrors ? (EventResult)new FailureResultImpl() : (EventResult)new DerivedResultImpl()));
        MavenWorkspaceSettingsComponent mavenWorkspaceSettingsComponent = MavenWorkspaceSettingsComponent.getInstance(this.myProject);
        Intrinsics.checkNotNullExpressionValue((Object)mavenWorkspaceSettingsComponent, (String)"MavenWorkspaceSettingsCo\u2026nt.getInstance(myProject)");
        MavenGeneralSettings generalSettings = mavenWorkspaceSettingsComponent.getSettings().generalSettings;
        if (this.hasUnresolved) {
            MavenGeneralSettings mavenGeneralSettings = generalSettings;
            Intrinsics.checkNotNullExpressionValue((Object)mavenGeneralSettings, (String)"generalSettings");
            if (mavenGeneralSettings.isWorkOffline()) {
                this.mySyncView.onEvent((Object)this.mySyncId, (BuildEvent)new BuildIssueEventImpl((Object)this.mySyncId, new BuildIssue(){
                    @NotNull
                    private final String title;
                    @NotNull
                    private final String description;
                    @NotNull
                    private final List<BuildIssueQuickFix> quickFixes;

                    @NotNull
                    public String getTitle() {
                        return this.title;
                    }

                    @NotNull
                    public String getDescription() {
                        return this.description;
                    }

                    @NotNull
                    public List<BuildIssueQuickFix> getQuickFixes() {
                        return this.quickFixes;
                    }

                    @Nullable
                    public Navigatable getNavigatable(@NotNull Project project) {
                        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                        return null;
                    }
                    {
                        this.title = "Dependency Resolution Failed";
                        this.description = "<a href=\"off_maven_offline_mode_quick_fix\">Switch Off Offline Mode</a>\n";
                        this.quickFixes = CollectionsKt.listOf((Object)new OffMavenOfflineModeQuickFix());
                    }
                }, MessageEvent.Kind.ERROR));
            }
        }
        this.finished = true;
        this.started = false;
    }

    private final synchronized void showError(String keyPrefix, String dependency) {
        MavenSyncConsole this_$iv = this;
        boolean $i$f$doIfImportInProcess = false;
        if (this_$iv.started && !this_$iv.finished) {
            boolean bl = false;
            this.hasErrors = true;
            this.hasUnresolved = true;
            String umbrellaString = SyncBundle.message(keyPrefix + ".resolve", new Object[0]);
            String errorString = SyncBundle.message(keyPrefix + ".resolve.error", dependency);
            String string = umbrellaString;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"umbrellaString");
            this.startTask(this.mySyncId, string);
            this.mySyncView.onEvent((Object)this.mySyncId, (BuildEvent)new MessageEventImpl((Object)umbrellaString, MessageEvent.Kind.ERROR, SyncBundle.message("maven.sync.group.error", new Object[0]), errorString, errorString));
            String string2 = errorString;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"errorString");
            this.addText(this.mySyncId, string2, false);
        }
    }

    private final synchronized void startTask(Object parentId, @NlsSafe String taskName) {
        MavenSyncConsole this_$iv = this;
        boolean $i$f$doIfImportInProcess = false;
        if (this_$iv.started && !this_$iv.finished) {
            boolean bl = false;
            MavenSyncConsole.debugLog$default(this, "Maven sync: start " + taskName, null, 2, null);
            if (this.myStartedSet.add((Pair<Object, String>)TuplesKt.to((Object)parentId, (Object)taskName))) {
                this.mySyncView.onEvent((Object)this.mySyncId, (BuildEvent)new StartEventImpl((Object)taskName, parentId, System.currentTimeMillis(), taskName));
            }
        }
    }

    private final synchronized void completeTask(Object parentId, @NlsSafe String taskName, EventResult result) {
        MavenSyncConsole this_$iv = this;
        boolean $i$f$doIfImportInProcess = false;
        if (this_$iv.started && !this_$iv.finished) {
            boolean bl = false;
            this.hasErrors = this.hasErrors || result instanceof FailureResultImpl;
            MavenSyncConsole.debugLog$default(this, "Maven sync: complete " + taskName + " with " + result, null, 2, null);
            if (this.myStartedSet.remove(TuplesKt.to((Object)parentId, (Object)taskName))) {
                this.mySyncView.onEvent((Object)this.mySyncId, (BuildEvent)new FinishEventImpl((Object)taskName, parentId, System.currentTimeMillis(), taskName, result));
            }
        }
    }

    private final void debugLog(String s, Throwable exception) {
        MavenLog.LOG.debug(s, exception);
    }

    static /* synthetic */ void debugLog$default(MavenSyncConsole mavenSyncConsole, String string, Throwable throwable, int n, Object object) {
        if ((n & 2) != 0) {
            throwable = null;
        }
        mavenSyncConsole.debugLog(string, throwable);
    }

    private final synchronized void completeUmbrellaEvents(String keyPrefix) {
        MavenSyncConsole this_$iv = this;
        boolean $i$f$doIfImportInProcess = false;
        if (this_$iv.started && !this_$iv.finished) {
            String taskName;
            boolean bl = false;
            String string = taskName = SyncBundle.message(keyPrefix + ".resolve", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"taskName");
            this.completeTask(this.mySyncId, string, (EventResult)new DerivedResultImpl());
        }
    }

    private final synchronized void downloadEventStarted(String keyPrefix, String dependency) {
        MavenSyncConsole this_$iv = this;
        boolean $i$f$doIfImportInProcess = false;
        if (this_$iv.started && !this_$iv.finished) {
            boolean bl = false;
            String downloadString = SyncBundle.message(keyPrefix + ".download", new Object[0]);
            String downloadArtifactString = SyncBundle.message(keyPrefix + ".artifact.download", dependency);
            String string = downloadString;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"downloadString");
            this.startTask(this.mySyncId, string);
            String string2 = downloadArtifactString;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"downloadArtifactString");
            this.startTask(downloadString, string2);
        }
    }

    private final synchronized void downloadEventCompleted(String keyPrefix, String dependency) {
        MavenSyncConsole this_$iv = this;
        boolean $i$f$doIfImportInProcess = false;
        if (this_$iv.started && !this_$iv.finished) {
            String downloadArtifactString;
            boolean bl = false;
            String downloadString = SyncBundle.message(keyPrefix + ".download", new Object[0]);
            String string = downloadArtifactString = SyncBundle.message(keyPrefix + ".artifact.download", dependency);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"downloadArtifactString");
            this.addText(string, downloadArtifactString, true);
            String string2 = downloadString;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"downloadString");
            this.completeTask(string2, downloadArtifactString, (EventResult)new SuccessResultImpl(false));
        }
    }

    private final synchronized void downloadEventFailed(String keyPrefix, @NlsSafe String dependency, @NlsSafe String error, @NlsSafe String stackTrace) {
        MavenSyncConsole this_$iv = this;
        boolean $i$f$doIfImportInProcess = false;
        if (this_$iv.started && !this_$iv.finished) {
            boolean bl = false;
            String downloadString = SyncBundle.message(keyPrefix + ".download", new Object[0]);
            String downloadArtifactString = SyncBundle.message(keyPrefix + ".artifact.download", dependency);
            if (this.isJavadocOrSource(dependency)) {
                String string = downloadArtifactString;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"downloadArtifactString");
                String string2 = SyncBundle.message("maven.sync.failure.dependency.not.found", dependency);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"SyncBundle.message(\"mave\u2026y.not.found\", dependency)");
                this.addText(string, string2, true);
                String string3 = downloadString;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"downloadString");
                this.completeTask(string3, downloadArtifactString, (EventResult)new MessageEventResult(this, keyPrefix, dependency, stackTrace, error){
                    final /* synthetic */ MavenSyncConsole this$0;
                    final /* synthetic */ String $keyPrefix$inlined;
                    final /* synthetic */ String $dependency$inlined;
                    final /* synthetic */ String $stackTrace$inlined;
                    final /* synthetic */ String $error$inlined;
                    {
                        this.this$0 = mavenSyncConsole;
                        this.$keyPrefix$inlined = string;
                        this.$dependency$inlined = string2;
                        this.$stackTrace$inlined = string3;
                        this.$error$inlined = string4;
                    }

                    @NotNull
                    public MessageEvent.Kind getKind() {
                        return MessageEvent.Kind.WARNING;
                    }

                    @Nullable
                    public String getDetails() {
                        return SyncBundle.message("maven.sync.failure.dependency.not.found", this.$dependency$inlined);
                    }
                });
            } else {
                if (stackTrace != null && Registry.is((String)"maven.spy.events.debug")) {
                    String string = downloadArtifactString;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"downloadArtifactString");
                    this.addText(string, stackTrace, false);
                } else {
                    String string = downloadArtifactString;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"downloadArtifactString");
                    this.addText(string, error, true);
                }
                String string = downloadString;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"downloadString");
                this.completeTask(string, downloadArtifactString, (EventResult)new FailureResultImpl(error));
            }
        }
    }

    public final synchronized void showQuickFixBadMaven(@NotNull String message, @NotNull MessageEvent.Kind kind) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        String bundledVersion = MavenServerManager.getInstance().getMavenVersion("Bundled (Maven 3)");
        this.mySyncView.onEvent((Object)this.mySyncId, (BuildEvent)new BuildIssueEventImpl((Object)this.mySyncId, new BuildIssue(message, bundledVersion){
            private final String title;
            @NotNull
            private final String description;
            @NotNull
            private final List<BuildIssueQuickFix> quickFixes;
            final /* synthetic */ String $message;
            final /* synthetic */ String $bundledVersion;

            public String getTitle() {
                return this.title;
            }

            @NotNull
            public String getDescription() {
                return this.description;
            }

            @NotNull
            public List<BuildIssueQuickFix> getQuickFixes() {
                return this.quickFixes;
            }

            @Nullable
            public Navigatable getNavigatable(@NotNull Project project) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                return null;
            }
            {
                this.$message = $captured_local_variable$0;
                this.$bundledVersion = $captured_local_variable$1;
                this.title = SyncBundle.message("maven.sync.version.issue.title", new Object[0]);
                this.description = $captured_local_variable$0 + '\n' + "- <a href=\"open_maven_settings_quick_fix\">" + SyncBundle.message("maven.sync.version.open.settings", new Object[0]) + "</a>\n" + "- <a href=\"use_bundled_maven_quick_fix\">" + SyncBundle.message("maven.sync.version.use.bundled", $captured_local_variable$1) + "</a>\n";
                this.quickFixes = CollectionsKt.listOf((Object[])new BuildIssueQuickFix[]{new OpenMavenSettingsQuickFix(), new UseBundledMavenQuickFix()});
            }
        }, kind));
    }

    public final synchronized void showQuickFixJDK(@NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        this.mySyncView.onEvent((Object)this.mySyncId, (BuildEvent)new BuildIssueEventImpl((Object)this.mySyncId, new BuildIssue(version){
            private final String title;
            @NotNull
            private final String description;
            @NotNull
            private final List<BuildIssueQuickFix> quickFixes;
            final /* synthetic */ String $version;

            public String getTitle() {
                return this.title;
            }

            @NotNull
            public String getDescription() {
                return this.description;
            }

            @NotNull
            public List<BuildIssueQuickFix> getQuickFixes() {
                return this.quickFixes;
            }

            @Nullable
            public Navigatable getNavigatable(@NotNull Project project) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                return null;
            }
            {
                this.$version = $captured_local_variable$0;
                this.title = SyncBundle.message("maven.sync.quickfixes.maven.jdk.version.title", new Object[0]);
                this.description = SyncBundle.message("maven.sync.quickfixes.upgrade.to.jdk7", $captured_local_variable$0) + "\n" + "- <a href=\"open_maven_settings_quick_fix\">" + SyncBundle.message("maven.sync.quickfixes.open.settings", new Object[0]) + "</a>\n";
                this.quickFixes = CollectionsKt.listOf((Object)new OpenMavenSettingsQuickFix());
            }
        }, MessageEvent.Kind.ERROR));
    }

    private final boolean isJavadocOrSource(String dependency) {
        List split = StringsKt.split$default((CharSequence)dependency, (char[])new char[]{':'}, (boolean)false, (int)0, (int)6, null);
        if (split.size() < 4) {
            return false;
        }
        String classifier = (String)split.get(2);
        return this.JAVADOC_AND_SOURCE_CLASSIFIERS.contains(classifier);
    }

    private final void doIfImportInProcess(Function0<Unit> action) {
        int $i$f$doIfImportInProcess = 0;
        if (!this.started || this.finished) {
            return;
        }
        action.invoke();
    }

    public MavenSyncConsole(@NotNull Project myProject) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        this.myProject = myProject;
        this.mySyncView = mySyncView.1.INSTANCE;
        ExternalSystemTaskId externalSystemTaskId = ExternalSystemTaskId.create((ProjectSystemId)MavenUtil.SYSTEM_ID, (ExternalSystemTaskType)ExternalSystemTaskType.RESOLVE_PROJECT, (Project)this.myProject);
        Intrinsics.checkNotNullExpressionValue((Object)externalSystemTaskId, (String)"ExternalSystemTaskId.cre\u2026SOLVE_PROJECT, myProject)");
        this.mySyncId = externalSystemTaskId;
        this.JAVADOC_AND_SOURCE_CLASSIFIERS = SetsKt.setOf((Object[])new String[]{"javadoc", "sources", "test-javadoc", "test-sources"});
        this.delayedActions = new ArrayList();
        this.myStartedSet = new LinkedHashSet();
    }

    public static final /* synthetic */ void access$doIfImportInProcess(MavenSyncConsole $this, Function0 action) {
        $this.doIfImportInProcess((Function0<Unit>)action);
    }

    public static final /* synthetic */ void access$setMySyncView$p(MavenSyncConsole $this, BuildProgressListener buildProgressListener) {
        $this.mySyncView = buildProgressListener;
    }

    public static final /* synthetic */ void access$setMySyncId$p(MavenSyncConsole $this, ExternalSystemTaskId externalSystemTaskId) {
        $this.mySyncId = externalSystemTaskId;
    }

    public static final /* synthetic */ void access$setStarted$p(MavenSyncConsole $this, boolean bl) {
        $this.started = bl;
    }

    public static final /* synthetic */ void access$setFinished$p(MavenSyncConsole $this, boolean bl) {
        $this.finished = bl;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/idea/maven/buildtool/MavenSyncConsole$WrapperProgressIndicator;", "Lcom/intellij/openapi/progress/EmptyProgressIndicator;", "(Lorg/jetbrains/idea/maven/buildtool/MavenSyncConsole;)V", "myFraction", "", "getMyFraction", "()J", "setMyFraction", "(J)V", "setFraction", "", "fraction", "", "setText", "text", "", "intellij.maven"})
    public final class WrapperProgressIndicator
    extends EmptyProgressIndicator {
        private long myFraction;

        public final long getMyFraction() {
            return this.myFraction;
        }

        public final void setMyFraction(long l) {
            this.myFraction = l;
        }

        public void setText(@NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            MavenSyncConsole this_$iv = MavenSyncConsole.this;
            boolean $i$f$doIfImportInProcess = false;
            if (this_$iv.started && !this_$iv.finished) {
                boolean bl = false;
                String string = SyncBundle.message("maven.sync.wrapper", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SyncBundle.message(\"maven.sync.wrapper\")");
                MavenSyncConsole.this.addText(string, text, true);
            }
        }

        public void setFraction(double fraction) {
            MavenSyncConsole this_$iv = MavenSyncConsole.this;
            boolean $i$f$doIfImportInProcess = false;
            if (this_$iv.started && !this_$iv.finished) {
                boolean bl = false;
                long newFraction = (long)(fraction * (double)100);
                if (this.myFraction != newFraction) {
                    this.myFraction = newFraction;
                    MavenSyncConsole.this.mySyncView.onEvent((Object)MavenSyncConsole.this.mySyncId, (BuildEvent)new ProgressBuildEventImpl((Object)SyncBundle.message("maven.sync.wrapper", new Object[0]), (Object)SyncBundle.message("maven.sync.wrapper", new Object[0]), System.currentTimeMillis(), SyncBundle.message("maven.sync.wrapper.dowloading", new Object[0]), 100L, this.myFraction, "%"));
                }
            }
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\b\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\"\u0010\n\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u00032\b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u0016J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\b\u0010\u000e\u001a\u00020\bH\u0016J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/idea/maven/buildtool/MavenSyncConsole$ArtifactSyncListenerImpl;", "Lorg/jetbrains/idea/maven/buildtool/ArtifactSyncListener;", "keyPrefix", "", "(Lorg/jetbrains/idea/maven/buildtool/MavenSyncConsole;Ljava/lang/String;)V", "getKeyPrefix", "()Ljava/lang/String;", "downloadCompleted", "", "dependency", "downloadFailed", "error", "stackTrace", "downloadStarted", "finish", "showError", "intellij.maven"})
    private final class ArtifactSyncListenerImpl
    implements ArtifactSyncListener {
        @NotNull
        private final String keyPrefix;

        @Override
        public void downloadStarted(@NotNull String dependency) {
            Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
            MavenSyncConsole.this.downloadEventStarted(this.keyPrefix, dependency);
        }

        @Override
        public void downloadCompleted(@NotNull String dependency) {
            Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
            MavenSyncConsole.this.downloadEventCompleted(this.keyPrefix, dependency);
        }

        @Override
        public void downloadFailed(@NotNull String dependency, @NotNull String error, @Nullable String stackTrace) {
            Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            MavenSyncConsole.this.downloadEventFailed(this.keyPrefix, dependency, error, stackTrace);
        }

        @Override
        public void finish() {
            MavenSyncConsole.this.completeUmbrellaEvents(this.keyPrefix);
        }

        @Override
        public void showError(@NotNull String dependency) {
            Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
            MavenSyncConsole.this.showError(this.keyPrefix, dependency);
        }

        @NotNull
        public final String getKeyPrefix() {
            return this.keyPrefix;
        }

        public ArtifactSyncListenerImpl(String keyPrefix) {
            Intrinsics.checkNotNullParameter((Object)keyPrefix, (String)"keyPrefix");
            this.keyPrefix = keyPrefix;
        }
    }
}

