/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit.codeInsight.references;

import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u0002H\u0002J\u0013\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016\u00a2\u0006\u0002\u0010\u0011J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\u0013"}, d2={"Lcom/intellij/execution/junit/codeInsight/references/EnumSourceReference;", "Lcom/intellij/psi/PsiReferenceBase;", "Lcom/intellij/psi/PsiLiteral;", "element", "(Lcom/intellij/psi/PsiLiteral;)V", "bindToElement", "Lcom/intellij/psi/PsiElement;", "filterDuplicated", "", "constanta", "Lcom/intellij/psi/PsiEnumConstant;", "findReferencedEnumClass", "Lcom/intellij/psi/PsiClass;", "literal", "getVariants", "", "", "()[Ljava/lang/Object;", "resolve", "intellij.junit"})
public final class EnumSourceReference
extends PsiReferenceBase<PsiLiteral> {
    @NotNull
    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (element instanceof PsiEnumConstant) {
            PsiElement psiElement2 = this.handleElementRename(((PsiEnumConstant)element).getName());
            psiElement = psiElement2;
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"handleElementRename(element.name)");
        } else {
            PsiElement psiElement3 = super.bindToElement(element);
            psiElement = psiElement3;
            Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"super.bindToElement(element)");
        }
        return psiElement;
    }

    @Nullable
    public PsiElement resolve() {
        PsiLiteral psiLiteral = (PsiLiteral)this.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiLiteral, (String)"element");
        PsiClass psiClass = this.findReferencedEnumClass(psiLiteral);
        if (psiClass == null) {
            return null;
        }
        return (PsiElement)psiClass.findFieldByName(this.getValue(), false);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Object[] getVariants() {
        void $this$mapTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        PsiLiteral psiLiteral = (PsiLiteral)this.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiLiteral, (String)"element");
        PsiClass psiClass = this.findReferencedEnumClass(psiLiteral);
        if (psiClass == null) {
            return new Object[0];
        }
        PsiClass enumClass = psiClass;
        PsiField[] psiFieldArray = enumClass.getFields();
        Intrinsics.checkNotNullExpressionValue((Object)psiFieldArray, (String)"enumClass.fields");
        PsiField[] $this$filterIsInstance$iv = psiFieldArray;
        boolean $i$f$filterIsInstance = false;
        PsiField[] psiFieldArray2 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof PsiEnumConstant)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PsiEnumConstant it = (PsiEnumConstant)element$iv$iv;
            boolean bl = false;
            if (!this.filterDuplicated(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            PsiEnumConstant it = (PsiEnumConstant)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            LookupElement lookupElement = LookupElementBuilder.create((PsiNamedElement)((PsiNamedElement)it)).withAutoCompletionPolicy(AutoCompletionPolicy.SETTINGS_DEPENDENT);
            collection.add(lookupElement);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Object[] objectArray = thisCollection$iv.toArray(new Object[0]);
        if (objectArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return objectArray;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean filterDuplicated(PsiEnumConstant constanta) {
        PsiLiteral psiLiteral = (PsiLiteral)this.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiLiteral, (String)"element");
        if (psiLiteral.getParent() instanceof PsiArrayInitializerMemberValue) {
            void $this$mapTo$iv$iv;
            Iterable $this$filterIsInstanceTo$iv$iv;
            PsiLiteral psiLiteral2 = (PsiLiteral)this.getElement();
            Intrinsics.checkNotNullExpressionValue((Object)psiLiteral2, (String)"element");
            PsiElement psiElement = psiLiteral2.getParent();
            if (psiElement == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.psi.PsiArrayInitializerMemberValue");
            }
            PsiAnnotationMemberValue[] initializers = ((PsiArrayInitializerMemberValue)psiElement).getInitializers();
            Intrinsics.checkNotNullExpressionValue((Object)initializers, (String)"initializers");
            PsiAnnotationMemberValue[] $this$filterIsInstance$iv = initializers;
            boolean $i$f$filterIsInstance = false;
            PsiAnnotationMemberValue[] psiAnnotationMemberValueArray = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof PsiLiteralExpression)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterIsInstanceTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                PsiLiteralExpression psiLiteralExpression = (PsiLiteralExpression)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Object object = it.getValue();
                collection.add(object);
            }
            return !CollectionsKt.toSet((Iterable)((List)destination$iv$iv)).contains(constanta.getName());
        }
        return true;
    }

    private final PsiClass findReferencedEnumClass(PsiLiteral literal) {
        PsiClassObjectAccessExpression psiClassObjectAccessExpression;
        PsiAnnotation psiAnnotation = (PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)literal), PsiAnnotation.class, (boolean)false);
        if (psiAnnotation == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiAnnotation, (String)"PsiTreeUtil.getParentOfT\u2026           ?: return null");
        PsiAnnotation annotation = psiAnnotation;
        PsiAnnotationMemberValue memberValue = annotation.findAttributeValue("value");
        PsiAnnotationMemberValue psiAnnotationMemberValue = memberValue;
        if (!(psiAnnotationMemberValue instanceof PsiClassObjectAccessExpression)) {
            psiAnnotationMemberValue = null;
        }
        return PsiUtil.resolveClassInClassTypeOnly((psiClassObjectAccessExpression = (PsiClassObjectAccessExpression)psiAnnotationMemberValue) != null && (psiClassObjectAccessExpression = psiClassObjectAccessExpression.getOperand()) != null ? psiClassObjectAccessExpression.getType() : null);
    }

    public EnumSourceReference(@NotNull PsiLiteral element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super((PsiElement)element, false);
    }
}

