/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.maven.embedder;

import com.intellij.util.ExceptionUtilRt;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.DefaultMaven;
import org.apache.maven.Maven;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.manager.DefaultWagonManager;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.DefaultArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.DefaultArtifactResolver;
import org.apache.maven.artifact.resolver.ResolutionListener;
import org.apache.maven.execution.DefaultMavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.ReactorManager;
import org.apache.maven.extension.ExtensionManager;
import org.apache.maven.model.Extension;
import org.apache.maven.model.Plugin;
import org.apache.maven.monitor.event.DefaultEventDispatcher;
import org.apache.maven.monitor.event.DefaultEventMonitor;
import org.apache.maven.monitor.event.EventDispatcher;
import org.apache.maven.monitor.event.EventMonitor;
import org.apache.maven.plugin.PluginManager;
import org.apache.maven.profiles.DefaultProfileManager;
import org.apache.maven.profiles.ProfileManager;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuilderConfiguration;
import org.apache.maven.project.interpolation.ModelInterpolationException;
import org.apache.maven.settings.MavenSettingsBuilder;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.RuntimeInfo;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.codehaus.classworlds.ClassWorld;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.logging.BaseLoggerManager;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.LoggerManager;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.maven.embedder.FieldAccessor;
import org.jetbrains.maven.embedder.MavenEmbedderLog;
import org.jetbrains.maven.embedder.MavenEmbedderSettings;
import org.jetbrains.maven.embedder.MavenExecutionResult;
import org.jetbrains.maven.embedder.NullMavenLogger;
import org.jetbrains.maven.embedder.PlexusComponentConfigurator;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcherException;

public final class MavenEmbedder {
    private static final String PROP_MAVEN_HOME = "maven.home";
    private final DefaultPlexusContainer myContainer;
    private final Settings mySettings;
    private final Logger myLogger;
    private final MavenEmbedderSettings myEmbedderSettings;
    private final ArtifactRepository myLocalRepository;
    private Properties myUserProperties;

    private MavenEmbedder(@NotNull DefaultPlexusContainer container, @NotNull Settings settings, @NotNull Logger logger, @NotNull MavenEmbedderSettings embedderSettings) {
        if (container == null) {
            MavenEmbedder.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            MavenEmbedder.$$$reportNull$$$0(1);
        }
        if (logger == null) {
            MavenEmbedder.$$$reportNull$$$0(2);
        }
        if (embedderSettings == null) {
            MavenEmbedder.$$$reportNull$$$0(3);
        }
        this.myUserProperties = new Properties();
        this.myContainer = container;
        this.mySettings = settings;
        this.myLogger = logger;
        this.myEmbedderSettings = embedderSettings;
        this.myLocalRepository = this.createLocalRepository(embedderSettings);
        this.loadSettings();
    }

    private void loadSettings() {
        Proxy proxy;
        WagonManager wagonManager = this.getComponent(WagonManager.class);
        wagonManager.setOnline(!this.mySettings.isOffline());
        if (wagonManager instanceof DefaultWagonManager) {
            ((DefaultWagonManager)wagonManager).setHttpUserAgent("Apache-Maven/2.2");
        }
        if ((proxy = this.mySettings.getActiveProxy()) != null && proxy.getHost() != null) {
            String pass = this.decrypt(proxy.getPassword());
            wagonManager.addProxy(proxy.getProtocol(), proxy.getHost(), proxy.getPort(), proxy.getUsername(), pass, proxy.getNonProxyHosts());
        }
        for (Object each : this.mySettings.getServers()) {
            Server server = (Server)each;
            String passWord = this.decrypt(server.getPassword());
            String passPhrase = this.decrypt(server.getPassphrase());
            wagonManager.addAuthenticationInfo(server.getId(), server.getUsername(), passWord, server.getPrivateKey(), passPhrase);
            wagonManager.addPermissionInfo(server.getId(), server.getFilePermissions(), server.getDirectoryPermissions());
            if (server.getConfiguration() == null) continue;
            wagonManager.addConfiguration(server.getId(), (Xpp3Dom)server.getConfiguration());
        }
        for (Object each : this.mySettings.getMirrors()) {
            Mirror mirror = (Mirror)each;
            if (mirror.getUrl() == null) continue;
            wagonManager.addMirror(mirror.getId(), mirror.getMirrorOf(), mirror.getUrl());
        }
    }

    private String decrypt(String pass) {
        try {
            pass = this.getComponent(SecDispatcher.class, "maven").decrypt(pass);
        }
        catch (SecDispatcherException e) {
            MavenEmbedderLog.LOG.warn(e);
        }
        return pass;
    }

    private ArtifactRepository createLocalRepository(MavenEmbedderSettings generalSettings) {
        ArtifactRepositoryLayout layout = this.getComponent(ArtifactRepositoryLayout.class, "default");
        ArtifactRepositoryFactory factory = this.getComponent(ArtifactRepositoryFactory.class);
        String url = this.mySettings.getLocalRepository();
        if (!url.startsWith("file:")) {
            url = "file://" + url;
        }
        DefaultArtifactRepository localRepository = new DefaultArtifactRepository("local", url, layout);
        boolean snapshotPolicySet = this.mySettings.isOffline();
        if (!snapshotPolicySet && generalSettings.getSnapshotUpdatePolicy() == MavenEmbedderSettings.UpdatePolicy.ALWAYS_UPDATE) {
            factory.setGlobalUpdatePolicy("always");
        }
        factory.setGlobalChecksumPolicy("warn");
        return localRepository;
    }

    @NotNull
    public ArtifactRepository getLocalRepository() {
        ArtifactRepository artifactRepository = this.myLocalRepository;
        if (artifactRepository == null) {
            MavenEmbedder.$$$reportNull$$$0(4);
        }
        return artifactRepository;
    }

    @NotNull
    public File getLocalRepositoryFile() {
        return new File(this.myLocalRepository.getBasedir());
    }

    public Settings getSettings() {
        return this.mySettings;
    }

    @NotNull
    public MavenExecutionResult resolveProject(@NotNull File file, @NotNull List<String> activeProfiles, @NotNull List<String> inactiveProfiles) {
        if (file == null) {
            MavenEmbedder.$$$reportNull$$$0(5);
        }
        if (activeProfiles == null) {
            MavenEmbedder.$$$reportNull$$$0(6);
        }
        if (inactiveProfiles == null) {
            MavenEmbedder.$$$reportNull$$$0(7);
        }
        MavenExecutionResult mavenExecutionResult = this.resolveProject(file, activeProfiles, inactiveProfiles, Collections.<ResolutionListener>emptyList());
        if (mavenExecutionResult == null) {
            MavenEmbedder.$$$reportNull$$$0(8);
        }
        return mavenExecutionResult;
    }

    @NotNull
    public MavenExecutionResult resolveProject(@NotNull File file, @NotNull List<String> activeProfiles, @NotNull List<String> inactiveProfiles, List<ResolutionListener> listeners) {
        if (file == null) {
            MavenEmbedder.$$$reportNull$$$0(9);
        }
        if (activeProfiles == null) {
            MavenEmbedder.$$$reportNull$$$0(10);
        }
        if (inactiveProfiles == null) {
            MavenEmbedder.$$$reportNull$$$0(11);
        }
        MavenExecutionRequest request = this.createRequest(file, activeProfiles, inactiveProfiles, Collections.<String>emptyList());
        ProjectBuilderConfiguration config = request.getProjectBuilderConfiguration();
        request.getGlobalProfileManager().loadSettingsProfiles(this.mySettings);
        ProfileManager globalProfileManager = request.getGlobalProfileManager();
        globalProfileManager.loadSettingsProfiles(request.getSettings());
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        MavenProject project = null;
        try {
            MavenProjectBuilder builder = this.getComponent(MavenProjectBuilder.class);
            project = builder.build(new File(file.getPath()), config);
            builder.calculateConcreteState(project, config, false);
            this.findExtensions(project);
            Artifact projectArtifact = project.getArtifact();
            Map managedVersions = project.getManagedVersionMap();
            ArtifactMetadataSource metadataSource = this.getComponent(ArtifactMetadataSource.class);
            project.setDependencyArtifacts(project.createArtifacts(this.getComponent(ArtifactFactory.class), null, null));
            ArtifactResolver resolver = this.getComponent(ArtifactResolver.class);
            ArtifactResolutionResult result = resolver.resolveTransitively(project.getDependencyArtifacts(), projectArtifact, managedVersions, this.myLocalRepository, project.getRemoteArtifactRepositories(), metadataSource, null, listeners);
            project.setArtifacts(result.getArtifacts());
        }
        catch (Exception e) {
            MavenExecutionResult mavenExecutionResult = this.handleException(e);
            if (mavenExecutionResult == null) {
                MavenEmbedder.$$$reportNull$$$0(12);
            }
            return mavenExecutionResult;
        }
        return new MavenExecutionResult(project, exceptions);
    }

    private void findExtensions(MavenProject project) {
        ExtensionManager extensionManager = this.getComponent(ExtensionManager.class);
        for (Object each : project.getBuildExtensions()) {
            try {
                extensionManager.addExtension((Extension)each, project, this.myLocalRepository);
            }
            catch (PlexusContainerException e) {
                MavenEmbedderLog.LOG.error(e);
            }
            catch (ArtifactResolutionException e) {
                MavenEmbedderLog.LOG.error(e);
            }
            catch (ArtifactNotFoundException e) {
                MavenEmbedderLog.LOG.error(e);
            }
        }
        extensionManager.registerWagons();
        Map handlers = this.findArtifactTypeHandlers(project);
        this.getComponent(ArtifactHandlerManager.class).addHandlers(handlers);
    }

    private Map findArtifactTypeHandlers(MavenProject project) {
        HashMap result = new HashMap();
        for (Object each : project.getBuildPlugins()) {
            Plugin eachPlugin = (Plugin)each;
            if (!eachPlugin.isExtensions()) continue;
            try {
                PluginManager pluginManager = this.getComponent(PluginManager.class);
                pluginManager.verifyPlugin(eachPlugin, project, this.mySettings, this.myLocalRepository);
                result.putAll(pluginManager.getPluginComponents(eachPlugin, ArtifactHandler.ROLE));
            }
            catch (Exception e) {
                MavenEmbedderLog.LOG.info(e);
                continue;
            }
            for (Object o : result.values()) {
                ArtifactHandler handler = (ArtifactHandler)o;
                if (!project.getPackaging().equals(handler.getPackaging())) continue;
                project.getArtifact().setArtifactHandler(handler);
            }
        }
        return result;
    }

    public void resolve(@NotNull Artifact artifact, @NotNull List<ArtifactRepository> repos) throws ArtifactResolutionException, ArtifactNotFoundException {
        if (artifact == null) {
            MavenEmbedder.$$$reportNull$$$0(13);
        }
        if (repos == null) {
            MavenEmbedder.$$$reportNull$$$0(14);
        }
        this.getComponent(ArtifactResolver.class).resolve(artifact, repos, this.myLocalRepository);
    }

    public Set<Artifact> resolveTransitively(@NotNull Set<Artifact> toResolve, @NotNull List<ArtifactRepository> repos) throws ArtifactResolutionException, ArtifactNotFoundException {
        if (toResolve == null) {
            MavenEmbedder.$$$reportNull$$$0(15);
        }
        if (repos == null) {
            MavenEmbedder.$$$reportNull$$$0(16);
        }
        Artifact project = this.getComponent(ArtifactFactory.class).createBuildArtifact("temp", "temp", "666", "pom");
        return this.getComponent(ArtifactResolver.class).resolveTransitively(toResolve, project, Collections.EMPTY_MAP, this.myLocalRepository, repos, this.getComponent(ArtifactMetadataSource.class)).getArtifacts();
    }

    @NotNull
    public MavenExecutionResult execute(@NotNull File file, @NotNull List<String> activeProfiles, @NotNull List<String> inactiveProfiles, @NotNull List<String> goals, @NotNull List<String> selectedProjects, boolean alsoMake, boolean alsoMakeDependents) {
        if (file == null) {
            MavenEmbedder.$$$reportNull$$$0(17);
        }
        if (activeProfiles == null) {
            MavenEmbedder.$$$reportNull$$$0(18);
        }
        if (inactiveProfiles == null) {
            MavenEmbedder.$$$reportNull$$$0(19);
        }
        if (goals == null) {
            MavenEmbedder.$$$reportNull$$$0(20);
        }
        if (selectedProjects == null) {
            MavenEmbedder.$$$reportNull$$$0(21);
        }
        try {
            MavenExecutionRequest request = this.createRequest(file, activeProfiles, inactiveProfiles, goals);
            if (!selectedProjects.isEmpty()) {
                request.setRecursive(true);
                request.setSelectedProjects(selectedProjects);
                if (alsoMake && alsoMakeDependents) {
                    request.setMakeBehavior("make-both");
                } else if (alsoMake) {
                    request.setMakeBehavior("make");
                } else if (alsoMakeDependents) {
                    request.setMakeBehavior("make-dependents");
                }
            }
            Maven maven = this.getComponent(Maven.class);
            Method method = maven.getClass().getDeclaredMethod("doExecute", MavenExecutionRequest.class, EventDispatcher.class);
            method.setAccessible(true);
            ReactorManager reactor = (ReactorManager)method.invoke((Object)maven, request, request.getEventDispatcher());
            return new MavenExecutionResult(reactor.getTopLevelProject(), Collections.<Exception>emptyList());
        }
        catch (InvocationTargetException e) {
            MavenExecutionResult mavenExecutionResult = this.handleException(e.getTargetException());
            if (mavenExecutionResult == null) {
                MavenEmbedder.$$$reportNull$$$0(22);
            }
            return mavenExecutionResult;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public MavenExecutionResult readProjectWithModules(@NotNull File file, List<String> activeProfiles, List<String> inactiveProfiles) {
        if (file == null) {
            MavenEmbedder.$$$reportNull$$$0(23);
        }
        MavenExecutionRequest request = this.createRequest(file, activeProfiles, inactiveProfiles, Collections.<String>emptyList());
        request.getGlobalProfileManager().loadSettingsProfiles(this.mySettings);
        request.setRecursive(true);
        return this.readProject(request);
    }

    @NotNull
    private MavenExecutionResult readProject(@NotNull MavenExecutionRequest request) {
        if (request == null) {
            MavenEmbedder.$$$reportNull$$$0(24);
        }
        ProfileManager globalProfileManager = request.getGlobalProfileManager();
        globalProfileManager.loadSettingsProfiles(request.getSettings());
        MavenProject rootProject = null;
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        Object result = null;
        try {
            File pomFile = new File(request.getPomFile());
            if (!pomFile.exists()) {
                throw new FileNotFoundException("File doesn't exist: " + pomFile.getPath());
            }
            Method getProjectsMethod = DefaultMaven.class.getDeclaredMethod("getProjects", MavenExecutionRequest.class);
            getProjectsMethod.setAccessible(true);
            Maven maven = this.getComponent(Maven.class);
            result = getProjectsMethod.invoke((Object)maven, request);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            MavenExecutionResult mavenExecutionResult = this.handleException(e.getTargetException());
            if (mavenExecutionResult == null) {
                MavenEmbedder.$$$reportNull$$$0(25);
            }
            return mavenExecutionResult;
        }
        catch (Exception e) {
            MavenExecutionResult mavenExecutionResult = this.handleException(e);
            if (mavenExecutionResult == null) {
                MavenEmbedder.$$$reportNull$$$0(26);
            }
            return mavenExecutionResult;
        }
        if (result != null) {
            MavenProjectBuilder builder = this.getComponent(MavenProjectBuilder.class);
            for (Object p : (List)result) {
                MavenProject project = (MavenProject)p;
                try {
                    builder.calculateConcreteState(project, request.getProjectBuilderConfiguration(), false);
                }
                catch (ModelInterpolationException e) {
                    exceptions.add((Exception)((Object)e));
                }
                if (!project.isExecutionRoot()) continue;
                rootProject = project;
            }
            if (rootProject == null && exceptions.isEmpty()) {
                throw new RuntimeException("Could't build project for unknown reason");
            }
        }
        return new MavenExecutionResult(rootProject, exceptions);
    }

    @NotNull
    public MavenExecutionResult readProject(@NotNull File file, @NotNull List<String> activeProfiles, @NotNull List<String> inactiveProfiles) {
        if (file == null) {
            MavenEmbedder.$$$reportNull$$$0(27);
        }
        if (activeProfiles == null) {
            MavenEmbedder.$$$reportNull$$$0(28);
        }
        if (inactiveProfiles == null) {
            MavenEmbedder.$$$reportNull$$$0(29);
        }
        MavenExecutionRequest request = this.createRequest(file, activeProfiles, inactiveProfiles, Collections.<String>emptyList());
        request.getGlobalProfileManager().loadSettingsProfiles(this.mySettings);
        request.setRecursive(false);
        return this.readProject(request);
    }

    private MavenExecutionRequest createRequest(File file, List<String> activeProfiles, List<String> inactiveProfiles, List<String> goals) {
        Properties executionProperties = this.myEmbedderSettings.getProperties();
        if (executionProperties == null) {
            executionProperties = new Properties();
        }
        DefaultEventDispatcher dispatcher = new DefaultEventDispatcher();
        dispatcher.addEventMonitor((EventMonitor)new DefaultEventMonitor(this.myLogger));
        DefaultMavenExecutionRequest result = new DefaultMavenExecutionRequest(this.myLocalRepository, this.mySettings, (EventDispatcher)dispatcher, goals, file.getParent(), this.createProfileManager(activeProfiles, inactiveProfiles, executionProperties), executionProperties, this.myUserProperties, true){
            private boolean myIsRecursive;

            public boolean isRecursive() {
                return this.myIsRecursive;
            }

            public void setRecursive(boolean recursive) {
                this.myIsRecursive = recursive;
            }
        };
        result.setPomFile(file.getPath());
        result.setRecursive(this.myEmbedderSettings.isRecursive());
        return result;
    }

    private MavenExecutionResult handleException(Throwable e) {
        ExceptionUtilRt.rethrowUnchecked((Throwable)e);
        return new MavenExecutionResult(null, Collections.singletonList((Exception)e));
    }

    private ProfileManager createProfileManager(List<String> activeProfiles, List<String> inactiveProfiles, Properties executionProperties) {
        DefaultProfileManager profileManager = new DefaultProfileManager(this.getContainer(), executionProperties);
        profileManager.explicitlyActivate(activeProfiles);
        profileManager.explicitlyDeactivate(inactiveProfiles);
        return profileManager;
    }

    public <T> T getComponent(Class<T> clazz) {
        try {
            return (T)this.getContainer().lookup(clazz.getName());
        }
        catch (ComponentLookupException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T getComponent(Class<T> clazz, String roleHint) {
        try {
            return (T)this.getContainer().lookup(clazz.getName(), roleHint);
        }
        catch (ComponentLookupException e) {
            throw new RuntimeException(e);
        }
    }

    public PlexusContainer getContainer() {
        return this.myContainer;
    }

    public void release() {
        this.releaseResolverThreadExecutor();
        this.myContainer.dispose();
    }

    private void releaseResolverThreadExecutor() {
        ArtifactResolver resolver = this.getComponent(ArtifactResolver.class);
        FieldAccessor pool = new FieldAccessor(DefaultArtifactResolver.class, resolver, "resolveArtifactPool");
        try {
            Object threadPool = pool.getField();
            threadPool.getClass().getMethod("shutdown", new Class[0]).invoke(threadPool, new Object[0]);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public static MavenEmbedder create(@NotNull MavenEmbedderSettings embedderSettings) {
        File mavenHome;
        if (embedderSettings == null) {
            MavenEmbedder.$$$reportNull$$$0(30);
        }
        final Logger logger = MavenEmbedder.getLogger(embedderSettings);
        DefaultPlexusContainer container = new DefaultPlexusContainer();
        container.setClassWorld(new ClassWorld("plexus.core", embedderSettings.getClass().getClassLoader()));
        container.setLoggerManager((LoggerManager)new BaseLoggerManager(){

            protected Logger createLogger(String s) {
                return logger;
            }
        });
        try {
            container.initialize();
            container.start();
        }
        catch (PlexusContainerException e) {
            MavenEmbedderLog.LOG.error(e);
            throw new RuntimeException(e);
        }
        PlexusComponentConfigurator configurator = embedderSettings.getConfigurator();
        if (configurator != null) {
            configurator.configureComponents((PlexusContainer)container);
        }
        if ((mavenHome = embedderSettings.getMavenHome()) != null) {
            System.setProperty(PROP_MAVEN_HOME, mavenHome.getPath());
        }
        Settings nativeSettings = MavenEmbedder.buildSettings((PlexusContainer)container, embedderSettings);
        return new MavenEmbedder(container, nativeSettings, logger, embedderSettings);
    }

    @NotNull
    private static Logger getLogger(@NotNull MavenEmbedderSettings embedderSettings) {
        Logger logger;
        if (embedderSettings == null) {
            MavenEmbedder.$$$reportNull$$$0(31);
        }
        return (logger = embedderSettings.getLogger()) != null ? logger : new NullMavenLogger();
    }

    public static Settings buildSettings(PlexusContainer container, MavenEmbedderSettings embedderSettings) {
        File file = embedderSettings.getGlobalSettingsFile();
        if (file != null) {
            System.setProperty("org.apache.maven.global-settings", file.getPath());
        }
        Settings settings = null;
        try {
            MavenSettingsBuilder builder = (MavenSettingsBuilder)container.lookup(MavenSettingsBuilder.ROLE);
            File userSettingsFile = embedderSettings.getUserSettingsFile();
            if (userSettingsFile != null && userSettingsFile.exists() && !userSettingsFile.isDirectory()) {
                settings = builder.buildSettings(userSettingsFile, false);
            }
            if (settings == null) {
                settings = builder.buildSettings();
            }
        }
        catch (ComponentLookupException e) {
            MavenEmbedderLog.LOG.error(e);
        }
        catch (IOException e) {
            MavenEmbedderLog.LOG.warn(e);
        }
        catch (XmlPullParserException e) {
            MavenEmbedderLog.LOG.warn(e);
        }
        if (settings == null) {
            settings = new Settings();
        }
        if (embedderSettings.getLocalRepository() != null) {
            settings.setLocalRepository(embedderSettings.getLocalRepository().getPath());
        }
        if (settings.getLocalRepository() == null) {
            settings.setLocalRepository(System.getProperty("user.home") + "/.m2/repository");
        }
        settings.setOffline(embedderSettings.isWorkOffline());
        settings.setInteractiveMode(false);
        settings.setUsePluginRegistry(embedderSettings.isUsePluginRegistry());
        RuntimeInfo runtimeInfo = new RuntimeInfo(settings);
        runtimeInfo.setPluginUpdateOverride(Boolean.valueOf(embedderSettings.getPluginUpdatePolicy() == MavenEmbedderSettings.UpdatePolicy.ALWAYS_UPDATE));
        settings.setRuntimeInfo(runtimeInfo);
        return settings;
    }

    public static <T> void setImplementation(PlexusContainer container, Class<T> componentClass, Class<? extends T> implementationClass) {
        ComponentDescriptor d = container.getComponentDescriptor(componentClass.getName());
        d.setImplementation(implementationClass.getName());
    }

    public void setUserProperties(@Nullable Properties userProperties) {
        this.myUserProperties = userProperties == null ? new Properties() : userProperties;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 8: 
            case 12: 
            case 22: 
            case 25: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 8: 
            case 12: 
            case 22: 
            case 25: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logger";
                break;
            }
            case 3: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "embedderSettings";
                break;
            }
            case 4: 
            case 8: 
            case 12: 
            case 22: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/maven/embedder/MavenEmbedder";
                break;
            }
            case 5: 
            case 9: 
            case 17: 
            case 23: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 10: 
            case 18: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activeProfiles";
                break;
            }
            case 7: 
            case 11: 
            case 19: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inactiveProfiles";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repos";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toResolve";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "goals";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedProjects";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/maven/embedder/MavenEmbedder";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalRepository";
                break;
            }
            case 8: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveProject";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "readProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 8: 
            case 12: 
            case 22: 
            case 25: 
            case 26: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "resolveProject";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "resolveTransitively";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "readProjectWithModules";
                break;
            }
            case 24: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "readProject";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getLogger";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 8: 
            case 12: 
            case 22: 
            case 25: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

