/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.scratch.output;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.scratch.ScratchExpression;
import org.jetbrains.kotlin.idea.scratch.output.OutputStylingUtilsKt;
import org.jetbrains.kotlin.idea.scratch.output.PreviewEditorScratchOutputHandlerKt;
import org.jetbrains.kotlin.idea.scratch.output.PreviewOutputBlocksManager;
import org.jetbrains.kotlin.idea.scratch.output.PreviewOutputBlocksManager$OutputBlock$printAndSaveOutput$;
import org.jetbrains.kotlin.idea.scratch.output.PreviewOutputBlocksManager$clear$;
import org.jetbrains.kotlin.idea.scratch.output.ScratchOutput;
import org.jetbrains.kotlin.idea.scratch.output.ScratchOutputBlock;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001\u001dB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0007J\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0007H\u0002J\u0018\u0010\u0017\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00150\u00190\u0018J\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0007J\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u001c\u001a\u00020\u0015R\u001e\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\b\u0012\u00060\bR\u00020\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/output/PreviewOutputBlocksManager;", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "(Lcom/intellij/openapi/editor/Editor;)V", "blocks", "Ljava/util/NavigableMap;", "Lorg/jetbrains/kotlin/idea/scratch/ScratchExpression;", "Lorg/jetbrains/kotlin/idea/scratch/output/PreviewOutputBlocksManager$OutputBlock;", "foldingModel", "Lcom/intellij/openapi/editor/FoldingModel;", "markupModel", "Lcom/intellij/openapi/editor/markup/MarkupModel;", "targetDocument", "Lcom/intellij/openapi/editor/Document;", "addBlockToTheEnd", "Lorg/jetbrains/kotlin/idea/scratch/output/ScratchOutputBlock;", "expression", "clear", "", "computeCellLineStart", "", "scratchExpression", "computeSourceToPreviewAlignments", "", "Lkotlin/Pair;", "getBlock", "getBlockAtLine", "line", "OutputBlock", "kotlin.jvm"})
public final class PreviewOutputBlocksManager {
    private final Document targetDocument;
    private final FoldingModel foldingModel;
    private final MarkupModel markupModel;
    private final NavigableMap<ScratchExpression, OutputBlock> blocks;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Pair<Integer, Integer>> computeSourceToPreviewAlignments() {
        void $this$mapTo$iv$iv;
        Collection collection = this.blocks.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"blocks.values");
        Iterable $this$map$iv = collection;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            OutputBlock outputBlock = (OutputBlock)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it.getSourceExpression().getLineStart(), (Object)it.getLineStart());
            collection2.add(pair);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public final ScratchOutputBlock getBlock(@NotNull ScratchExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        return (ScratchOutputBlock)this.blocks.get(expression);
    }

    @NotNull
    public final ScratchOutputBlock addBlockToTheEnd(@NotNull ScratchExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        OutputBlock outputBlock = new OutputBlock(expression);
        boolean bl = false;
        boolean bl2 = false;
        OutputBlock it = outputBlock;
        boolean bl3 = false;
        if (this.blocks.putIfAbsent(expression, it) != null) {
            String string = "There is already a cell for " + expression + '!';
            boolean bl4 = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return outputBlock;
    }

    public final void clear() {
        this.blocks.clear();
        boolean $i$f$runWriteAction = false;
        ApplicationManager.getApplication().runWriteAction(new Computable<T>(this){
            final /* synthetic */ PreviewOutputBlocksManager this$0;
            {
                this.this$0 = previewOutputBlocksManager;
            }

            public final T compute() {
                boolean bl = false;
                Project project$iv = null;
                String name$iv = null;
                String groupId$iv = null;
                boolean $i$f$executeCommand = false;
                CommandProcessor.getInstance().executeCommand(project$iv, new Runnable(this){
                    final /* synthetic */ clear$$inlined$runWriteAction$1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public final void run() {
                        boolean bl = false;
                        PreviewOutputBlocksManager.access$getTargetDocument$p(this.this$0.this$0).setText((CharSequence)"");
                    }
                }, name$iv, (Object)groupId$iv);
                return (T)Unit.INSTANCE;
            }
        });
    }

    private final int computeCellLineStart(ScratchExpression scratchExpression) {
        Map.Entry<ScratchExpression, OutputBlock> entry = this.blocks.lowerEntry(scratchExpression);
        if (entry == null || (entry = entry.getValue()) == null) {
            return scratchExpression.getLineStart();
        }
        Map.Entry<ScratchExpression, OutputBlock> previous = entry;
        int distanceBetweenSources = scratchExpression.getLineStart() - ((OutputBlock)((Object)previous)).getSourceExpression().getLineEnd();
        int differenceBetweenSourceAndOutputHeight = PreviewEditorScratchOutputHandlerKt.access$getHeight$p(((OutputBlock)((Object)previous)).getSourceExpression()) - ((OutputBlock)((Object)previous)).getHeight();
        int n = 0;
        boolean bl = false;
        int compensation = Math.max(differenceBetweenSourceAndOutputHeight, n);
        return ((OutputBlock)((Object)previous)).getLineEnd() + compensation + distanceBetweenSources;
    }

    @Nullable
    public final ScratchOutputBlock getBlockAtLine(int line) {
        Object v1;
        block1: {
            Collection collection = this.blocks.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"blocks.values");
            Iterable iterable = collection;
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                OutputBlock it = (OutputBlock)t;
                boolean bl3 = false;
                int n = line;
                if (!(it.getLineStart() <= n && it.getLineEnd() >= n)) continue;
                v1 = t;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    public PreviewOutputBlocksManager(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
        this.targetDocument = document;
        FoldingModel foldingModel = editor.getFoldingModel();
        Intrinsics.checkNotNullExpressionValue((Object)foldingModel, (String)"editor.foldingModel");
        this.foldingModel = foldingModel;
        MarkupModel markupModel = editor.getMarkupModel();
        Intrinsics.checkNotNullExpressionValue((Object)markupModel, (String)"editor.markupModel");
        this.markupModel = markupModel;
        this.blocks = new TreeMap(Comparator.comparingInt(blocks.1.INSTANCE));
    }

    public static final /* synthetic */ Document access$getTargetDocument$p(PreviewOutputBlocksManager $this) {
        return $this.targetDocument;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0016H\u0016J\u0010\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0016H\u0002J\b\u0010\u001d\u001a\u00020\u001aH\u0002J\b\u0010\u001e\u001a\u00020\u001aH\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\rR\u0014\u0010\u000e\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\rR\u0014\u0010\u000f\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\nR\u001e\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\b@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\nR\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/output/PreviewOutputBlocksManager$OutputBlock;", "Lorg/jetbrains/kotlin/idea/scratch/output/ScratchOutputBlock;", "sourceExpression", "Lorg/jetbrains/kotlin/idea/scratch/ScratchExpression;", "(Lorg/jetbrains/kotlin/idea/scratch/output/PreviewOutputBlocksManager;Lorg/jetbrains/kotlin/idea/scratch/ScratchExpression;)V", "foldRegion", "Lcom/intellij/openapi/editor/FoldRegion;", "height", "", "getHeight", "()I", "isLastCell", "", "()Z", "isOutputSmall", "lineEnd", "getLineEnd", "<set-?>", "lineStart", "getLineStart", "outputs", "", "Lorg/jetbrains/kotlin/idea/scratch/output/ScratchOutput;", "getSourceExpression", "()Lorg/jetbrains/kotlin/idea/scratch/ScratchExpression;", "addOutput", "", "output", "printAndSaveOutput", "recalculatePosition", "updateFolding", "kotlin.jvm"})
    private final class OutputBlock
    implements ScratchOutputBlock {
        private final List<ScratchOutput> outputs;
        private int lineStart;
        private FoldRegion foldRegion;
        @NotNull
        private final ScratchExpression sourceExpression;

        @Override
        public int getLineStart() {
            return this.lineStart;
        }

        @Override
        public int getLineEnd() {
            return this.getLineStart() + PreviewEditorScratchOutputHandlerKt.access$countNewLines(this.outputs);
        }

        public final int getHeight() {
            return this.getLineEnd() - this.getLineStart() + 1;
        }

        @Override
        public void addOutput(@NotNull ScratchOutput output) {
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            this.printAndSaveOutput(output);
            Map.Entry entry = PreviewOutputBlocksManager.this.blocks.lowerEntry(this.getSourceExpression());
            if (entry != null && (entry = (OutputBlock)entry.getValue()) != null) {
                super.updateFolding();
            }
            Collection collection = PreviewOutputBlocksManager.this.blocks.tailMap(this.getSourceExpression()).values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"blocks.tailMap(sourceExpression).values");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                OutputBlock it = (OutputBlock)element$iv;
                boolean bl = false;
                it.recalculatePosition();
                it.updateFolding();
            }
        }

        private final void printAndSaveOutput(ScratchOutput output) {
            int beforeAdding = this.getLineEnd();
            int currentOutputStartLine = this.outputs.isEmpty() ? this.getLineStart() : beforeAdding + 1;
            this.outputs.add(output);
            boolean $i$f$runWriteAction = false;
            ApplicationManager.getApplication().runWriteAction(new Computable<T>(this, currentOutputStartLine, output){
                final /* synthetic */ OutputBlock this$0;
                final /* synthetic */ int $currentOutputStartLine$inlined;
                final /* synthetic */ ScratchOutput $output$inlined;
                {
                    this.this$0 = outputBlock;
                    this.$currentOutputStartLine$inlined = n;
                    this.$output$inlined = scratchOutput;
                }

                public final T compute() {
                    boolean bl = false;
                    Project project$iv = null;
                    String name$iv = null;
                    String groupId$iv = null;
                    boolean $i$f$executeCommand = false;
                    CommandProcessor.getInstance().executeCommand(project$iv, new Runnable(this){
                        final /* synthetic */ OutputBlock$printAndSaveOutput$$inlined$runWriteAction$1 this$0;
                        {
                            this.this$0 = var1_1;
                        }

                        public final void run() {
                            boolean bl = false;
                            PreviewEditorScratchOutputHandlerKt.access$insertStringAtLine(PreviewOutputBlocksManager.access$getTargetDocument$p(this.this$0.this$0.PreviewOutputBlocksManager.this), this.this$0.$currentOutputStartLine$inlined, this.this$0.$output$inlined.getText());
                        }
                    }, name$iv, (Object)groupId$iv);
                    return (T)Unit.INSTANCE;
                }
            });
            PreviewEditorScratchOutputHandlerKt.highlightLines$default(PreviewOutputBlocksManager.this.markupModel, currentOutputStartLine, this.getLineEnd(), OutputStylingUtilsKt.getAttributesForOutputType(output.getType()), null, 8, null);
        }

        private final void recalculatePosition() {
            this.lineStart = PreviewOutputBlocksManager.this.computeCellLineStart(this.getSourceExpression());
        }

        private final void updateFolding() {
            PreviewOutputBlocksManager.this.foldingModel.runBatchFoldingOperation(new Runnable(this){
                final /* synthetic */ OutputBlock this$0;

                public final void run() {
                    block2: {
                        FoldRegion foldRegion = OutputBlock.access$getFoldRegion$p(this.this$0);
                        if (foldRegion != null) {
                            FoldRegion foldRegion2 = foldRegion;
                            FoldingModel foldingModel = PreviewOutputBlocksManager.access$getFoldingModel$p(this.this$0.PreviewOutputBlocksManager.this);
                            boolean bl = false;
                            boolean bl2 = false;
                            FoldRegion p1 = foldRegion2;
                            boolean bl3 = false;
                            foldingModel.removeFoldRegion(p1);
                        }
                        if (this.this$0.getHeight() <= PreviewEditorScratchOutputHandlerKt.access$getHeight$p(this.this$0.getSourceExpression())) {
                            return;
                        }
                        int firstFoldedLine = this.this$0.getLineStart() + (PreviewEditorScratchOutputHandlerKt.access$getHeight$p(this.this$0.getSourceExpression()) - 1);
                        String placeholderLine = PreviewEditorScratchOutputHandlerKt.access$getLineContent(PreviewOutputBlocksManager.access$getTargetDocument$p(this.this$0.PreviewOutputBlocksManager.this), firstFoldedLine) + "...";
                        OutputBlock.access$setFoldRegion$p(this.this$0, PreviewOutputBlocksManager.access$getFoldingModel$p(this.this$0.PreviewOutputBlocksManager.this).addFoldRegion(PreviewOutputBlocksManager.access$getTargetDocument$p(this.this$0.PreviewOutputBlocksManager.this).getLineStartOffset(firstFoldedLine), PreviewOutputBlocksManager.access$getTargetDocument$p(this.this$0.PreviewOutputBlocksManager.this).getLineEndOffset(this.this$0.getLineEnd()), placeholderLine));
                        FoldRegion foldRegion3 = OutputBlock.access$getFoldRegion$p(this.this$0);
                        if (foldRegion3 == null) break block2;
                        foldRegion3.setExpanded(OutputBlock.access$isLastCell$p(this.this$0) && OutputBlock.access$isOutputSmall$p(this.this$0));
                    }
                }
                {
                    this.this$0 = outputBlock;
                }
            });
        }

        private final boolean isLastCell() {
            return false;
        }

        private final boolean isOutputSmall() {
            return true;
        }

        @Override
        @NotNull
        public ScratchExpression getSourceExpression() {
            return this.sourceExpression;
        }

        public OutputBlock(ScratchExpression sourceExpression) {
            Intrinsics.checkNotNullParameter((Object)sourceExpression, (String)"sourceExpression");
            this.sourceExpression = sourceExpression;
            boolean bl = false;
            this.outputs = new ArrayList();
            this.lineStart = PreviewOutputBlocksManager.this.computeCellLineStart(this.getSourceExpression());
        }

        public static final /* synthetic */ FoldRegion access$getFoldRegion$p(OutputBlock $this) {
            return $this.foldRegion;
        }

        public static final /* synthetic */ void access$setFoldRegion$p(OutputBlock $this, FoldRegion foldRegion) {
            $this.foldRegion = foldRegion;
        }

        public static final /* synthetic */ int access$getLineStart$p(OutputBlock $this) {
            return $this.getLineStart();
        }

        public static final /* synthetic */ void access$setLineStart$p(OutputBlock $this, int n) {
            $this.lineStart = n;
        }

        public static final /* synthetic */ boolean access$isLastCell$p(OutputBlock $this) {
            return $this.isLastCell();
        }

        public static final /* synthetic */ boolean access$isOutputSmall$p(OutputBlock $this) {
            return $this.isOutputSmall();
        }
    }
}

