/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.framework.ui;

import com.intellij.DynamicBundle;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Function;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinJvmBundle;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.idea.configuration.KotlinProjectConfigurator;
import org.jetbrains.kotlin.idea.util.ProgressIndicatorUtils;

public class ChooseModulePanel {
    private JPanel contentPane;
    private JRadioButton allModulesWithKtRadioButton;
    private JRadioButton singleModuleRadioButton;
    private JComboBox singleModuleComboBox;
    private HyperlinkLabel allModulesWithKtNames;
    private JRadioButton allModulesRadioButton;
    @NotNull
    private final Project project;
    @NotNull
    private final List<Module> modules;
    @NotNull
    private final List<Module> modulesWithKtFiles;

    public ChooseModulePanel(@NotNull Project project, @NotNull KotlinProjectConfigurator configurator, Collection<Module> excludeModules) {
        if (project == null) {
            ChooseModulePanel.$$$reportNull$$$0(0);
        }
        if (configurator == null) {
            ChooseModulePanel.$$$reportNull$$$0(1);
        }
        this.project = project;
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        Pair modulesPair = (Pair)ProgressIndicatorUtils.underModalProgress((Project)project, (String)KotlinJvmBundle.message("lookup.kotlin.modules.configurations.progress.text", objectArray), () -> {
            List<Module> modules = ConfigureKotlinInProjectUtilsKt.getCanBeConfiguredModules(project, configurator);
            List<Module> modulesWithKtFiles = ConfigureKotlinInProjectUtilsKt.getCanBeConfiguredModulesWithKotlinFiles(project, configurator);
            return Pair.create(modules, modulesWithKtFiles);
        });
        this.modules = (List)modulesPair.first;
        this.modulesWithKtFiles = (List)modulesPair.second;
        DefaultComboBoxModel<String> comboBoxModel = new DefaultComboBoxModel<String>();
        for (Module module : this.modules) {
            comboBoxModel.addElement(module.getName());
        }
        if (this.modulesWithKtFiles.isEmpty()) {
            this.allModulesWithKtRadioButton.setVisible(false);
            this.allModulesWithKtNames.setVisible(false);
        }
        this.singleModuleComboBox.setModel(comboBoxModel);
        ActionListener listener2 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChooseModulePanel.this.updateComponents();
            }
        };
        this.singleModuleRadioButton.addActionListener(listener2);
        this.allModulesWithKtRadioButton.addActionListener(listener2);
        this.allModulesRadioButton.addActionListener(listener2);
        if (this.modulesWithKtFiles.size() > 2) {
            String firstName = this.modulesWithKtFiles.get(0).getName();
            String secondName = this.modulesWithKtFiles.get(1).getName();
            String message = KotlinJvmBundle.message("choose.module.modules", firstName, secondName, this.modulesWithKtFiles.size() - 2);
            this.allModulesWithKtNames.setHtmlText("<html>" + message);
            this.allModulesWithKtNames.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent event) {
                    String title = KotlinJvmBundle.message("choose.module.modules.with.kotlin", new Object[0]);
                    JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<Module>(title, ChooseModulePanel.this.modulesWithKtFiles){

                        @NotNull
                        public String getTextFor(Module value) {
                            String string = value.getName();
                            if (string == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            return string;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/framework/ui/ChooseModulePanel$2$1", "getTextFor"));
                        }
                    }).showUnderneathOf((Component)ChooseModulePanel.this.allModulesWithKtNames);
                }
            });
        } else {
            this.allModulesWithKtNames.setText(StringUtil.join(this.modulesWithKtFiles, (Function)new Function<Module, String>(){

                public String fun(Module module) {
                    return module.getName();
                }
            }, (String)", "));
        }
        ButtonGroup modulesGroup = new ButtonGroup();
        modulesGroup.add(this.allModulesRadioButton);
        modulesGroup.add(this.allModulesWithKtRadioButton);
        modulesGroup.add(this.singleModuleRadioButton);
        if (this.allModulesWithKtRadioButton.isVisible()) {
            this.allModulesWithKtRadioButton.setSelected(true);
        } else {
            this.allModulesRadioButton.setSelected(true);
        }
        this.updateComponents();
    }

    public JComponent getContentPane() {
        return this.contentPane;
    }

    private void updateComponents() {
        this.singleModuleComboBox.setEnabled(this.singleModuleRadioButton.isSelected());
    }

    public List<Module> getModulesToConfigure() {
        if (this.allModulesRadioButton.isSelected()) {
            return this.modules;
        }
        if (this.allModulesWithKtRadioButton.isSelected()) {
            return this.modulesWithKtFiles;
        }
        String selectedItem = (String)this.singleModuleComboBox.getSelectedItem();
        if (selectedItem == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(ModuleManager.getInstance((Project)this.project).findModuleByName(selectedItem));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "configurator";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/kotlin/idea/framework/ui/ChooseModulePanel";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        HyperlinkLabel hyperlinkLabel;
        JComboBox jComboBox;
        JRadioButton jRadioButton3;
        JPanel jPanel;
        this.contentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.singleModuleRadioButton = jRadioButton3 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton3, DynamicBundle.getBundle((String)"messages/KotlinJvmBundle", ChooseModulePanel.class).getString("single.module"));
        jPanel.add((Component)jRadioButton3, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.singleModuleComboBox = jComboBox = new JComboBox();
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        jComboBox.setModel(defaultComboBoxModel);
        jPanel.add(jComboBox, new GridConstraints(2, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 0, 1, 3, 0, 2, 1, 6, null, null, null));
        this.allModulesWithKtNames = hyperlinkLabel = new HyperlinkLabel();
        hyperlinkLabel.setEnabled(true);
        jPanel.add((Component)hyperlinkLabel, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), new Dimension(-1, 100)));
        this.allModulesWithKtRadioButton = jRadioButton2 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton2, DynamicBundle.getBundle((String)"messages/KotlinJvmBundle", ChooseModulePanel.class).getString("all.modules.containing.kotlin.files"));
        jPanel.add((Component)jRadioButton2, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.allModulesRadioButton = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, DynamicBundle.getBundle((String)"messages/KotlinJvmBundle", ChooseModulePanel.class).getString("all.modules"));
        jPanel.add((Component)jRadioButton, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

