/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.connection;

import com.intellij.ide.browsers.WebBrowser;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.socketConnection.ConnectionState;
import com.intellij.util.io.socketConnection.ConnectionStatus;
import com.intellij.util.io.socketConnection.SocketConnectionListener;
import java.util.EventListener;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.event.HyperlinkListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.DebugEventListener;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.connection.VmConnection$sam$com_intellij_util_Function$0;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010)\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020\u0014J\u000e\u0010+\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020,J\u0018\u0010-\u001a\u00020\u000f2\b\u0010.\u001a\u0004\u0018\u00010/2\u0006\u00100\u001a\u000201J\f\u00102\u001a\u0006\u0012\u0002\b\u000303H\u0016J\b\u00104\u001a\u00020\u000fH\u0016J)\u00105\u001a\u00020\u000f2!\u00106\u001a\u001d\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b7\u0012\b\b8\u0012\u0004\b\b(#\u0012\u0004\u0012\u00020\u000f0\rJ\f\u0010\u001b\u001a\u0006\u0012\u0002\b\u000303H\u0007J(\u00109\u001a\u00020\u000f2\u0006\u00100\u001a\u0002012\n\b\u0002\u0010.\u001a\u0004\u0018\u00010/2\n\b\u0002\u0010:\u001a\u0004\u0018\u00010;H\u0004J\b\u0010<\u001a\u00020\u000fH\u0014J\u001a\u0010=\u001a\u00020\u000f2\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rR\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000Rj\u0010\u000b\u001a^\u0012$\u0012\"\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f \u0010*\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f\u0018\u00010\r0\r \u0010*-\u0012$\u0012\"\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f \u0010*\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f\u0018\u00010\r0\r0\u0012\u00a2\u0006\u0002\b\u00110\f\u00a2\u0006\u0002\b\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u00148DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00140\u0018X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001d\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u001c\u0010 \u001a\u0010\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u000e0\u000e0!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010#\u001a\u0004\u0018\u00018\u00002\b\u0010\"\u001a\u0004\u0018\u00018\u0000@DX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010(\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'\u00a8\u0006>"}, d2={"Lorg/jetbrains/debugger/connection/VmConnection;", "T", "Lorg/jetbrains/debugger/Vm;", "Lcom/intellij/openapi/Disposable;", "()V", "browser", "Lcom/intellij/ide/browsers/WebBrowser;", "getBrowser", "()Lcom/intellij/ide/browsers/WebBrowser;", "closed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "connectionDispatcher", "", "Lkotlin/Function1;", "Lcom/intellij/util/io/socketConnection/ConnectionState;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "", "debugEventListener", "Lorg/jetbrains/debugger/DebugEventListener;", "getDebugEventListener", "()Lorg/jetbrains/debugger/DebugEventListener;", "dispatcher", "Lcom/intellij/util/EventDispatcher;", "getDispatcher", "()Lcom/intellij/util/EventDispatcher;", "opened", "Lorg/jetbrains/concurrency/AsyncPromise;", "state", "getState", "()Lcom/intellij/util/io/socketConnection/ConnectionState;", "stateRef", "Ljava/util/concurrent/atomic/AtomicReference;", "<set-?>", "vm", "getVm", "()Lorg/jetbrains/debugger/Vm;", "setVm", "(Lorg/jetbrains/debugger/Vm;)V", "Lorg/jetbrains/debugger/Vm;", "addDebugListener", "listener", "addListener", "Lcom/intellij/util/io/socketConnection/SocketConnectionListener;", "close", "message", "", "status", "Lcom/intellij/util/io/socketConnection/ConnectionStatus;", "detachAndClose", "Lorg/jetbrains/concurrency/Promise;", "dispose", "executeOnStart", "consumer", "Lkotlin/ParameterName;", "name", "setState", "messageLinkListener", "Ljavax/swing/event/HyperlinkListener;", "startProcessing", "stateChanged", "intellij.platform.scriptDebugger.ui"})
public abstract class VmConnection<T extends Vm>
implements Disposable {
    @Nullable
    private final WebBrowser browser;
    private final AtomicReference<ConnectionState> stateRef = new AtomicReference<ConnectionState>(new ConnectionState(ConnectionStatus.NOT_CONNECTED));
    @NotNull
    private final EventDispatcher<DebugEventListener> dispatcher;
    private final List<Function1<ConnectionState, Unit>> connectionDispatcher;
    @Nullable
    private volatile T vm;
    private final AsyncPromise<T> opened;
    private final AtomicBoolean closed;

    @Nullable
    public WebBrowser getBrowser() {
        return this.browser;
    }

    @NotNull
    protected EventDispatcher<DebugEventListener> getDispatcher() {
        return this.dispatcher;
    }

    @Nullable
    public final T getVm() {
        return this.vm;
    }

    protected final void setVm(@Nullable T t) {
        this.vm = t;
    }

    @NotNull
    public final ConnectionState getState() {
        ConnectionState connectionState = this.stateRef.get();
        Intrinsics.checkNotNullExpressionValue((Object)connectionState, (String)"stateRef.get()");
        return connectionState;
    }

    public final void addDebugListener(@NotNull DebugEventListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.getDispatcher().addListener((EventListener)listener2);
    }

    @TestOnly
    @NotNull
    public final Promise<?> opened() {
        return (Promise)this.opened;
    }

    public final void executeOnStart(@NotNull Function1<? super T, Unit> consumer2) {
        Intrinsics.checkNotNullParameter(consumer2, (String)"consumer");
        Function1<? super T, Unit> function1 = consumer2;
        this.opened.then((Function)new VmConnection$sam$com_intellij_util_Function$0(function1));
    }

    protected final void setState(@NotNull ConnectionStatus status, @Nullable String message, @Nullable HyperlinkListener messageLinkListener) {
        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
        ConnectionState newState2 = new ConnectionState(status, message, messageLinkListener);
        ConnectionState oldState = this.stateRef.getAndSet(newState2);
        if (oldState == null || oldState.getStatus() != status) {
            if (status == ConnectionStatus.CONNECTION_FAILED) {
                String string = newState2.getMessage();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"newState.message");
                this.opened.setError(string);
            }
            for (Function1<ConnectionState, Unit> listener2 : this.connectionDispatcher) {
                listener2.invoke((Object)newState2);
            }
        }
    }

    public static /* synthetic */ void setState$default(VmConnection vmConnection, ConnectionStatus connectionStatus, String string, HyperlinkListener hyperlinkListener, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: setState");
        }
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            hyperlinkListener = null;
        }
        vmConnection.setState(connectionStatus, string, hyperlinkListener);
    }

    public final void stateChanged(@NotNull Function1<? super ConnectionState, Unit> listener2) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        this.connectionDispatcher.add(listener2);
    }

    public final void addListener(@NotNull SocketConnectionListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.stateChanged((Function1<ConnectionState, Unit>)((Function1)new Function1<ConnectionState, Unit>(listener2){
            final /* synthetic */ SocketConnectionListener $listener;

            public final void invoke(@NotNull ConnectionState it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$listener.statusChanged(it.getStatus());
            }
            {
                this.$listener = socketConnectionListener;
                super(1);
            }
        }));
    }

    @NotNull
    protected final DebugEventListener getDebugEventListener() {
        EventListener eventListener = this.getDispatcher().getMulticaster();
        Intrinsics.checkNotNullExpressionValue((Object)eventListener, (String)"dispatcher.multicaster");
        return (DebugEventListener)eventListener;
    }

    protected void startProcessing() {
        block0: {
            T t = this.vm;
            if (t == null) break block0;
            T t2 = t;
            boolean bl = false;
            boolean bl2 = false;
            T it = t2;
            boolean bl3 = false;
            this.opened.setResult(it);
        }
    }

    public final void close(@Nullable String message, @NotNull ConnectionStatus status) {
        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
        if (!this.closed.compareAndSet(false, true)) {
            return;
        }
        if (Promises.isPending((Promise)((Promise)this.opened))) {
            this.opened.setError("closed");
        }
        VmConnection.setState$default(this, status, message, null, 4, null);
        Disposer.dispose((Disposable)this, (boolean)false);
    }

    public void dispose() {
        this.vm = null;
    }

    @NotNull
    public Promise<?> detachAndClose() {
        if (Promises.isPending((Promise)((Promise)this.opened))) {
            this.opened.setError((Throwable)Promises.createError$default((String)"detached and closed", (boolean)false, (int)2, null));
        }
        T currentVm = this.vm;
        Promise<?> callback2 = null;
        if (currentVm == null) {
            callback2 = Promises.nullPromise();
        } else {
            this.vm = null;
            callback2 = currentVm.getAttachStateManager().detach();
        }
        this.close(null, ConnectionStatus.DISCONNECTED);
        return callback2;
    }

    public VmConnection() {
        EventDispatcher eventDispatcher = EventDispatcher.create(DebugEventListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"EventDispatcher.create(D\u2026ventListener::class.java)");
        this.dispatcher = eventDispatcher;
        List list2 = ContainerUtil.createLockFreeCopyOnWriteList();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"ContainerUtil.createLock\u2026nnectionState) -> Unit>()");
        this.connectionDispatcher = list2;
        this.opened = new AsyncPromise();
        this.closed = new AtomicBoolean();
    }
}

