/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.ide.impl.legacyBridge.project;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.RootProvider;
import com.intellij.openapi.roots.impl.ProjectRootManagerComponent;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.util.containers.BidirectionalMultiMap;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.workspaceModel.ide.WorkspaceModel;
import com.intellij.workspaceModel.ide.WorkspaceModelChangeListener;
import com.intellij.workspaceModel.ide.WorkspaceModelTopics;
import com.intellij.workspaceModel.ide.impl.jps.serialization.JpsProjectEntitiesLoaderKt;
import com.intellij.workspaceModel.storage.EntityChange;
import com.intellij.workspaceModel.storage.VersionedStorageChange;
import com.intellij.workspaceModel.storage.WorkspaceEntity;
import com.intellij.workspaceModel.storage.WorkspaceEntityStorageBuilder;
import com.intellij.workspaceModel.storage.bridgeEntities.LibraryId;
import com.intellij.workspaceModel.storage.bridgeEntities.LibraryTableId;
import com.intellij.workspaceModel.storage.bridgeEntities.ModifiableModuleEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.ModuleDependencyItem;
import com.intellij.workspaceModel.storage.bridgeEntities.ModuleEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.ModuleId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u00172\u00020\u0001:\u0003\u0017\u0018\u0019B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\rH\u0016J\b\u0010\u0011\u001a\u00020\rH\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0014J\b\u0010\u0014\u001a\u00020\rH\u0016J\u0010\u0010\u0015\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0016\u001a\u00020\rH\u0002R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00060\tR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00060\u000bR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/workspaceModel/ide/impl/legacyBridge/project/ProjectRootManagerBridge;", "Lcom/intellij/openapi/roots/impl/ProjectRootManagerComponent;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "globalLibraryTableListener", "Lcom/intellij/workspaceModel/ide/impl/legacyBridge/project/ProjectRootManagerBridge$GlobalLibraryTableListener;", "jdkChangeListener", "Lcom/intellij/workspaceModel/ide/impl/legacyBridge/project/ProjectRootManagerBridge$JdkChangeListener;", "addTrackedLibraryAndJdkFromEntity", "", "moduleEntity", "Lcom/intellij/workspaceModel/storage/bridgeEntities/ModuleEntity;", "dispose", "fireRootsChanged", "getActionToRunWhenProjectJdkChanges", "Ljava/lang/Runnable;", "projectClosed", "removeTrackedLibrariesAndJdkFromEntity", "unsubscribeListeners", "Companion", "GlobalLibraryTableListener", "JdkChangeListener", "intellij.platform.lang.impl"})
public final class ProjectRootManagerBridge
extends ProjectRootManagerComponent {
    private final Logger LOG;
    private final GlobalLibraryTableListener globalLibraryTableListener;
    private final JdkChangeListener jdkChangeListener;
    private static final String LIBRARY_NAME_DELIMITER = ":";
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    protected Runnable getActionToRunWhenProjectJdkChanges() {
        return new Runnable(this){
            final /* synthetic */ ProjectRootManagerBridge this$0;

            public final void run() {
                ProjectRootManagerBridge.access$getActionToRunWhenProjectJdkChanges$s567649755(this.this$0).run();
                if (ProjectRootManagerBridge.access$getJdkChangeListener$p(this.this$0).hasProjectSdkDependency()) {
                    ProjectRootManagerBridge.access$fireRootsChanged(this.this$0);
                }
            }
            {
                this.this$0 = projectRootManagerBridge;
            }
        };
    }

    @Override
    public void projectClosed() {
        super.projectClosed();
        this.unsubscribeListeners();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.unsubscribeListeners();
    }

    private final void unsubscribeListeners() {
        LibraryTablesRegistrar libraryTablesRegistrar;
        LibraryTablesRegistrar libraryTablesRegistrar2 = libraryTablesRegistrar = LibraryTablesRegistrar.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)libraryTablesRegistrar2, (String)"libraryTablesRegistrar");
        LibraryTable libraryTable = libraryTablesRegistrar2.getLibraryTable();
        Intrinsics.checkNotNullExpressionValue((Object)libraryTable, (String)"libraryTablesRegistrar.libraryTable");
        LibraryTable globalLibraryTable = libraryTable;
        Iterable $this$forEach$iv = this.globalLibraryTableListener.getLibraryLevels();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LibraryTable libraryTable2;
            Object object;
            LibraryTable libraryTable3;
            String libraryLevel = (String)element$iv;
            boolean bl = false;
            String string = libraryLevel;
            switch (string.hashCode()) {
                case 1554253136: {
                    if (string.equals("application")) {
                        libraryTable3 = globalLibraryTable;
                        break;
                    }
                }
                default: {
                    libraryTable3 = libraryTablesRegistrar.getLibraryTableByLevel(libraryLevel, this.getProject());
                }
            }
            if ((object = (libraryTable2 = libraryTable3)) != null && (object = object.getLibraryIterator()) != null) {
                Object $this$forEach$iv2 = object;
                boolean $i$f$forEach2 = false;
                Object object2 = $this$forEach$iv2;
                boolean bl2 = false;
                Object object3 = object2;
                while (object3.hasNext()) {
                    Object element$iv2 = object3.next();
                    Library it = (Library)element$iv2;
                    boolean bl3 = false;
                    Library library2 = it;
                    if (!(library2 instanceof RootProvider)) {
                        library2 = null;
                    }
                    RootProvider rootProvider = (RootProvider)library2;
                    if (rootProvider != null) {
                        rootProvider.removeRootSetChangedListener((RootProvider.RootSetChangedListener)this.globalLibraryTableListener);
                    }
                }
            }
            LibraryTable libraryTable4 = libraryTable2;
            if (libraryTable4 == null) continue;
            libraryTable4.removeListener((LibraryTable.Listener)this.globalLibraryTableListener);
        }
        this.globalLibraryTableListener.clear();
        this.jdkChangeListener.unsubscribeListeners();
    }

    private final void addTrackedLibraryAndJdkFromEntity(ModuleEntity moduleEntity) {
        Logger $this$debug$iv = this.LOG;
        Exception e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug$iv.isDebugEnabled()) {
            Logger logger = $this$debug$iv;
            boolean bl = false;
            String string = "Add tracked global libraries and JDK from " + moduleEntity.getName();
            logger.debug(string, (Throwable)e$iv);
        }
        LibraryTablesRegistrar libraryTablesRegistrar = LibraryTablesRegistrar.getInstance();
        Iterable $this$forEach$iv = moduleEntity.getDependencies();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ModuleDependencyItem it = (ModuleDependencyItem)element$iv;
            boolean bl = false;
            if (it instanceof ModuleDependencyItem.Exportable.LibraryDependency && ((ModuleDependencyItem.Exportable.LibraryDependency)it).getLibrary().getTableId() instanceof LibraryTableId.GlobalLibraryTableId) {
                LibraryTable libraryTable;
                String libraryName = ((ModuleDependencyItem.Exportable.LibraryDependency)it).getLibrary().getName();
                String libraryLevel = ((ModuleDependencyItem.Exportable.LibraryDependency)it).getLibrary().getTableId().getLevel();
                if (libraryTablesRegistrar.getLibraryTableByLevel(libraryLevel, this.getProject()) == null) {
                    continue;
                }
                Intrinsics.checkNotNullExpressionValue((Object)libraryTable, (String)"libraryTablesRegistrar.g\u2026roject) ?: return@forEach");
                if (this.globalLibraryTableListener.isEmpty(libraryLevel)) {
                    libraryTable.addListener((LibraryTable.Listener)this.globalLibraryTableListener);
                }
                this.globalLibraryTableListener.addTrackedLibrary(moduleEntity, libraryTable, libraryName);
                continue;
            }
            if (!(it instanceof ModuleDependencyItem.SdkDependency) && !(it instanceof ModuleDependencyItem.InheritedSdkDependency)) continue;
            this.jdkChangeListener.addTrackedJdk(it, moduleEntity);
        }
    }

    private final void removeTrackedLibrariesAndJdkFromEntity(ModuleEntity moduleEntity) {
        Logger $this$debug$iv = this.LOG;
        Exception e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug$iv.isDebugEnabled()) {
            Logger logger = $this$debug$iv;
            boolean bl = false;
            String string = "Removed tracked global libraries and JDK from " + moduleEntity.getName();
            logger.debug(string, (Throwable)e$iv);
        }
        LibraryTablesRegistrar libraryTablesRegistrar = LibraryTablesRegistrar.getInstance();
        Iterable $this$forEach$iv = moduleEntity.getDependencies();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ModuleDependencyItem it = (ModuleDependencyItem)element$iv;
            boolean bl = false;
            if (it instanceof ModuleDependencyItem.Exportable.LibraryDependency && ((ModuleDependencyItem.Exportable.LibraryDependency)it).getLibrary().getTableId() instanceof LibraryTableId.GlobalLibraryTableId) {
                LibraryTable libraryTable;
                String libraryName = ((ModuleDependencyItem.Exportable.LibraryDependency)it).getLibrary().getName();
                String libraryLevel = ((ModuleDependencyItem.Exportable.LibraryDependency)it).getLibrary().getTableId().getLevel();
                if (libraryTablesRegistrar.getLibraryTableByLevel(libraryLevel, this.getProject()) == null) {
                    continue;
                }
                Intrinsics.checkNotNullExpressionValue((Object)libraryTable, (String)"libraryTablesRegistrar.g\u2026roject) ?: return@forEach");
                this.globalLibraryTableListener.unTrackLibrary(moduleEntity, libraryTable, libraryName);
                if (!this.globalLibraryTableListener.isEmpty(libraryLevel)) continue;
                libraryTable.removeListener((LibraryTable.Listener)this.globalLibraryTableListener);
                continue;
            }
            if (!(it instanceof ModuleDependencyItem.SdkDependency) && !(it instanceof ModuleDependencyItem.InheritedSdkDependency)) continue;
            this.jdkChangeListener.removeTrackedJdk(it, moduleEntity);
        }
    }

    private final void fireRootsChanged() {
        Project project = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
        if (project.isOpen()) {
            this.makeRootsChange(EmptyRunnable.INSTANCE, false, true);
        }
    }

    public ProjectRootManagerBridge(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        Logger logger = Logger.getInstance(((Object)((Object)this)).getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(javaClass)");
        this.LOG = logger;
        this.globalLibraryTableListener = new GlobalLibraryTableListener();
        this.jdkChangeListener = new JdkChangeListener();
        MessageBusConnection messageBusConnection = project.getMessageBus().connect((Disposable)this);
        Intrinsics.checkNotNullExpressionValue((Object)messageBusConnection, (String)"project.messageBus.connect(this)");
        MessageBusConnection bus = messageBusConnection;
        WorkspaceModelTopics.Companion.getInstance(project).subscribeAfterModuleLoading(bus, new WorkspaceModelChangeListener(){

            @Override
            public void changed(@NotNull VersionedStorageChange event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Project project = myProject;
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
                if (project.isDisposed()) {
                    return;
                }
                List<EntityChange<ModuleEntity>> moduleChanges = event.getChanges(ModuleEntity.class);
                for (EntityChange<ModuleEntity> change : moduleChanges) {
                    EntityChange<ModuleEntity> entityChange = change;
                    if (entityChange instanceof EntityChange.Added) {
                        this.addTrackedLibraryAndJdkFromEntity((ModuleEntity)((EntityChange.Added)change).getEntity());
                        continue;
                    }
                    if (entityChange instanceof EntityChange.Removed) {
                        this.removeTrackedLibrariesAndJdkFromEntity((ModuleEntity)((EntityChange.Removed)change).getEntity());
                        continue;
                    }
                    if (!(entityChange instanceof EntityChange.Replaced)) continue;
                    this.removeTrackedLibrariesAndJdkFromEntity((ModuleEntity)((EntityChange.Replaced)change).getOldEntity());
                    this.addTrackedLibraryAndJdkFromEntity((ModuleEntity)((EntityChange.Replaced)change).getNewEntity());
                }
            }

            @Override
            public void beforeChanged(@NotNull VersionedStorageChange event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                WorkspaceModelChangeListener.DefaultImpls.beforeChanged(this, event);
            }
        });
        bus.subscribe(ProjectJdkTable.JDK_TABLE_TOPIC, (Object)this.jdkChangeListener);
    }

    public static final /* synthetic */ Runnable access$getActionToRunWhenProjectJdkChanges$s567649755(ProjectRootManagerBridge $this) {
        return super.getActionToRunWhenProjectJdkChanges();
    }

    public static final /* synthetic */ JdkChangeListener access$getJdkChangeListener$p(ProjectRootManagerBridge $this) {
        return $this.jdkChangeListener;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\tJ\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0013H\u0016J\u001a\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00132\b\u0010\u0017\u001a\u0004\u0018\u00010\tH\u0016J\u0006\u0010\u0018\u001a\u00020\u000bJ\u0010\u0010\u0019\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0013H\u0002J\u0018\u0010\u0019\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\tH\u0002J\u0016\u0010\u001a\u001a\u0012\u0012\u0004\u0012\u00020\t0\u001bj\b\u0012\u0004\u0012\u00020\t`\u001cJ\u000e\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\tJ\u0010\u0010\u001f\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020!H\u0016J\u001e\u0010\"\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/workspaceModel/ide/impl/legacyBridge/project/ProjectRootManagerBridge$GlobalLibraryTableListener;", "Lcom/intellij/openapi/roots/libraries/LibraryTable$Listener;", "Lcom/intellij/openapi/roots/RootProvider$RootSetChangedListener;", "(Lcom/intellij/workspaceModel/ide/impl/legacyBridge/project/ProjectRootManagerBridge;)V", "insideRootsChange", "", "librariesPerModuleMap", "Lcom/intellij/util/containers/BidirectionalMultiMap;", "Lcom/intellij/workspaceModel/storage/bridgeEntities/ModuleId;", "", "addTrackedLibrary", "", "moduleEntity", "Lcom/intellij/workspaceModel/storage/bridgeEntities/ModuleEntity;", "libraryTable", "Lcom/intellij/openapi/roots/libraries/LibraryTable;", "libraryName", "afterLibraryAdded", "newLibrary", "Lcom/intellij/openapi/roots/libraries/Library;", "afterLibraryRemoved", "library", "afterLibraryRenamed", "oldName", "clear", "getLibraryIdentifier", "getLibraryLevels", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "isEmpty", "libraryLevel", "rootSetChanged", "wrapper", "Lcom/intellij/openapi/roots/RootProvider;", "unTrackLibrary", "intellij.platform.lang.impl"})
    private final class GlobalLibraryTableListener
    implements LibraryTable.Listener,
    RootProvider.RootSetChangedListener {
        private final BidirectionalMultiMap<ModuleId, String> librariesPerModuleMap = new BidirectionalMultiMap();
        private boolean insideRootsChange;

        public final void addTrackedLibrary(@NotNull ModuleEntity moduleEntity, @NotNull LibraryTable libraryTable, @NotNull String libraryName) {
            Intrinsics.checkNotNullParameter((Object)moduleEntity, (String)"moduleEntity");
            Intrinsics.checkNotNullParameter((Object)libraryTable, (String)"libraryTable");
            Intrinsics.checkNotNullParameter((Object)libraryName, (String)"libraryName");
            Library library2 = libraryTable.getLibraryByName(libraryName);
            String libraryIdentifier = this.getLibraryIdentifier(libraryTable, libraryName);
            if (!this.librariesPerModuleMap.containsValue((Object)libraryIdentifier)) {
                Library library3 = library2;
                if (!(library3 instanceof RootProvider)) {
                    library3 = null;
                }
                RootProvider rootProvider = (RootProvider)library3;
                if (rootProvider != null) {
                    rootProvider.addRootSetChangedListener((RootProvider.RootSetChangedListener)this);
                }
            }
            this.librariesPerModuleMap.put((Object)moduleEntity.persistentId(), (Object)libraryIdentifier);
        }

        public final void unTrackLibrary(@NotNull ModuleEntity moduleEntity, @NotNull LibraryTable libraryTable, @NotNull String libraryName) {
            block2: {
                Intrinsics.checkNotNullParameter((Object)moduleEntity, (String)"moduleEntity");
                Intrinsics.checkNotNullParameter((Object)libraryTable, (String)"libraryTable");
                Intrinsics.checkNotNullParameter((Object)libraryName, (String)"libraryName");
                Library library2 = libraryTable.getLibraryByName(libraryName);
                String libraryIdentifier = this.getLibraryIdentifier(libraryTable, libraryName);
                this.librariesPerModuleMap.remove((Object)moduleEntity.persistentId(), (Object)libraryIdentifier);
                if (this.librariesPerModuleMap.containsValue((Object)libraryIdentifier)) break block2;
                Library library3 = library2;
                if (!(library3 instanceof RootProvider)) {
                    library3 = null;
                }
                RootProvider rootProvider = (RootProvider)library3;
                if (rootProvider != null) {
                    rootProvider.removeRootSetChangedListener((RootProvider.RootSetChangedListener)this);
                }
            }
        }

        public final boolean isEmpty(@NotNull String libraryLevel) {
            boolean bl;
            block3: {
                Intrinsics.checkNotNullParameter((Object)libraryLevel, (String)"libraryLevel");
                Set set2 = this.librariesPerModuleMap.getValues();
                Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"librariesPerModuleMap.values");
                Iterable $this$none$iv = set2;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        String string = it;
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it");
                        if (!StringsKt.startsWith$default((String)string, (String)(libraryLevel + ':'), (boolean)false, (int)2, null)) continue;
                        bl = false;
                        break block3;
                    }
                    bl = true;
                }
            }
            return bl;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final HashSet<String> getLibraryLevels() {
            void var2_2;
            void $this$mapTo$iv;
            Set set2 = this.librariesPerModuleMap.getValues();
            Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"librariesPerModuleMap.values");
            Iterable iterable = set2;
            Collection destination$iv = new HashSet();
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it;
                String string = (String)item$iv;
                Collection collection = destination$iv;
                boolean bl = false;
                void v1 = it;
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"it");
                String string2 = StringsKt.substringBefore$default((String)v1, (String)ProjectRootManagerBridge.LIBRARY_NAME_DELIMITER, null, (int)2, null);
                collection.add(string2);
            }
            return (HashSet)var2_2;
        }

        public void afterLibraryAdded(@NotNull Library newLibrary) {
            Intrinsics.checkNotNullParameter((Object)newLibrary, (String)"newLibrary");
            if (this.librariesPerModuleMap.containsValue((Object)this.getLibraryIdentifier(newLibrary))) {
                ProjectRootManagerBridge.this.fireRootsChanged();
            }
        }

        public void afterLibraryRemoved(@NotNull Library library2) {
            Intrinsics.checkNotNullParameter((Object)library2, (String)"library");
            if (this.librariesPerModuleMap.containsValue((Object)this.getLibraryIdentifier(library2))) {
                ProjectRootManagerBridge.this.fireRootsChanged();
            }
        }

        public void afterLibraryRenamed(@NotNull Library library2, @Nullable String oldName) {
            Intrinsics.checkNotNullParameter((Object)library2, (String)"library");
            LibraryTable libraryTable = library2.getTable();
            String newName2 = library2.getName();
            if (libraryTable != null && oldName != null && newName2 != null) {
                Set set2 = this.librariesPerModuleMap.getKeys((Object)this.getLibraryIdentifier(libraryTable, oldName));
                Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"librariesPerModuleMap.ge\u2026r(libraryTable, oldName))");
                Set affectedModules = set2;
                Collection collection = affectedModules;
                boolean bl = false;
                if (!collection.isEmpty()) {
                    String string = libraryTable.getTableLevel();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"libraryTable.tableLevel");
                    LibraryTableId libraryTableId = JpsProjectEntitiesLoaderKt.levelToLibraryTableId(string);
                    Project project = ProjectRootManagerBridge.this.myProject;
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
                    WorkspaceModel.Companion.getInstance(project).updateProjectModel((Function1)new Function1<WorkspaceEntityStorageBuilder, Unit>(affectedModules, libraryTableId, oldName, newName2){
                        final /* synthetic */ Set $affectedModules;
                        final /* synthetic */ LibraryTableId $libraryTableId;
                        final /* synthetic */ String $oldName;
                        final /* synthetic */ String $newName;

                        /*
                         * WARNING - void declaration
                         */
                        public final void invoke(@NotNull WorkspaceEntityStorageBuilder builder2) {
                            ModuleDependencyItem moduleDependencyItem;
                            Object element$iv$iv$iv;
                            void $this$mapNotNullTo$iv$iv;
                            Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
                            Iterable $this$mapNotNull$iv = this.$affectedModules;
                            boolean $i$f$mapNotNull = false;
                            Iterable iterable = $this$mapNotNull$iv;
                            Collection destination$iv$iv = new ArrayList<E>();
                            boolean $i$f$mapNotNullTo = false;
                            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                            boolean $i$f$forEach = false;
                            Iterator<T> iterator2 = $this$forEach$iv$iv$iv.iterator();
                            while (iterator2.hasNext()) {
                                T element$iv$iv = element$iv$iv$iv = iterator2.next();
                                boolean bl = false;
                                ModuleId it = (ModuleId)element$iv$iv;
                                boolean bl2 = false;
                                ModuleId moduleId = it;
                                Intrinsics.checkNotNullExpressionValue((Object)moduleId, (String)"it");
                                if ((ModuleEntity)builder2.resolve(moduleId) == null) continue;
                                boolean bl3 = false;
                                boolean bl4 = false;
                                ModuleEntity it$iv$iv = moduleDependencyItem;
                                boolean bl5 = false;
                                destination$iv$iv.add(it$iv$iv);
                            }
                            Iterable $this$forEach$iv = (List)destination$iv$iv;
                            boolean $i$f$forEach2 = false;
                            for (E element$iv : $this$forEach$iv) {
                                void $this$mapTo$iv$iv;
                                ModuleEntity module = (ModuleEntity)element$iv;
                                boolean bl = false;
                                Iterable $this$map$iv = module.getDependencies();
                                boolean $i$f$map = false;
                                element$iv$iv$iv = $this$map$iv;
                                Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                boolean $i$f$mapTo = false;
                                for (T item$iv$iv : $this$mapTo$iv$iv) {
                                    void it;
                                    moduleDependencyItem = (ModuleDependencyItem)item$iv$iv;
                                    Collection collection = destination$iv$iv2;
                                    boolean bl6 = false;
                                    void var18_24 = it instanceof ModuleDependencyItem.Exportable.LibraryDependency && Intrinsics.areEqual((Object)((ModuleDependencyItem.Exportable.LibraryDependency)it).getLibrary().getTableId(), (Object)this.$libraryTableId) && Intrinsics.areEqual((Object)((ModuleDependencyItem.Exportable.LibraryDependency)it).getLibrary().getName(), (Object)this.$oldName) ? (ModuleDependencyItem)ModuleDependencyItem.Exportable.LibraryDependency.copy$default((ModuleDependencyItem.Exportable.LibraryDependency)it, new LibraryId(this.$newName, this.$libraryTableId), false, null, 6, null) : it;
                                    collection.add(var18_24);
                                }
                                List updated = (List)destination$iv$iv2;
                                builder2.modifyEntity(ModifiableModuleEntity.class, (WorkspaceEntity)module, (Function1)new Function1<ModifiableModuleEntity, Unit>(updated){
                                    final /* synthetic */ List $updated;

                                    public final void invoke(@NotNull ModifiableModuleEntity $this$modifyEntity) {
                                        Intrinsics.checkNotNullParameter((Object)$this$modifyEntity, (String)"$receiver");
                                        $this$modifyEntity.setDependencies(this.$updated);
                                    }
                                    {
                                        this.$updated = list2;
                                        super(1);
                                    }
                                });
                            }
                        }
                        {
                            this.$affectedModules = set2;
                            this.$libraryTableId = libraryTableId;
                            this.$oldName = string;
                            this.$newName = string2;
                            super(1);
                        }
                    });
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void rootSetChanged(@NotNull RootProvider wrapper2) {
            Intrinsics.checkNotNullParameter((Object)wrapper2, (String)"wrapper");
            if (this.insideRootsChange) {
                return;
            }
            this.insideRootsChange = true;
            try {
                ProjectRootManagerBridge.this.fireRootsChanged();
            }
            finally {
                this.insideRootsChange = false;
            }
        }

        private final String getLibraryIdentifier(Library library2) {
            StringBuilder stringBuilder = new StringBuilder();
            LibraryTable libraryTable = library2.getTable();
            Intrinsics.checkNotNullExpressionValue((Object)libraryTable, (String)"library.table");
            return stringBuilder.append(libraryTable.getTableLevel()).append(':').append(library2.getName()).toString();
        }

        private final String getLibraryIdentifier(LibraryTable libraryTable, String libraryName) {
            return libraryTable.getTableLevel() + ':' + libraryName;
        }

        public final void clear() {
            this.librariesPerModuleMap.clear();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0010\u001a\u00020\u0006H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0014H\u0002J\u0006\u0010\u0018\u001a\u00020\u0016J\u0010\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0014H\u0016J\u0018\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0014H\u0016J\u0016\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u001f\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\fH\u0016J\u0006\u0010!\u001a\u00020\u000fR/\u0010\u0004\u001a#\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\b0\b0\u0005\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\f0\u000bj\b\u0012\u0004\u0012\u00020\f`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/workspaceModel/ide/impl/legacyBridge/project/ProjectRootManagerBridge$JdkChangeListener;", "Lcom/intellij/openapi/projectRoots/ProjectJdkTable$Listener;", "Lcom/intellij/openapi/roots/RootProvider$RootSetChangedListener;", "(Lcom/intellij/workspaceModel/ide/impl/legacyBridge/project/ProjectRootManagerBridge;)V", "sdkDependencies", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/workspaceModel/storage/bridgeEntities/ModuleDependencyItem;", "kotlin.jvm.PlatformType", "Lcom/intellij/workspaceModel/storage/bridgeEntities/ModuleId;", "Lorg/jetbrains/annotations/NotNull;", "watchedSdks", "Ljava/util/HashSet;", "Lcom/intellij/openapi/roots/RootProvider;", "Lkotlin/collections/HashSet;", "addTrackedJdk", "", "sdkDependency", "moduleEntity", "Lcom/intellij/workspaceModel/storage/bridgeEntities/ModuleEntity;", "findSdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "hasDependencies", "", "jdk", "hasProjectSdkDependency", "jdkAdded", "jdkNameChanged", "previousName", "", "jdkRemoved", "removeTrackedJdk", "rootSetChanged", "wrapper", "unsubscribeListeners", "intellij.platform.lang.impl"})
    private final class JdkChangeListener
    implements ProjectJdkTable.Listener,
    RootProvider.RootSetChangedListener {
        private final MultiMap<ModuleDependencyItem, ModuleId> sdkDependencies;
        private final HashSet<RootProvider> watchedSdks;

        public void jdkAdded(@NotNull Sdk jdk) {
            Intrinsics.checkNotNullParameter((Object)jdk, (String)"jdk");
            if (this.hasDependencies(jdk)) {
                if (this.watchedSdks.add(jdk.getRootProvider())) {
                    jdk.getRootProvider().addRootSetChangedListener((RootProvider.RootSetChangedListener)this);
                }
                ProjectRootManagerBridge.this.fireRootsChanged();
            }
        }

        public void jdkNameChanged(@NotNull Sdk jdk, @NotNull String previousName) {
            Collection affectedModules;
            Intrinsics.checkNotNullParameter((Object)jdk, (String)"jdk");
            Intrinsics.checkNotNullParameter((Object)previousName, (String)"previousName");
            SdkTypeId sdkTypeId = jdk.getSdkType();
            Intrinsics.checkNotNullExpressionValue((Object)sdkTypeId, (String)"jdk.sdkType");
            String string = sdkTypeId.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jdk.sdkType.name");
            ModuleDependencyItem.SdkDependency sdkDependency = new ModuleDependencyItem.SdkDependency(previousName, string);
            Collection collection = this.sdkDependencies.get((Object)sdkDependency);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"sdkDependencies.get(sdkDependency)");
            Collection collection2 = affectedModules = collection;
            boolean bl = false;
            if (!collection2.isEmpty()) {
                Project project = ProjectRootManagerBridge.this.myProject;
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
                WorkspaceModel.Companion.getInstance(project).updateProjectModel((Function1)new Function1<WorkspaceEntityStorageBuilder, Unit>(affectedModules, jdk){
                    final /* synthetic */ Collection $affectedModules;
                    final /* synthetic */ Sdk $jdk;

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(@NotNull WorkspaceEntityStorageBuilder builder2) {
                        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
                        for (ModuleId moduleId : this.$affectedModules) {
                            void $this$mapTo$iv$iv;
                            ModuleEntity module;
                            if ((ModuleEntity)moduleId.resolve(builder2) == null) {
                                continue;
                            }
                            Iterable $this$map$iv = module.getDependencies();
                            boolean $i$f$map = false;
                            Iterable iterable = $this$map$iv;
                            Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                            boolean $i$f$mapTo = false;
                            for (T item$iv$iv : $this$mapTo$iv$iv) {
                                ModuleDependencyItem moduleDependencyItem;
                                void it;
                                ModuleDependencyItem moduleDependencyItem2 = (ModuleDependencyItem)item$iv$iv;
                                Collection collection = destination$iv$iv;
                                boolean bl = false;
                                void var15_15 = it;
                                if (var15_15 instanceof ModuleDependencyItem.SdkDependency) {
                                    String string = this.$jdk.getName();
                                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jdk.name");
                                    SdkTypeId sdkTypeId = this.$jdk.getSdkType();
                                    Intrinsics.checkNotNullExpressionValue((Object)sdkTypeId, (String)"jdk.sdkType");
                                    String string2 = sdkTypeId.getName();
                                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"jdk.sdkType.name");
                                    moduleDependencyItem = new ModuleDependencyItem.SdkDependency(string, string2);
                                } else {
                                    moduleDependencyItem = it;
                                }
                                void var17_17 = moduleDependencyItem;
                                collection.add(var17_17);
                            }
                            List updated = (List)destination$iv$iv;
                            builder2.modifyEntity(ModifiableModuleEntity.class, (WorkspaceEntity)module, (Function1)new Function1<ModifiableModuleEntity, Unit>(updated){
                                final /* synthetic */ List $updated;

                                public final void invoke(@NotNull ModifiableModuleEntity $this$modifyEntity) {
                                    Intrinsics.checkNotNullParameter((Object)$this$modifyEntity, (String)"$receiver");
                                    $this$modifyEntity.setDependencies(this.$updated);
                                }
                                {
                                    this.$updated = list2;
                                    super(1);
                                }
                            });
                        }
                    }
                    {
                        this.$affectedModules = collection;
                        this.$jdk = sdk2;
                        super(1);
                    }
                });
            }
        }

        public void jdkRemoved(@NotNull Sdk jdk) {
            Intrinsics.checkNotNullParameter((Object)jdk, (String)"jdk");
            if (this.watchedSdks.remove(jdk.getRootProvider())) {
                jdk.getRootProvider().removeRootSetChangedListener((RootProvider.RootSetChangedListener)this);
            }
            if (this.hasDependencies(jdk)) {
                ProjectRootManagerBridge.this.fireRootsChanged();
            }
        }

        public void rootSetChanged(@NotNull RootProvider wrapper2) {
            Intrinsics.checkNotNullParameter((Object)wrapper2, (String)"wrapper");
            ProjectRootManagerBridge.this.fireRootsChanged();
        }

        public final void addTrackedJdk(@NotNull ModuleDependencyItem sdkDependency, @NotNull ModuleEntity moduleEntity) {
            Intrinsics.checkNotNullParameter((Object)sdkDependency, (String)"sdkDependency");
            Intrinsics.checkNotNullParameter((Object)moduleEntity, (String)"moduleEntity");
            Sdk sdk2 = this.findSdk(sdkDependency);
            if (sdk2 != null && this.watchedSdks.add(sdk2.getRootProvider())) {
                sdk2.getRootProvider().addRootSetChangedListener((RootProvider.RootSetChangedListener)this);
            }
            this.sdkDependencies.putValue((Object)sdkDependency, (Object)moduleEntity.persistentId());
        }

        public final void removeTrackedJdk(@NotNull ModuleDependencyItem sdkDependency, @NotNull ModuleEntity moduleEntity) {
            Intrinsics.checkNotNullParameter((Object)sdkDependency, (String)"sdkDependency");
            Intrinsics.checkNotNullParameter((Object)moduleEntity, (String)"moduleEntity");
            this.sdkDependencies.remove((Object)sdkDependency, (Object)moduleEntity.persistentId());
            Sdk sdk2 = this.findSdk(sdkDependency);
            if (sdk2 != null && !this.hasDependencies(sdk2) && this.watchedSdks.remove(sdk2.getRootProvider())) {
                sdk2.getRootProvider().removeRootSetChangedListener((RootProvider.RootSetChangedListener)this);
            }
        }

        public final boolean hasProjectSdkDependency() {
            Collection collection = this.sdkDependencies.get((Object)ModuleDependencyItem.InheritedSdkDependency.INSTANCE);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"sdkDependencies.get(Modu\u2026m.InheritedSdkDependency)");
            Collection collection2 = collection;
            boolean bl = false;
            return !collection2.isEmpty();
        }

        private final Sdk findSdk(ModuleDependencyItem sdkDependency) {
            ModuleDependencyItem moduleDependencyItem = sdkDependency;
            return moduleDependencyItem instanceof ModuleDependencyItem.InheritedSdkDependency ? ProjectRootManagerBridge.this.getProjectSdk() : (moduleDependencyItem instanceof ModuleDependencyItem.SdkDependency ? ProjectJdkTable.getInstance().findJdk(((ModuleDependencyItem.SdkDependency)sdkDependency).getSdkName(), ((ModuleDependencyItem.SdkDependency)sdkDependency).getSdkType()) : null);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean hasDependencies(Sdk jdk) {
            String string = jdk.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jdk.name");
            SdkTypeId sdkTypeId = jdk.getSdkType();
            Intrinsics.checkNotNullExpressionValue((Object)sdkTypeId, (String)"jdk.sdkType");
            String string2 = sdkTypeId.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"jdk.sdkType.name");
            Collection collection = this.sdkDependencies.get((Object)new ModuleDependencyItem.SdkDependency(string, string2));
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"sdkDependencies.get(Modu\u2026.name, jdk.sdkType.name))");
            Collection collection2 = collection;
            boolean bl = false;
            if (!collection2.isEmpty()) {
                return true;
            }
            boolean bl2 = false;
            if (bl2) return true;
            if (!Intrinsics.areEqual((Object)jdk.getName(), (Object)ProjectRootManagerBridge.this.getProjectSdkName())) return false;
            SdkTypeId sdkTypeId2 = jdk.getSdkType();
            Intrinsics.checkNotNullExpressionValue((Object)sdkTypeId2, (String)"jdk.sdkType");
            if (!Intrinsics.areEqual((Object)sdkTypeId2.getName(), (Object)ProjectRootManagerBridge.this.getProjectSdkTypeName())) return false;
            if (!this.hasProjectSdkDependency()) return false;
            return true;
        }

        public final void unsubscribeListeners() {
            Iterable $this$forEach$iv = this.watchedSdks;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RootProvider it = (RootProvider)element$iv;
                boolean bl = false;
                it.removeRootSetChangedListener((RootProvider.RootSetChangedListener)this);
            }
            this.watchedSdks.clear();
        }

        public JdkChangeListener() {
            MultiMap multiMap = MultiMap.createSet();
            Intrinsics.checkNotNullExpressionValue((Object)multiMap, (String)"MultiMap.createSet<Modul\u2026pendencyItem, ModuleId>()");
            this.sdkDependencies = multiMap;
            this.watchedSdks = new HashSet();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/workspaceModel/ide/impl/legacyBridge/project/ProjectRootManagerBridge$Companion;", "", "()V", "LIBRARY_NAME_DELIMITER", "", "intellij.platform.lang.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

