/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.stubs.StubUpdatingIndex;
import com.intellij.util.SystemProperties;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.UnindexedFilesUpdater;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IndexInfrastructure {
    private static final String STUB_VERSIONS = ".versions";
    private static final String PERSISTENT_INDEX_DIRECTORY_NAME = ".persistent";
    private static final boolean ourDoParallelIndicesInitialization = SystemProperties.getBooleanProperty((String)"idea.parallel.indices.initialization", (boolean)false);
    public static final boolean ourDoAsyncIndicesInitialization = SystemProperties.getBooleanProperty((String)"idea.async.indices.initialization", (boolean)true);
    private static final ExecutorService ourGenesisExecutor = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"IndexInfrastructure Pool");

    private IndexInfrastructure() {
    }

    @NotNull
    public static File getVersionFile(@NotNull ID<?, ?> indexName) {
        if (indexName == null) {
            IndexInfrastructure.$$$reportNull$$$0(0);
        }
        return new File(IndexInfrastructure.getIndexDirectory(indexName, true), indexName + ".ver");
    }

    @NotNull
    public static File getStorageFile(@NotNull ID<?, ?> indexName) {
        if (indexName == null) {
            IndexInfrastructure.$$$reportNull$$$0(1);
        }
        return new File(IndexInfrastructure.getIndexRootDir(indexName), indexName.getName());
    }

    @NotNull
    public static File getInputIndexStorageFile(@NotNull ID<?, ?> indexName) {
        if (indexName == null) {
            IndexInfrastructure.$$$reportNull$$$0(2);
        }
        return new File(IndexInfrastructure.getIndexRootDir(indexName), indexName + "_inputs");
    }

    @NotNull
    public static File getIndexRootDir(@NotNull ID<?, ?> indexName) {
        if (indexName == null) {
            IndexInfrastructure.$$$reportNull$$$0(3);
        }
        return IndexInfrastructure.getIndexDirectory(indexName, false);
    }

    public static File getPersistentIndexRoot() {
        File indexDir = new File(PathManager.getIndexRoot() + File.separator + PERSISTENT_INDEX_DIRECTORY_NAME);
        indexDir.mkdirs();
        return indexDir;
    }

    @NotNull
    public static File getPersistentIndexRootDir(@NotNull ID<?, ?> indexName) {
        if (indexName == null) {
            IndexInfrastructure.$$$reportNull$$$0(4);
        }
        return IndexInfrastructure.getIndexDirectory(indexName, false, PERSISTENT_INDEX_DIRECTORY_NAME);
    }

    @NotNull
    private static File getIndexDirectory(@NotNull ID<?, ?> indexName, boolean forVersion) {
        if (indexName == null) {
            IndexInfrastructure.$$$reportNull$$$0(5);
        }
        return IndexInfrastructure.getIndexDirectory(indexName, forVersion, "");
    }

    @NotNull
    private static File getIndexDirectory(@NotNull ID<?, ?> indexId, boolean forVersion, String relativePath) {
        if (indexId == null) {
            IndexInfrastructure.$$$reportNull$$$0(6);
        }
        return IndexInfrastructure.getIndexDirectory(indexId.getName(), relativePath, indexId instanceof StubIndexKey, forVersion);
    }

    @NotNull
    private static File getIndexDirectory(String indexName, String relativePath, boolean stubKey, boolean forVersion) {
        File indexDir;
        indexName = StringUtil.toLowerCase((String)indexName);
        if (stubKey) {
            indexDir = new File(IndexInfrastructure.getIndexDirectory(StubUpdatingIndex.INDEX_ID, false, (String)relativePath), forVersion ? STUB_VERSIONS : indexName);
        } else {
            if (((String)relativePath).length() > 0) {
                relativePath = File.separator + (String)relativePath;
            }
            indexDir = new File(PathManager.getIndexRoot() + (String)relativePath, indexName);
        }
        if (!FileBasedIndex.USE_IN_MEMORY_INDEX) {
            indexDir.mkdirs();
        }
        File file2 = indexDir;
        if (file2 == null) {
            IndexInfrastructure.$$$reportNull$$$0(7);
        }
        return file2;
    }

    @Nullable
    public static VirtualFile findFileById(@NotNull PersistentFS fs, int id2) {
        if (fs == null) {
            IndexInfrastructure.$$$reportNull$$$0(8);
        }
        return fs.findFileById(id2);
    }

    @Nullable
    public static VirtualFile findFileByIdIfCached(@NotNull PersistentFS fs, int id2) {
        if (fs == null) {
            IndexInfrastructure.$$$reportNull$$$0(9);
        }
        return fs.findFileByIdIfCached(id2);
    }

    @NotNull
    public static <T> Future<T> submitGenesisTask(@NotNull Callable<T> action2) {
        if (action2 == null) {
            IndexInfrastructure.$$$reportNull$$$0(10);
        }
        Future<T> future2 = ourGenesisExecutor.submit(action2);
        if (future2 == null) {
            IndexInfrastructure.$$$reportNull$$$0(11);
        }
        return future2;
    }

    @ApiStatus.Internal
    public static File getFileBasedIndexRootDir(@NotNull String indexName) {
        if (indexName == null) {
            IndexInfrastructure.$$$reportNull$$$0(12);
        }
        return IndexInfrastructure.getIndexDirectory(indexName, "", false, false);
    }

    @ApiStatus.Internal
    public static File getStubIndexRootDir(@NotNull String indexName) {
        if (indexName == null) {
            IndexInfrastructure.$$$reportNull$$$0(13);
        }
        return IndexInfrastructure.getIndexDirectory(indexName, "", true, false);
    }

    public static boolean hasIndices() {
        return !SystemProperties.is((String)"idea.skip.indices.initialization");
    }

    public static boolean isIndexesInitializationSuspended() {
        return SystemProperties.is((String)"idea.suspend.indexes.initialization");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexId";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/IndexInfrastructure";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fs";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/IndexInfrastructure";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexDirectory";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "submitGenesisTask";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getVersionFile";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getStorageFile";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getInputIndexStorageFile";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getIndexRootDir";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPersistentIndexRootDir";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getIndexDirectory";
                break;
            }
            case 7: 
            case 11: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findFileById";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findFileByIdIfCached";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "submitGenesisTask";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getFileBasedIndexRootDir";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getStubIndexRootDir";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static abstract class DataInitialization<T>
    implements Callable<T> {
        private final List<ThrowableRunnable<?>> myNestedInitializationTasks = new ArrayList();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final T call() throws Exception {
            long started = System.nanoTime();
            try {
                this.prepare();
                this.runParallelNestedInitializationTasks();
                T t = this.finish();
                return t;
            }
            finally {
                Logger.getInstance((String)this.getClass().getName()).info("Initialization done: " + (System.nanoTime() - started) / 1000000L);
            }
        }

        protected T finish() {
            return null;
        }

        protected void prepare() {
        }

        protected abstract void onThrowable(@NotNull Throwable var1);

        protected void addNestedInitializationTask(@NotNull ThrowableRunnable<?> nestedInitializationTask) {
            if (nestedInitializationTask == null) {
                DataInitialization.$$$reportNull$$$0(0);
            }
            this.myNestedInitializationTasks.add(nestedInitializationTask);
        }

        private void runParallelNestedInitializationTasks() throws InterruptedException {
            int numberOfTasksToExecute = this.myNestedInitializationTasks.size();
            if (numberOfTasksToExecute == 0) {
                return;
            }
            CountDownLatch proceedLatch = new CountDownLatch(numberOfTasksToExecute);
            if (ourDoParallelIndicesInitialization) {
                ExecutorService taskExecutor = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"IndexInfrastructure.DataInitialization.RunParallelNestedInitializationTasks", (Executor)AppExecutorUtil.getAppExecutorService(), (int)UnindexedFilesUpdater.getNumberOfIndexingThreads());
                for (ThrowableRunnable<?> callable : this.myNestedInitializationTasks) {
                    taskExecutor.execute(() -> this.executeNestedInitializationTask(callable, proceedLatch));
                }
                proceedLatch.await();
                taskExecutor.shutdown();
            } else {
                for (ThrowableRunnable<?> callable : this.myNestedInitializationTasks) {
                    this.executeNestedInitializationTask(callable, proceedLatch);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void executeNestedInitializationTask(@NotNull ThrowableRunnable<?> callable, CountDownLatch proceedLatch) {
            if (callable == null) {
                DataInitialization.$$$reportNull$$$0(1);
            }
            Application app = ApplicationManager.getApplication();
            try {
                if (app.isDisposed()) {
                    return;
                }
                callable.run();
            }
            catch (Throwable t) {
                this.onThrowable(t);
            }
            finally {
                proceedLatch.countDown();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nestedInitializationTask";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callable";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/util/indexing/IndexInfrastructure$DataInitialization";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addNestedInitializationTask";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "executeNestedInitializationTask";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

