/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.UIBundle;
import com.intellij.util.Consumer;
import com.intellij.util.ui.OwnerOptional;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.nio.file.Path;
import org.jetbrains.annotations.Nullable;

public final class MacFileSaverDialog
implements FileSaverDialog {
    private FileDialog myFileDialog;
    private final FileSaverDescriptor myDescriptor;

    private static String getChooserTitle(FileChooserDescriptor descriptor2) {
        String title = descriptor2.getTitle();
        return title != null ? title : UIBundle.message((String)"file.chooser.default.title", (Object[])new Object[0]);
    }

    public MacFileSaverDialog(FileSaverDescriptor descriptor2, Project project) {
        this(descriptor2, IdeFocusManager.getInstance((Project)project).getFocusOwner());
    }

    public MacFileSaverDialog(FileSaverDescriptor descriptor2, Component parent) {
        String title = MacFileSaverDialog.getChooserTitle((FileChooserDescriptor)descriptor2);
        Consumer dialogConsumer = owner -> {
            this.myFileDialog = new FileDialog((Dialog)owner, title, 1);
        };
        Consumer frameConsumer = owner -> {
            this.myFileDialog = new FileDialog((Frame)owner, title, 1);
        };
        this.myDescriptor = descriptor2;
        OwnerOptional.fromComponent(parent).ifDialog((Consumer<? super Dialog>)dialogConsumer).ifFrame((Consumer<? super Frame>)frameConsumer).ifNull((Consumer<? super Frame>)frameConsumer);
    }

    @Nullable
    public VirtualFileWrapper save(@Nullable VirtualFile baseDir, @Nullable String filename) {
        return this.doSave(baseDir == null ? null : baseDir.getCanonicalPath(), filename);
    }

    @Nullable
    public VirtualFileWrapper save(@Nullable Path baseDir, @Nullable String filename) {
        return this.doSave(baseDir == null ? null : baseDir.toAbsolutePath().normalize().toString(), filename);
    }

    @Nullable
    private VirtualFileWrapper doSave(@Nullable String baseDir, @Nullable String filename) {
        this.myFileDialog.setDirectory(baseDir);
        this.myFileDialog.setFile(filename);
        this.myFileDialog.setFilenameFilter((dir, name) -> {
            String vfsPath = FileUtil.toSystemIndependentName((String)new File(dir, name).getAbsolutePath());
            return this.myDescriptor.isFileSelectable(LocalFileSystem.getInstance().refreshAndFindFileByPath(vfsPath));
        });
        this.myFileDialog.setVisible(true);
        String file2 = this.myFileDialog.getFile();
        return file2 == null ? null : new VirtualFileWrapper(new File(this.myFileDialog.getDirectory() + File.separator + file2));
    }
}

