/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tools;

import com.intellij.execution.process.ProcessListener;
import com.intellij.ide.macro.MacroManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.DumbAware;
import com.intellij.tools.HackyDataContext;
import com.intellij.tools.Tool;
import com.intellij.tools.ToolRunProfile;
import com.intellij.tools.ToolsBundle;
import com.intellij.tools.ToolsProvider;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToolAction
extends AnAction
implements DumbAware {
    private final String myActionId;

    public ToolAction(@NotNull Tool tool) {
        if (tool == null) {
            ToolAction.$$$reportNull$$$0(0);
        }
        this.myActionId = tool.getActionId();
        this.getTemplatePresentation().setText(tool.getName(), false);
        this.getTemplatePresentation().setDescription(tool.getDescription());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ToolAction.$$$reportNull$$$0(1);
        }
        ToolAction.runTool(this.myActionId, e.getDataContext(), e, 0L, null);
    }

    public void update(@NotNull AnActionEvent e) {
        Tool tool;
        if (e == null) {
            ToolAction.$$$reportNull$$$0(2);
        }
        if ((tool = ToolAction.findTool(this.myActionId, e.getDataContext())) != null) {
            e.getPresentation().setText(ToolRunProfile.expandMacrosInName(tool, e.getDataContext()), false);
        }
    }

    private static Tool findTool(String actionId, DataContext context) {
        MacroManager.getInstance().cacheMacrosPreview(context);
        for (Tool tool : ToolAction.getAllTools()) {
            if (!actionId.equals(tool.getActionId())) continue;
            return tool;
        }
        return null;
    }

    protected static List<Tool> getAllTools() {
        return ToolsProvider.getAllTools();
    }

    static void runTool(String actionId, DataContext context) {
        ToolAction.runTool(actionId, context, null, 0L, null);
    }

    static void runTool(String actionId, DataContext context, @Nullable AnActionEvent e, long executionId, @Nullable ProcessListener processListener) {
        Tool tool = ToolAction.findTool(actionId, context);
        if (tool != null) {
            tool.execute(e, new HackyDataContext(context), executionId, processListener);
        } else {
            Tool.notifyCouldNotStart(processListener);
        }
    }

    @Nullable
    public String getTemplateText() {
        return ToolsBundle.message("action.text.external.tool", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tool";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/intellij/tools/ToolAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

