/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.terminal.CompositeFilterWrapper;
import com.intellij.terminal.JBTerminalPanel;
import com.intellij.terminal.JBTerminalStarter;
import com.intellij.terminal.JBTerminalSystemSettingsProviderBase;
import com.intellij.terminal.JBTerminalWidgetListener;
import com.intellij.terminal.TerminalExecutionConsole;
import com.intellij.terminal.TerminalSplitAction;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.components.JBScrollBar;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBSwingUtilities;
import com.jediterm.terminal.SubstringFinder;
import com.jediterm.terminal.Terminal;
import com.jediterm.terminal.TerminalColor;
import com.jediterm.terminal.TerminalStarter;
import com.jediterm.terminal.TtyConnector;
import com.jediterm.terminal.model.JediTerminal;
import com.jediterm.terminal.model.SelectionUtil;
import com.jediterm.terminal.model.StyleState;
import com.jediterm.terminal.model.TerminalSelection;
import com.jediterm.terminal.model.TerminalTextBuffer;
import com.jediterm.terminal.model.hyperlinks.LinkInfo;
import com.jediterm.terminal.model.hyperlinks.LinkResult;
import com.jediterm.terminal.model.hyperlinks.LinkResultItem;
import com.jediterm.terminal.ui.JediTermWidget;
import com.jediterm.terminal.ui.TerminalAction;
import com.jediterm.terminal.ui.TerminalPanel;
import com.jediterm.terminal.ui.settings.SettingsProvider;
import com.jediterm.terminal.util.Pair;
import java.awt.Component;
import java.awt.Container;
import java.awt.DefaultFocusTraversalPolicy;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ItemListener;
import java.awt.event.KeyListener;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JBTerminalWidget
extends JediTermWidget
implements Disposable,
DataProvider {
    public static final DataKey<String> SELECTED_TEXT_DATA_KEY = DataKey.create((String)(JBTerminalWidget.class.getName() + " selected text"));
    public static final DataKey<JBTerminalWidget> TERMINAL_DATA_KEY = DataKey.create((String)JBTerminalWidget.class.getName());
    private static final Logger LOG = Logger.getInstance(JBTerminalWidget.class);
    private final JBTerminalSystemSettingsProviderBase mySettingsProvider;
    private final CompositeFilterWrapper myCompositeFilterWrapper;
    private JBTerminalWidgetListener myListener;

    public JBTerminalWidget(@NotNull Project project, @NotNull JBTerminalSystemSettingsProviderBase settingsProvider, @NotNull Disposable parent) {
        if (project == null) {
            JBTerminalWidget.$$$reportNull$$$0(0);
        }
        if (settingsProvider == null) {
            JBTerminalWidget.$$$reportNull$$$0(1);
        }
        if (parent == null) {
            JBTerminalWidget.$$$reportNull$$$0(2);
        }
        this(project, 80, 24, settingsProvider, null, parent);
    }

    public JBTerminalWidget(@NotNull Project project, int columns, int lines, @NotNull JBTerminalSystemSettingsProviderBase settingsProvider, @Nullable TerminalExecutionConsole console, @NotNull Disposable parent) {
        if (project == null) {
            JBTerminalWidget.$$$reportNull$$$0(3);
        }
        if (settingsProvider == null) {
            JBTerminalWidget.$$$reportNull$$$0(4);
        }
        if (parent == null) {
            JBTerminalWidget.$$$reportNull$$$0(5);
        }
        super(columns, lines, (SettingsProvider)settingsProvider);
        this.mySettingsProvider = settingsProvider;
        this.myCompositeFilterWrapper = new CompositeFilterWrapper(project, console, this);
        this.addHyperlinkFilter(line -> this.runFilters(project, line));
        this.setName("terminal");
        Disposer.register((Disposable)parent, (Disposable)this);
        this.setFocusTraversalPolicy(new DefaultFocusTraversalPolicy(){

            @Override
            public Component getDefaultComponent(Container aContainer) {
                return JBTerminalWidget.this.getTerminalPanel();
            }
        });
    }

    @Nullable
    private LinkResult runFilters(@NotNull Project project, @NotNull String line) {
        Filter.Result r;
        if (project == null) {
            JBTerminalWidget.$$$reportNull$$$0(6);
        }
        if (line == null) {
            JBTerminalWidget.$$$reportNull$$$0(7);
        }
        if ((r = (Filter.Result)ReadAction.compute(() -> {
            try {
                return this.myCompositeFilterWrapper.getCompositeFilter().applyFilter(line, line.length());
            }
            catch (ProcessCanceledException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Skipping running filters on " + line, (Throwable)e);
                }
                return null;
            }
        })) != null) {
            return new LinkResult(ContainerUtil.mapNotNull((Collection)r.getResultItems(), item -> JBTerminalWidget.convertResultItem(project, item)));
        }
        return null;
    }

    @Nullable
    private static LinkResultItem convertResultItem(@NotNull Project project, @NotNull Filter.ResultItem item) {
        HyperlinkInfo info;
        if (project == null) {
            JBTerminalWidget.$$$reportNull$$$0(8);
        }
        if (item == null) {
            JBTerminalWidget.$$$reportNull$$$0(9);
        }
        if ((info = item.getHyperlinkInfo()) != null) {
            return new LinkResultItem(item.getHighlightStartOffset(), item.getHighlightEndOffset(), new LinkInfo(() -> info.navigate(project)));
        }
        return null;
    }

    public JBTerminalWidgetListener getListener() {
        return this.myListener;
    }

    public void setListener(JBTerminalWidgetListener listener2) {
        this.myListener = listener2;
    }

    protected JBTerminalPanel createTerminalPanel(@NotNull SettingsProvider settingsProvider, @NotNull StyleState styleState, @NotNull TerminalTextBuffer textBuffer) {
        if (settingsProvider == null) {
            JBTerminalWidget.$$$reportNull$$$0(10);
        }
        if (styleState == null) {
            JBTerminalWidget.$$$reportNull$$$0(11);
        }
        if (textBuffer == null) {
            JBTerminalWidget.$$$reportNull$$$0(12);
        }
        JBTerminalPanel panel2 = new JBTerminalPanel((JBTerminalSystemSettingsProviderBase)settingsProvider, textBuffer, styleState);
        Disposer.register((Disposable)this, (Disposable)panel2);
        return panel2;
    }

    protected Graphics getComponentGraphics(Graphics graphics) {
        return JBSwingUtilities.runGlobalCGTransform((JComponent)((Object)this), (Graphics)super.getComponentGraphics(graphics));
    }

    protected TerminalStarter createTerminalStarter(JediTerminal terminal, TtyConnector connector) {
        return new JBTerminalStarter((Terminal)terminal, connector);
    }

    protected JScrollBar createScrollBar() {
        JBScrollBar bar2 = new JBScrollBar();
        bar2.putClientProperty(JBScrollPane.Alignment.class, (Object)JBScrollPane.Alignment.RIGHT);
        bar2.putClientProperty((Object)JBScrollBar.TRACK, (g, x, y, width, height, object) -> {
            SubstringFinder.FindResult result2 = this.myTerminalPanel.getFindResult();
            if (result2 != null) {
                int modelHeight = bar2.getModel().getMaximum() - bar2.getModel().getMinimum();
                TerminalColor backgroundColor = this.mySettingsProvider.getFoundPatternColor().getBackground();
                if (backgroundColor != null) {
                    g.setColor(this.mySettingsProvider.getTerminalColorPalette().getColor(backgroundColor));
                }
                int anchorHeight = Math.max(2, height / modelHeight);
                for (SubstringFinder.FindResult.FindItem r : result2.getItems()) {
                    int where = height * r.getStart().y / modelHeight;
                    g.fillRect(x, y + where, width, anchorHeight);
                }
            }
        });
        return bar2;
    }

    public List<TerminalAction> getActions() {
        List actions = super.getActions();
        if (this.isInTerminalToolWindow()) {
            actions.add(new TerminalAction(this.mySettingsProvider.getNewSessionActionPresentation(), input -> {
                this.myListener.onNewSession();
                return true;
            }).withMnemonicKey(Integer.valueOf(84)).withEnabledSupplier(() -> this.myListener != null));
            actions.add(new TerminalAction(this.mySettingsProvider.getCloseSessionActionPresentation(), input -> {
                this.myListener.onSessionClosed();
                return true;
            }).withMnemonicKey(Integer.valueOf(84)).withEnabledSupplier(() -> this.myListener != null));
            actions.add(TerminalSplitAction.create(true, this.myListener).withMnemonicKey(86).separatorBefore(true));
            actions.add(TerminalSplitAction.create(false, this.myListener).withMnemonicKey(72));
            if (this.myListener != null && this.myListener.isGotoNextSplitTerminalAvailable()) {
                actions.add(this.mySettingsProvider.getGotoNextSplitTerminalAction(this.myListener, true));
                actions.add(this.mySettingsProvider.getGotoNextSplitTerminalAction(this.myListener, false));
            }
            actions.add(new TerminalAction(this.mySettingsProvider.getPreviousTabActionPresentation(), input -> {
                this.myListener.onPreviousTabSelected();
                return true;
            }).withMnemonicKey(Integer.valueOf(84)).withEnabledSupplier(() -> this.myListener != null));
            actions.add(new TerminalAction(this.mySettingsProvider.getNextTabActionPresentation(), input -> {
                this.myListener.onNextTabSelected();
                return true;
            }).withMnemonicKey(Integer.valueOf(84)).withEnabledSupplier(() -> this.myListener != null));
            actions.add(new TerminalAction(this.mySettingsProvider.getMoveTabRightActionPresentation(), input -> {
                this.myListener.moveTabRight();
                return true;
            }).withMnemonicKey(Integer.valueOf(82)).withEnabledSupplier(() -> this.myListener != null && this.myListener.canMoveTabRight()));
            actions.add(new TerminalAction(this.mySettingsProvider.getMoveTabLeftActionPresentation(), input -> {
                this.myListener.moveTabLeft();
                return true;
            }).withMnemonicKey(Integer.valueOf(76)).withEnabledSupplier(() -> this.myListener != null && this.myListener.canMoveTabLeft()));
            actions.add(new TerminalAction(this.mySettingsProvider.getShowTabsActionPresentation(), input -> {
                this.myListener.showTabs();
                return true;
            }).withMnemonicKey(Integer.valueOf(84)).withEnabledSupplier(() -> this.myListener != null));
        }
        return actions;
    }

    private boolean isInTerminalToolWindow() {
        return JBTerminalWidget.isInTerminalToolWindow(DataManager.getInstance().getDataContext((Component)this.myTerminalPanel));
    }

    static boolean isInTerminalToolWindow(@NotNull DataContext dataContext) {
        ToolWindow toolWindow;
        if (dataContext == null) {
            JBTerminalWidget.$$$reportNull$$$0(13);
        }
        return (toolWindow = (ToolWindow)dataContext.getData(PlatformDataKeys.TOOL_WINDOW)) != null && "Terminal".equals(toolWindow.getId());
    }

    public void dispose() {
        this.close();
    }

    public void terminateProcess() {
        this.close();
    }

    protected JediTermWidget.SearchComponent createSearchComponent() {
        return new JediTermWidget.SearchComponent(){
            private final SearchTextField myTextField = new SearchTextField(false);

            public String getText() {
                return this.myTextField.getText();
            }

            public boolean ignoreCase() {
                return false;
            }

            public JComponent getComponent() {
                this.myTextField.setOpaque(false);
                return this.myTextField;
            }

            public void addDocumentChangeListener(DocumentListener listener2) {
                this.myTextField.addDocumentListener(listener2);
            }

            public void addKeyListener(KeyListener listener2) {
                this.myTextField.addKeyboardListener(listener2);
            }

            public void addIgnoreCaseListener(ItemListener listener2) {
            }

            public void onResultUpdated(SubstringFinder.FindResult result2) {
            }

            public void nextFindResultItem(SubstringFinder.FindResult.FindItem item) {
            }

            public void prevFindResultItem(SubstringFinder.FindResult.FindItem item) {
            }
        };
    }

    public void addMessageFilter(@NotNull Filter filter2) {
        if (filter2 == null) {
            JBTerminalWidget.$$$reportNull$$$0(14);
        }
        this.myCompositeFilterWrapper.addFilter(filter2);
    }

    public void start(TtyConnector connector) {
        this.setTtyConnector(connector);
        this.start();
    }

    public JBTerminalSystemSettingsProviderBase getSettingsProvider() {
        return this.mySettingsProvider;
    }

    public void moveDisposable(@NotNull Disposable newParent) {
        if (newParent == null) {
            JBTerminalWidget.$$$reportNull$$$0(15);
        }
        Disposer.register((Disposable)newParent, (Disposable)this);
    }

    public void notifyStarted() {
        if (this.myListener != null) {
            this.myListener.onTerminalStarted();
        }
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            JBTerminalWidget.$$$reportNull$$$0(16);
        }
        if (SELECTED_TEXT_DATA_KEY.is(dataId)) {
            return this.getSelectedText();
        }
        if (TERMINAL_DATA_KEY.is(dataId)) {
            return this;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private String getSelectedText() {
        TerminalPanel terminalPanel = this.getTerminalPanel();
        TerminalSelection selection = terminalPanel.getSelection();
        if (selection != null) {
            Pair points = selection.pointsForRun(terminalPanel.getColumnCount());
            if (points.first != null && points.second != null) {
                TerminalTextBuffer buffer = terminalPanel.getTerminalTextBuffer();
                buffer.lock();
                try {
                    String string = SelectionUtil.getSelectionText((Point)((Point)points.first), (Point)((Point)points.second), (TerminalTextBuffer)buffer);
                    return string;
                }
                finally {
                    buffer.unlock();
                }
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsProvider";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "styleState";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textBuffer";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParent";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        objectArray2[1] = "com/intellij/terminal/JBTerminalWidget";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "runFilters";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "convertResultItem";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "createTerminalPanel";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "isInTerminalToolWindow";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "addMessageFilter";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "moveDisposable";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "getData";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

