/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.runtime;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.openapi.project.Project;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.ServerConfiguration;
import com.intellij.remoteServer.configuration.deployment.DeploymentConfiguration;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.impl.configuration.deployment.DeployToServerRunConfigurationExtensionsManager;
import com.intellij.remoteServer.impl.runtime.deployment.DeploymentTaskImpl;
import com.intellij.remoteServer.runtime.ServerConnection;
import com.intellij.remoteServer.runtime.ServerConnectionManager;
import com.intellij.remoteServer.runtime.deployment.debug.DebugConnector;
import com.intellij.remoteServer.runtime.ui.RemoteServersView;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeployToServerState<S extends ServerConfiguration, D extends DeploymentConfiguration>
implements RunProfileState {
    @NotNull
    private final RemoteServer<S> myServer;
    @NotNull
    private final DeploymentSource mySource;
    @NotNull
    private final D myConfiguration;
    @NotNull
    private final ExecutionEnvironment myEnvironment;

    public DeployToServerState(@NotNull RemoteServer<S> server, @NotNull DeploymentSource deploymentSource, @NotNull D deploymentConfiguration, @NotNull ExecutionEnvironment environment) {
        if (server == null) {
            DeployToServerState.$$$reportNull$$$0(0);
        }
        if (deploymentSource == null) {
            DeployToServerState.$$$reportNull$$$0(1);
        }
        if (deploymentConfiguration == null) {
            DeployToServerState.$$$reportNull$$$0(2);
        }
        if (environment == null) {
            DeployToServerState.$$$reportNull$$$0(3);
        }
        this.myServer = server;
        this.mySource = deploymentSource;
        this.myConfiguration = deploymentConfiguration;
        this.myEnvironment = environment;
    }

    @Nullable
    public ExecutionResult execute(Executor executor, @NotNull ProgramRunner<?> runner) throws ExecutionException {
        if (runner == null) {
            DeployToServerState.$$$reportNull$$$0(4);
        }
        ServerConnection connection = ServerConnectionManager.getInstance().getOrCreateConnection(this.myServer);
        Project project = this.myEnvironment.getProject();
        RemoteServersView.getInstance(project).showServerConnection(connection);
        DebugConnector debugConnector = DefaultDebugExecutor.getDebugExecutorInstance().equals(executor) ? this.myServer.getType().createDebugConnector() : null;
        DeploymentTaskImpl<D> task2 = new DeploymentTaskImpl<D>(this.mySource, this.myConfiguration, project, debugConnector, this.myEnvironment);
        DeployToServerRunConfigurationExtensionsManager.getInstance().patchDeploymentTask(task2);
        connection.deploy(task2, s -> RemoteServersView.getInstance(project).showDeployment(connection, (String)s));
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deploymentSource";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deploymentConfiguration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
        }
        objectArray2[1] = "com/intellij/remoteServer/impl/runtime/DeployToServerState";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

