/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.MetaLanguage;
import com.intellij.model.psi.PsiSymbolReference;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.patterns.ElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceProviderBean;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.ReferenceRange;
import com.intellij.psi.impl.source.resolve.reference.ProviderBinding;
import com.intellij.psi.impl.source.resolve.reference.PsiReferenceRegistrarImpl;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.impl.source.resolve.reference.TrackingReferenceRegistrar;
import com.intellij.util.IdempotenceChecker;
import com.intellij.util.KeyedLazyInstance;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import it.unimi.dsi.fastutil.doubles.Double2ObjectMap;
import it.unimi.dsi.fastutil.doubles.Double2ObjectMaps;
import it.unimi.dsi.fastutil.doubles.Double2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ReferenceProvidersRegistryImpl
extends ReferenceProvidersRegistry {
    private static final LanguageExtension<PsiReferenceContributor> CONTRIBUTOR_EXTENSION = new LanguageExtension(PsiReferenceContributor.EP_NAME);
    private static final LanguageExtension<PsiReferenceProviderBean> REFERENCE_PROVIDER_EXTENSION = new LanguageExtension(PsiReferenceProviderBean.EP_NAME.getName());
    private final Map<Language, PsiReferenceRegistrarImpl> myRegistrars = new ConcurrentHashMap<Language, PsiReferenceRegistrarImpl>();

    public ReferenceProvidersRegistryImpl() {
        if (ApplicationManager.getApplication().getExtensionArea().hasExtensionPoint(PsiReferenceContributor.EP_NAME)) {
            PsiReferenceContributor.EP_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<KeyedLazyInstance<PsiReferenceContributor>>(){

                public void extensionAdded(@NotNull KeyedLazyInstance<PsiReferenceContributor> extension, @NotNull PluginDescriptor pluginDescriptor) {
                    block6: {
                        PsiReferenceContributor instance;
                        Language language;
                        block5: {
                            if (extension == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            if (pluginDescriptor == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            language = Language.findLanguageByID((String)extension.getKey());
                            instance = (PsiReferenceContributor)extension.getInstance();
                            if (language != Language.ANY) break block5;
                            for (PsiReferenceRegistrarImpl registrar : ReferenceProvidersRegistryImpl.this.myRegistrars.values()) {
                                ReferenceProvidersRegistryImpl.registerContributedReferenceProviders(registrar, instance);
                            }
                            break block6;
                        }
                        if (language == null) break block6;
                        this.registerContributorForLanguageAndDialects(language, instance);
                        if (language instanceof MetaLanguage) {
                            Collection matchingLanguages = ((MetaLanguage)language).getMatchingLanguages();
                            for (Language matchingLanguage : matchingLanguages) {
                                this.registerContributorForLanguageAndDialects(matchingLanguage, instance);
                            }
                        }
                    }
                }

                private void registerContributorForLanguageAndDialects(Language language, PsiReferenceContributor instance) {
                    Set languageAndDialects = LanguageUtil.getAllDerivedLanguages((Language)language);
                    for (Language languageOrDialect : languageAndDialects) {
                        PsiReferenceRegistrarImpl registrar = (PsiReferenceRegistrarImpl)((Object)ReferenceProvidersRegistryImpl.this.myRegistrars.get(languageOrDialect));
                        if (registrar == null) continue;
                        ReferenceProvidersRegistryImpl.registerContributedReferenceProviders(registrar, instance);
                    }
                }

                public void extensionRemoved(@NotNull KeyedLazyInstance<PsiReferenceContributor> extension, @NotNull PluginDescriptor pluginDescriptor) {
                    if (extension == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    if (pluginDescriptor == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    Disposer.dispose((Disposable)((Disposable)extension.getInstance()));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "extension";
                            break;
                        }
                        case 1: 
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "pluginDescriptor";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/ReferenceProvidersRegistryImpl$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "extensionAdded";
                            break;
                        }
                        case 2: 
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "extensionRemoved";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }, null);
        }
    }

    @NotNull
    private static PsiReferenceRegistrarImpl createRegistrar(@NotNull Language language) {
        if (language == null) {
            ReferenceProvidersRegistryImpl.$$$reportNull$$$0(0);
        }
        PsiReferenceRegistrarImpl registrar = new PsiReferenceRegistrarImpl();
        for (PsiReferenceContributor contributor : CONTRIBUTOR_EXTENSION.allForLanguageOrAny(language)) {
            ReferenceProvidersRegistryImpl.registerContributedReferenceProviders(registrar, contributor);
        }
        List referenceProviderBeans = REFERENCE_PROVIDER_EXTENSION.allForLanguageOrAny(language);
        for (final PsiReferenceProviderBean providerBean : referenceProviderBeans) {
            ElementPattern pattern = providerBean.createElementPattern();
            if (pattern == null) continue;
            registrar.registerReferenceProvider(pattern, new PsiReferenceProvider(){
                PsiReferenceProvider myProvider;

                public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element2, @NotNull ProcessingContext context) {
                    if (element2 == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (context == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    if (this.myProvider == null) {
                        this.myProvider = providerBean.instantiate();
                        if (this.myProvider == null) {
                            this.myProvider = ReferenceProvidersRegistry.NULL_REFERENCE_PROVIDER;
                        }
                    }
                    PsiReference[] psiReferenceArray = this.myProvider.getReferencesByElement(element2, context);
                    if (psiReferenceArray == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    return psiReferenceArray;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 2: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 2: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "element";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "context";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/ReferenceProvidersRegistryImpl$2";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/ReferenceProvidersRegistryImpl$2";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getReferencesByElement";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "getReferencesByElement";
                            break;
                        }
                        case 2: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 2: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            });
        }
        registrar.markInitialized();
        PsiReferenceRegistrarImpl psiReferenceRegistrarImpl = registrar;
        if (psiReferenceRegistrarImpl == null) {
            ReferenceProvidersRegistryImpl.$$$reportNull$$$0(1);
        }
        return psiReferenceRegistrarImpl;
    }

    private static void registerContributedReferenceProviders(@NotNull PsiReferenceRegistrarImpl registrar, @NotNull PsiReferenceContributor contributor) {
        if (registrar == null) {
            ReferenceProvidersRegistryImpl.$$$reportNull$$$0(2);
        }
        if (contributor == null) {
            ReferenceProvidersRegistryImpl.$$$reportNull$$$0(3);
        }
        contributor.registerReferenceProviders((PsiReferenceRegistrar)new TrackingReferenceRegistrar(registrar, (Disposable)contributor));
        Disposer.register((Disposable)ApplicationManager.getApplication(), (Disposable)contributor);
    }

    @NotNull
    public PsiReferenceRegistrarImpl getRegistrar(@NotNull Language language) {
        if (language == null) {
            ReferenceProvidersRegistryImpl.$$$reportNull$$$0(4);
        }
        PsiReferenceRegistrarImpl psiReferenceRegistrarImpl = this.myRegistrars.computeIfAbsent(language, ReferenceProvidersRegistryImpl::createRegistrar);
        if (psiReferenceRegistrarImpl == null) {
            ReferenceProvidersRegistryImpl.$$$reportNull$$$0(5);
        }
        return psiReferenceRegistrarImpl;
    }

    public void unloadProvidersFor(@NotNull Language language) {
        PsiReferenceRegistrarImpl psiReferenceRegistrar;
        if (language == null) {
            ReferenceProvidersRegistryImpl.$$$reportNull$$$0(6);
        }
        if ((psiReferenceRegistrar = this.myRegistrars.remove(language)) != null) {
            psiReferenceRegistrar.cleanup();
        }
        for (PsiReferenceRegistrarImpl registrar : this.myRegistrars.values()) {
            registrar.clearBindingsCache();
        }
    }

    protected PsiReference @NotNull [] doGetReferencesFromProviders(@NotNull PsiElement context, @NotNull PsiReferenceService.Hints hints2) {
        List<ProviderBinding.ProviderInfo<ProcessingContext>> providers;
        Double2ObjectMap<List<PsiReference[]>> allReferencesMap;
        if (context == null) {
            ReferenceProvidersRegistryImpl.$$$reportNull$$$0(7);
        }
        if (hints2 == null) {
            ReferenceProvidersRegistryImpl.$$$reportNull$$$0(8);
        }
        if ((allReferencesMap = ReferenceProvidersRegistryImpl.mapNotEmptyReferencesFromProviders(context, providers = this.getRegistrar(context.getLanguage()).getPairsByElement(context, hints2))).isEmpty()) {
            if (PsiReference.EMPTY_ARRAY == null) {
                ReferenceProvidersRegistryImpl.$$$reportNull$$$0(9);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        SmartList result2 = new SmartList();
        double maxPriority = Math.max(-100.0, Arrays.stream(allReferencesMap.keySet().toDoubleArray()).max().getAsDouble());
        List<PsiReference> maxPriorityRefs = ReferenceProvidersRegistryImpl.collectReferences((Collection)allReferencesMap.get(maxPriority));
        ContainerUtil.addAllNotNull((Collection)result2, maxPriorityRefs);
        ContainerUtil.addAllNotNull((Collection)result2, ReferenceProvidersRegistryImpl.getLowerPriorityReferences(allReferencesMap, maxPriority, maxPriorityRefs));
        PsiReference[] psiReferenceArray = result2.toArray(PsiReference.EMPTY_ARRAY);
        if (psiReferenceArray == null) {
            ReferenceProvidersRegistryImpl.$$$reportNull$$$0(10);
        }
        return psiReferenceArray;
    }

    @NotNull
    private static Double2ObjectMap<List<PsiReference[]>> mapNotEmptyReferencesFromProviders(@NotNull PsiElement context, @NotNull List<? extends ProviderBinding.ProviderInfo<ProcessingContext>> providers) {
        if (context == null) {
            ReferenceProvidersRegistryImpl.$$$reportNull$$$0(11);
        }
        if (providers == null) {
            ReferenceProvidersRegistryImpl.$$$reportNull$$$0(12);
        }
        Double2ObjectOpenHashMap map2 = new Double2ObjectOpenHashMap();
        for (ProviderBinding.ProviderInfo<ProcessingContext> providerInfo : providers) {
            Object[] refs = ReferenceProvidersRegistryImpl.getReferences(context, providerInfo);
            if ((ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isInternal()) && Registry.is((String)"ide.check.reference.provider.underlying.element")) {
                ReferenceProvidersRegistryImpl.assertReferenceUnderlyingElement(context, (PsiReference[])refs, providerInfo.provider);
            }
            if (refs.length <= 0) continue;
            List list2 = (List)map2.get(providerInfo.priority);
            if (list2 == null) {
                list2 = new SmartList();
                map2.put(providerInfo.priority, (Object)list2);
            }
            list2.add(refs);
            if (!IdempotenceChecker.isLoggingEnabled()) continue;
            IdempotenceChecker.logTrace(providerInfo.provider + " returned " + Arrays.toString(refs));
        }
        Double2ObjectOpenHashMap double2ObjectOpenHashMap = map2;
        if (double2ObjectOpenHashMap == null) {
            ReferenceProvidersRegistryImpl.$$$reportNull$$$0(13);
        }
        return double2ObjectOpenHashMap;
    }

    private static void assertReferenceUnderlyingElement(@NotNull PsiElement context, PsiReference[] refs, PsiReferenceProvider provider2) {
        if (context == null) {
            ReferenceProvidersRegistryImpl.$$$reportNull$$$0(14);
        }
        for (PsiReference reference2 : refs) {
            if (reference2 != null) assert (reference2.getElement() == context) : "reference " + reference2 + " was created for " + context + " but target " + reference2.getElement() + ", provider " + provider2;
        }
    }

    private static PsiReference @NotNull [] getReferences(@NotNull PsiElement context, @NotNull ProviderBinding.ProviderInfo<? extends ProcessingContext> providerInfo) {
        PsiReference[] psiReferenceArray;
        if (context == null) {
            ReferenceProvidersRegistryImpl.$$$reportNull$$$0(15);
        }
        if (providerInfo == null) {
            ReferenceProvidersRegistryImpl.$$$reportNull$$$0(16);
        }
        try {
            psiReferenceArray = providerInfo.provider.getReferencesByElement(context, (ProcessingContext)providerInfo.processingContext);
        }
        catch (IndexNotReadyException indexNotReadyException) {
            if (PsiReference.EMPTY_ARRAY == null) {
                ReferenceProvidersRegistryImpl.$$$reportNull$$$0(18);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        if (psiReferenceArray == null) {
            ReferenceProvidersRegistryImpl.$$$reportNull$$$0(17);
        }
        return psiReferenceArray;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private static List<PsiReference> getLowerPriorityReferences(@NotNull Double2ObjectMap<List<PsiReference[]>> allReferencesMap, double maxPriority, @NotNull List<? extends PsiReference> list2) {
        if (allReferencesMap == null) {
            ReferenceProvidersRegistryImpl.$$$reportNull$$$0(19);
        }
        if (list2 == null) {
            ReferenceProvidersRegistryImpl.$$$reportNull$$$0(20);
        }
        SmartList result2 = new SmartList();
        for (Double2ObjectMap.Entry entry : Double2ObjectMaps.fastIterable(allReferencesMap)) {
            if (maxPriority == entry.getDoubleKey()) continue;
            for (Object[] references : (List)entry.getValue()) {
                void maxPriorityRefs;
                if (!ReferenceProvidersRegistryImpl.haveNotIntersectedTextRanges((List<? extends PsiReference>)maxPriorityRefs, (PsiReference[])references)) continue;
                ContainerUtil.addAllNotNull((Collection)result2, (Object[])references);
            }
        }
        SmartList smartList = result2;
        if (smartList == null) {
            ReferenceProvidersRegistryImpl.$$$reportNull$$$0(21);
        }
        return smartList;
    }

    private static boolean haveNotIntersectedTextRanges(@NotNull List<? extends PsiReference> higherPriorityRefs, PsiReference @NotNull [] lowerPriorityRefs) {
        if (higherPriorityRefs == null) {
            ReferenceProvidersRegistryImpl.$$$reportNull$$$0(22);
        }
        if (lowerPriorityRefs == null) {
            ReferenceProvidersRegistryImpl.$$$reportNull$$$0(23);
        }
        for (PsiReference ref : lowerPriorityRefs) {
            if (ref == null) continue;
            for (PsiReference psiReference : higherPriorityRefs) {
                if (psiReference == null || !ReferenceRange.containsRangeInElement((PsiSymbolReference)psiReference, (TextRange)ref.getRangeInElement())) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    private static List<PsiReference> collectReferences(@Nullable Collection<PsiReference[]> references) {
        if (references == null) {
            List<PsiReference> list2 = Collections.emptyList();
            if (list2 == null) {
                ReferenceProvidersRegistryImpl.$$$reportNull$$$0(24);
            }
            return list2;
        }
        SmartList list3 = new SmartList();
        for (Object[] objectArray : references) {
            ContainerUtil.addAllNotNull((Collection)list3, (Object[])objectArray);
        }
        SmartList smartList = list3;
        if (smartList == null) {
            ReferenceProvidersRegistryImpl.$$$reportNull$$$0(25);
        }
        return smartList;
    }

    @Deprecated
    public static void disableUnderlyingElementChecks(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            ReferenceProvidersRegistryImpl.$$$reportNull$$$0(26);
        }
        Registry.get((String)"ide.check.reference.provider.underlying.element").setValue(false, parentDisposable);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 10: 
            case 13: 
            case 17: 
            case 18: 
            case 21: 
            case 24: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 10: 
            case 13: 
            case 17: 
            case 18: 
            case 21: 
            case 24: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 10: 
            case 13: 
            case 17: 
            case 18: 
            case 21: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/ReferenceProvidersRegistryImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contributor";
                break;
            }
            case 7: 
            case 11: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hints";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providers";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providerInfo";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allReferencesMap";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "maxPriorityRefs";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "higherPriorityRefs";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lowerPriorityRefs";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/ReferenceProvidersRegistryImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createRegistrar";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegistrar";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetReferencesFromProviders";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "mapNotEmptyReferencesFromProviders";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getLowerPriorityReferences";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "collectReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createRegistrar";
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 10: 
            case 13: 
            case 17: 
            case 18: 
            case 21: 
            case 24: 
            case 25: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "registerContributedReferenceProviders";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getRegistrar";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "unloadProvidersFor";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doGetReferencesFromProviders";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "mapNotEmptyReferencesFromProviders";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "assertReferenceUnderlyingElement";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getReferences";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getLowerPriorityReferences";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "haveNotIntersectedTextRanges";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "disableUnderlyingElementChecks";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 10: 
            case 13: 
            case 17: 
            case 18: 
            case 21: 
            case 24: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

