/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.openapi.components.BaseState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.wm.impl.FrameInfo;
import com.intellij.openapi.wm.impl.FrameInfoHelperKt;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.ProjectFrameHelper;
import com.intellij.openapi.wm.impl.WindowManagerImpl;
import com.intellij.openapi.wm.impl.X11UiUtil;
import java.awt.Rectangle;
import javax.swing.JFrame;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000  2\u00020\u0001:\u0001 B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0004J\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u0004J \u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019J(\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u0016\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eR\"\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006!"}, d2={"Lcom/intellij/openapi/wm/impl/FrameInfoHelper;", "", "()V", "<set-?>", "Lcom/intellij/openapi/wm/impl/FrameInfo;", "info", "getInfo", "()Lcom/intellij/openapi/wm/impl/FrameInfo;", "isDirty", "", "()Z", "setDirty", "(Z)V", "copyFrom", "", "newInfo", "getModificationCount", "", "setInfoInDeviceSpace", "update", "project", "Lcom/intellij/openapi/project/Project;", "lastNormalFrameBounds", "Ljava/awt/Rectangle;", "windowManager", "Lcom/intellij/openapi/wm/impl/WindowManagerImpl;", "updateAndGetInfo", "frameHelper", "Lcom/intellij/openapi/wm/impl/ProjectFrameHelper;", "frame", "Ljavax/swing/JFrame;", "updateFrameInfo", "Companion", "intellij.platform.ide.impl"})
public final class FrameInfoHelper {
    @Nullable
    private FrameInfo info;
    private volatile boolean isDirty;
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final FrameInfo getInfo() {
        return this.info;
    }

    public final boolean isDirty() {
        return this.isDirty;
    }

    public final void setDirty(boolean bl) {
        this.isDirty = bl;
    }

    public final void setInfoInDeviceSpace(@NotNull FrameInfo info) {
        Intrinsics.checkNotNullParameter((Object)((Object)info), (String)"info");
        this.info = info;
    }

    public final void updateFrameInfo(@NotNull ProjectFrameHelper frameHelper, @NotNull JFrame frame) {
        Intrinsics.checkNotNullParameter((Object)frameHelper, (String)"frameHelper");
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        this.info = FrameInfoHelperKt.updateFrameInfo(frameHelper, frame, null, this.info);
    }

    public final long getModificationCount() {
        FrameInfo frameInfo = this.info;
        return frameInfo != null ? frameInfo.getModificationCount() : 0L;
    }

    public final void update(@NotNull Project project, @Nullable Rectangle lastNormalFrameBounds, @NotNull WindowManagerImpl windowManager) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)windowManager), (String)"windowManager");
        ProjectFrameHelper projectFrameHelper = windowManager.getFrameHelper(project);
        if (projectFrameHelper == null) {
            return;
        }
        ProjectFrameHelper frameHelper = projectFrameHelper;
        IdeFrameImpl ideFrameImpl = frameHelper.getFrame();
        if (ideFrameImpl == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)ideFrameImpl, (String)"frameHelper.frame ?: return");
        this.updateAndGetInfo(frameHelper, ideFrameImpl, lastNormalFrameBounds, windowManager);
    }

    @NotNull
    public final FrameInfo updateAndGetInfo(@NotNull ProjectFrameHelper frameHelper, @NotNull JFrame frame, @Nullable Rectangle lastNormalFrameBounds, @NotNull WindowManagerImpl windowManager) {
        Intrinsics.checkNotNullParameter((Object)frameHelper, (String)"frameHelper");
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        Intrinsics.checkNotNullParameter((Object)((Object)windowManager), (String)"windowManager");
        FrameInfo newInfo = FrameInfoHelperKt.updateFrameInfo(frameHelper, frame, lastNormalFrameBounds, this.info);
        windowManager.getDefaultFrameInfoHelper$intellij_platform_ide_impl().copyFrom(newInfo);
        this.info = newInfo;
        this.isDirty = false;
        return newInfo;
    }

    public final void copyFrom(@NotNull FrameInfo newInfo) {
        Intrinsics.checkNotNullParameter((Object)((Object)newInfo), (String)"newInfo");
        if (this.info == null) {
            this.info = new FrameInfo();
        }
        FrameInfo frameInfo = this.info;
        Intrinsics.checkNotNull((Object)((Object)frameInfo));
        BaseState.copyFrom$default((BaseState)frameInfo, (BaseState)newInfo, (boolean)false, (int)2, null);
        this.isDirty = false;
    }

    @JvmStatic
    public static final boolean isFullScreenSupportedInCurrentOs() {
        return Companion.isFullScreenSupportedInCurrentOs();
    }

    public static final boolean isFloatingMenuBarSupported() {
        return Companion.isFloatingMenuBarSupported();
    }

    @JvmStatic
    public static final boolean isMaximized(int state) {
        return Companion.isMaximized(state);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\u0004H\u0007J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0007R\u001a\u0010\u0003\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0003\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/intellij/openapi/wm/impl/FrameInfoHelper$Companion;", "", "()V", "isFloatingMenuBarSupported", "", "isFloatingMenuBarSupported$annotations", "()Z", "isFullScreenSupportedInCurrentOs", "isMaximized", "state", "", "intellij.platform.ide.impl"})
    public static final class Companion {
        @JvmStatic
        public final boolean isFullScreenSupportedInCurrentOs() {
            return SystemInfoRt.isMac || SystemInfoRt.isWindows || SystemInfoRt.isXWindow && X11UiUtil.isFullScreenSupported();
        }

        @JvmStatic
        public static /* synthetic */ void isFloatingMenuBarSupported$annotations() {
        }

        public final boolean isFloatingMenuBarSupported() {
            return !SystemInfoRt.isMac && Companion.isFullScreenSupportedInCurrentOs();
        }

        @JvmStatic
        public final boolean isMaximized(int state) {
            return (state & 6) == 6;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

