/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.playback.commands;

import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class DelayCommand
extends AbstractCommand {
    public static final String PREFIX = "%delay";

    public DelayCommand(String text2, int line) {
        super(text2, line);
    }

    @Override
    public Promise<Object> _execute(PlaybackContext context) {
        String s = this.getText().substring(PREFIX.length()).trim();
        try {
            int delay = Integer.parseInt(s);
            context.getRobot().delay(delay);
        }
        catch (NumberFormatException e) {
            this.dumpError(context, "Invalid delay value: " + s);
            return Promises.rejectedPromise((Throwable)e);
        }
        return Promises.resolvedPromise();
    }
}

