/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingGroup;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.FoldingModelImpl;
import com.intellij.openapi.editor.impl.RangeMarkerImpl;
import com.intellij.openapi.util.Key;
import com.intellij.util.DocumentUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FoldRegionImpl
extends RangeMarkerImpl
implements FoldRegion {
    private static final Key<Boolean> MUTE_INNER_HIGHLIGHTERS = Key.create((String)"mute.inner.highlighters");
    private static final Key<Boolean> SHOW_GUTTER_MARK_FOR_SINGLE_LINE = Key.create((String)"show.gutter.mark.for.single.line");
    private boolean myIsExpanded;
    private final EditorImpl myEditor;
    private String myPlaceholderText;
    private final FoldingGroup myGroup;
    private final boolean myShouldNeverExpand;
    private boolean myDocumentRegionWasChanged;
    int mySizeBeforeUpdate;

    FoldRegionImpl(@NotNull EditorImpl editor, int startOffset, int endOffset, @NotNull String placeholder, @Nullable FoldingGroup group2, boolean shouldNeverExpand) {
        if (editor == null) {
            FoldRegionImpl.$$$reportNull$$$0(0);
        }
        if (placeholder == null) {
            FoldRegionImpl.$$$reportNull$$$0(1);
        }
        super(editor.getDocument(), startOffset, endOffset, false, true);
        this.myGroup = group2;
        this.myShouldNeverExpand = shouldNeverExpand;
        this.myIsExpanded = true;
        this.myEditor = editor;
        this.myPlaceholderText = placeholder;
    }

    public boolean isExpanded() {
        return this.myIsExpanded;
    }

    public void setExpanded(boolean expanded) {
        this.setExpanded(expanded, true);
    }

    void setExpanded(boolean expanded, boolean notify2) {
        FoldingModelImpl foldingModel = this.myEditor.getFoldingModel();
        if (this.myGroup == null) {
            FoldRegionImpl.doSetExpanded(expanded, foldingModel, this, notify2);
        } else {
            for (FoldRegion region : foldingModel.getGroupedRegions(this.myGroup)) {
                FoldRegionImpl.doSetExpanded(expanded, foldingModel, region, notify2 || region != this);
                if (region.isExpanded() == expanded) continue;
                for (FoldRegion regionToRevert : foldingModel.getGroupedRegions(this.myGroup)) {
                    if (regionToRevert == region) break;
                    FoldRegionImpl.doSetExpanded(!expanded, foldingModel, regionToRevert, notify2 || region != this);
                }
                return;
            }
        }
    }

    private static void doSetExpanded(boolean expanded, FoldingModelImpl foldingModel, FoldRegion region, boolean notify2) {
        if (expanded) {
            foldingModel.expandFoldRegion(region, notify2);
        } else {
            foldingModel.collapseFoldRegion(region, notify2);
        }
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.intervalStart() < this.intervalEnd();
    }

    void setExpandedInternal(boolean toExpand) {
        this.myIsExpanded = toExpand;
    }

    @NotNull
    public String getPlaceholderText() {
        String string = this.myPlaceholderText;
        if (string == null) {
            FoldRegionImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    public Editor getEditor() {
        return this.myEditor;
    }

    @Nullable
    public FoldingGroup getGroup() {
        return this.myGroup;
    }

    public boolean shouldNeverExpand() {
        return this.myShouldNeverExpand;
    }

    boolean hasDocumentRegionChanged() {
        return this.myDocumentRegionWasChanged;
    }

    void resetDocumentRegionChanged() {
        this.myDocumentRegionWasChanged = false;
    }

    @Override
    protected void changedUpdateImpl(@NotNull DocumentEvent e) {
        if (e == null) {
            FoldRegionImpl.$$$reportNull$$$0(3);
        }
        if (this.isValid()) {
            int oldStart = this.intervalStart();
            int oldEnd = this.intervalEnd();
            int changeStart = e.getOffset();
            int changeEnd = e.getOffset() + e.getOldLength();
            if (changeStart < oldEnd && changeEnd > oldStart) {
                this.myDocumentRegionWasChanged = true;
            }
        }
        super.changedUpdateImpl(e);
        if (this.isValid()) {
            this.alignToValidBoundaries();
        }
    }

    @Override
    protected void onReTarget(@NotNull DocumentEvent e) {
        if (e == null) {
            FoldRegionImpl.$$$reportNull$$$0(4);
        }
        this.alignToValidBoundaries();
    }

    private void alignToValidBoundaries() {
        DocumentEx document = this.getDocument();
        int start2 = this.intervalStart();
        int end = this.intervalEnd();
        if (DocumentUtil.isInsideCharacterPair(document, start2)) {
            this.setIntervalStart(start2 - 1);
        }
        if (DocumentUtil.isInsideCharacterPair(document, end)) {
            this.setIntervalEnd(end - 1);
        }
    }

    public void setInnerHighlightersMuted(boolean value2) {
        this.putUserData(MUTE_INNER_HIGHLIGHTERS, value2 ? Boolean.TRUE : null);
    }

    public boolean areInnerHighlightersMuted() {
        return Boolean.TRUE.equals(this.getUserData(MUTE_INNER_HIGHLIGHTERS));
    }

    public void setGutterMarkEnabledForSingleLine(boolean value2) {
        if (value2 != this.isGutterMarkEnabledForSingleLine()) {
            this.putUserData(SHOW_GUTTER_MARK_FOR_SINGLE_LINE, value2 ? Boolean.TRUE : null);
            this.myEditor.getGutterComponentEx().repaint();
        }
    }

    public boolean isGutterMarkEnabledForSingleLine() {
        return Boolean.TRUE.equals(this.getUserData(SHOW_GUTTER_MARK_FOR_SINGLE_LINE));
    }

    public void setPlaceholderText(@NotNull String text2) {
        if (text2 == null) {
            FoldRegionImpl.$$$reportNull$$$0(5);
        }
        this.myPlaceholderText = text2;
        this.myEditor.getFoldingModel().onPlaceholderTextChanged(this);
    }

    @Override
    public void dispose() {
        this.myEditor.getFoldingModel().removeRegionFromTree(this);
    }

    @Override
    public String toString() {
        return "FoldRegion " + (this.myIsExpanded ? "-" : "+") + "(" + this.getStartOffset() + ":" + this.getEndOffset() + ")" + (this.isValid() ? "" : "(invalid)") + ", placeholder='" + this.myPlaceholderText + "'";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeholder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/FoldRegionImpl";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/FoldRegionImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlaceholderText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "changedUpdateImpl";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "onReTarget";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setPlaceholderText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

