/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.MarkupModelWindow;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModelManager;
import com.intellij.openapi.editor.impl.EmptyMarkupModel;
import com.intellij.openapi.editor.impl.MarkupModelImpl;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.util.ConcurrencyUtil;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DocumentMarkupModel {
    private static final Key<MarkupModelEx> MARKUP_MODEL_KEY = Key.create((String)"DocumentMarkupModel.MarkupModel");
    private static final Key<ConcurrentMap<Project, MarkupModelImpl>> MARKUP_MODEL_MAP_KEY = Key.create((String)"DocumentMarkupModel.MarkupModelMap");

    private DocumentMarkupModel() {
    }

    public static MarkupModel forDocument(@NotNull Document document, @Nullable Project project, boolean create2) {
        DocumentMarkupModelManager documentMarkupModelManager;
        if (document == null) {
            DocumentMarkupModel.$$$reportNull$$$0(0);
        }
        if (document instanceof DocumentWindow) {
            Document delegate = ((DocumentWindow)document).getDelegate();
            MarkupModelEx baseMarkupModel = (MarkupModelEx)DocumentMarkupModel.forDocument(delegate, project, true);
            return new MarkupModelWindow(baseMarkupModel, (DocumentWindow)document);
        }
        if (project == null) {
            MarkupModelImpl newModel;
            MarkupModelEx markupModel = (MarkupModelEx)document.getUserData(MARKUP_MODEL_KEY);
            if (create2 && markupModel == null && (markupModel = (MarkupModelEx)((UserDataHolderEx)document).putUserDataIfAbsent(MARKUP_MODEL_KEY, (Object)(newModel = new MarkupModelImpl((DocumentEx)document)))) != newModel) {
                newModel.dispose();
            }
            return markupModel;
        }
        DocumentMarkupModelManager documentMarkupModelManager2 = documentMarkupModelManager = project.isDisposed() ? null : DocumentMarkupModelManager.getInstance(project);
        if (documentMarkupModelManager == null || documentMarkupModelManager.isDisposed() || project.isDisposed()) {
            return new EmptyMarkupModel(document);
        }
        ConcurrentMap<Project, MarkupModelImpl> markupModelMap = DocumentMarkupModel.getMarkupModelMap(document);
        MarkupModelImpl model2 = (MarkupModelImpl)markupModelMap.get(project);
        if (create2 && model2 == null) {
            MarkupModelImpl newModel = new MarkupModelImpl((DocumentEx)document);
            model2 = (MarkupModelImpl)ConcurrencyUtil.cacheOrGet(markupModelMap, (Object)project, (Object)newModel);
            if (model2 == newModel) {
                documentMarkupModelManager.registerDocument(document);
            } else {
                newModel.dispose();
            }
        }
        return model2;
    }

    private static ConcurrentMap<Project, MarkupModelImpl> getMarkupModelMap(@NotNull Document document) {
        ConcurrentMap markupModelMap;
        if (document == null) {
            DocumentMarkupModel.$$$reportNull$$$0(1);
        }
        if ((markupModelMap = (ConcurrentMap)document.getUserData(MARKUP_MODEL_MAP_KEY)) == null) {
            ConcurrentHashMap newMap = new ConcurrentHashMap();
            markupModelMap = (ConcurrentMap)((UserDataHolderEx)document).putUserDataIfAbsent(MARKUP_MODEL_MAP_KEY, newMap);
        }
        return markupModelMap;
    }

    static void removeMarkupModel(@NotNull Document document, @NotNull Project project) {
        MarkupModelImpl removed;
        if (document == null) {
            DocumentMarkupModel.$$$reportNull$$$0(2);
        }
        if (project == null) {
            DocumentMarkupModel.$$$reportNull$$$0(3);
        }
        if ((removed = (MarkupModelImpl)DocumentMarkupModel.getMarkupModelMap(document).remove(project)) != null) {
            removed.dispose();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/editor/impl/DocumentMarkupModel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "forDocument";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getMarkupModelMap";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "removeMarkupModel";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

