/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.model.search.impl;

import com.intellij.lang.Language;
import com.intellij.model.Pointer;
import com.intellij.model.Symbol;
import com.intellij.model.psi.PsiSymbolReference;
import com.intellij.model.psi.PsiSymbolReferenceProvider;
import com.intellij.model.psi.PsiSymbolReferenceProviderBean;
import com.intellij.model.psi.impl.ReferenceProviders;
import com.intellij.model.search.CodeReferenceSearcher;
import com.intellij.model.search.LeafOccurrenceMapper;
import com.intellij.model.search.PsiSymbolReferenceSearchParameters;
import com.intellij.model.search.PsiSymbolReferenceSearcher;
import com.intellij.model.search.SearchContext;
import com.intellij.model.search.SearchRequest;
import com.intellij.model.search.SearchService;
import com.intellij.model.search.SearchWordQueryBuilder;
import com.intellij.model.search.impl.CodeReferenceMapper;
import com.intellij.model.search.impl.ExternalReferenceMapper;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.Query;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u00050\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/model/search/impl/DefaultReferenceSearcher;", "Lcom/intellij/model/search/PsiSymbolReferenceSearcher;", "()V", "collectSearchRequests", "", "Lcom/intellij/util/Query;", "Lcom/intellij/model/psi/PsiSymbolReference;", "parameters", "Lcom/intellij/model/search/PsiSymbolReferenceSearchParameters;", "intellij.platform.indexing.impl"})
public final class DefaultReferenceSearcher
implements PsiSymbolReferenceSearcher {
    @NotNull
    public Collection<Query<? extends PsiSymbolReference>> collectSearchRequests(@NotNull PsiSymbolReferenceSearchParameters parameters2) {
        Intrinsics.checkNotNullParameter((Object)parameters2, (String)"parameters");
        Project project = parameters2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"parameters.project");
        Project project2 = project;
        SearchScope searchScope2 = parameters2.getSearchScope();
        Intrinsics.checkNotNullExpressionValue((Object)searchScope2, (String)"parameters.searchScope");
        SearchScope inputScope = searchScope2;
        Symbol symbol = parameters2.getSymbol();
        Intrinsics.checkNotNullExpressionValue((Object)symbol, (String)"parameters.symbol");
        Symbol target2 = symbol;
        Pointer pointer = target2.createPointer();
        Intrinsics.checkNotNullExpressionValue((Object)pointer, (String)"target.createPointer()");
        Pointer targetPointer = pointer;
        SearchService searchService = SearchService.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)searchService, (String)"SearchService.getInstance()");
        SearchService service = searchService;
        boolean bl = false;
        List result2 = new ArrayList();
        ExtensionPointName extensionPointName = CodeReferenceSearcher.EP_NAME;
        Intrinsics.checkNotNullExpressionValue((Object)extensionPointName, (String)"CodeReferenceSearcher.EP_NAME");
        for (CodeReferenceSearcher searcher : extensionPointName.getExtensionList()) {
            Language language;
            SearchWordQueryBuilder builder2;
            SearchScope searchScope3;
            SearchScope searchScope4;
            SearchRequest request;
            if (searcher.getSearchRequest(project2, target2) == null) {
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)searcher.getReferencingLanguage(target2), (String)"searcher.getReferencingLanguage(target)");
            SearchScope searchScope5 = request.getSearchScope();
            if (searchScope5 == null || (searchScope5 = searchScope5.intersectWith(inputScope)) == null) {
                searchScope5 = searchScope4 = inputScope;
            }
            if ((searchScope3 = request.getInjectionSearchScope()) == null || (searchScope3 = searchScope3.intersectWith(inputScope)) == null) {
                searchScope3 = inputScope;
            }
            SearchScope injectionSearchScope = searchScope3;
            LeafOccurrenceMapper mapper = new CodeReferenceMapper((Pointer<? extends Symbol>)targetPointer, searcher);
            Intrinsics.checkNotNullExpressionValue((Object)service.searchWord(project2, request.getSearchString()), (String)"service.searchWord(project, request.searchString)");
            Collection collection = result2;
            Query query2 = builder2.inContexts(SearchContext.IN_CODE, new SearchContext[0]).inScope(searchScope4).inFilesWithLanguage(language).buildQuery(mapper);
            boolean bl2 = false;
            collection.add(query2);
            collection = result2;
            query2 = builder2.inContexts(SearchContext.IN_CODE_HOSTS, new SearchContext[0]).inScope(injectionSearchScope).inInjections(language).buildQuery(mapper);
            bl2 = false;
            collection.add(query2);
        }
        ExternalReferenceMapper mapper = new ExternalReferenceMapper((Pointer<? extends Symbol>)targetPointer);
        for (PsiSymbolReferenceProviderBean providerBean : ReferenceProviders.byTargetClass(target2.getClass())) {
            Collection requests2;
            Intrinsics.checkNotNullExpressionValue((Object)((PsiSymbolReferenceProvider)providerBean.getInstance()).getSearchRequests(project2, target2), (String)"providerBean.instance.ge\u2026Requests(project, target)");
            for (SearchRequest request : requests2) {
                Language language;
                SearchWordQueryBuilder builder3;
                SearchScope searchScope6;
                SearchScope searchScope7;
                Intrinsics.checkNotNullExpressionValue((Object)providerBean.getHostLanguage(), (String)"providerBean.getHostLanguage()");
                SearchScope searchScope8 = request.getSearchScope();
                if (searchScope8 == null || (searchScope8 = searchScope8.intersectWith(inputScope)) == null) {
                    searchScope8 = searchScope7 = inputScope;
                }
                if ((searchScope6 = request.getInjectionSearchScope()) == null || (searchScope6 = searchScope6.intersectWith(inputScope)) == null) {
                    searchScope6 = inputScope;
                }
                SearchScope injectionSearchScope = searchScope6;
                Intrinsics.checkNotNullExpressionValue((Object)service.searchWord(project2, request.getSearchString()).inContexts(SearchContext.IN_CODE_HOSTS, new SearchContext[0]), (String)"service.searchWord(proje\u2026inContexts(IN_CODE_HOSTS)");
                Collection collection = result2;
                Query query3 = builder3.inScope(searchScope7).inFilesWithLanguage(language).buildQuery((LeafOccurrenceMapper)mapper);
                boolean bl3 = false;
                collection.add(query3);
                collection = result2;
                query3 = builder3.inScope(injectionSearchScope).inInjections(language).buildQuery((LeafOccurrenceMapper)mapper);
                bl3 = false;
                collection.add(query3);
            }
        }
        return result2;
    }
}

