/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.psiView.formattingblocks;

import com.intellij.formatting.Block;
import com.intellij.formatting.templateLanguages.DataLanguageBlockWrapper;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.PlatformColors;
import java.awt.Color;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class BlockTreeNode
extends SimpleNode {
    private final Block myBlock;

    public BlockTreeNode(Block block, BlockTreeNode parent) {
        super((SimpleNode)parent);
        this.myBlock = block;
    }

    public Block getBlock() {
        return this.myBlock;
    }

    public BlockTreeNode @NotNull [] getChildren() {
        BlockTreeNode[] blockTreeNodeArray = (BlockTreeNode[])ContainerUtil.map2Array((Collection)this.myBlock.getSubBlocks(), BlockTreeNode.class, block -> new BlockTreeNode((Block)block, this));
        if (blockTreeNodeArray == null) {
            BlockTreeNode.$$$reportNull$$$0(0);
        }
        return blockTreeNodeArray;
    }

    protected void update(@NotNull PresentationData presentation2) {
        Object name;
        if (presentation2 == null) {
            BlockTreeNode.$$$reportNull$$$0(1);
        }
        if ((name = this.myBlock.getDebugName()) == null) {
            name = this.myBlock.getClass().getSimpleName();
        }
        if (this.myBlock instanceof DataLanguageBlockWrapper) {
            name = (String)name + " (" + ((DataLanguageBlockWrapper)this.myBlock).getOriginal().getClass().getSimpleName() + ")";
        }
        presentation2.addText((String)name, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        if (this.myBlock.getIndent() != null) {
            presentation2.addText(" " + String.valueOf(this.myBlock.getIndent()).replaceAll("[<>]", " "), SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
        if (this.myBlock.getAlignment() != null) {
            float d = 1.0f * (float)System.identityHashCode(this.myBlock.getAlignment()) / 2.1474836E9f;
            JBColor color = new JBColor(Color.HSBtoRGB(d, 0.3f, 0.7f), Color.HSBtoRGB(d, 0.3f, 0.8f));
            presentation2.addText(" " + this.myBlock.getAlignment(), new SimpleTextAttributes(1, (Color)color));
        }
        if (this.myBlock.getWrap() != null) {
            presentation2.addText(" " + this.myBlock.getWrap(), new SimpleTextAttributes(2, PlatformColors.BLUE));
        }
    }

    public Object @NotNull [] getEqualityObjects() {
        Object[] objectArray = new Object[]{this.myBlock};
        if (objectArray == null) {
            BlockTreeNode.$$$reportNull$$$0(2);
        }
        return objectArray;
    }

    public boolean isAlwaysLeaf() {
        return this.myBlock.isLeaf() && this.myBlock.getSubBlocks().isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/psiView/formattingblocks/BlockTreeNode";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/psiView/formattingblocks/BlockTreeNode";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEqualityObjects";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

