/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.intellij;

import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.ide.ui.laf.darcula.ui.DarculaTextBorder;
import com.intellij.ui.Gray;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.JBValue;
import com.intellij.util.ui.MacUIUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Path2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.ApiStatus;

@Deprecated
@ApiStatus.ScheduledForRemoval(inVersion="2020.2")
public class MacIntelliJTextBorder
extends DarculaTextBorder {
    private static final Color OUTLINE_COLOR = Gray.xBC;
    private static final Insets PADDINGS = JBUI.emptyInsets();
    static final JBValue BW = new JBValue.Float(3.0f);
    static final JBValue ARC = new JBValue.Float(6.0f);

    static float LW(Graphics2D g2) {
        float f = UIUtil.isRetina((Graphics2D)g2) ? 0.5f : 1.0f;
        return JBUIScale.scale((float)f);
    }

    @Override
    protected float lw(Graphics2D g2) {
        return MacIntelliJTextBorder.LW(g2);
    }

    @Override
    protected float bw() {
        return BW.getFloat();
    }

    @Override
    protected Color getOutlineColor(boolean enabled, boolean focused) {
        return OUTLINE_COLOR;
    }

    @Override
    protected void paintSearchArea(Graphics2D g, Rectangle r, JTextComponent c, boolean fillBackground) {
        MacIntelliJTextBorder.paintMacSearchArea(g, r, c, fillBackground);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void paintMacSearchArea(Graphics2D g, Rectangle r, JTextComponent c, boolean fillBackground) {
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, MacUIUtil.USE_QUARTZ ? RenderingHints.VALUE_STROKE_PURE : RenderingHints.VALUE_STROKE_NORMALIZE);
            g2.translate(r.x, r.y);
            float arc = ARC.getFloat();
            float lw = MacIntelliJTextBorder.LW(g2);
            float bw = BW.getFloat();
            RoundRectangle2D.Float outerShape = new RoundRectangle2D.Float(bw, bw, (float)r.width - bw * 2.0f, (float)r.height - bw * 2.0f, arc, arc);
            if (fillBackground) {
                g2.setColor(c.getBackground());
                g2.fill(outerShape);
            }
            Path2D.Float path = new Path2D.Float(0);
            path.append(outerShape, false);
            path.append(new RoundRectangle2D.Float(bw + lw, bw + lw, (float)r.width - (bw + lw) * 2.0f, (float)r.height - (bw + lw) * 2.0f, arc - lw, arc - lw), false);
            g2.setColor(OUTLINE_COLOR);
            g2.fill(path);
            if (c.hasFocus()) {
                Object op = c.getClientProperty("JComponent.outline");
                if (op != null) {
                    DarculaUIUtil.paintOutlineBorder(g2, r.width, r.height, arc, true, true, DarculaUIUtil.Outline.valueOf(op.toString()));
                } else {
                    DarculaUIUtil.paintFocusBorder(g2, r.width, r.height, arc, true);
                }
            }
        }
        finally {
            g2.dispose();
        }
    }

    @Override
    protected Insets paddings() {
        return PADDINGS;
    }
}

