/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.customRegions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.lang.folding.CustomFoldingProvider;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomRegionTreeElement
implements StructureViewTreeElement {
    private final PsiElement myStartElement;
    private int myEndOffset;
    private final Collection<StructureViewTreeElement> myChildElements;
    private final CustomFoldingProvider myProvider;
    private final CustomRegionTreeElement myParent;
    private List<CustomRegionTreeElement> mySubRegions;

    public CustomRegionTreeElement(@NotNull PsiElement startElement, @NotNull CustomFoldingProvider provider2, @Nullable CustomRegionTreeElement parent) {
        if (startElement == null) {
            CustomRegionTreeElement.$$$reportNull$$$0(0);
        }
        if (provider2 == null) {
            CustomRegionTreeElement.$$$reportNull$$$0(1);
        }
        this.myEndOffset = Integer.MAX_VALUE;
        this.myChildElements = new ArrayList<StructureViewTreeElement>();
        this.myStartElement = startElement;
        this.myProvider = provider2;
        this.myParent = parent;
    }

    public CustomRegionTreeElement(@NotNull PsiElement startElement, @NotNull CustomFoldingProvider provider2) {
        if (startElement == null) {
            CustomRegionTreeElement.$$$reportNull$$$0(2);
        }
        if (provider2 == null) {
            CustomRegionTreeElement.$$$reportNull$$$0(3);
        }
        this(startElement, provider2, null);
    }

    public Object getValue() {
        return this;
    }

    public void navigate(boolean requestFocus) {
        ((Navigatable)this.myStartElement).navigate(requestFocus);
    }

    public boolean canNavigate() {
        return this.myStartElement instanceof Navigatable && ((Navigatable)this.myStartElement).canNavigate();
    }

    public boolean canNavigateToSource() {
        return this.canNavigate();
    }

    @NotNull
    public ItemPresentation getPresentation() {
        return new ItemPresentation(){

            @Nullable
            public String getPresentableText() {
                return CustomRegionTreeElement.this.myProvider.getPlaceholderText(CustomRegionTreeElement.this.myStartElement.getText());
            }

            @Nullable
            public String getLocationString() {
                return null;
            }

            @NotNull
            public Icon getIcon(boolean unused) {
                Icon icon2 = AllIcons.Nodes.CustomRegion;
                if (icon2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return icon2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/structureView/customRegions/CustomRegionTreeElement$1", "getIcon"));
            }
        };
    }

    public void addChild(@NotNull StructureViewTreeElement childElement) {
        if (childElement == null) {
            CustomRegionTreeElement.$$$reportNull$$$0(4);
        }
        if (this.mySubRegions != null) {
            for (CustomRegionTreeElement subRegion : this.mySubRegions) {
                if (!subRegion.containsElement(childElement)) continue;
                subRegion.addChild(childElement);
                return;
            }
        }
        this.myChildElements.add(childElement);
    }

    public TreeElement @NotNull [] getChildren() {
        if (this.mySubRegions == null || this.mySubRegions.isEmpty()) {
            TreeElement[] treeElementArray = (TreeElement[])this.myChildElements.toArray(StructureViewTreeElement.EMPTY_ARRAY);
            if (treeElementArray == null) {
                CustomRegionTreeElement.$$$reportNull$$$0(5);
            }
            return treeElementArray;
        }
        StructureViewTreeElement[] allElements = new StructureViewTreeElement[this.myChildElements.size() + this.mySubRegions.size()];
        int index = 0;
        for (StructureViewTreeElement structureViewTreeElement : this.myChildElements) {
            allElements[index++] = structureViewTreeElement;
        }
        for (StructureViewTreeElement structureViewTreeElement : this.mySubRegions) {
            allElements[index++] = structureViewTreeElement;
        }
        if (allElements == null) {
            CustomRegionTreeElement.$$$reportNull$$$0(6);
        }
        return allElements;
    }

    public boolean containsElement(StructureViewTreeElement element2) {
        TextRange elementRange;
        Object o = element2.getValue();
        return o instanceof PsiElement && (elementRange = ((PsiElement)o).getTextRange()).getStartOffset() >= this.myStartElement.getTextRange().getStartOffset() && elementRange.getEndOffset() <= this.myEndOffset;
    }

    public CustomRegionTreeElement createNestedRegion(@NotNull PsiElement element2) {
        if (element2 == null) {
            CustomRegionTreeElement.$$$reportNull$$$0(7);
        }
        if (this.mySubRegions == null) {
            this.mySubRegions = new ArrayList<CustomRegionTreeElement>();
        }
        CustomRegionTreeElement currSubRegion = new CustomRegionTreeElement(element2, this.myProvider, this);
        this.mySubRegions.add(currSubRegion);
        return currSubRegion;
    }

    public CustomRegionTreeElement endRegion(@NotNull PsiElement element2) {
        if (element2 == null) {
            CustomRegionTreeElement.$$$reportNull$$$0(8);
        }
        this.myEndOffset = element2.getTextRange().getEndOffset();
        return this.myParent;
    }

    public String toString() {
        return "Region '" + this.myProvider.getPlaceholderText(this.myStartElement.getText()) + "'";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childElement";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/structureView/customRegions/CustomRegionTreeElement";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/structureView/customRegions/CustomRegionTreeElement";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addChild";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createNestedRegion";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "endRegion";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

