/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.script;

import com.intellij.ide.extensionResources.ExtensionsRootType;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.script.IdeConsoleScriptBindings;
import com.intellij.ide.script.IdeScriptEngine;
import com.intellij.ide.script.IdeScriptEngineManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.Formats;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.PathKt;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

final class IdeStartupScripts
implements StartupActivity.DumbAware {
    private static final Logger LOG = Logger.getInstance(IdeStartupScripts.class);
    private static final String SCRIPT_DIR = "startup";
    private final AtomicBoolean isActive = new AtomicBoolean(true);

    IdeStartupScripts() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            throw ExtensionNotApplicableException.INSTANCE;
        }
    }

    public void runActivity(@NotNull Project project) {
        if (project == null) {
            IdeStartupScripts.$$$reportNull$$$0(0);
        }
        if (!this.isActive.compareAndSet(true, false)) {
            return;
        }
        IdeStartupScripts.runAllScriptsImpl(project, IdeStartupScripts.prepareScriptsAndEngines());
    }

    @NotNull
    private static List<Pair<Path, IdeScriptEngine>> prepareScriptsAndEngines() {
        List<Path> scripts = IdeStartupScripts.getScripts();
        LOG.info(scripts.size() + " startup script(s) found");
        if (scripts.isEmpty()) {
            List<Pair<Path, IdeScriptEngine>> list2 = Collections.emptyList();
            if (list2 == null) {
                IdeStartupScripts.$$$reportNull$$$0(1);
            }
            return list2;
        }
        IdeScriptEngineManager scriptEngineManager = IdeScriptEngineManager.getInstance();
        ArrayList<Pair<Path, IdeScriptEngine>> result2 = new ArrayList<Pair<Path, IdeScriptEngine>>();
        for (Path script : scripts) {
            IdeScriptEngine engine;
            String extension = FileUtilRt.getExtension((String)script.getFileName().toString());
            IdeScriptEngine ideScriptEngine = engine = extension.isEmpty() ? null : scriptEngineManager.getEngineByFileExtension(extension, null);
            if (engine == null) {
                LOG.warn(script + " not supported (no script engine)");
                continue;
            }
            result2.add((Pair<Path, IdeScriptEngine>)new Pair((Object)script, (Object)engine));
        }
        ArrayList<Pair<Path, IdeScriptEngine>> arrayList = result2;
        if (arrayList == null) {
            IdeStartupScripts.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    /*
     * Loose catch block
     */
    @NotNull
    private static List<Path> getScripts() {
        List<Path> list2;
        Stream<Path> stream;
        block11: {
            Path directory = ExtensionsRootType.getInstance().findResourceDirectory(PluginManagerCore.CORE_ID, SCRIPT_DIR, false);
            stream = Files.list(directory);
            list2 = stream.filter(ExtensionsRootType.regularFileFilter()).sorted((f1, f2) -> {
                String f1Name = f1 == null ? null : f1.getFileName().toString();
                String f2Name = f2 == null ? null : f2.getFileName().toString();
                return StringUtil.compare((String)f1Name, (String)f2Name, (boolean)false);
            }).collect(Collectors.toList());
            if (stream == null) break block11;
            stream.close();
        }
        List<Path> list3 = list2;
        if (list3 == null) {
            IdeStartupScripts.$$$reportNull$$$0(3);
        }
        return list3;
        {
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoSuchFileException directory) {
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }
        }
        List<Path> list4 = Collections.emptyList();
        if (list4 == null) {
            IdeStartupScripts.$$$reportNull$$$0(4);
        }
        return list4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runAllScriptsImpl(@NotNull Project project, @NotNull List<Pair<Path, IdeScriptEngine>> result2) {
        if (project == null) {
            IdeStartupScripts.$$$reportNull$$$0(5);
        }
        if (result2 == null) {
            IdeStartupScripts.$$$reportNull$$$0(6);
        }
        for (Pair<Path, IdeScriptEngine> pair : result2) {
            try {
                LOG.info(((Path)pair.first).toString());
                String scriptText = PathKt.readText((Path)((Path)pair.first));
                IdeConsoleScriptBindings.ensureIdeIsBound(project, (IdeScriptEngine)pair.second);
                long start2 = System.currentTimeMillis();
                try {
                    ((IdeScriptEngine)pair.second).eval(scriptText);
                }
                catch (ProcessCanceledException e) {
                    LOG.warn("... cancelled");
                }
                finally {
                    LOG.info("... completed in " + Formats.formatDuration((long)(System.currentTimeMillis() - start2)));
                }
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/script/IdeStartupScripts";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/script/IdeStartupScripts";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareScriptsAndEngines";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getScripts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "runActivity";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "runAllScriptsImpl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

