/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.ide.projectView.impl.ProjectViewFileNestingService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileNestingBuilder {
    private long myBaseListModCount = -1L;
    private Set<ProjectViewFileNestingService.NestingRule> myNestingRules;

    public static FileNestingBuilder getInstance() {
        return (FileNestingBuilder)ApplicationManager.getApplication().getService(FileNestingBuilder.class);
    }

    @NotNull
    public synchronized Collection<ProjectViewFileNestingService.NestingRule> getNestingRules() {
        ProjectViewFileNestingService fileNestingService = ProjectViewFileNestingService.getInstance();
        List<ProjectViewFileNestingService.NestingRule> baseRules = fileNestingService.getRules();
        long modCount = fileNestingService.getModificationCount();
        if (this.myNestingRules == null || this.myBaseListModCount != modCount) {
            this.myNestingRules = new THashSet();
            this.myBaseListModCount = modCount;
            MultiMap childToParentSuffix = new MultiMap();
            MultiMap parentToChildSuffix = new MultiMap();
            for (ProjectViewFileNestingService.NestingRule rule : baseRules) {
                String parentFileSuffix = rule.getParentFileSuffix();
                String childFileSuffix = rule.getChildFileSuffix();
                if (parentFileSuffix.isEmpty() || childFileSuffix.isEmpty() || parentFileSuffix.equals(childFileSuffix)) continue;
                this.myNestingRules.add(rule);
                childToParentSuffix.putValue((Object)childFileSuffix, (Object)parentFileSuffix);
                parentToChildSuffix.putValue((Object)parentFileSuffix, (Object)childFileSuffix);
                for (String s : parentToChildSuffix.get((Object)childFileSuffix)) {
                    this.myNestingRules.add(new ProjectViewFileNestingService.NestingRule(parentFileSuffix, s));
                    parentToChildSuffix.putValue((Object)parentFileSuffix, (Object)s);
                    childToParentSuffix.putValue((Object)s, (Object)parentFileSuffix);
                }
                for (String s : childToParentSuffix.get((Object)parentFileSuffix)) {
                    this.myNestingRules.add(new ProjectViewFileNestingService.NestingRule(s, childFileSuffix));
                    parentToChildSuffix.putValue((Object)s, (Object)childFileSuffix);
                    childToParentSuffix.putValue((Object)childFileSuffix, (Object)s);
                }
            }
        }
        Set<ProjectViewFileNestingService.NestingRule> set2 = this.myNestingRules;
        if (set2 == null) {
            FileNestingBuilder.$$$reportNull$$$0(0);
        }
        return set2;
    }

    @NotNull
    public <T> MultiMap<T, T> mapParentToChildren(@NotNull Collection<? extends T> nodes, @NotNull Function<? super T, String> fileNameFunc) {
        Collection<ProjectViewFileNestingService.NestingRule> rules;
        if (nodes == null) {
            FileNestingBuilder.$$$reportNull$$$0(1);
        }
        if (fileNameFunc == null) {
            FileNestingBuilder.$$$reportNull$$$0(2);
        }
        if ((rules = this.getNestingRules()).isEmpty()) {
            MultiMap multiMap = MultiMap.empty();
            if (multiMap == null) {
                FileNestingBuilder.$$$reportNull$$$0(3);
            }
            return multiMap;
        }
        MultiMap parentToChildren = null;
        THashSet allChildNodes = null;
        THashMap baseNameAndRuleToEdge = null;
        for (T node : nodes) {
            String fileName = fileNameFunc.apply(node);
            if (fileName == null) continue;
            for (ProjectViewFileNestingService.NestingRule rule : rules) {
                Edge<T> edge;
                String baseName;
                Couple<Boolean> c = FileNestingBuilder.checkMatchingAsParentOrChild(rule, fileName);
                boolean matchesParent = (Boolean)c.first;
                boolean matchesChild = (Boolean)c.second;
                if (!matchesChild && !matchesParent) continue;
                if (baseNameAndRuleToEdge == null) {
                    baseNameAndRuleToEdge = new THashMap();
                    parentToChildren = new MultiMap();
                    allChildNodes = new THashSet();
                }
                if (matchesParent) {
                    baseName = fileName.substring(0, fileName.length() - rule.getParentFileSuffix().length());
                    edge = FileNestingBuilder.getOrCreateEdge(baseNameAndRuleToEdge, baseName, rule);
                    edge.from = node;
                    FileNestingBuilder.updateInfoIfEdgeComplete(parentToChildren, allChildNodes, edge);
                }
                if (!matchesChild) continue;
                baseName = fileName.substring(0, fileName.length() - rule.getChildFileSuffix().length());
                edge = FileNestingBuilder.getOrCreateEdge(baseNameAndRuleToEdge, baseName, rule);
                edge.to = node;
                FileNestingBuilder.updateInfoIfEdgeComplete(parentToChildren, allChildNodes, edge);
            }
        }
        MultiMap multiMap = parentToChildren == null ? MultiMap.empty() : parentToChildren;
        if (multiMap == null) {
            FileNestingBuilder.$$$reportNull$$$0(4);
        }
        return multiMap;
    }

    public static Couple<Boolean> checkMatchingAsParentOrChild(@NotNull ProjectViewFileNestingService.NestingRule rule, @NotNull String fileName) {
        if (rule == null) {
            FileNestingBuilder.$$$reportNull$$$0(5);
        }
        if (fileName == null) {
            FileNestingBuilder.$$$reportNull$$$0(6);
        }
        String parentFileSuffix = rule.getParentFileSuffix();
        String childFileSuffix = rule.getChildFileSuffix();
        boolean matchesParent = StringUtil.endsWithIgnoreCase((String)fileName, (String)parentFileSuffix);
        boolean matchesChild = StringUtil.endsWithIgnoreCase((String)fileName, (String)childFileSuffix);
        if (matchesParent && matchesChild) {
            if (parentFileSuffix.length() > childFileSuffix.length()) {
                matchesChild = false;
            } else {
                matchesParent = false;
            }
        }
        return Couple.of((Object)matchesParent, (Object)matchesChild);
    }

    @NotNull
    private static <T> Edge<T> getOrCreateEdge(@NotNull Map<Pair<String, ProjectViewFileNestingService.NestingRule>, Edge<T>> baseNameAndRuleToEdge, @NotNull String baseName, @NotNull ProjectViewFileNestingService.NestingRule rule) {
        Pair baseNameAndRule;
        Edge<T> edge;
        if (baseNameAndRuleToEdge == null) {
            FileNestingBuilder.$$$reportNull$$$0(7);
        }
        if (baseName == null) {
            FileNestingBuilder.$$$reportNull$$$0(8);
        }
        if (rule == null) {
            FileNestingBuilder.$$$reportNull$$$0(9);
        }
        if ((edge = baseNameAndRuleToEdge.get(baseNameAndRule = Pair.create((Object)baseName, (Object)rule))) == null) {
            edge = new Edge();
            baseNameAndRuleToEdge.put((Pair<String, ProjectViewFileNestingService.NestingRule>)baseNameAndRule, edge);
        }
        Edge<T> edge2 = edge;
        if (edge2 == null) {
            FileNestingBuilder.$$$reportNull$$$0(10);
        }
        return edge2;
    }

    private static <T> void updateInfoIfEdgeComplete(@NotNull MultiMap<T, T> parentToChildren, @NotNull Set<? super T> allChildNodes, @NotNull Edge<? extends T> edge) {
        if (parentToChildren == null) {
            FileNestingBuilder.$$$reportNull$$$0(11);
        }
        if (allChildNodes == null) {
            FileNestingBuilder.$$$reportNull$$$0(12);
        }
        if (edge == null) {
            FileNestingBuilder.$$$reportNull$$$0(13);
        }
        if (edge.from != null && edge.to != null) {
            allChildNodes.add(edge.to);
            parentToChildren.remove(edge.to);
            if (!allChildNodes.contains(edge.from)) {
                parentToChildren.putValue(edge.from, edge.to);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/projectView/impl/FileNestingBuilder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileNameFunc";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rule";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseNameAndRuleToEdge";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseName";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentToChildren";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allChildNodes";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edge";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNestingRules";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/projectView/impl/FileNestingBuilder";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "mapParentToChildren";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateEdge";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "mapParentToChildren";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkMatchingAsParentOrChild";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateEdge";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "updateInfoIfEdgeComplete";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Edge<T> {
        @Nullable
        private T from;
        @Nullable
        private T to;

        private Edge() {
        }
    }
}

