/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.marketplace;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.marketplace.AggregationSearchResponse;
import com.intellij.ide.plugins.marketplace.FeatureImpl;
import com.intellij.ide.plugins.marketplace.IdeCompatibleUpdate;
import com.intellij.ide.plugins.marketplace.IntellijUpdateMetadata;
import com.intellij.ide.plugins.marketplace.MarketplaceBrokenPlugin;
import com.intellij.ide.plugins.marketplace.MarketplacePluginDownloadService;
import com.intellij.ide.plugins.marketplace.MarketplaceRequests;
import com.intellij.ide.plugins.marketplace.MarketplaceSearchPluginData;
import com.intellij.ide.plugins.marketplace.RepositoryContentHandler;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.URLUtil;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u00b6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0017\u0018\u0000 e2\u00020\u0001:\u0003efgB\u0005\u00a2\u0006\u0002\u0010\u0002J!\u0010\u0019\u001a\u00070\n\u00a2\u0006\u0002\b\b2\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u001bH\u0002J\u0018\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0018\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020$H\u0016J \u0010%\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010&\u001a\u00020'2\u0006\u0010#\u001a\u00020$H\u0016J\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00040)J\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00040)J\f\u0010+\u001a\b\u0012\u0004\u0012\u00020,0)J\r\u0010-\u001a\u00020!H\u0000\u00a2\u0006\u0002\b.J\u0006\u0010/\u001a\u00020\u0004J\"\u00100\u001a\b\u0012\u0004\u0012\u0002010)2\u0006\u00102\u001a\u00020\u00042\n\b\u0002\u00103\u001a\u0004\u0018\u000104H\u0007J\u0010\u00105\u001a\u00020!2\u0006\u00106\u001a\u00020!H\u0002J \u00107\u001a\b\u0012\u0004\u0012\u0002080)2\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u001bJ*\u00109\u001a\u0004\u0018\u00010:2\u0006\u0010;\u001a\u00020\u00042\n\b\u0002\u00103\u001a\u0004\u0018\u0001042\n\b\u0002\u0010#\u001a\u0004\u0018\u00010$H\u0007J&\u00109\u001a\b\u0012\u0004\u0012\u0002010)2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00040)2\n\b\u0002\u00103\u001a\u0004\u0018\u000104J\u000e\u0010=\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010)J\u0016\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00040)2\b\u0010#\u001a\u0004\u0018\u00010$J\u0010\u0010?\u001a\u00020!2\u0006\u0010@\u001a\u000201H\u0002J\u0010\u0010A\u001a\u00020\u00042\u0006\u0010@\u001a\u000201H\u0002J\b\u0010B\u001a\u00020!H\u0002J\u0012\u0010C\u001a\u0004\u0018\u00010\u00042\u0006\u00106\u001a\u00020!H\u0002J\u0006\u0010D\u001a\u00020EJ(\u0010F\u001a\b\u0012\u0004\u0012\u00020:0)2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00040)2\n\b\u0002\u00103\u001a\u0004\u0018\u000104H\u0007J\"\u0010G\u001a\u00020:2\u0006\u0010H\u001a\u00020\u00042\u0006\u0010I\u001a\u0002012\n\b\u0002\u0010#\u001a\u0004\u0018\u00010$J\u000e\u0010J\u001a\u00020:2\u0006\u0010K\u001a\u00020:J\u0018\u0010L\u001a\u00020E2\u0006\u0010M\u001a\u00020\u00042\u0006\u0010N\u001a\u00020OH\u0002J$\u0010P\u001a\u0016\u0012\u0004\u0012\u00020, Q*\n\u0012\u0004\u0012\u00020,\u0018\u00010)0)2\u0006\u0010R\u001a\u00020SH\u0002J\u0018\u0010T\u001a\n Q*\u0004\u0018\u00010U0U2\u0006\u0010R\u001a\u00020SH\u0002J$\u0010V\u001a\u0016\u0012\u0004\u0012\u00020\u0004 Q*\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010)0)2\u0006\u0010R\u001a\u00020SH\u0002JI\u0010W\u001a\u0002HX\"\u0004\b\u0000\u0010X2\b\u00106\u001a\u0004\u0018\u00010!2\u0006\u0010Y\u001a\u00020\u00042\b\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010Z\u001a\u00020\u00042\u0012\u0010[\u001a\u000e\u0012\u0004\u0012\u00020S\u0012\u0004\u0012\u0002HX0\\\u00a2\u0006\u0002\u0010]J\u0018\u0010^\u001a\u00020E2\u0006\u00106\u001a\u00020!2\u0006\u0010_\u001a\u00020\u0004H\u0002J\u001c\u0010`\u001a\b\u0012\u0004\u0012\u00020:0)2\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001fJ\u0016\u0010a\u001a\u00020b*\u00020c2\b\u00106\u001a\u0004\u0018\u00010!H\u0002J\u0016\u0010d\u001a\u00020E*\u00020c2\b\u0010_\u001a\u0004\u0018\u00010\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\u0004\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u00070\n\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\f\u001a\u00070\n\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R.\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u000f2\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001b\u0010\u0013\u001a\u00020\u00148BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006h"}, d2={"Lcom/intellij/ide/plugins/marketplace/MarketplaceRequests;", "", "()V", "AVAILABLE_PLUGINS_XML_IDS_URL", "", "BROKEN_PLUGIN_PATH", "COMPATIBLE_UPDATE_URL", "IDE_BUILD_FOR_REQUEST", "Lorg/jetbrains/annotations/NotNull;", "JETBRAINS_PLUGINS_URL", "Lcom/intellij/util/Url;", "MARKETPLACE_ORGANIZATIONS_URL", "MARKETPLACE_TAGS_URL", "PLUGIN_MANAGER_URL", "<set-?>", "", "jetBrainsPluginsIds", "getJetBrainsPluginsIds", "()Ljava/util/Set;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getObjectMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "objectMapper$delegate", "Lkotlin/Lazy;", "createFeatureUrl", "param", "", "createSearchUrl", "query", "count", "", "downloadPlugin", "Ljava/io/File;", "pluginUrl", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "downloadPluginViaBlockMap", "prevPlugin", "Ljava/nio/file/Path;", "getAllPluginsTags", "", "getAllPluginsVendors", "getBrokenPlugins", "Lcom/intellij/ide/plugins/marketplace/MarketplaceBrokenPlugin;", "getBrokenPluginsFile", "getBrokenPluginsFile$intellij_platform_ide_impl", "getBuildForPluginRepositoryRequests", "getCompatibleUpdatesByModule", "Lcom/intellij/ide/plugins/marketplace/IdeCompatibleUpdate;", "module", "buildNumber", "Lcom/intellij/openapi/util/BuildNumber;", "getETagFile", "file", "getFeatures", "Lcom/intellij/ide/plugins/marketplace/FeatureImpl;", "getLastCompatiblePluginUpdate", "Lcom/intellij/ide/plugins/PluginNode;", "id", "ids", "getMarketplaceCachedPlugins", "getMarketplacePlugins", "getUpdateMetadataFile", "update", "getUpdateMetadataUrl", "getUpdatesMetadataFilesDirectory", "loadEtagForFile", "loadJetBrainsPluginsIds", "", "loadLastCompatiblePluginDescriptors", "loadPluginDescriptor", "xmlId", "ideCompatibleUpdate", "loadPluginDetails", "pluginNode", "logWarnOrPrintIfDebug", "message", "throwable", "", "parseBrokenPlugins", "kotlin.jvm.PlatformType", "reader", "Ljava/io/Reader;", "parseJsonPluginMeta", "Lcom/intellij/ide/plugins/marketplace/IntellijUpdateMetadata;", "parseXmlIds", "readOrUpdateFile", "T", "url", "indicatorMessage", "parser", "Lkotlin/Function1;", "(Ljava/io/File;Ljava/lang/String;Lcom/intellij/openapi/progress/ProgressIndicator;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "saveETagForFile", "eTag", "searchPlugins", "isNotModified", "", "Ljava/net/URLConnection;", "setUpETag", "Companion", "CompatibleUpdateForModuleRequest", "CompatibleUpdateRequest", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public class MarketplaceRequests {
    private final String PLUGIN_MANAGER_URL;
    private final String AVAILABLE_PLUGINS_XML_IDS_URL;
    private final String IDE_BUILD_FOR_REQUEST;
    private final Url MARKETPLACE_ORGANIZATIONS_URL;
    private final Url MARKETPLACE_TAGS_URL;
    private final Url JETBRAINS_PLUGINS_URL;
    private final String COMPATIBLE_UPDATE_URL;
    private final Lazy objectMapper$delegate;
    private final String BROKEN_PLUGIN_PATH;
    @Nullable
    private Set<String> jetBrainsPluginsIds;
    private static final Logger LOG;
    private static final String TAG_EXT = ".etag";
    private static final String FULL_PLUGINS_XML_IDS_FILENAME = "pluginsXMLIds.json";
    private static final MarketplaceRequests INSTANCE;
    public static final Companion Companion;

    private final ObjectMapper getObjectMapper() {
        Lazy lazy = this.objectMapper$delegate;
        MarketplaceRequests marketplaceRequests = this;
        Object var3_3 = null;
        boolean bl = false;
        return (ObjectMapper)lazy.getValue();
    }

    private final File getUpdatesMetadataFilesDirectory() {
        return FilesKt.resolve((File)new File(PathManager.getPluginsPath()), (String)"meta");
    }

    @NotNull
    public final File getBrokenPluginsFile$intellij_platform_ide_impl() {
        return FilesKt.resolve((File)new File(PathManager.getPluginsPath()), (String)"brokenPlugins.json");
    }

    private final File getUpdateMetadataFile(IdeCompatibleUpdate update2) {
        return FilesKt.resolve((File)this.getUpdatesMetadataFilesDirectory(), (String)(update2.getExternalUpdateId() + ".json"));
    }

    private final String getUpdateMetadataUrl(IdeCompatibleUpdate update2) {
        return this.PLUGIN_MANAGER_URL + "/files/" + update2.getExternalPluginId() + '/' + update2.getExternalUpdateId() + "/meta.json";
    }

    private final Url createSearchUrl(String query2, int count) {
        return Urls.newFromEncoded((String)(this.PLUGIN_MANAGER_URL + "/api/search/plugins?" + query2 + "&build=" + this.IDE_BUILD_FOR_REQUEST + "&max=" + count));
    }

    private final Url createFeatureUrl(Map<String, String> param) {
        Url url = Urls.newFromEncoded((String)(this.PLUGIN_MANAGER_URL + "/feature/getImplementations")).addParameters(param);
        Intrinsics.checkNotNullExpressionValue((Object)url, (String)"Urls.newFromEncoded(\n   \u2026\n  ).addParameters(param)");
        return url;
    }

    @NotNull
    public final List<FeatureImpl> getFeatures(@NotNull Map<String, String> param) {
        List list2;
        Intrinsics.checkNotNullParameter(param, (String)"param");
        try {
            List list3;
            if (param.isEmpty()) {
                list3 = CollectionsKt.emptyList();
            } else {
                Object object = HttpRequests.request((Url)this.createFeatureUrl(param)).throwStatusCodeException(false).productNameAsUserAgent().connect((HttpRequests.RequestProcessor)new HttpRequests.RequestProcessor<List<? extends FeatureImpl>>(this){
                    final /* synthetic */ MarketplaceRequests this$0;

                    public final List<FeatureImpl> process(@NotNull HttpRequests.Request it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return (List)MarketplaceRequests.access$getObjectMapper$p(this.this$0).readValue(it.getInputStream(), (TypeReference)new TypeReference<List<? extends FeatureImpl>>(){});
                    }
                    {
                        this.this$0 = marketplaceRequests;
                    }
                });
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"HttpRequests\n        .re\u2026 {}\n          )\n        }");
                list3 = (List)object;
            }
            list2 = list3;
        }
        catch (Exception e) {
            this.logWarnOrPrintIfDebug("Can not get features from Marketplace", e);
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    @NotNull
    public final List<String> getMarketplacePlugins(@Nullable ProgressIndicator indicator) throws IOException {
        File pluginXmlIdsFile = new File(PathManager.getPluginsPath(), FULL_PLUGINS_XML_IDS_FILENAME);
        String string = IdeBundle.message((String)"progress.downloading.available.plugins", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"IdeBundle.message(\"progr\u2026ading.available.plugins\")");
        Object t = this.readOrUpdateFile(pluginXmlIdsFile, this.AVAILABLE_PLUGINS_XML_IDS_URL, indicator, string, (Function1)new Function1<Reader, List<? extends String>>(this){

            public final List<String> invoke(@NotNull Reader p1) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return MarketplaceRequests.access$parseXmlIds((MarketplaceRequests)this.receiver, p1);
            }
        });
        Intrinsics.checkNotNullExpressionValue(t, (String)"readOrUpdateFile(\n      \u2026      ::parseXmlIds\n    )");
        return (List)t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final List<String> getMarketplaceCachedPlugins() throws IOException {
        List<String> list2;
        File pluginXmlIdsFile = new File(PathManager.getPluginsPath(), FULL_PLUGINS_XML_IDS_FILENAME);
        if (pluginXmlIdsFile.length() > 0L) {
            Object object = pluginXmlIdsFile;
            Object object2 = Charsets.UTF_8;
            int n = 8192;
            boolean bl = false;
            List<String> list3 = object;
            boolean bl2 = false;
            Object object3 = list3;
            boolean bl3 = false;
            object3 = new FileInputStream((File)object3);
            bl3 = false;
            list3 = new InputStreamReader((InputStream)object3, (Charset)object2);
            bl2 = false;
            object = list3 instanceof BufferedReader ? (BufferedReader)((Object)list3) : new BufferedReader((Reader)((Object)list3), n);
            object2 = this;
            n = 0;
            bl = false;
            Throwable throwable = null;
            try {
                Reader p1 = (Reader)object;
                boolean bl4 = false;
                list3 = ((MarketplaceRequests)object2).parseXmlIds(p1);
                list2 = list3;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
        } else {
            list2 = null;
        }
        return list2;
    }

    @NotNull
    public final String getBuildForPluginRepositoryRequests() {
        String string;
        ApplicationInfoEx applicationInfoEx = ApplicationInfoImpl.getShadowInstance();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)applicationInfoEx), (String)"ApplicationInfoImpl.getShadowInstance()");
        ApplicationInfoEx instance = applicationInfoEx;
        String compatibleBuild = PluginManagerCore.getPluginsCompatibleBuild();
        if (compatibleBuild != null) {
            BuildNumber buildNumber = instance.getBuild();
            Intrinsics.checkNotNullExpressionValue((Object)buildNumber, (String)"instance.build");
            BuildNumber buildNumber2 = BuildNumber.fromStringWithProductCode((String)compatibleBuild, (String)buildNumber.getProductCode());
            Intrinsics.checkNotNull((Object)buildNumber2);
            String string2 = buildNumber2.asString();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"BuildNumber.fromStringWi\u2026Code\n      )!!.asString()");
        } else {
            String string3 = instance.getApiVersion();
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"instance.apiVersion");
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<PluginNode> searchPlugins(@NotNull String query2, int count) throws IOException {
        void $this$mapTo$iv$iv;
        MarketplaceSearchPluginData it;
        Iterable $this$filterTo$iv$iv;
        List marketplaceSearchPluginData2;
        Intrinsics.checkNotNullParameter((Object)query2, (String)"query");
        List list2 = marketplaceSearchPluginData2 = (List)HttpRequests.request((Url)this.createSearchUrl(query2, count)).throwStatusCodeException(false).connect((HttpRequests.RequestProcessor)new HttpRequests.RequestProcessor<List<? extends MarketplaceSearchPluginData>>(this){
            final /* synthetic */ MarketplaceRequests this$0;

            public final List<MarketplaceSearchPluginData> process(@NotNull HttpRequests.Request it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (List)MarketplaceRequests.access$getObjectMapper$p(this.this$0).readValue(it.getInputStream(), (TypeReference)new TypeReference<List<? extends MarketplaceSearchPluginData>>(){});
            }
            {
                this.this$0 = marketplaceRequests;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"marketplaceSearchPluginData");
        Iterable $this$filter$iv = list2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (MarketplaceSearchPluginData)element$iv$iv;
            boolean bl = false;
            if (!(it.getExternalUpdateId() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (MarketplaceSearchPluginData)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            PluginNode pluginNode = it.toPluginNode();
            collection.add(pluginNode);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final List<String> getAllPluginsVendors() {
        List list2;
        try {
            Object object = HttpRequests.request((Url)this.MARKETPLACE_ORGANIZATIONS_URL).productNameAsUserAgent().throwStatusCodeException(false).connect((HttpRequests.RequestProcessor)new HttpRequests.RequestProcessor<List<? extends String>>(this){
                final /* synthetic */ MarketplaceRequests this$0;

                public final List<String> process(@NotNull HttpRequests.Request it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return CollectionsKt.toList((Iterable)((AggregationSearchResponse)MarketplaceRequests.access$getObjectMapper$p(this.this$0).readValue(it.getInputStream(), AggregationSearchResponse.class)).getAggregations().keySet());
                }
                {
                    this.this$0 = marketplaceRequests;
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"HttpRequests\n      .requ\u2026ons.keys.toList()\n      }");
            list2 = (List)object;
        }
        catch (Exception e) {
            this.logWarnOrPrintIfDebug("Can not get organizations from Marketplace", e);
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    @NotNull
    public final List<MarketplaceBrokenPlugin> getBrokenPlugins() {
        List list2;
        try {
            Object t = this.readOrUpdateFile(this.getBrokenPluginsFile$intellij_platform_ide_impl(), this.BROKEN_PLUGIN_PATH, null, "", (Function1)new Function1<Reader, List<? extends MarketplaceBrokenPlugin>>(this){

                public final List<MarketplaceBrokenPlugin> invoke(@NotNull Reader p1) {
                    Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                    return MarketplaceRequests.access$parseBrokenPlugins((MarketplaceRequests)this.receiver, p1);
                }
            });
            Intrinsics.checkNotNullExpressionValue(t, (String)"readOrUpdateFile(\n      \u2026arseBrokenPlugins\n      )");
            list2 = (List)t;
        }
        catch (Exception e) {
            this.logWarnOrPrintIfDebug("Can not get broken plugins file from Marketplace", e);
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    @NotNull
    public final List<String> getAllPluginsTags() {
        List list2;
        try {
            Object object = HttpRequests.request((Url)this.MARKETPLACE_TAGS_URL).productNameAsUserAgent().throwStatusCodeException(false).connect((HttpRequests.RequestProcessor)new HttpRequests.RequestProcessor<List<? extends String>>(this){
                final /* synthetic */ MarketplaceRequests this$0;

                public final List<String> process(@NotNull HttpRequests.Request it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return CollectionsKt.toList((Iterable)((AggregationSearchResponse)MarketplaceRequests.access$getObjectMapper$p(this.this$0).readValue(it.getInputStream(), AggregationSearchResponse.class)).getAggregations().keySet());
                }
                {
                    this.this$0 = marketplaceRequests;
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"HttpRequests\n      .requ\u2026ons.keys.toList()\n      }");
            list2 = (List)object;
        }
        catch (Exception e) {
            this.logWarnOrPrintIfDebug("Can not get tags from Marketplace", e);
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    @NotNull
    public final PluginNode loadPluginDescriptor(@NotNull String xmlId, @NotNull IdeCompatibleUpdate ideCompatibleUpdate, @Nullable ProgressIndicator indicator) throws IOException {
        Intrinsics.checkNotNullParameter((Object)xmlId, (String)"xmlId");
        Intrinsics.checkNotNullParameter((Object)ideCompatibleUpdate, (String)"ideCompatibleUpdate");
        File file2 = this.getUpdateMetadataFile(ideCompatibleUpdate);
        String string = this.getUpdateMetadataUrl(ideCompatibleUpdate);
        String string2 = IdeBundle.message((String)"progress.downloading.plugins.meta", (Object[])new Object[]{xmlId});
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"IdeBundle.message(\"progr\u2026ing.plugins.meta\", xmlId)");
        return ((IntellijUpdateMetadata)this.readOrUpdateFile(file2, string, indicator, string2, (Function1)new Function1<Reader, IntellijUpdateMetadata>(this){

            public final IntellijUpdateMetadata invoke(@NotNull Reader p1) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return MarketplaceRequests.access$parseJsonPluginMeta((MarketplaceRequests)this.receiver, p1);
            }
        })).toPluginNode();
    }

    public static /* synthetic */ PluginNode loadPluginDescriptor$default(MarketplaceRequests marketplaceRequests, String string, IdeCompatibleUpdate ideCompatibleUpdate, ProgressIndicator progressIndicator, int n, Object object) throws IOException {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: loadPluginDescriptor");
        }
        if ((n & 4) != 0) {
            progressIndicator = null;
        }
        return marketplaceRequests.loadPluginDescriptor(string, ideCompatibleUpdate, progressIndicator);
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @NotNull
    public final List<PluginNode> loadLastCompatiblePluginDescriptors(@NotNull List<String> ids, @Nullable BuildNumber buildNumber) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        if (ids.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        List<IdeCompatibleUpdate> data2 = this.getLastCompatiblePluginUpdate(ids, buildNumber);
        Iterable $this$map$iv = data2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IdeCompatibleUpdate ideCompatibleUpdate = (IdeCompatibleUpdate)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            PluginNode pluginNode = this.loadPluginDescriptor(it.getPluginId(), (IdeCompatibleUpdate)it, null);
            collection.add(pluginNode);
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List loadLastCompatiblePluginDescriptors$default(MarketplaceRequests marketplaceRequests, List list2, BuildNumber buildNumber, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: loadLastCompatiblePluginDescriptors");
        }
        if ((n & 2) != 0) {
            buildNumber = null;
        }
        return marketplaceRequests.loadLastCompatiblePluginDescriptors(list2, buildNumber);
    }

    @JvmOverloads
    @NotNull
    public final List<PluginNode> loadLastCompatiblePluginDescriptors(@NotNull List<String> ids) {
        return MarketplaceRequests.loadLastCompatiblePluginDescriptors$default(this, ids, null, 2, null);
    }

    @NotNull
    public final PluginNode loadPluginDetails(@NotNull PluginNode pluginNode) {
        Intrinsics.checkNotNullParameter((Object)pluginNode, (String)"pluginNode");
        String externalPluginId = pluginNode.getExternalPluginId();
        String externalUpdateId = pluginNode.getExternalUpdateId();
        if (externalPluginId == null || externalUpdateId == null) {
            return pluginNode;
        }
        IdeCompatibleUpdate ideCompatibleUpdate = new IdeCompatibleUpdate(externalUpdateId, externalPluginId, null, null, 12, null);
        PluginId pluginId = pluginNode.getPluginId();
        Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"pluginNode.pluginId");
        String string = pluginId.getIdString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pluginNode.pluginId.idString");
        PluginNode pluginNode2 = MarketplaceRequests.loadPluginDescriptor$default(this, string, ideCompatibleUpdate, null, 4, null);
        boolean bl = false;
        boolean bl2 = false;
        PluginNode $this$apply = pluginNode2;
        boolean bl3 = false;
        $this$apply.setRating(pluginNode.getRating());
        $this$apply.setDownloads(pluginNode.getDownloads());
        $this$apply.setDate(pluginNode.getDate());
        return pluginNode2;
    }

    public final <T> T readOrUpdateFile(@Nullable File file2, @NotNull String url, @Nullable ProgressIndicator indicator, @NotNull String indicatorMessage, @NotNull Function1<? super Reader, ? extends T> parser) throws IOException {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)indicatorMessage, (String)"indicatorMessage");
        Intrinsics.checkNotNullParameter(parser, (String)"parser");
        String eTag = file2 != null ? this.loadEtagForFile(file2) : null;
        return (T)HttpRequests.request((String)url).tuner(new HttpRequests.ConnectionTuner(this, eTag){
            final /* synthetic */ MarketplaceRequests this$0;
            final /* synthetic */ String $eTag;

            public final void tune(@NotNull URLConnection connection) {
                Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
                MarketplaceRequests.access$setUpETag(this.this$0, connection, this.$eTag);
            }
            {
                this.this$0 = marketplaceRequests;
                this.$eTag = string;
            }
        }).productNameAsUserAgent().connect(new HttpRequests.RequestProcessor<T>(this, indicator, file2, parser, indicatorMessage, url){
            final /* synthetic */ MarketplaceRequests this$0;
            final /* synthetic */ ProgressIndicator $indicator;
            final /* synthetic */ File $file;
            final /* synthetic */ Function1 $parser;
            final /* synthetic */ String $indicatorMessage;
            final /* synthetic */ String $url;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final T process(@NotNull HttpRequests.Request request) {
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                try {
                    Object object;
                    ProgressIndicator progressIndicator = this.$indicator;
                    if (progressIndicator != null) {
                        progressIndicator.checkCanceled();
                    }
                    URLConnection uRLConnection = request.getConnection();
                    Intrinsics.checkNotNullExpressionValue((Object)uRLConnection, (String)"request.connection");
                    URLConnection connection = uRLConnection;
                    if (this.$file != null && MarketplaceRequests.access$isNotModified(this.this$0, connection, this.$file)) {
                        Object object2 = this.$file;
                        Charset charset = Charsets.UTF_8;
                        int n = 8192;
                        boolean bl = false;
                        Object object3 = object2;
                        boolean bl2 = false;
                        Object object4 = object3;
                        boolean bl3 = false;
                        object4 = new FileInputStream((File)object4);
                        bl3 = false;
                        object3 = new InputStreamReader((InputStream)object4, charset);
                        bl2 = false;
                        object2 = object3 instanceof BufferedReader ? (BufferedReader)object3 : new BufferedReader((Reader)object3, n);
                        charset = this.$parser;
                        n = 0;
                        bl = false;
                        Throwable throwable = null;
                        try {
                            object3 = charset.invoke(object2);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
                        }
                        return (T)object3;
                    }
                    if (this.$indicator != null) {
                        this.$indicator.checkCanceled();
                        this.$indicator.setText2(this.$indicatorMessage);
                    }
                    if (this.$file != null) {
                        boolean bl;
                        Object object5;
                        Object object6 = MarketplaceRequests.access$getINSTANCE$cp();
                        boolean bl4 = false;
                        boolean bl5 = false;
                        synchronized (object6) {
                            Unit unit;
                            boolean bl6 = false;
                            request.saveToFile(this.$file, this.$indicator);
                            String string = connection.getHeaderField("ETag");
                            if (string != null) {
                                object5 = string;
                                bl = false;
                                boolean bl7 = false;
                                String it = object5;
                                boolean bl8 = false;
                                MarketplaceRequests.access$saveETagForFile(this.this$0, this.$file, it);
                                unit = Unit.INSTANCE;
                            } else {
                                unit = null;
                            }
                            Unit unit2 = unit;
                        }
                        object6 = this.$file;
                        Charset charset = Charsets.UTF_8;
                        int n = 8192;
                        boolean bl9 = false;
                        object5 = object6;
                        bl = false;
                        Object object7 = object5;
                        boolean bl10 = false;
                        object7 = new FileInputStream((File)object7);
                        bl10 = false;
                        object5 = new InputStreamReader((InputStream)object7, charset);
                        bl = false;
                        object6 = object5 instanceof BufferedReader ? (BufferedReader)object5 : new BufferedReader((Reader)object5, n);
                        charset = this.$parser;
                        n = 0;
                        bl9 = false;
                        Throwable throwable = null;
                        try {
                            object5 = charset.invoke(object6);
                        }
                        catch (Throwable throwable3) {
                            throwable = throwable3;
                            throw throwable3;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)object6, (Throwable)throwable);
                        }
                        return (T)object5;
                    }
                    Closeable closeable = request.getReader();
                    Function1 function1 = this.$parser;
                    boolean bl = false;
                    boolean bl11 = false;
                    Throwable throwable = null;
                    try {
                        object = function1.invoke((Object)closeable);
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                    return (T)object;
                }
                catch (Exception e) {
                    File file2 = this.$file;
                    String fileText = file2 != null ? FilesKt.readText$default((File)file2, null, (int)1, null) : null;
                    File file3 = this.$file;
                    MarketplaceRequests.access$getLOG$cp().warn("Error reading Marketplace file: url=" + this.$url + " file=" + (file3 != null ? file3.getName() : null) + ". File content:\n" + fileText);
                    throw (Throwable)e;
                }
            }
            {
                this.this$0 = marketplaceRequests;
                this.$indicator = progressIndicator;
                this.$file = file2;
                this.$parser = function1;
                this.$indicatorMessage = string;
                this.$url = string2;
            }
        });
    }

    @NotNull
    public final List<IdeCompatibleUpdate> getLastCompatiblePluginUpdate(@NotNull List<String> ids, @Nullable BuildNumber buildNumber) {
        List list2;
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        try {
            List list3;
            if (ids.isEmpty()) {
                list3 = CollectionsKt.emptyList();
            } else {
                ObjectMapper objectMapper2 = this.getObjectMapper();
                String string = PluginDownloader.getBuildNumberForDownload(buildNumber);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PluginDownloader.getBuil\u2026rForDownload(buildNumber)");
                String data2 = objectMapper2.writeValueAsString((Object)new CompatibleUpdateRequest(string, ids));
                String string2 = Urls.newFromEncoded((String)this.COMPATIBLE_UPDATE_URL).toExternalForm();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"Urls.newFromEncoded(COMP\u2026ATE_URL).toExternalForm()");
                String url = string2;
                Object object = HttpRequests.post((String)url, (String)"application/json; charset=utf-8").productNameAsUserAgent().throwStatusCodeException(false).connect((HttpRequests.RequestProcessor)new HttpRequests.RequestProcessor<List<? extends IdeCompatibleUpdate>>(this, data2){
                    final /* synthetic */ MarketplaceRequests this$0;
                    final /* synthetic */ String $data;

                    public final List<IdeCompatibleUpdate> process(@NotNull HttpRequests.Request it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        it.write(this.$data);
                        return (List)MarketplaceRequests.access$getObjectMapper$p(this.this$0).readValue(it.getInputStream(), (TypeReference)new TypeReference<List<? extends IdeCompatibleUpdate>>(){});
                    }
                    {
                        this.this$0 = marketplaceRequests;
                        this.$data = string;
                    }
                });
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"HttpRequests\n        .po\u2026}\n            )\n        }");
                list3 = (List)object;
            }
            list2 = list3;
        }
        catch (Exception e) {
            this.logWarnOrPrintIfDebug("Can not get compatible updates from Marketplace", e);
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    public static /* synthetic */ List getLastCompatiblePluginUpdate$default(MarketplaceRequests marketplaceRequests, List list2, BuildNumber buildNumber, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getLastCompatiblePluginUpdate");
        }
        if ((n & 2) != 0) {
            buildNumber = null;
        }
        return marketplaceRequests.getLastCompatiblePluginUpdate(list2, buildNumber);
    }

    @JvmOverloads
    @Nullable
    public final PluginNode getLastCompatiblePluginUpdate(@NotNull String id2, @Nullable BuildNumber buildNumber, @Nullable ProgressIndicator indicator) {
        PluginNode pluginNode;
        IdeCompatibleUpdate data2;
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        IdeCompatibleUpdate ideCompatibleUpdate = data2 = (IdeCompatibleUpdate)CollectionsKt.firstOrNull(this.getLastCompatiblePluginUpdate(CollectionsKt.listOf((Object)id2), buildNumber));
        if (ideCompatibleUpdate != null) {
            IdeCompatibleUpdate ideCompatibleUpdate2 = ideCompatibleUpdate;
            boolean bl = false;
            boolean bl2 = false;
            IdeCompatibleUpdate it = ideCompatibleUpdate2;
            boolean bl3 = false;
            pluginNode = this.loadPluginDescriptor(id2, it, indicator);
        } else {
            pluginNode = null;
        }
        return pluginNode;
    }

    public static /* synthetic */ PluginNode getLastCompatiblePluginUpdate$default(MarketplaceRequests marketplaceRequests, String string, BuildNumber buildNumber, ProgressIndicator progressIndicator, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getLastCompatiblePluginUpdate");
        }
        if ((n & 2) != 0) {
            buildNumber = null;
        }
        if ((n & 4) != 0) {
            progressIndicator = null;
        }
        return marketplaceRequests.getLastCompatiblePluginUpdate(string, buildNumber, progressIndicator);
    }

    @JvmOverloads
    @Nullable
    public final PluginNode getLastCompatiblePluginUpdate(@NotNull String id2, @Nullable BuildNumber buildNumber) {
        return MarketplaceRequests.getLastCompatiblePluginUpdate$default(this, id2, buildNumber, null, 4, null);
    }

    @JvmOverloads
    @Nullable
    public final PluginNode getLastCompatiblePluginUpdate(@NotNull String id2) {
        return MarketplaceRequests.getLastCompatiblePluginUpdate$default(this, id2, null, null, 6, null);
    }

    @JvmOverloads
    @NotNull
    public final List<IdeCompatibleUpdate> getCompatibleUpdatesByModule(@NotNull String module, @Nullable BuildNumber buildNumber) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        try {
            ObjectMapper objectMapper2 = this.getObjectMapper();
            String string = PluginDownloader.getBuildNumberForDownload(buildNumber);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PluginDownloader.getBuil\u2026rForDownload(buildNumber)");
            String data2 = objectMapper2.writeValueAsString((Object)new CompatibleUpdateForModuleRequest(string, module));
            String string2 = Urls.newFromEncoded((String)this.COMPATIBLE_UPDATE_URL).toExternalForm();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"Urls.newFromEncoded(COMP\u2026ATE_URL).toExternalForm()");
            String url = string2;
            Object object = HttpRequests.post((String)url, (String)"application/json; charset=utf-8").productNameAsUserAgent().throwStatusCodeException(false).connect((HttpRequests.RequestProcessor)new HttpRequests.RequestProcessor<List<? extends IdeCompatibleUpdate>>(this, data2){
                final /* synthetic */ MarketplaceRequests this$0;
                final /* synthetic */ String $data;

                public final List<IdeCompatibleUpdate> process(@NotNull HttpRequests.Request it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    it.write(this.$data);
                    return (List)MarketplaceRequests.access$getObjectMapper$p(this.this$0).readValue(it.getInputStream(), (TypeReference)new TypeReference<List<? extends IdeCompatibleUpdate>>(){});
                }
                {
                    this.this$0 = marketplaceRequests;
                    this.$data = string;
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"HttpRequests\n      .post\u2026() {}\n          )\n      }");
            list2 = (List)object;
        }
        catch (Exception e) {
            this.logWarnOrPrintIfDebug("Can not get compatible update by module from Marketplace", e);
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    public static /* synthetic */ List getCompatibleUpdatesByModule$default(MarketplaceRequests marketplaceRequests, String string, BuildNumber buildNumber, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getCompatibleUpdatesByModule");
        }
        if ((n & 2) != 0) {
            buildNumber = null;
        }
        return marketplaceRequests.getCompatibleUpdatesByModule(string, buildNumber);
    }

    @JvmOverloads
    @NotNull
    public final List<IdeCompatibleUpdate> getCompatibleUpdatesByModule(@NotNull String module) {
        return MarketplaceRequests.getCompatibleUpdatesByModule$default(this, module, null, 2, null);
    }

    @Nullable
    public final Set<String> getJetBrainsPluginsIds() {
        return this.jetBrainsPluginsIds;
    }

    public final void loadJetBrainsPluginsIds() {
        if (this.jetBrainsPluginsIds == null) {
            Set set2;
            MarketplaceRequests marketplaceRequests;
            MarketplaceRequests marketplaceRequests2 = this;
            try {
                marketplaceRequests = marketplaceRequests2;
                set2 = (Set)HttpRequests.request((Url)this.JETBRAINS_PLUGINS_URL).productNameAsUserAgent().throwStatusCodeException(false).connect((HttpRequests.RequestProcessor)new HttpRequests.RequestProcessor<Set<? extends String>>(this){
                    final /* synthetic */ MarketplaceRequests this$0;

                    /*
                     * WARNING - void declaration
                     */
                    public final Set<String> process(@NotNull HttpRequests.Request it) {
                        void $this$mapTo$iv$iv;
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        Object object = MarketplaceRequests.access$getObjectMapper$p(this.this$0).readValue(it.getInputStream(), (TypeReference)new TypeReference<List<? extends MarketplaceSearchPluginData>>(){});
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"objectMapper.readValue(\n\u2026Data>>() {}\n            )");
                        Iterable $this$map$iv = (Iterable)object;
                        boolean $i$f$map = false;
                        Iterable iterable = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void searchPluginData;
                            MarketplaceSearchPluginData marketplaceSearchPluginData2 = (MarketplaceSearchPluginData)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            String string = searchPluginData.getId();
                            collection.add(string);
                        }
                        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                    }
                    {
                        this.this$0 = marketplaceRequests;
                    }
                });
            }
            catch (Exception e) {
                marketplaceRequests = marketplaceRequests2;
                this.logWarnOrPrintIfDebug("Can not get JetBrains plugins' IDs from Marketplace", e);
                set2 = null;
            }
            marketplaceRequests.jetBrainsPluginsIds = set2;
        }
    }

    private final List<MarketplaceBrokenPlugin> parseBrokenPlugins(Reader reader) {
        return (List)this.getObjectMapper().readValue(reader, (TypeReference)new TypeReference<List<? extends MarketplaceBrokenPlugin>>(){});
    }

    private final List<String> parseXmlIds(Reader reader) {
        return (List)this.getObjectMapper().readValue(reader, (TypeReference)new TypeReference<List<? extends String>>(){});
    }

    private final IntellijUpdateMetadata parseJsonPluginMeta(Reader reader) {
        return (IntellijUpdateMetadata)this.getObjectMapper().readValue(reader, IntellijUpdateMetadata.class);
    }

    private final File getETagFile(File file2) {
        return FilesKt.resolveSibling((File)file2, (String)(file2.getName() + TAG_EXT));
    }

    private final String loadEtagForFile(File file2) {
        File eTagFile = this.getETagFile(file2);
        if (eTagFile.exists()) {
            try {
                List lines = FilesKt.readLines$default((File)eTagFile, null, (int)1, null);
                if (lines.size() == 1) {
                    return (String)lines.get(0);
                }
                LOG.warn("Can't load ETag from '" + eTagFile.getAbsolutePath() + "'. Unexpected number of lines: " + lines.size());
                FileUtil.delete((File)eTagFile);
            }
            catch (IOException e) {
                LOG.warn("Can't load ETag from '" + eTagFile.getAbsolutePath() + "'", (Throwable)e);
            }
        }
        return "";
    }

    private final void saveETagForFile(File file2, String eTag) {
        File eTagFile = this.getETagFile(file2);
        try {
            FilesKt.writeText$default((File)eTagFile, (String)eTag, null, (int)2, null);
        }
        catch (IOException e) {
            LOG.warn("Can't save ETag to '" + eTagFile.getAbsolutePath() + "'", (Throwable)e);
        }
    }

    @NotNull
    public File downloadPlugin(@NotNull String pluginUrl, @NotNull ProgressIndicator indicator) throws IOException {
        Intrinsics.checkNotNullParameter((Object)pluginUrl, (String)"pluginUrl");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        return MarketplacePluginDownloadService.INSTANCE.downloadPlugin(pluginUrl, indicator);
    }

    @NotNull
    public File downloadPluginViaBlockMap(@NotNull String pluginUrl, @NotNull Path prevPlugin, @NotNull ProgressIndicator indicator) throws IOException {
        Intrinsics.checkNotNullParameter((Object)pluginUrl, (String)"pluginUrl");
        Intrinsics.checkNotNullParameter((Object)prevPlugin, (String)"prevPlugin");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        return MarketplacePluginDownloadService.INSTANCE.downloadPluginViaBlockMap(pluginUrl, prevPlugin, indicator);
    }

    private final void setUpETag(URLConnection $this$setUpETag, String eTag) {
        block0: {
            String string = eTag;
            if (string == null) break block0;
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            $this$setUpETag.setRequestProperty("If-None-Match", it);
        }
    }

    private final boolean isNotModified(URLConnection $this$isNotModified, File file2) {
        return file2 != null && file2.length() > 0L && $this$isNotModified instanceof HttpURLConnection && ((HttpURLConnection)$this$isNotModified).getResponseCode() == 304;
    }

    private final void logWarnOrPrintIfDebug(String message, Throwable throwable) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(message, throwable);
        } else {
            LOG.warn(message + ':' + throwable.getMessage());
        }
    }

    public MarketplaceRequests() {
        ApplicationInfoEx applicationInfoEx = ApplicationInfoImpl.getShadowInstance();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)applicationInfoEx), (String)"ApplicationInfoImpl.getShadowInstance()");
        String string = applicationInfoEx.getPluginManagerUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ApplicationInfoImpl.getS\u2026stance().pluginManagerUrl");
        this.PLUGIN_MANAGER_URL = StringsKt.trimEnd((String)string, (char[])new char[]{'/'});
        this.AVAILABLE_PLUGINS_XML_IDS_URL = this.PLUGIN_MANAGER_URL + "/files/pluginsXMLIds.json";
        String string2 = URLUtil.encodeURIComponent((String)this.getBuildForPluginRepositoryRequests());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"URLUtil.encodeURICompone\u2026uginRepositoryRequests())");
        this.IDE_BUILD_FOR_REQUEST = string2;
        Url url = Urls.newFromEncoded((String)(this.PLUGIN_MANAGER_URL + "/api/search/aggregation/organizations")).addParameters(MapsKt.mapOf((Pair)TuplesKt.to((Object)"build", (Object)this.IDE_BUILD_FOR_REQUEST)));
        Intrinsics.checkNotNullExpressionValue((Object)url, (String)"Urls.newFromEncoded(\n   \u2026o IDE_BUILD_FOR_REQUEST))");
        this.MARKETPLACE_ORGANIZATIONS_URL = url;
        Url url2 = Urls.newFromEncoded((String)(this.PLUGIN_MANAGER_URL + "/api/search/aggregation/tags")).addParameters(MapsKt.mapOf((Pair)TuplesKt.to((Object)"build", (Object)this.IDE_BUILD_FOR_REQUEST)));
        Intrinsics.checkNotNullExpressionValue((Object)url2, (String)"Urls.newFromEncoded(\n   \u2026o IDE_BUILD_FOR_REQUEST))");
        this.MARKETPLACE_TAGS_URL = url2;
        Url url3 = Urls.newFromEncoded((String)(this.PLUGIN_MANAGER_URL + "/api/search/plugins?organization=JetBrains&max=1000")).addParameters(MapsKt.mapOf((Pair)TuplesKt.to((Object)"build", (Object)this.IDE_BUILD_FOR_REQUEST)));
        Intrinsics.checkNotNullExpressionValue((Object)url3, (String)"Urls.newFromEncoded(\n   \u2026o IDE_BUILD_FOR_REQUEST))");
        this.JETBRAINS_PLUGINS_URL = url3;
        this.COMPATIBLE_UPDATE_URL = this.PLUGIN_MANAGER_URL + "/api/search/compatibleUpdates";
        this.objectMapper$delegate = LazyKt.lazy((Function0)objectMapper.2.INSTANCE);
        this.BROKEN_PLUGIN_PATH = this.PLUGIN_MANAGER_URL + "/files/brokenPlugins.json";
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(MarketplaceRequests.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(Marke\u2026laceRequests::class.java)");
        LOG = logger;
        INSTANCE = new MarketplaceRequests();
    }

    public static final /* synthetic */ ObjectMapper access$getObjectMapper$p(MarketplaceRequests $this) {
        return $this.getObjectMapper();
    }

    public static final /* synthetic */ List access$parseXmlIds(MarketplaceRequests $this, Reader reader) {
        return $this.parseXmlIds(reader);
    }

    public static final /* synthetic */ List access$parseBrokenPlugins(MarketplaceRequests $this, Reader reader) {
        return $this.parseBrokenPlugins(reader);
    }

    public static final /* synthetic */ IntellijUpdateMetadata access$parseJsonPluginMeta(MarketplaceRequests $this, Reader reader) {
        return $this.parseJsonPluginMeta(reader);
    }

    public static final /* synthetic */ void access$setUpETag(MarketplaceRequests $this, URLConnection $this$access_u24setUpETag, String eTag) {
        $this.setUpETag($this$access_u24setUpETag, eTag);
    }

    public static final /* synthetic */ boolean access$isNotModified(MarketplaceRequests $this, URLConnection $this$access_u24isNotModified, File file2) {
        return $this.isNotModified($this$access_u24isNotModified, file2);
    }

    public static final /* synthetic */ void access$saveETagForFile(MarketplaceRequests $this, File file2, String eTag) {
        $this.saveETagForFile(file2, eTag);
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    @JvmStatic
    @NotNull
    public static final MarketplaceRequests getInstance() {
        return Companion.getInstance();
    }

    @JvmStatic
    @NotNull
    public static final List<PluginNode> parsePluginList(@NotNull Reader reader) {
        return Companion.parsePluginList(reader);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J#\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ide/plugins/marketplace/MarketplaceRequests$CompatibleUpdateRequest;", "", "build", "", "pluginXMLIds", "", "(Ljava/lang/String;Ljava/util/List;)V", "getBuild", "()Ljava/lang/String;", "getPluginXMLIds", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.platform.ide.impl"})
    private static final class CompatibleUpdateRequest {
        @NotNull
        private final String build;
        @NotNull
        private final List<String> pluginXMLIds;

        @NotNull
        public final String getBuild() {
            return this.build;
        }

        @NotNull
        public final List<String> getPluginXMLIds() {
            return this.pluginXMLIds;
        }

        public CompatibleUpdateRequest(@NotNull String build2, @NotNull List<String> pluginXMLIds) {
            Intrinsics.checkNotNullParameter((Object)build2, (String)"build");
            Intrinsics.checkNotNullParameter(pluginXMLIds, (String)"pluginXMLIds");
            this.build = build2;
            this.pluginXMLIds = pluginXMLIds;
        }

        @NotNull
        public final String component1() {
            return this.build;
        }

        @NotNull
        public final List<String> component2() {
            return this.pluginXMLIds;
        }

        @NotNull
        public final CompatibleUpdateRequest copy(@NotNull String build2, @NotNull List<String> pluginXMLIds) {
            Intrinsics.checkNotNullParameter((Object)build2, (String)"build");
            Intrinsics.checkNotNullParameter(pluginXMLIds, (String)"pluginXMLIds");
            return new CompatibleUpdateRequest(build2, pluginXMLIds);
        }

        public static /* synthetic */ CompatibleUpdateRequest copy$default(CompatibleUpdateRequest compatibleUpdateRequest, String string, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                string = compatibleUpdateRequest.build;
            }
            if ((n & 2) != 0) {
                list2 = compatibleUpdateRequest.pluginXMLIds;
            }
            return compatibleUpdateRequest.copy(string, list2);
        }

        @NotNull
        public String toString() {
            return "CompatibleUpdateRequest(build=" + this.build + ", pluginXMLIds=" + this.pluginXMLIds + ")";
        }

        public int hashCode() {
            String string = this.build;
            List<String> list2 = this.pluginXMLIds;
            return (string != null ? string.hashCode() : 0) * 31 + (list2 != null ? ((Object)list2).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof CompatibleUpdateRequest)) break block3;
                    CompatibleUpdateRequest compatibleUpdateRequest = (CompatibleUpdateRequest)object;
                    if (!Intrinsics.areEqual((Object)this.build, (Object)compatibleUpdateRequest.build) || !Intrinsics.areEqual(this.pluginXMLIds, compatibleUpdateRequest.pluginXMLIds)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ide/plugins/marketplace/MarketplaceRequests$CompatibleUpdateForModuleRequest;", "", "build", "", "module", "(Ljava/lang/String;Ljava/lang/String;)V", "getBuild", "()Ljava/lang/String;", "getModule", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.platform.ide.impl"})
    private static final class CompatibleUpdateForModuleRequest {
        @NotNull
        private final String build;
        @NotNull
        private final String module;

        @NotNull
        public final String getBuild() {
            return this.build;
        }

        @NotNull
        public final String getModule() {
            return this.module;
        }

        public CompatibleUpdateForModuleRequest(@NotNull String build2, @NotNull String module) {
            Intrinsics.checkNotNullParameter((Object)build2, (String)"build");
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            this.build = build2;
            this.module = module;
        }

        @NotNull
        public final String component1() {
            return this.build;
        }

        @NotNull
        public final String component2() {
            return this.module;
        }

        @NotNull
        public final CompatibleUpdateForModuleRequest copy(@NotNull String build2, @NotNull String module) {
            Intrinsics.checkNotNullParameter((Object)build2, (String)"build");
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            return new CompatibleUpdateForModuleRequest(build2, module);
        }

        public static /* synthetic */ CompatibleUpdateForModuleRequest copy$default(CompatibleUpdateForModuleRequest compatibleUpdateForModuleRequest, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = compatibleUpdateForModuleRequest.build;
            }
            if ((n & 2) != 0) {
                string2 = compatibleUpdateForModuleRequest.module;
            }
            return compatibleUpdateForModuleRequest.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "CompatibleUpdateForModuleRequest(build=" + this.build + ", module=" + this.module + ")";
        }

        public int hashCode() {
            String string = this.build;
            String string2 = this.module;
            return (string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof CompatibleUpdateForModuleRequest)) break block3;
                    CompatibleUpdateForModuleRequest compatibleUpdateForModuleRequest = (CompatibleUpdateForModuleRequest)object;
                    if (!Intrinsics.areEqual((Object)this.build, (Object)compatibleUpdateForModuleRequest.build) || !Intrinsics.areEqual((Object)this.module, (Object)compatibleUpdateForModuleRequest.module)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\u0006H\u0007J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ide/plugins/marketplace/MarketplaceRequests$Companion;", "", "()V", "FULL_PLUGINS_XML_IDS_FILENAME", "", "INSTANCE", "Lcom/intellij/ide/plugins/marketplace/MarketplaceRequests;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "TAG_EXT", "getInstance", "parsePluginList", "", "Lcom/intellij/ide/plugins/PluginNode;", "reader", "Ljava/io/Reader;", "intellij.platform.ide.impl"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final MarketplaceRequests getInstance() {
            return INSTANCE;
        }

        @JvmStatic
        @NotNull
        public final List<PluginNode> parsePluginList(@NotNull Reader reader) {
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            try {
                SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
                RepositoryContentHandler handler2 = new RepositoryContentHandler();
                parser.parse(new InputSource(reader), (DefaultHandler)handler2);
                List<PluginNode> list2 = handler2.getPluginsList();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"handler.pluginsList");
                return list2;
            }
            catch (Exception e) {
                Exception exception = e;
                if (exception instanceof ParserConfigurationException || exception instanceof SAXException || exception instanceof RuntimeException) {
                    throw (Throwable)new IOException(e);
                }
                throw (Throwable)e;
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

