/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.lightEdit.intentions.openInProject;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class ProjectRootFinder {
    ProjectRootFinder() {
    }

    @Nullable
    VirtualFile findProjectRoot(@NotNull VirtualFile sourceFile) {
        if (sourceFile == null) {
            ProjectRootFinder.$$$reportNull$$$0(0);
        }
        for (VirtualFile parent = sourceFile.getParent(); parent != null; parent = parent.getParent()) {
            if (this.isProjectDir(parent)) {
                return parent;
            }
            ProgressManager.checkCanceled();
        }
        return null;
    }

    protected abstract boolean isProjectDir(@NotNull VirtualFile var1);

    protected abstract boolean requiresConfirmation();

    protected boolean containsChild(@NotNull VirtualFile file2, @NotNull Predicate<? super VirtualFile> predicate) {
        if (file2 == null) {
            ProjectRootFinder.$$$reportNull$$$0(1);
        }
        if (predicate == null) {
            ProjectRootFinder.$$$reportNull$$$0(2);
        }
        if (file2.isDirectory()) {
            for (VirtualFile child2 : file2.getChildren()) {
                if (!predicate.test((VirtualFile)child2)) continue;
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/lightEdit/intentions/openInProject/ProjectRootFinder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findProjectRoot";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "containsChild";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

