/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.gdpr;

import com.intellij.ide.gdpr.AgreementUi;
import com.intellij.ide.gdpr.Agreements;
import com.intellij.ide.gdpr.Consent;
import com.intellij.ide.gdpr.ConsentOptions;
import com.intellij.ide.gdpr.EndUserAgreement;
import com.intellij.idea.SplashManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.AppUIUtil;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JCheckBox;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013J\f\u0010\u0014\u001a\u00020\u0015*\u00020\u0015H\u0002J\u0014\u0010\u0016\u001a\u00020\u0015*\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u001c\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\n\u00a8\u0006\u0017"}, d2={"Lcom/intellij/ide/gdpr/Agreements;", "", "()V", "bundle", "Ljava/util/ResourceBundle;", "kotlin.jvm.PlatformType", "getBundle", "()Ljava/util/ResourceBundle;", "isEap", "", "()Z", "prepareConsentsHtmlText", "", "consent", "Lcom/intellij/ide/gdpr/Consent;", "showDataSharingAgreement", "", "showEndUserAndDataSharingAgreements", "agreement", "Lcom/intellij/ide/gdpr/EndUserAgreement$Document;", "applyDataSharing", "Lcom/intellij/ide/gdpr/AgreementUi;", "applyUserAgreement", "intellij.platform.ide.impl"})
public final class Agreements {
    public static final Agreements INSTANCE;

    private final ResourceBundle getBundle() {
        return ResourceBundle.getBundle("messages.AgreementsBundle");
    }

    private final boolean isEap() {
        ApplicationInfoEx applicationInfoEx = ApplicationInfoImpl.getShadowInstance();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)applicationInfoEx), (String)"ApplicationInfoImpl.getShadowInstance()");
        return applicationInfoEx.isEAP();
    }

    public final void showEndUserAndDataSharingAgreements(@NotNull EndUserAgreement.Document agreement) {
        Intrinsics.checkNotNullParameter((Object)agreement, (String)"agreement");
        String string = agreement.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"agreement.text");
        AgreementUi agreementUi = AgreementUi.Companion.create(string);
        DialogWrapper dialog2 = this.applyUserAgreement(agreementUi, agreement).pack();
        SplashManager.executeWithHiddenSplash(dialog2.getWindow(), new Runnable(dialog2){
            final /* synthetic */ DialogWrapper $dialog;

            public final void run() {
                this.$dialog.show();
            }
            {
                this.$dialog = dialogWrapper2;
            }
        });
    }

    public final void showDataSharingAgreement() {
        AgreementUi agreementUi = AgreementUi.Companion.create$default(AgreementUi.Companion, null, 1, null);
        DialogWrapper dialog2 = this.applyDataSharing(agreementUi).pack();
        SplashManager.executeWithHiddenSplash(dialog2.getWindow(), new Runnable(dialog2){
            final /* synthetic */ DialogWrapper $dialog;

            public final void run() {
                this.$dialog.show();
            }
            {
                this.$dialog = dialogWrapper2;
            }
        });
    }

    private final AgreementUi applyUserAgreement(AgreementUi $this$applyUserAgreement, EndUserAgreement.Document agreement) {
        String string;
        boolean isPrivacyPolicy = agreement.isPrivacyPolicy();
        if (isPrivacyPolicy) {
            StringBuilder stringBuilder = new StringBuilder();
            ApplicationInfoEx applicationInfoEx = ApplicationInfoImpl.getShadowInstance();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)applicationInfoEx), (String)"ApplicationInfoImpl.getShadowInstance()");
            string = stringBuilder.append(applicationInfoEx.getShortCompanyName()).append(" ").append(this.getBundle().getString("userAgreement.dialog.privacyPolicy.title")).toString();
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            ApplicationNamesInfo applicationNamesInfo = ApplicationNamesInfo.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)applicationNamesInfo, (String)"ApplicationNamesInfo.getInstance()");
            string = stringBuilder.append(applicationNamesInfo.getFullProductName()).append(" ").append(this.getBundle().getString("userAgreement.dialog.userAgreement.title")).toString();
        }
        AgreementUi agreementUi = $this$applyUserAgreement.setTitle(string);
        String string2 = this.getBundle().getString("userAgreement.dialog.exit");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"bundle.getString(\"userAgreement.dialog.exit\")");
        AgreementUi agreementUi2 = agreementUi.setDeclineButton(string2, (Function1<? super DialogWrapper, Unit>)((Function1)applyUserAgreement.commonUserAgreement.1.INSTANCE));
        String string3 = this.getBundle().getString("userAgreement.dialog.checkBox");
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"bundle.getString(\"userAgreement.dialog.checkBox\")");
        AgreementUi commonUserAgreement2 = agreementUi2.addCheckBox(string3, (Function1<? super JCheckBox, Unit>)((Function1)new Function1<JCheckBox, Unit>($this$applyUserAgreement){
            final /* synthetic */ AgreementUi $this_applyUserAgreement;

            public final void invoke(@NotNull JCheckBox checkBox2) {
                Intrinsics.checkNotNullParameter((Object)checkBox2, (String)"checkBox");
                this.$this_applyUserAgreement.enableAcceptButton(checkBox2.isSelected());
                if (checkBox2.isSelected()) {
                    this.$this_applyUserAgreement.focusToAcceptButton();
                }
            }
            {
                this.$this_applyUserAgreement = agreementUi;
                super(1);
            }
        }));
        if (!this.isEap()) {
            String string4 = this.getBundle().getString("userAgreement.dialog.continue");
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"bundle.getString(\"userAgreement.dialog.continue\")");
            commonUserAgreement2.setAcceptButton(string4, false, (Function1<? super DialogWrapper, Unit>)((Function1)new Function1<DialogWrapper, Unit>($this$applyUserAgreement, agreement){
                final /* synthetic */ AgreementUi $this_applyUserAgreement;
                final /* synthetic */ EndUserAgreement.Document $agreement;

                public final void invoke(@NotNull DialogWrapper dialogWrapper2) {
                    Intrinsics.checkNotNullParameter((Object)dialogWrapper2, (String)"dialogWrapper");
                    EndUserAgreement.setAccepted(this.$agreement);
                    if (AppUIUtil.needToShowConsentsAgreement()) {
                        Agreements.access$applyDataSharing(Agreements.INSTANCE, this.$this_applyUserAgreement);
                    } else {
                        dialogWrapper2.close(0);
                    }
                }
                {
                    this.$this_applyUserAgreement = agreementUi;
                    this.$agreement = document;
                    super(1);
                }
            }));
        } else {
            String string5 = this.getBundle().getString("userAgreement.dialog.continue");
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"bundle.getString(\"userAgreement.dialog.continue\")");
            commonUserAgreement2.setAcceptButton(string5, false, (Function1<? super DialogWrapper, Unit>)((Function1)new Function1<DialogWrapper, Unit>(agreement){
                final /* synthetic */ EndUserAgreement.Document $agreement;

                public final void invoke(@NotNull DialogWrapper dialogWrapper2) {
                    Intrinsics.checkNotNullParameter((Object)dialogWrapper2, (String)"dialogWrapper");
                    EndUserAgreement.setAccepted(this.$agreement);
                    dialogWrapper2.close(0);
                }
                {
                    this.$agreement = document;
                    super(1);
                }
            })).addEapPanel(isPrivacyPolicy);
        }
        return $this$applyUserAgreement;
    }

    private final AgreementUi applyDataSharing(AgreementUi $this$applyDataSharing) {
        Consent dataSharingConsent;
        ConsentOptions consentOptions = ConsentOptions.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)consentOptions, (String)"ConsentOptions.getInstance()");
        Consent consent = dataSharingConsent = (Consent)((List)consentOptions.getConsents().first).get(0);
        Intrinsics.checkNotNullExpressionValue((Object)consent, (String)"dataSharingConsent");
        AgreementUi agreementUi = $this$applyDataSharing.setText(this.prepareConsentsHtmlText(consent));
        String string = this.getBundle().getString("dataSharing.dialog.title");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"bundle.getString(\"dataSharing.dialog.title\")");
        AgreementUi agreementUi2 = agreementUi.setTitle(string).clearBottomPanel().focusToText();
        String string2 = this.getBundle().getString("dataSharing.dialog.accept");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"bundle.getString(\"dataSharing.dialog.accept\")");
        AgreementUi agreementUi3 = AgreementUi.setAcceptButton$default(agreementUi2, string2, false, (Function1)new Function1<DialogWrapper, Unit>(dataSharingConsent){
            final /* synthetic */ Consent $dataSharingConsent;

            public final void invoke(@NotNull DialogWrapper it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Consent consentToSave = this.$dataSharingConsent.derive(true);
                AppUIUtil.saveConsents(CollectionsKt.listOf((Object)consentToSave));
                it.close(0);
            }
            {
                this.$dataSharingConsent = consent;
                super(1);
            }
        }, 2, null);
        String string3 = this.getBundle().getString("dataSharing.dialog.decline");
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"bundle.getString(\"dataSharing.dialog.decline\")");
        agreementUi3.setDeclineButton(string3, (Function1<? super DialogWrapper, Unit>)((Function1)new Function1<DialogWrapper, Unit>(dataSharingConsent){
            final /* synthetic */ Consent $dataSharingConsent;

            public final void invoke(@NotNull DialogWrapper it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Consent consentToSave = this.$dataSharingConsent.derive(false);
                AppUIUtil.saveConsents(CollectionsKt.listOf((Object)consentToSave));
                it.close(1);
            }
            {
                this.$dataSharingConsent = consent;
                super(1);
            }
        }));
        return $this$applyDataSharing;
    }

    private final String prepareConsentsHtmlText(Consent consent) {
        String string;
        ConsentOptions consentOptions = ConsentOptions.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)consentOptions, (String)"ConsentOptions.getInstance()");
        if (!consentOptions.isEAP()) {
            String string2 = "<p><hint>" + this.getBundle().getString("dataSharing.applyToAll.hint") + "</hint></p>";
            ApplicationInfoEx applicationInfoEx = ApplicationInfoImpl.getShadowInstance();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)applicationInfoEx), (String)"ApplicationInfoImpl.getShadowInstance()");
            String string3 = applicationInfoEx.getShortCompanyName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"ApplicationInfoImpl.getS\u2026stance().shortCompanyName");
            string = StringsKt.replace$default((String)string2, (String)"{0}", (String)string3, (boolean)false, (int)4, null);
        } else {
            string = "";
        }
        String allProductHint = string;
        StringBuilder stringBuilder = new StringBuilder().append("<p><hint>");
        String string4 = this.getBundle().getString("dataSharing.revoke.hint");
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"bundle.getString(\"dataSharing.revoke.hint\")");
        String string5 = ShowSettingsUtil.getSettingsMenuName();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"ShowSettingsUtil.getSettingsMenuName()");
        String preferencesHint = stringBuilder.append(StringsKt.replace$default((String)string4, (String)"{0}", (String)string5, (boolean)false, (int)4, null)).append("</hint></p>").toString();
        StringBuilder stringBuilder2 = new StringBuilder().append("<html><body> <h1>").append(this.getBundle().getString("dataSharing.consents.title")).append("</h1>").append("<p>");
        String string6 = consent.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"consent.text");
        return stringBuilder2.append(StringsKt.replace$default((String)string6, (String)"\n", (String)"</p><p>", (boolean)false, (int)4, null)).append("</p>").append(allProductHint).append(preferencesHint).append("</body></html>").toString();
    }

    private Agreements() {
    }

    static {
        Agreements agreements;
        INSTANCE = agreements = new Agreements();
    }

    public static final /* synthetic */ AgreementUi access$applyDataSharing(Agreements $this, AgreementUi $this$access_u24applyDataSharing) {
        return $this.applyDataSharing($this$access_u24applyDataSharing);
    }
}

