/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.cds;

import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.intellij.ide.cds.CDSPaths;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.SystemInfo;
import java.io.File;
import java.time.LocalDateTime;
import java.util.Comparator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0017\u001a\u00020\u00162\b\u0010\u0018\u001a\u0004\u0018\u00010\u0003J\u0010\u0010\u0019\u001a\u00020\u00162\b\u0010\u001a\u001a\u0004\u0018\u00010\u0003J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0006J\u0006\u0010\u001e\u001a\u00020\u001cR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\tR\u0011\u0010\u000e\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\tR\u0011\u0010\u0010\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\tR\u0011\u0010\u0012\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\t\u00a8\u0006 "}, d2={"Lcom/intellij/ide/cds/CDSPaths;", "", "baseDir", "Ljava/io/File;", "dumpOutputFile", "cdsClassesHash", "", "(Ljava/io/File;Ljava/io/File;Ljava/lang/String;)V", "getBaseDir", "()Ljava/io/File;", "getCdsClassesHash", "()Ljava/lang/String;", "classesArchiveFile", "getClassesArchiveFile", "classesErrorMarkerFile", "getClassesErrorMarkerFile", "classesListFile", "getClassesListFile", "classesPathFile", "getClassesPathFile", "getDumpOutputFile", "hasSameEnvironmentToBuildCDSArchive", "", "isOurFile", "file", "isSame", "jsaFile", "markError", "", "message", "mkdirs", "Companion", "intellij.platform.ide.impl"})
public final class CDSPaths {
    @NotNull
    private final File classesErrorMarkerFile;
    @NotNull
    private final File classesListFile;
    @NotNull
    private final File classesPathFile;
    @NotNull
    private final File classesArchiveFile;
    @NotNull
    private final File baseDir;
    @NotNull
    private final File dumpOutputFile;
    @NotNull
    private final String cdsClassesHash;
    @NotNull
    private static final Lazy current$delegate;
    public static final Companion Companion;

    @NotNull
    public final File getClassesErrorMarkerFile() {
        return this.classesErrorMarkerFile;
    }

    @NotNull
    public final File getClassesListFile() {
        return this.classesListFile;
    }

    @NotNull
    public final File getClassesPathFile() {
        return this.classesPathFile;
    }

    @NotNull
    public final File getClassesArchiveFile() {
        return this.classesArchiveFile;
    }

    public final boolean isSame(@Nullable File jsaFile) {
        return jsaFile != null && Intrinsics.areEqual((Object)jsaFile, (Object)this.classesArchiveFile) && jsaFile.isFile();
    }

    public final boolean isOurFile(@Nullable File file2) {
        return Intrinsics.areEqual((Object)file2, (Object)this.classesErrorMarkerFile) || Intrinsics.areEqual((Object)file2, (Object)this.classesListFile) || Intrinsics.areEqual((Object)file2, (Object)this.classesPathFile) || Intrinsics.areEqual((Object)file2, (Object)this.classesArchiveFile);
    }

    public final void mkdirs() {
        block0: {
            this.baseDir.mkdirs();
            File file2 = this.dumpOutputFile.getParentFile();
            if (file2 == null) break block0;
            file2.mkdirs();
        }
    }

    public final void markError(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        FilesKt.writeText$default((File)this.classesErrorMarkerFile, (String)("Failed on " + LocalDateTime.now() + ": " + message), null, (int)2, null);
    }

    public final boolean hasSameEnvironmentToBuildCDSArchive() {
        return Intrinsics.areEqual((Object)((Companion)CDSPaths.Companion).computePaths().cdsClassesHash, (Object)CDSPaths.Companion.getCurrent().cdsClassesHash);
    }

    @NotNull
    public final File getBaseDir() {
        return this.baseDir;
    }

    @NotNull
    public final File getDumpOutputFile() {
        return this.dumpOutputFile;
    }

    @NotNull
    public final String getCdsClassesHash() {
        return this.cdsClassesHash;
    }

    private CDSPaths(File baseDir, File dumpOutputFile, String cdsClassesHash) {
        this.baseDir = baseDir;
        this.dumpOutputFile = dumpOutputFile;
        this.cdsClassesHash = cdsClassesHash;
        this.classesErrorMarkerFile = new File(this.baseDir, this.cdsClassesHash + ".error");
        this.classesListFile = new File(this.baseDir, this.cdsClassesHash + ".txt");
        this.classesPathFile = new File(this.baseDir, this.cdsClassesHash + ".classpath");
        this.classesArchiveFile = new File(this.baseDir, this.cdsClassesHash + ".jsa");
    }

    static {
        Companion = new Companion(null);
        current$delegate = LazyKt.lazy((Function0)Companion.current.2.INSTANCE);
    }

    public /* synthetic */ CDSPaths(File baseDir, File dumpOutputFile, String cdsClassesHash, DefaultConstructorMarker $constructor_marker) {
        this(baseDir, dumpOutputFile, cdsClassesHash);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0011\u001a\u00020\u0004H\u0002R\u001b\u0010\u0003\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ide/cds/CDSPaths$Companion;", "", "()V", "current", "Lcom/intellij/ide/cds/CDSPaths;", "getCurrent", "()Lcom/intellij/ide/cds/CDSPaths;", "current$delegate", "Lkotlin/Lazy;", "freeSpaceForCDS", "", "getFreeSpaceForCDS", "()J", "systemDir", "Ljava/io/File;", "getSystemDir", "()Ljava/io/File;", "computePaths", "intellij.platform.ide.impl"})
    public static final class Companion {
        private final File getSystemDir() {
            return new File(PathManager.getSystemPath());
        }

        public final long getFreeSpaceForCDS() {
            return Companion.getSystemDir().getFreeSpace();
        }

        @NotNull
        public final CDSPaths getCurrent() {
            Lazy lazy = current$delegate;
            Companion companion = Companion;
            Object var3_3 = null;
            boolean bl = false;
            return (CDSPaths)lazy.getValue();
        }

        private final CDSPaths computePaths() {
            ApplicationInfo info;
            File baseDir = new File(this.getSystemDir(), "cds");
            Hasher hasher = Hashing.sha256().newHasher();
            hasher.putString((CharSequence)baseDir.getAbsolutePath(), Charsets.UTF_8);
            hasher.putString((CharSequence)PathManager.getHomePath(), Charsets.UTF_8);
            ApplicationInfo applicationInfo = info = ApplicationInfo.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)applicationInfo, (String)"info");
            hasher.putString((CharSequence)applicationInfo.getBuild().asString(), Charsets.UTF_8);
            hasher.putString((CharSequence)SystemInfo.getOsNameAndVersion(), Charsets.UTF_8);
            hasher.putString((CharSequence)SystemInfo.JAVA_RUNTIME_VERSION, Charsets.UTF_8);
            hasher.putString((CharSequence)SystemInfo.JAVA_VENDOR, Charsets.UTF_8);
            hasher.putString((CharSequence)SystemInfo.JAVA_VERSION, Charsets.UTF_8);
            List<? extends IdeaPluginDescriptor> list2 = PluginManagerCore.getLoadedPlugins();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"PluginManagerCore.getLoadedPlugins()");
            Iterable $this$sortedBy$iv = list2;
            boolean $i$f$sortedBy = false;
            boolean bl = false;
            Iterable $this$forEach$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    IdeaPluginDescriptor it = (IdeaPluginDescriptor)a;
                    boolean bl2 = false;
                    IdeaPluginDescriptor ideaPluginDescriptor = it;
                    Intrinsics.checkNotNullExpressionValue((Object)ideaPluginDescriptor, (String)"it");
                    PluginId pluginId = ideaPluginDescriptor.getPluginId();
                    Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"it.pluginId");
                    it = (IdeaPluginDescriptor)b;
                    Comparable comparable = (Comparable)((Object)pluginId.getIdString());
                    bl2 = false;
                    IdeaPluginDescriptor ideaPluginDescriptor2 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)ideaPluginDescriptor2, (String)"it");
                    PluginId pluginId2 = ideaPluginDescriptor2.getPluginId();
                    Intrinsics.checkNotNullExpressionValue((Object)pluginId2, (String)"it.pluginId");
                    String string = pluginId2.getIdString();
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)string)));
                }
            });
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IdeaPluginDescriptor it = (IdeaPluginDescriptor)element$iv;
                boolean bl2 = false;
                StringBuilder stringBuilder = new StringBuilder();
                IdeaPluginDescriptor ideaPluginDescriptor = it;
                Intrinsics.checkNotNullExpressionValue((Object)ideaPluginDescriptor, (String)"it");
                PluginId pluginId = ideaPluginDescriptor.getPluginId();
                Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"it.pluginId");
                hasher.putString((CharSequence)stringBuilder.append(pluginId.getIdString()).append(":").append(it.getVersion()).toString(), Charsets.UTF_8);
            }
            String cdsClassesHash = info.getBuild().asString() + '-' + hasher.hash();
            File dumpLog = new File(PathManager.getLogPath(), "cds-dump.log");
            return new CDSPaths(baseDir, dumpLog, cdsClassesHash, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

