/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.wm.impl.IdeGlassPaneImpl;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0018H\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lcom/intellij/ide/UIMouseTracker;", "Lcom/intellij/ide/IdeEventQueue$EventDispatcher;", "()V", "mouseCoordinates", "Ljava/awt/Point;", "getMouseCoordinates", "()Ljava/awt/Point;", "setMouseCoordinates", "(Ljava/awt/Point;)V", "totalMouseTrack", "", "getTotalMouseTrack", "()F", "setTotalMouseTrack", "(F)V", "componentClicked", "", "comp", "Ljava/awt/Component;", "dispatch", "", "e", "Ljava/awt/AWTEvent;", "onMouseClicked", "Ljava/awt/event/MouseEvent;", "onMouseMove", "intellij.platform.ide.impl"})
public final class UIMouseTracker
implements IdeEventQueue.EventDispatcher {
    @NotNull
    private Point mouseCoordinates;
    private float totalMouseTrack;

    @NotNull
    public final Point getMouseCoordinates() {
        return this.mouseCoordinates;
    }

    public final void setMouseCoordinates(@NotNull Point point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"<set-?>");
        this.mouseCoordinates = point;
    }

    public final float getTotalMouseTrack() {
        return this.totalMouseTrack;
    }

    public final void setTotalMouseTrack(float f) {
        this.totalMouseTrack = f;
    }

    @Override
    public boolean dispatch(@NotNull AWTEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (e instanceof MouseEvent) {
            switch (((MouseEvent)e).getID()) {
                case 502: {
                    this.onMouseClicked((MouseEvent)e);
                    break;
                }
                case 503: {
                    this.onMouseMove((MouseEvent)e);
                    break;
                }
            }
        }
        return false;
    }

    private final void onMouseMove(MouseEvent e) {
        float dX = e.getXOnScreen() - this.mouseCoordinates.x;
        float dY = e.getYOnScreen() - this.mouseCoordinates.y;
        this.mouseCoordinates.x = e.getXOnScreen();
        this.mouseCoordinates.y = e.getYOnScreen();
        float f = dX * dX + dY * dY;
        boolean bl = false;
        this.totalMouseTrack += (float)Math.sqrt(f);
    }

    private final void onMouseClicked(MouseEvent e) {
        Component clickedComponent;
        if (e.getClickCount() == 0) {
            return;
        }
        Component component2 = e.getComponent();
        Component component3 = clickedComponent = component2 instanceof Container ? ((Container)component2).findComponentAt(e.getPoint()) : null;
        if (clickedComponent != null) {
            if (clickedComponent instanceof IdeGlassPaneImpl) {
                DialogWrapper dialog2 = DialogWrapper.findInstance((Component)clickedComponent);
                if (dialog2 != null) {
                    Point pointOnDialog = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), dialog2.getContentPane());
                    Component comp = dialog2.getContentPane().findComponentAt(pointOnDialog.x, pointOnDialog.y);
                    if (comp != null) {
                        this.componentClicked(comp);
                    }
                }
            } else {
                this.componentClicked(clickedComponent);
            }
        }
    }

    private final void componentClicked(Component comp) {
    }

    public UIMouseTracker() {
        PointerInfo pointerInfo = MouseInfo.getPointerInfo();
        Intrinsics.checkNotNullExpressionValue((Object)pointerInfo, (String)"MouseInfo.getPointerInfo()");
        Point point = pointerInfo.getLocation();
        if (point == null) {
            point = new Point(0, 0);
        }
        this.mouseCoordinates = point;
    }
}

