/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration.ui.views;

import com.intellij.CommonBundle;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.util.DiffUtil;
import com.intellij.history.core.LocalHistoryFacade;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.LocalHistoryBundle;
import com.intellij.history.integration.LocalHistoryImpl;
import com.intellij.history.integration.revertion.Reverter;
import com.intellij.history.integration.ui.models.FileDifferenceModel;
import com.intellij.history.integration.ui.models.HistoryDialogModel;
import com.intellij.history.integration.ui.models.RevisionProcessingProgress;
import com.intellij.history.integration.ui.views.RevisionsList;
import com.intellij.history.utils.LocalHistoryLog;
import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.ContextHelpAction;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.ide.ui.SplitterProportionsDataImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diff.impl.patch.IdeaTextPatchBuilder;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.FrameWrapper;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.patch.CreatePatchConfigurationPanel;
import com.intellij.openapi.vcs.changes.patch.PatchWriter;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import com.intellij.project.ProjectKt;
import com.intellij.ui.ExcludingTraversalPolicy;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.util.Consumer;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class HistoryDialog<T extends HistoryDialogModel>
extends FrameWrapper {
    private static final int UPDATE_DIFFS = 1;
    private static final int UPDATE_REVS = 2;
    protected final Project myProject;
    protected final IdeaGateway myGateway;
    protected final VirtualFile myFile;
    private Splitter mySplitter;
    private RevisionsList myRevisionsList;
    private JBLoadingPanel myDiffView;
    private ActionToolbar myToolBar;
    private T myModel;
    private MergingUpdateQueue myUpdateQueue;
    private boolean isUpdating;

    protected HistoryDialog(@NotNull Project project, IdeaGateway gw, VirtualFile f, boolean doInit2) {
        if (project == null) {
            HistoryDialog.$$$reportNull$$$0(0);
        }
        super(project);
        this.myProject = project;
        this.myGateway = gw;
        this.myFile = f;
        this.setImages((List)DiffUtil.DIFF_FRAME_ICONS.getValue());
        this.closeOnEsc();
        if (doInit2) {
            this.init();
        }
    }

    @Override
    @Nullable
    protected String getDimensionKey() {
        return this.getClass().getName();
    }

    protected void init() {
        LocalHistoryFacade facade = LocalHistoryImpl.getInstanceImpl().getFacade();
        this.myModel = this.createModel(facade);
        this.setTitle(((HistoryDialogModel)this.myModel).getTitle());
        JComponent root = this.createComponent();
        this.setComponent(root);
        this.setPreferredFocusedComponent(this.showRevisionsList() ? this.myRevisionsList.getComponent() : this.myDiffView);
        this.myUpdateQueue = new MergingUpdateQueue(this.getClass() + ".revisionsUpdate", 500, true, root, (Disposable)this, null, false);
        this.myUpdateQueue.setRestartTimerOnAdd(true);
        facade.addListener(new LocalHistoryFacade.Listener(){

            @Override
            public void changeSetFinished() {
                HistoryDialog.this.scheduleRevisionsUpdate(null);
            }
        }, this);
        this.scheduleRevisionsUpdate(null);
    }

    protected void scheduleRevisionsUpdate(@Nullable Consumer<? super T> configRunnable) {
        this.doScheduleUpdate(2, (Computable<Runnable>)((Computable)() -> {
            T t = this.myModel;
            synchronized (t) {
                if (configRunnable != null) {
                    configRunnable.consume(this.myModel);
                }
                ((HistoryDialogModel)this.myModel).clearRevisions();
                ((HistoryDialogModel)this.myModel).getRevisions();
            }
            return () -> this.myRevisionsList.updateData((HistoryDialogModel)this.myModel);
        }));
    }

    protected abstract T createModel(LocalHistoryFacade var1);

    protected JComponent createComponent() {
        JPanel root = new JPanel(new BorderLayout());
        ExcludingTraversalPolicy traversalPolicy = new ExcludingTraversalPolicy(new Component[0]);
        root.setFocusTraversalPolicy((FocusTraversalPolicy)traversalPolicy);
        root.setFocusTraversalPolicyProvider(true);
        Pair<JComponent, Dimension> diffAndToolbarSize = this.createDiffPanel(root, traversalPolicy);
        this.myDiffView = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)this, 200);
        this.myDiffView.add((Component)diffAndToolbarSize.first, (Object)"Center");
        JComponent revisionsSide = this.createRevisionsSide((Dimension)diffAndToolbarSize.second);
        if (this.showRevisionsList()) {
            this.mySplitter = new Splitter(false, 0.3f);
            this.mySplitter.setFirstComponent(revisionsSide);
            this.mySplitter.setSecondComponent((JComponent)this.myDiffView);
            this.restoreSplitterProportion();
            root.add((Component)this.mySplitter);
            this.setDiffBorder(IdeBorderFactory.createBorder((int)3));
        } else {
            this.setDiffBorder(IdeBorderFactory.createBorder((int)10));
            root.add((Component)this.myDiffView);
        }
        return root;
    }

    protected boolean showRevisionsList() {
        return true;
    }

    protected abstract void setDiffBorder(Border var1);

    @Override
    public void dispose() {
        this.saveSplitterProportion();
        super.dispose();
    }

    protected abstract Pair<JComponent, Dimension> createDiffPanel(JPanel var1, ExcludingTraversalPolicy var2);

    private JComponent createRevisionsSide(Dimension prefToolBarSize) {
        ActionGroup actions = this.createRevisionsActions();
        this.myToolBar = HistoryDialog.createRevisionsToolbar(actions);
        this.myRevisionsList = new RevisionsList(new RevisionsList.SelectionListener(){

            @Override
            public void revisionsSelected(int first, int last) {
                HistoryDialog.this.scheduleDiffUpdate((Couple<Integer>)Couple.of((Object)first, (Object)last));
            }
        });
        HistoryDialog.addPopupMenuToComponent(this.myRevisionsList.getComponent(), actions);
        JPanel result2 = new JPanel(new BorderLayout());
        JPanel toolBarPanel = new JPanel(new BorderLayout());
        toolBarPanel.add(this.myToolBar.getComponent());
        if (prefToolBarSize != null) {
            toolBarPanel.setPreferredSize(new Dimension(1, prefToolBarSize.height));
        }
        result2.add((Component)toolBarPanel, "North");
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)this.myRevisionsList.getComponent());
        scrollPane.setBorder(IdeBorderFactory.createBorder((int)6));
        result2.add((Component)scrollPane, "Center");
        return result2;
    }

    private static ActionToolbar createRevisionsToolbar(ActionGroup actions) {
        ActionManager am = ActionManager.getInstance();
        return am.createActionToolbar("HistoryDialogRevisions", actions, true);
    }

    private ActionGroup createRevisionsActions() {
        DefaultActionGroup result2 = new DefaultActionGroup();
        result2.add((AnAction)new RevertAction());
        result2.add((AnAction)new CreatePatchAction());
        result2.add((AnAction)Separator.getInstance());
        result2.add((AnAction)new ContextHelpAction(this.getHelpId()));
        return result2;
    }

    private static void addPopupMenuToComponent(JComponent comp, final ActionGroup ag) {
        comp.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component c, int x, int y) {
                ActionPopupMenu m = HistoryDialog.createPopupMenu(ag);
                m.getComponent().show(c, x, y);
            }
        });
    }

    private static ActionPopupMenu createPopupMenu(ActionGroup ag) {
        ActionManager m = ActionManager.getInstance();
        return m.createActionPopupMenu("unknown", ag);
    }

    private void scheduleDiffUpdate(@Nullable Couple<Integer> toSelect2) {
        this.doScheduleUpdate(1, (Computable<Runnable>)((Computable)() -> {
            T t = this.myModel;
            synchronized (t) {
                if (toSelect2 == null) {
                    ((HistoryDialogModel)this.myModel).resetSelection();
                } else {
                    ((HistoryDialogModel)this.myModel).selectRevisions((Integer)toSelect2.first, (Integer)toSelect2.second);
                }
                return this.doUpdateDiffs(this.myModel);
            }
        }));
    }

    private void doScheduleUpdate(int id2, final Computable<? extends Runnable> update2) {
        this.myUpdateQueue.queue(new Update(this, id2){

            public boolean canEat(Update update1) {
                return this.getPriority() >= update1.getPriority();
            }

            public void run() {
                if (this.isDisposed() || HistoryDialog.this.myProject.isDisposed()) {
                    return;
                }
                ApplicationManager.getApplication().invokeAndWait(() -> {
                    if (this.isDisposed() || HistoryDialog.this.myProject.isDisposed()) {
                        return;
                    }
                    HistoryDialog.this.isUpdating = true;
                    HistoryDialog.this.updateActions();
                    HistoryDialog.this.myDiffView.startLoading();
                });
                Runnable apply2 = null;
                try {
                    apply2 = (Runnable)update2.compute();
                }
                catch (Exception e) {
                    LocalHistoryLog.LOG.error((Throwable)e);
                }
                Runnable finalApply = apply2;
                ApplicationManager.getApplication().invokeAndWait(() -> {
                    if (this.isDisposed() || HistoryDialog.this.myProject.isDisposed()) {
                        return;
                    }
                    HistoryDialog.this.isUpdating = false;
                    if (finalApply != null) {
                        try {
                            finalApply.run();
                        }
                        catch (Exception e) {
                            LocalHistoryLog.LOG.error((Throwable)e);
                        }
                    }
                    HistoryDialog.this.updateActions();
                    HistoryDialog.this.myDiffView.stopLoading();
                });
            }
        });
    }

    protected void updateActions() {
        if (this.showRevisionsList()) {
            this.myToolBar.updateActionsImmediately();
        }
    }

    protected abstract Runnable doUpdateDiffs(T var1);

    protected ContentDiffRequest createDifference(final FileDifferenceModel m) {
        final Ref requestRef = new Ref();
        new Task.Modal(this.myProject, LocalHistoryBundle.message("message.processing.revisions", new Object[0]), false){

            public void run(@NotNull ProgressIndicator i2) {
                if (i2 == null) {
                    5.$$$reportNull$$$0(0);
                }
                i2.setIndeterminate(false);
                ApplicationManager.getApplication().runReadAction(() -> {
                    RevisionProcessingProgressAdapter p = new RevisionProcessingProgressAdapter(i2);
                    p.processingLeftRevision();
                    DiffContent left = m.getLeftDiffContent(p);
                    p.processingRightRevision();
                    DiffContent right = m.getRightDiffContent(p);
                    requestRef.set((Object)new SimpleDiffRequest(m.getTitle(), left, right, m.getLeftTitle(p), m.getRightTitle(p)));
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "i", "com/intellij/history/integration/ui/views/HistoryDialog$5", "run"));
            }
        }.queue();
        return (ContentDiffRequest)requestRef.get();
    }

    private void saveSplitterProportion() {
        SplitterProportionsDataImpl d = new SplitterProportionsDataImpl();
        d.saveSplitterProportions((Component)this.mySplitter);
        d.externalizeToDimensionService(this.getDimensionKey());
    }

    private void restoreSplitterProportion() {
        SplitterProportionsDataImpl d = new SplitterProportionsDataImpl();
        d.externalizeFromDimensionService(this.getDimensionKey());
        d.restoreSplitterProportions((Component)this.mySplitter);
    }

    protected abstract String getHelpId();

    protected void revert() {
        this.revert(((HistoryDialogModel)this.myModel).createReverter());
    }

    private boolean isRevertEnabled() {
        return ((HistoryDialogModel)this.myModel).isRevertEnabled();
    }

    protected void revert(Reverter r) {
        try {
            if (!this.askForProceeding(r)) {
                return;
            }
            List<String> errors = r.checkCanRevert();
            if (!errors.isEmpty()) {
                this.showError(LocalHistoryBundle.message("message.cannot.revert.because", HistoryDialog.formatErrors(errors)));
                return;
            }
            r.revert();
            this.showNotification(r.getCommandName());
        }
        catch (Exception e) {
            this.showError(LocalHistoryBundle.message("message.error.during.revert", e));
        }
    }

    private boolean askForProceeding(Reverter r) throws IOException {
        List<String> questions = r.askUserForProceeding();
        if (questions.isEmpty()) {
            return true;
        }
        return Messages.showYesNoDialog((Project)this.myProject, (String)LocalHistoryBundle.message("message.do.you.want.to.proceed", HistoryDialog.formatQuestions(questions)), (String)LocalHistoryBundle.message("dialog.title.revert", new Object[0]), (Icon)Messages.getWarningIcon()) == 0;
    }

    private static String formatQuestions(List<String> questions) {
        if (questions.size() == 1) {
            return questions.get(0);
        }
        StringBuilder result2 = new StringBuilder();
        for (int i2 = 0; i2 < questions.size(); ++i2) {
            result2.append(i2 + 1).append(") ").append(questions.get(i2)).append("\n");
        }
        return result2.substring(0, result2.length() - 1);
    }

    private void showNotification(@NlsContexts.PopupContent String title) {
        SwingUtilities.invokeLater(() -> {
            Balloon b = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(title, null, MessageType.INFO.getPopupBackground(), null).setFadeoutTime(3000L).setShowCallout(false).createBalloon();
            Dimension size = this.myDiffView.getSize();
            RelativePoint point = new RelativePoint((Component)this.myDiffView, new Point(size.width / 2, size.height / 2));
            b.show(point, Balloon.Position.above);
        });
    }

    private static String formatErrors(List<String> errors) {
        if (errors.size() == 1) {
            return errors.get(0);
        }
        StringBuilder result2 = new StringBuilder();
        for (String e : errors) {
            result2.append("\n    -").append(e);
        }
        return result2.toString();
    }

    private boolean isCreatePatchEnabled() {
        return ((HistoryDialogModel)this.myModel).isCreatePatchEnabled();
    }

    private void createPatch() {
        try {
            if (!((HistoryDialogModel)this.myModel).canPerformCreatePatch()) {
                this.showError(LocalHistoryBundle.message("message.cannot.create.patch.because.of.unavailable.content", new Object[0]));
                return;
            }
            CreatePatchConfigurationPanel p = new CreatePatchConfigurationPanel(this.myProject);
            p.setFileName(this.getDefaultPatchFile());
            p.setCommonParentPath(ChangesUtil.findCommonAncestor(((HistoryDialogModel)this.myModel).getChanges()));
            if (!this.showAsDialog(p)) {
                return;
            }
            Path base = Paths.get(p.getBaseDirName(), new String[0]);
            List patches2 = IdeaTextPatchBuilder.buildPatch((Project)this.myProject, ((HistoryDialogModel)this.myModel).getChanges(), (Path)base, (boolean)p.isReversePatch(), (boolean)false);
            if (p.isToClipboard()) {
                PatchWriter.writeAsPatchToClipboard((Project)this.myProject, (List)patches2, (Path)base, (CommitContext)new CommitContext());
                this.showNotification(LocalHistoryBundle.message("message.patch.copied.to.clipboard", new Object[0]));
            } else {
                Path file2 = Paths.get(p.getFileName(), new String[0]);
                PatchWriter.writePatches((Project)this.myProject, (Path)file2, (Path)base, (List)patches2, null, (Charset)p.getEncoding(), (boolean)false);
                this.showNotification(LocalHistoryBundle.message("message.patch.created", new Object[0]));
                RevealFileAction.openFile(file2);
            }
        }
        catch (VcsException | IOException e) {
            this.showError(LocalHistoryBundle.message("message.error.during.create.patch", e));
        }
    }

    @NotNull
    private Path getDefaultPatchFile() {
        Path path = FileUtil.findSequentNonexistentFile((File)ProjectKt.getStateStore(this.myProject).getProjectBasePath().toFile(), (String)"local_history", (String)"patch").toPath();
        if (path == null) {
            HistoryDialog.$$$reportNull$$$0(1);
        }
        return path;
    }

    private boolean showAsDialog(CreatePatchConfigurationPanel p) {
        MyDialogWrapper dialogWrapper2 = new MyDialogWrapper(this.myProject, p);
        dialogWrapper2.setTitle(LocalHistoryBundle.message("create.patch.dialog.title", new Object[0]));
        dialogWrapper2.setModal(true);
        dialogWrapper2.show();
        return dialogWrapper2.getExitCode() == 0;
    }

    public void showError(@NlsContexts.DialogMessage String s) {
        Messages.showErrorDialog((Project)this.myProject, (String)s, (String)CommonBundle.getErrorTitle());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/history/integration/ui/views/HistoryDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/history/integration/ui/views/HistoryDialog";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultPatchFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyDialogWrapper
    extends DialogWrapper {
        @NotNull
        private final CreatePatchConfigurationPanel myPanel;

        protected MyDialogWrapper(@Nullable Project project, @NotNull CreatePatchConfigurationPanel centralPanel) {
            if (centralPanel == null) {
                MyDialogWrapper.$$$reportNull$$$0(0);
            }
            super(project, true);
            this.myPanel = centralPanel;
            this.init();
            this.initValidation();
        }

        @Nullable
        protected JComponent createCenterPanel() {
            return this.myPanel.getPanel();
        }

        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return IdeFocusTraversalPolicy.getPreferredFocusedComponent(this.myPanel.getPanel());
        }

        @Nullable
        protected ValidationInfo doValidate() {
            return this.myPanel.validateFields();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "centralPanel", "com/intellij/history/integration/ui/views/HistoryDialog$MyDialogWrapper", "<init>"));
        }
    }

    private static class RevisionProcessingProgressAdapter
    implements RevisionProcessingProgress {
        private final ProgressIndicator myIndicator;

        RevisionProcessingProgressAdapter(ProgressIndicator i2) {
            this.myIndicator = i2;
        }

        @Override
        public void processingLeftRevision() {
            this.myIndicator.setText(LocalHistoryBundle.message("message.processing.left.revision", new Object[0]));
        }

        @Override
        public void processingRightRevision() {
            this.myIndicator.setText(LocalHistoryBundle.message("message.processing.right.revision", new Object[0]));
        }

        @Override
        public void processed(int percentage) {
            this.myIndicator.setFraction((double)percentage / 100.0);
        }
    }

    private class CreatePatchAction
    extends MyAction {
        CreatePatchAction() {
            super(LocalHistoryBundle.message("action.create.patch", new Object[0]), null, AllIcons.Vcs.Patch);
        }

        @Override
        protected void doPerform(T model2) {
            HistoryDialog.this.createPatch();
        }

        @Override
        protected boolean isEnabled(T model2) {
            return HistoryDialog.this.isCreatePatchEnabled();
        }
    }

    private class RevertAction
    extends MyAction {
        RevertAction() {
            super(LocalHistoryBundle.message("action.revert", new Object[0]), null, AllIcons.Actions.Rollback);
        }

        @Override
        protected void doPerform(T model2) {
            HistoryDialog.this.revert();
        }

        @Override
        protected boolean isEnabled(T model2) {
            return HistoryDialog.this.isRevertEnabled();
        }
    }

    protected abstract class MyAction
    extends AnAction {
        protected MyAction(@NlsActions.ActionDescription String text2, String description, Icon icon2) {
            super(text2, description, icon2);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MyAction.$$$reportNull$$$0(0);
            }
            this.doPerform(HistoryDialog.this.myModel);
        }

        protected abstract void doPerform(T var1);

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MyAction.$$$reportNull$$$0(1);
            }
            Presentation p = e.getPresentation();
            p.setEnabled(this.isEnabled());
        }

        private boolean isEnabled() {
            return !HistoryDialog.this.isUpdating && this.isEnabled(HistoryDialog.this.myModel);
        }

        protected abstract boolean isEnabled(T var1);

        public void performIfEnabled() {
            if (this.isEnabled()) {
                this.doPerform(HistoryDialog.this.myModel);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/history/integration/ui/views/HistoryDialog$MyAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

