/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.featureStatistics.fusCollectors;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId2;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/featureStatistics/fusCollectors/WSLInstallationsCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/ApplicationUsagesCollector;", "()V", "getGroup", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "getMetrics", "", "Lcom/intellij/internal/statistic/beans/MetricEvent;", "Companion", "intellij.platform.ide.impl"})
public final class WSLInstallationsCollector
extends ApplicationUsagesCollector {
    private static final EventLogGroup group;
    private static final EventId2<Integer, Integer> installationCountEvent;
    private static final Logger LOG;
    public static final Companion Companion;

    @NotNull
    public EventLogGroup getGroup() {
        return group;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<MetricEvent> getMetrics() {
        void $this$mapNotNullTo$iv;
        void $this$groupByTo$iv$iv;
        ProcessOutput processOutput;
        if (!SystemInfo.isWin10OrNewer) {
            return SetsKt.emptySet();
        }
        File file2 = PathEnvironmentVariableUtil.findInPath((String)"wsl.exe");
        if (file2 == null) {
            return SetsKt.emptySet();
        }
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"PathEnvironmentVariableU\u2026xe\") ?: return emptySet()");
        File wslExe = file2;
        try {
            GeneralCommandLine generalCommandLine = new GeneralCommandLine(new String[]{wslExe.getAbsolutePath(), "-l", "-v"}).withCharset(StandardCharsets.UTF_16LE);
            Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine, (String)"GeneralCommandLine(wslEx\u2026tandardCharsets.UTF_16LE)");
            processOutput = ExecUtil.execAndGetOutput((GeneralCommandLine)generalCommandLine, (int)10000);
        }
        catch (ExecutionException e) {
            LOG.info("Failed to run wsl: " + e.getMessage());
            return SetsKt.emptySet();
        }
        ProcessOutput output = processOutput;
        if (output.getExitCode() != 0) {
            LOG.info("Failed to run wsl: exit code " + output.getExitCode() + ", stderr " + output.getStderr());
            return SetsKt.emptySet();
        }
        List list2 = output.getStdoutLines();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"output.stdoutLines");
        Object $this$groupBy$iv = CollectionsKt.drop((Iterable)list2, (int)1);
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            String it = (String)element$iv$iv;
            boolean bl = false;
            String string = it;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it");
            String key$iv$iv = StringsKt.substringAfterLast$default((String)string, (char)' ', null, (int)2, null);
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map installations = destination$iv$iv;
        $this$groupBy$iv = installations;
        Collection destination$iv = new HashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv;
        boolean bl = false;
        Iterator iterator3 = iterator2.entrySet().iterator();
        while (iterator3.hasNext()) {
            MetricEvent metricEvent;
            void versionString;
            Map.Entry element$iv$iv;
            Map.Entry element$iv = element$iv$iv = iterator3.next();
            boolean bl3 = false;
            Map.Entry $dstr$versionString$distributions = element$iv;
            boolean bl4 = false;
            Object object = $dstr$versionString$distributions;
            boolean bl5 = false;
            String string = (String)object.getKey();
            object = $dstr$versionString$distributions;
            bl5 = false;
            List distributions = (List)object.getValue();
            Integer n = StringsKt.toIntOrNull((String)versionString);
            if (n != null) {
                object = n;
                bl5 = false;
                boolean bl6 = false;
                int version2 = ((Number)object).intValue();
                boolean bl7 = false;
                metricEvent = installationCountEvent.metric((Object)version2, (Object)distributions.size());
            } else {
                metricEvent = null;
            }
            if (metricEvent == null) continue;
            MetricEvent metricEvent2 = metricEvent;
            boolean bl8 = false;
            boolean bl9 = false;
            MetricEvent it$iv = metricEvent2;
            boolean bl10 = false;
            destination$iv.add(it$iv);
        }
        return (Set)destination$iv;
    }

    static {
        Companion = new Companion(null);
        group = new EventLogGroup("wsl.installations", 1);
        installationCountEvent = group.registerEvent("count", (EventField)EventFields.Int((String)"version"), (EventField)EventFields.Int((String)"count"));
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(WSLInstallationsCollector.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/featureStatistics/fusCollectors/WSLInstallationsCollector$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "group", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "installationCountEvent", "Lcom/intellij/internal/statistic/eventLog/events/EventId2;", "", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

