/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.wsl.target;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Platform;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.target.HostPort;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentAwareRunProfileState;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetPlatform;
import com.intellij.execution.target.TargetedCommandLine;
import com.intellij.execution.wsl.WSLCommandLineOptions;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.target.WslTargetEnvironmentRequest;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.io.FileUtil;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001.B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020#H\u0002J\u0018\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0016J\b\u0010+\u001a\u00020,H\u0016J\u0012\u0010-\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020#H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR \u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\fR\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR \u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\fR \u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\f\u00a8\u0006/"}, d2={"Lcom/intellij/execution/wsl/target/WslTargetEnvironment;", "Lcom/intellij/execution/target/TargetEnvironment;", "wslRequest", "Lcom/intellij/execution/wsl/target/WslTargetEnvironmentRequest;", "distribution", "Lcom/intellij/execution/wsl/WSLDistribution;", "(Lcom/intellij/execution/wsl/target/WslTargetEnvironmentRequest;Lcom/intellij/execution/wsl/WSLDistribution;)V", "downloadVolumes", "", "Lcom/intellij/execution/target/TargetEnvironment$DownloadRoot;", "Lcom/intellij/execution/target/TargetEnvironment$DownloadableVolume;", "getDownloadVolumes", "()Ljava/util/Map;", "localPortBindings", "Lcom/intellij/execution/target/TargetEnvironment$LocalPortBinding;", "Lcom/intellij/execution/target/HostPort;", "getLocalPortBindings", "myDownloadVolumes", "myLocalPortBindings", "", "myTargetPortBindings", "Lcom/intellij/execution/target/TargetEnvironment$TargetPortBinding;", "", "myUploadVolumes", "Lcom/intellij/execution/target/TargetEnvironment$UploadRoot;", "Lcom/intellij/execution/target/TargetEnvironment$UploadableVolume;", "targetPlatform", "Lcom/intellij/execution/target/TargetPlatform;", "getTargetPlatform", "()Lcom/intellij/execution/target/TargetPlatform;", "targetPortBindings", "getTargetPortBindings", "uploadVolumes", "getUploadVolumes", "convertUncPathToLinux", "", "localPath", "createProcess", "Ljava/lang/Process;", "commandLine", "Lcom/intellij/execution/target/TargetedCommandLine;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "shutdown", "", "toLinuxPath", "Volume", "intellij.platform.ide.impl"})
public final class WslTargetEnvironment
extends TargetEnvironment {
    private final Map<TargetEnvironment.UploadRoot, TargetEnvironment.UploadableVolume> myUploadVolumes;
    private final Map<TargetEnvironment.DownloadRoot, TargetEnvironment.DownloadableVolume> myDownloadVolumes;
    private final Map<TargetEnvironment.TargetPortBinding, Integer> myTargetPortBindings;
    private final Map<TargetEnvironment.LocalPortBinding, HostPort> myLocalPortBindings;
    private final WSLDistribution distribution;

    @NotNull
    public Map<TargetEnvironment.UploadRoot, TargetEnvironment.UploadableVolume> getUploadVolumes() {
        Map<TargetEnvironment.UploadRoot, TargetEnvironment.UploadableVolume> map2 = Collections.unmodifiableMap(this.myUploadVolumes);
        Intrinsics.checkNotNullExpressionValue(map2, (String)"Collections.unmodifiableMap(myUploadVolumes)");
        return map2;
    }

    @NotNull
    public Map<TargetEnvironment.DownloadRoot, TargetEnvironment.DownloadableVolume> getDownloadVolumes() {
        Map<TargetEnvironment.DownloadRoot, TargetEnvironment.DownloadableVolume> map2 = Collections.unmodifiableMap(this.myDownloadVolumes);
        Intrinsics.checkNotNullExpressionValue(map2, (String)"Collections.unmodifiableMap(myDownloadVolumes)");
        return map2;
    }

    @NotNull
    public Map<TargetEnvironment.TargetPortBinding, Integer> getTargetPortBindings() {
        Map<TargetEnvironment.TargetPortBinding, Integer> map2 = Collections.unmodifiableMap(this.myTargetPortBindings);
        Intrinsics.checkNotNullExpressionValue(map2, (String)"Collections.unmodifiableMap(myTargetPortBindings)");
        return map2;
    }

    @NotNull
    public Map<TargetEnvironment.LocalPortBinding, HostPort> getLocalPortBindings() {
        Map<TargetEnvironment.LocalPortBinding, HostPort> map2 = Collections.unmodifiableMap(this.myLocalPortBindings);
        Intrinsics.checkNotNullExpressionValue(map2, (String)"Collections.unmodifiableMap(myLocalPortBindings)");
        return map2;
    }

    @NotNull
    public TargetPlatform getTargetPlatform() {
        TargetPlatform targetPlatform = TargetPlatform.CURRENT;
        Intrinsics.checkNotNullExpressionValue((Object)targetPlatform, (String)"TargetPlatform.CURRENT");
        return new TargetPlatform(Platform.UNIX, targetPlatform.getArch());
    }

    private final String toLinuxPath(String localPath) {
        String linuxPath = this.distribution.getWslPath(localPath);
        if (linuxPath != null) {
            return linuxPath;
        }
        return this.convertUncPathToLinux(localPath);
    }

    private final String convertUncPathToLinux(String localPath) {
        String root = "\\\\wsl$\\" + this.distribution.getMsId();
        String string = FileUtil.toSystemDependentName((String)localPath);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"FileUtil.toSystemDependentName(localPath)");
        String winLocalPath = string;
        if (StringsKt.startsWith$default((String)winLocalPath, (String)root, (boolean)false, (int)2, null)) {
            CharSequence charSequence = winLocalPath;
            int n = root.length();
            boolean bl = false;
            String string2 = charSequence;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            String linuxPath = string3;
            charSequence = linuxPath;
            n = 0;
            if (charSequence.length() == 0) {
                return "/";
            }
            if (StringsKt.startsWith$default((String)linuxPath, (String)"\\", (boolean)false, (int)2, null)) {
                return FileUtil.toSystemIndependentName((String)linuxPath);
            }
        }
        return null;
    }

    @NotNull
    public Process createProcess(@NotNull TargetedCommandLine commandLine, @NotNull ProgressIndicator indicator) throws ExecutionException {
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        GeneralCommandLine line = new GeneralCommandLine(commandLine.collectCommandsSynchronously());
        WSLCommandLineOptions wSLCommandLineOptions = new WSLCommandLineOptions().setRemoteWorkingDirectory(commandLine.getWorkingDirectory());
        Intrinsics.checkNotNullExpressionValue((Object)wSLCommandLineOptions, (String)"WSLCommandLineOptions().\u2026andLine.workingDirectory)");
        WSLCommandLineOptions options2 = wSLCommandLineOptions;
        GeneralCommandLine generalCommandLine = this.distribution.patchCommandLine(line, null, options2);
        Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine, (String)"distribution.patchCommandLine(line, null, options)");
        line = generalCommandLine;
        Process process2 = line.createProcess();
        Intrinsics.checkNotNullExpressionValue((Object)process2, (String)"line.createProcess()");
        return process2;
    }

    public void shutdown() {
    }

    public WslTargetEnvironment(@NotNull WslTargetEnvironmentRequest wslRequest, @NotNull WSLDistribution distribution) {
        Intrinsics.checkNotNullParameter((Object)((Object)wslRequest), (String)"wslRequest");
        Intrinsics.checkNotNullParameter((Object)distribution, (String)"distribution");
        super((TargetEnvironmentRequest)wslRequest);
        this.distribution = distribution;
        this.myUploadVolumes = new HashMap();
        this.myDownloadVolumes = new HashMap();
        this.myTargetPortBindings = new HashMap();
        this.myLocalPortBindings = new HashMap();
        for (TargetEnvironment.UploadRoot uploadRoot : wslRequest.getUploadVolumes()) {
            String targetRoot = this.toLinuxPath(((Object)uploadRoot.getLocalRootPath().toAbsolutePath()).toString());
            if (targetRoot == null) continue;
            this.myUploadVolumes.put(uploadRoot, new Volume(uploadRoot.getLocalRootPath(), targetRoot));
        }
        for (TargetEnvironment.TargetPortBinding targetPortBinding : wslRequest.getTargetPortBindings()) {
            int theOnlyPort = targetPortBinding.getTarget();
            if (targetPortBinding.getLocal() != null) {
                Integer n = targetPortBinding.getLocal();
                if (n == null || n != theOnlyPort) {
                    throw (Throwable)new UnsupportedOperationException("Local target's TCP port forwarder is not implemented");
                }
            }
            this.myTargetPortBindings.put(targetPortBinding, theOnlyPort);
        }
        for (TargetEnvironment.LocalPortBinding localPortBinding : wslRequest.getLocalPortBindings()) {
            int theOnlyPort = localPortBinding.getLocal();
            if (localPortBinding.getTarget() != null) {
                Integer n = localPortBinding.getTarget();
                if (n == null || n != theOnlyPort) {
                    throw (Throwable)new UnsupportedOperationException("Local target's TCP port forwarder is not implemented");
                }
            }
            this.myLocalPortBindings.put(localPortBinding, new HostPort("localhost", theOnlyPort));
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005H\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0011"}, d2={"Lcom/intellij/execution/wsl/target/WslTargetEnvironment$Volume;", "Lcom/intellij/execution/target/TargetEnvironment$UploadableVolume;", "localRoot", "Ljava/nio/file/Path;", "targetRoot", "", "(Lcom/intellij/execution/wsl/target/WslTargetEnvironment;Ljava/nio/file/Path;Ljava/lang/String;)V", "getLocalRoot", "()Ljava/nio/file/Path;", "getTargetRoot", "()Ljava/lang/String;", "resolveTargetPath", "relativePath", "upload", "", "targetProgressIndicator", "Lcom/intellij/execution/target/TargetEnvironmentAwareRunProfileState$TargetProgressIndicator;", "intellij.platform.ide.impl"})
    private final class Volume
    implements TargetEnvironment.UploadableVolume {
        @NotNull
        private final Path localRoot;
        @NotNull
        private final String targetRoot;

        @NotNull
        public String resolveTargetPath(@NotNull String relativePath) throws IOException {
            String localPath;
            Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
            String string = localPath = FileUtil.toCanonicalPath((String)FileUtil.join((String[])new String[]{((Object)this.getLocalRoot()).toString(), relativePath}));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"localPath");
            String string2 = WslTargetEnvironment.this.toLinuxPath(string);
            Intrinsics.checkNotNull((Object)string2);
            return string2;
        }

        public void upload(@NotNull String relativePath, @NotNull TargetEnvironmentAwareRunProfileState.TargetProgressIndicator targetProgressIndicator2) throws IOException {
            Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
            Intrinsics.checkNotNullParameter((Object)targetProgressIndicator2, (String)"targetProgressIndicator");
        }

        @NotNull
        public Path getLocalRoot() {
            return this.localRoot;
        }

        @NotNull
        public String getTargetRoot() {
            return this.targetRoot;
        }

        public Volume(@NotNull Path localRoot, String targetRoot) {
            Intrinsics.checkNotNullParameter((Object)localRoot, (String)"localRoot");
            Intrinsics.checkNotNullParameter((Object)targetRoot, (String)"targetRoot");
            this.localRoot = localRoot;
            this.targetRoot = targetRoot;
        }
    }
}

