/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.ui;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.testframework.TestIconMapper;
import com.intellij.execution.testframework.TestRunnerBundle;
import com.intellij.execution.testframework.sm.runner.states.TestStateInfo;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.progress.util.ColorProgressBar;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.ui.EdtInvocationManager;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.border.Border;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class TestStatusLine
extends NonOpaquePanel {
    private static final SimpleTextAttributes IGNORE_ATTRIBUTES = new SimpleTextAttributes(0, ColorProgressBar.YELLOW);
    private static final SimpleTextAttributes ERROR_ATTRIBUTES = new SimpleTextAttributes(0, ColorProgressBar.RED_TEXT);
    protected final JProgressBar myProgressBar = new JProgressBar();
    protected final SimpleColoredComponent myState = new SimpleColoredComponent();
    private final JPanel myProgressPanel;
    private final JLabel myWarning = new JLabel();

    public TestStatusLine() {
        super((LayoutManager)new BorderLayout());
        this.myProgressPanel = new NonOpaquePanel((LayoutManager)new BorderLayout());
        this.add(this.myProgressPanel, "South");
        this.myProgressBar.setMaximum(100);
        this.myProgressBar.putClientProperty("ProgressBar.stripeWidth", 3);
        this.myProgressBar.putClientProperty("ProgressBar.flatEnds", Boolean.TRUE);
        this.setStatusColor(ColorProgressBar.GREEN);
        NonOpaquePanel stateWrapper = new NonOpaquePanel((LayoutManager)new FlowLayout(0, 0, 0));
        this.myState.setOpaque(false);
        stateWrapper.add((Component)this.myState);
        this.myWarning.setOpaque(false);
        this.myWarning.setVisible(false);
        this.myWarning.setIcon(AllIcons.General.Warning);
        this.myWarning.setBorder((Border)JBUI.Borders.emptyLeft((int)10));
        stateWrapper.add(this.myWarning);
        this.add((Component)stateWrapper, "Center");
        this.myState.append(ExecutionBundle.message((String)"junit.runing.info.starting.label", (Object[])new Object[0]));
    }

    public void formatTestMessage(int testsTotal, int finishedTestsCount, int failuresCount, int ignoredTestsCount, Long duration, long endTime) {
        UIUtil.invokeLaterIfNeeded(() -> {
            this.doFormatTestMessage(testsTotal, finishedTestsCount, failuresCount, ignoredTestsCount, duration, endTime);
            this.updateWarningVisibility();
        });
    }

    private void updateWarningVisibility() {
        this.myWarning.setVisible(this.myState.getCharSequence(false).length() > 0 && StringUtil.isNotEmpty((String)this.myWarning.getText()));
    }

    private void doFormatTestMessage(int testsTotal, int finishedTestsCount, int failuresCount, int ignoredTestsCount, Long duration, long endTime) {
        boolean stopped;
        this.myState.clear();
        if (testsTotal == 0 && (testsTotal = finishedTestsCount) == 0) {
            return;
        }
        int passedCount = finishedTestsCount - failuresCount - ignoredTestsCount;
        if (duration == null || endTime == 0L) {
            this.formatCounts(failuresCount, ignoredTestsCount, passedCount, testsTotal);
            return;
        }
        boolean bl = stopped = finishedTestsCount != testsTotal;
        if (stopped) {
            this.myState.append(TestRunnerBundle.message("test.stopped", new Object[0]) + " ");
        }
        this.formatCounts(failuresCount, ignoredTestsCount, passedCount, testsTotal);
        @NlsSafe String fragment = " \u2013 " + StringUtil.formatDuration((long)duration, (String)"\u2009");
        this.myState.append(fragment, SimpleTextAttributes.GRAY_ATTRIBUTES);
    }

    private void formatCounts(int failuresCount, int ignoredTestsCount, int passedCount, int testsTotal) {
        boolean something = false;
        if (failuresCount > 0) {
            this.myState.append(TestRunnerBundle.message("tests.result.prefix", new Object[0]) + " ", ERROR_ATTRIBUTES);
            this.myState.append(TestRunnerBundle.message("tests.result.failed.count", failuresCount), ERROR_ATTRIBUTES);
            something = true;
        } else {
            this.myState.append(TestRunnerBundle.message("tests.result.prefix", new Object[0]) + " ");
        }
        if (passedCount > 0 || ignoredTestsCount + failuresCount == 0) {
            if (something) {
                this.myState.append(", ");
            }
            something = true;
            this.myState.append(TestRunnerBundle.message("tests.result.passed.count", passedCount));
        }
        if (ignoredTestsCount > 0) {
            if (something) {
                this.myState.append(", ");
            }
            this.myState.append(TestRunnerBundle.message("tests.result.ignored.count", ignoredTestsCount), IGNORE_ATTRIBUTES);
        }
        if (testsTotal > 0) {
            this.myState.append(TestRunnerBundle.message("tests.result.total.count", testsTotal), SimpleTextAttributes.GRAYED_ATTRIBUTES);
        }
    }

    public void setIndeterminate(boolean flag) {
        this.myProgressPanel.add((Component)this.myProgressBar, "North");
        this.myProgressBar.setIndeterminate(flag);
    }

    public void onTestsDone(@Nullable TestStateInfo.Magnitude info) {
        EdtInvocationManager.getInstance().invokeLater(() -> {
            this.myProgressPanel.remove(this.myProgressBar);
            if (info != null) {
                this.myState.setIcon(TestIconMapper.getToolbarIcon((TestStateInfo.Magnitude)info));
            }
        });
    }

    public void setStatusColor(Color color) {
        this.myProgressBar.setForeground(color);
    }

    public Color getStatusColor() {
        return this.myProgressBar.getForeground();
    }

    public void setFraction(double v) {
        int fraction = (int)(v * 100.0);
        this.myProgressBar.setValue(fraction);
    }

    @Deprecated
    public void setPreferredSize(boolean orientation) {
        JBDimension size = new JBDimension(orientation ? 150 : 450, -1);
        this.myProgressPanel.setMaximumSize((Dimension)size);
        this.myProgressPanel.setMinimumSize((Dimension)size);
        this.myProgressPanel.setPreferredSize((Dimension)size);
    }

    public void setText(@Nls String progressStatus_text) {
        UIUtil.invokeLaterIfNeeded(() -> {
            this.myState.clear();
            this.myState.append(progressStatus_text);
            this.myWarning.setVisible(!progressStatus_text.isEmpty());
        });
    }

    @TestOnly
    @NotNull
    public String getStateText() {
        String string = this.myState.toString();
        if (string == null) {
            TestStatusLine.$$$reportNull$$$0(0);
        }
        return string;
    }

    @ApiStatus.Internal
    public void setWarning(@Nls @NotNull String suffix) {
        if (suffix == null) {
            TestStatusLine.$$$reportNull$$$0(1);
        }
        this.myWarning.setText(suffix);
        this.updateWarningVisibility();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/testframework/ui/TestStatusLine";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getStateText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/testframework/ui/TestStatusLine";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setWarning";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

