/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.target;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.target.ContributedConfigurationBase;
import com.intellij.execution.target.LanguageRuntimeConfiguration;
import com.intellij.execution.target.LanguageRuntimeConfigurationKt;
import com.intellij.execution.target.LanguageRuntimeType;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.target.TargetEnvironmentConfigurationKt;
import com.intellij.execution.target.TargetEnvironmentDetailsConfigurable;
import com.intellij.execution.target.TargetEnvironmentType;
import com.intellij.execution.target.TargetEnvironmentWizard;
import com.intellij.execution.target.TargetEnvironmentsManager;
import com.intellij.execution.target.TargetEnvironmentsMasterDetails;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.util.Condition;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.CommonActionsPanel;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.IconUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.UtilKt;
import com.intellij.util.text.StringKt;
import com.intellij.util.text.UniqueNameGenerator;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\b\t\n\u0002\u0010\u0000\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0005)*+,-B)\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\nH\u0002J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\n0\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00162\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\n0\u001eH\u0002J\b\u0010\u001f\u001a\u00020\u0018H\u0016J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020\n0\u0016H\u0002J\b\u0010!\u001a\u00020\u0005H\u0016J\b\u0010\"\u001a\u00020\u0005H\u0014J\b\u0010#\u001a\u00020\u001cH\u0016J\b\u0010$\u001a\u00020\u0018H\u0014J\b\u0010%\u001a\u00020\u0018H\u0016J\u0012\u0010&\u001a\u00020\u001c2\b\u0010'\u001a\u0004\u0018\u00010(H\u0014R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\u0004\u0018\u00010\n8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006."}, d2={"Lcom/intellij/execution/target/TargetEnvironmentsMasterDetails;", "Lcom/intellij/openapi/ui/MasterDetailsComponent;", "project", "Lcom/intellij/openapi/project/Project;", "initialSelectedName", "", "defaultLanguageRuntime", "Lcom/intellij/execution/target/LanguageRuntimeType;", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lcom/intellij/execution/target/LanguageRuntimeType;)V", "_lastSelectedConfig", "Lcom/intellij/execution/target/TargetEnvironmentConfiguration;", "selectedConfig", "getSelectedConfig$intellij_platform_execution_impl", "()Lcom/intellij/execution/target/TargetEnvironmentConfiguration;", "targetManager", "Lcom/intellij/execution/target/TargetEnvironmentsManager;", "getTargetManager", "()Lcom/intellij/execution/target/TargetEnvironmentsManager;", "addTargetNode", "Lcom/intellij/openapi/ui/MasterDetailsComponent$MyNode;", "target", "allTargets", "", "apply", "", "createActions", "Lcom/intellij/openapi/actionSystem/AnAction;", "fromPopup", "", "deletedTargets", "", "disposeUIResources", "getConfiguredTargets", "getDisplayName", "getEmptySelectionString", "isModified", "processRemovedItems", "reset", "wasObjectStored", "editableObject", "", "CreateNewTargetAction", "CreateNewTargetGroup", "DuplicateAction", "TargetEnvironmentNode", "TargetEnvironmentRenderer", "intellij.platform.execution.impl"})
public final class TargetEnvironmentsMasterDetails
extends MasterDetailsComponent {
    private TargetEnvironmentConfiguration _lastSelectedConfig;
    private final Project project;
    private final String initialSelectedName;
    private final LanguageRuntimeType<?> defaultLanguageRuntime;

    @Nullable
    public final TargetEnvironmentConfiguration getSelectedConfig$intellij_platform_execution_impl() {
        TargetEnvironmentConfiguration targetEnvironmentConfiguration;
        NamedConfigurable namedConfigurable = this.myCurrentConfigurable;
        Object object = namedConfigurable != null ? namedConfigurable.getEditableObject() : null;
        if (!(object instanceof TargetEnvironmentConfiguration)) {
            object = null;
        }
        if ((targetEnvironmentConfiguration = (TargetEnvironmentConfiguration)object) == null) {
            targetEnvironmentConfiguration = this._lastSelectedConfig;
        }
        return targetEnvironmentConfiguration;
    }

    private final TargetEnvironmentsManager getTargetManager() {
        return TargetEnvironmentsManager.Companion.getInstance(this.project);
    }

    @NotNull
    public String getDisplayName() {
        String string = ExecutionBundle.message((String)"targets.details.configurable.name.remote.targets", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ExecutionBundle.message(\u2026ble.name.remote.targets\")");
        return string;
    }

    @NotNull
    protected String getEmptySelectionString() {
        String string = ExecutionBundle.message((String)"targets.details.status.text.select.target.to.configure", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ExecutionBundle.message(\u2026ect.target.to.configure\")");
        return string;
    }

    public void reset() {
        block1: {
            this.myRoot.removeAllChildren();
            Iterable $this$forEach$iv = this.allTargets();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TargetEnvironmentConfiguration nextTarget = (TargetEnvironmentConfiguration)element$iv;
                boolean bl = false;
                this.addTargetNode(nextTarget);
            }
            super.reset();
            String string = this.initialSelectedName;
            if (string == null) break block1;
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            this.selectNodeInTree(this.initialSelectedName);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isModified() {
        if (this.allTargets().size() != this.getConfiguredTargets().size()) return true;
        Collection collection = this.deletedTargets();
        boolean bl = false;
        if (!collection.isEmpty()) {
            return true;
        }
        boolean bl2 = false;
        if (bl2) return true;
        if (!super.isModified()) return false;
        return true;
    }

    @NotNull
    protected List<AnAction> createActions(boolean fromPopup) {
        return CollectionsKt.mutableListOf((Object[])new AnAction[]{(AnAction)new CreateNewTargetGroup(), (AnAction)new MasterDetailsComponent.MyDeleteAction((MasterDetailsComponent)this), (AnAction)new DuplicateAction()});
    }

    protected void processRemovedItems() {
        Set<TargetEnvironmentConfiguration> deletedTargets = this.deletedTargets();
        Iterable $this$forEach$iv = deletedTargets;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TargetEnvironmentConfiguration it = (TargetEnvironmentConfiguration)element$iv;
            boolean bl = false;
            this.getTargetManager().getTargets().removeConfig((ContributedConfigurationBase)it);
        }
        super.processRemovedItems();
    }

    protected boolean wasObjectStored(@Nullable Object editableObject) {
        return CollectionsKt.contains((Iterable)this.getTargetManager().getTargets().resolvedConfigs(), (Object)editableObject);
    }

    private final Set<TargetEnvironmentConfiguration> deletedTargets() {
        return SetsKt.minus((Set)CollectionsKt.toSet((Iterable)this.allTargets()), (Iterable)this.getConfiguredTargets());
    }

    public void apply() {
        super.apply();
        List addedConfigs = CollectionsKt.minus((Iterable)this.getConfiguredTargets(), (Iterable)this.getTargetManager().getTargets().resolvedConfigs());
        Iterable $this$forEach$iv = addedConfigs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TargetEnvironmentConfiguration it = (TargetEnvironmentConfiguration)element$iv;
            boolean bl = false;
            this.getTargetManager().addTarget(it);
        }
        this.TREE_UPDATER.run();
    }

    public void disposeUIResources() {
        Object object = this.getSelectedObject();
        if (!(object instanceof TargetEnvironmentConfiguration)) {
            object = null;
        }
        this._lastSelectedConfig = (TargetEnvironmentConfiguration)object;
        super.disposeUIResources();
    }

    /*
     * WARNING - void declaration
     */
    private final List<TargetEnvironmentConfiguration> allTargets() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.getTargetManager().getTargets().resolvedConfigs();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TargetEnvironmentConfiguration it = (TargetEnvironmentConfiguration)element$iv$iv;
            boolean bl = false;
            if (!TargetEnvironmentConfigurationKt.getTargetType((TargetEnvironmentConfiguration)it).isSystemCompatible()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final MasterDetailsComponent.MyNode addTargetNode(TargetEnvironmentConfiguration target2) {
        Runnable runnable2 = this.TREE_UPDATER;
        Intrinsics.checkNotNullExpressionValue((Object)runnable2, (String)"TREE_UPDATER");
        TargetEnvironmentDetailsConfigurable configurable2 = new TargetEnvironmentDetailsConfigurable(this.project, target2, this.defaultLanguageRuntime, runnable2);
        TargetEnvironmentNode node = new TargetEnvironmentNode(target2, configurable2);
        this.addNode(node, this.myRoot);
        this.selectNodeInTree((DefaultMutableTreeNode)((Object)node));
        MasterDetailsComponent.MyNode myNode = this.myRoot;
        Intrinsics.checkNotNullExpressionValue((Object)myNode, (String)"myRoot");
        return myNode;
    }

    private final List<TargetEnvironmentConfiguration> getConfiguredTargets() {
        Enumeration enumeration = this.myRoot.children();
        Intrinsics.checkNotNullExpressionValue((Object)enumeration, (String)"myRoot.children()");
        Enumeration enumeration2 = enumeration;
        boolean bl = false;
        return SequencesKt.toList((Sequence)SequencesKt.filterNotNull((Sequence)SequencesKt.map((Sequence)SequencesKt.asSequence((Iterator)CollectionsKt.iterator((Enumeration)enumeration2)), (Function1)getConfiguredTargets.1.INSTANCE)));
    }

    @JvmOverloads
    public TargetEnvironmentsMasterDetails(@NotNull Project project, @Nullable String initialSelectedName, @Nullable LanguageRuntimeType<?> defaultLanguageRuntime) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.initialSelectedName = initialSelectedName;
        this.defaultLanguageRuntime = defaultLanguageRuntime;
        this.initTree();
        Tree tree = this.myTree;
        Intrinsics.checkNotNullExpressionValue((Object)tree, (String)"myTree");
        tree.setCellRenderer((TreeCellRenderer)((Object)new TargetEnvironmentRenderer()));
        Tree tree2 = this.myTree;
        Intrinsics.checkNotNullExpressionValue((Object)tree2, (String)"myTree");
        StatusText statusText = tree2.getEmptyText();
        Intrinsics.checkNotNullExpressionValue((Object)statusText, (String)"myTree.emptyText");
        statusText.setText("No targets added");
        Tree tree3 = this.myTree;
        Intrinsics.checkNotNullExpressionValue((Object)tree3, (String)"myTree");
        tree3.getEmptyText().appendSecondaryText(ExecutionBundle.message((String)"targets.details.status.text.add.new.target", (Object[])new Object[0]), SimpleTextAttributes.LINK_ATTRIBUTES, new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent it) {
                ActionPopupMenu actionPopupMenu = ActionManager.getInstance().createActionPopupMenu("TargetEnvironmentsConfigurable.EmptyListText", (ActionGroup)new CreateNewTargetGroup());
                Intrinsics.checkNotNullExpressionValue((Object)actionPopupMenu, (String)"ActionManager.getInstanc\u2026, CreateNewTargetGroup())");
                ActionPopupMenu popup2 = actionPopupMenu;
                Tree tree = myTree;
                Intrinsics.checkNotNullExpressionValue((Object)tree, (String)"myTree");
                StatusText statusText = tree.getEmptyText();
                Intrinsics.checkNotNullExpressionValue((Object)statusText, (String)"myTree.emptyText");
                Dimension size = statusText.getPreferredSize();
                Tree tree2 = myTree;
                Intrinsics.checkNotNullExpressionValue((Object)tree2, (String)"myTree");
                int n = tree2.getHeight();
                Tree tree3 = myTree;
                Intrinsics.checkNotNullExpressionValue((Object)tree3, (String)"myTree");
                StatusText statusText2 = tree3.getEmptyText();
                Intrinsics.checkNotNullExpressionValue((Object)statusText2, (String)"myTree.emptyText");
                int textY = n / (statusText2.isShowAboveCenter() ? 3 : 2);
                JPopupMenu jPopupMenu = popup2.getComponent();
                Component component2 = (Component)myTree;
                Tree tree4 = myTree;
                Intrinsics.checkNotNullExpressionValue((Object)tree4, (String)"myTree");
                jPopupMenu.show(component2, (tree4.getWidth() - size.width) / 2, textY + size.height);
            }
        });
        String string = KeymapUtil.getFirstKeyboardShortcutText((ShortcutSet)CommonActionsPanel.getCommonShortcut((CommonActionsPanel.Buttons)CommonActionsPanel.Buttons.ADD));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"KeymapUtil.getFirstKeybo\u2026ctionsPanel.Buttons.ADD))");
        String shortcutText = string;
        Tree tree4 = this.myTree;
        Intrinsics.checkNotNullExpressionValue((Object)tree4, (String)"myTree");
        tree4.getEmptyText().appendSecondaryText(" (" + shortcutText + ')', StatusText.DEFAULT_ATTRIBUTES, null);
    }

    public /* synthetic */ TargetEnvironmentsMasterDetails(Project project, String string, LanguageRuntimeType languageRuntimeType, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = null;
        }
        this(project, string, languageRuntimeType);
    }

    @JvmOverloads
    public TargetEnvironmentsMasterDetails(@NotNull Project project, @Nullable LanguageRuntimeType<?> defaultLanguageRuntime) {
        this(project, null, defaultLanguageRuntime, 2, null);
    }

    public static final /* synthetic */ List access$getConfiguredTargets(TargetEnvironmentsMasterDetails $this) {
        return $this.getConfiguredTargets();
    }

    public static final /* synthetic */ void access$setMyTree$p(TargetEnvironmentsMasterDetails $this, Tree tree) {
        $this.myTree = tree;
    }

    public static final /* synthetic */ void access$setSelectedNode(TargetEnvironmentsMasterDetails $this, MasterDetailsComponent.MyNode p0) {
        $this.setSelectedNode(p0);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u001b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/execution/target/TargetEnvironmentsMasterDetails$CreateNewTargetAction;", "T", "Lcom/intellij/execution/target/TargetEnvironmentConfiguration;", "Lcom/intellij/openapi/project/DumbAwareAction;", "project", "Lcom/intellij/openapi/project/Project;", "type", "Lcom/intellij/execution/target/TargetEnvironmentType;", "(Lcom/intellij/execution/target/TargetEnvironmentsMasterDetails;Lcom/intellij/openapi/project/Project;Lcom/intellij/execution/target/TargetEnvironmentType;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.platform.execution.impl"})
    private final class CreateNewTargetAction<T extends TargetEnvironmentConfiguration>
    extends DumbAwareAction {
        private final Project project;
        private final TargetEnvironmentType<T> type;

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            TargetEnvironmentConfiguration newConfig = null;
            TargetEnvironmentWizard wizard = TargetEnvironmentWizard.Companion.createWizard(this.project, this.type, TargetEnvironmentsMasterDetails.this.defaultLanguageRuntime);
            if (wizard != null) {
                if (!wizard.showAndGet()) {
                    return;
                }
                newConfig = wizard.getSubject();
            } else {
                newConfig = (TargetEnvironmentConfiguration)this.type.createDefaultConfig();
                this.type.initializeNewlyCreated((ContributedConfigurationBase)newConfig);
            }
            if (StringsKt.isBlank((CharSequence)newConfig.getDisplayName())) {
                String string = UniqueNameGenerator.generateUniqueName((String)this.type.getDisplayName(), (Condition)((Condition)new Condition<String>(this){
                    final /* synthetic */ CreateNewTargetAction this$0;

                    public final boolean value(String curName) {
                        boolean bl;
                        block3: {
                            Iterable $this$none$iv = TargetEnvironmentsMasterDetails.access$getConfiguredTargets(this.this$0.TargetEnvironmentsMasterDetails.this);
                            boolean $i$f$none = false;
                            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                                bl = true;
                            } else {
                                for (T element$iv : $this$none$iv) {
                                    TargetEnvironmentConfiguration it = (TargetEnvironmentConfiguration)element$iv;
                                    boolean bl2 = false;
                                    if (!Intrinsics.areEqual((Object)it.getDisplayName(), (Object)curName)) continue;
                                    bl = false;
                                    break block3;
                                }
                                bl = true;
                            }
                        }
                        return bl;
                    }
                    {
                        this.this$0 = createNewTargetAction;
                    }
                }));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"UniqueNameGenerator.gene\u2026me == curName }\n        }");
                newConfig.setDisplayName(string);
            }
            TargetEnvironmentsMasterDetails.this.getTargetManager().ensureUniqueName(newConfig);
            MasterDetailsComponent.MyNode newNode = TargetEnvironmentsMasterDetails.this.addTargetNode(newConfig);
            TargetEnvironmentsMasterDetails.this.selectNodeInTree((DefaultMutableTreeNode)newNode, true, true);
        }

        public CreateNewTargetAction(@NotNull Project project, TargetEnvironmentType<T> type) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(type, (String)"type");
            super(type.getDisplayName(), null, type.getIcon());
            this.project = project;
            this.type = type;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0001H\u0016J\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/execution/target/TargetEnvironmentsMasterDetails$CreateNewTargetGroup;", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "Lcom/intellij/openapi/ui/MasterDetailsComponent$ActionGroupWithPreselection;", "Lcom/intellij/openapi/project/DumbAware;", "(Lcom/intellij/execution/target/TargetEnvironmentsMasterDetails;)V", "getActionGroup", "getChildren", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;)[Lcom/intellij/openapi/actionSystem/AnAction;", "intellij.platform.execution.impl"})
    private final class CreateNewTargetGroup
    extends ActionGroup
    implements MasterDetailsComponent.ActionGroupWithPreselection,
    DumbAware {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            void $this$mapTo$iv$iv;
            TargetEnvironmentType it;
            Iterable $this$filterTo$iv$iv;
            List list2 = TargetEnvironmentType.EXTENSION_NAME.getExtensionList();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"TargetEnvironmentType.EXTENSION_NAME.extensionList");
            Iterable $this$filter$iv = list2;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (TargetEnvironmentType)element$iv$iv;
                boolean bl = false;
                if (!it.isSystemCompatible()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (TargetEnvironmentType)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Project project = TargetEnvironmentsMasterDetails.this.project;
                TargetEnvironmentType targetEnvironmentType = it;
                Intrinsics.checkNotNullExpressionValue((Object)targetEnvironmentType, (String)"it");
                CreateNewTargetAction createNewTargetAction = new CreateNewTargetAction(project, targetEnvironmentType);
                collection.add(createNewTargetAction);
            }
            Collection collection = (List)destination$iv$iv;
            Intrinsics.checkNotNullExpressionValue((Object)AnAction.EMPTY_ARRAY, (String)"AnAction.EMPTY_ARRAY");
            return (AnAction[])UtilKt.toArray((Collection)collection, (Object[])AnAction.EMPTY_ARRAY);
        }

        @NotNull
        public ActionGroup getActionGroup() {
            return this;
        }

        public CreateNewTargetGroup() {
            super(ExecutionBundle.message((String)"targets.details.action.add.text", (Object[])new Object[0]), "", IconUtil.getAddIcon());
            this.registerCustomShortcutSet(CommonActionsPanel.getCommonShortcut((CommonActionsPanel.Buttons)CommonActionsPanel.Buttons.ADD), (JComponent)TargetEnvironmentsMasterDetails.this.myTree);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\n\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002J\n\u0010\t\u001a\u0004\u0018\u00010\bH\u0002J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/execution/target/TargetEnvironmentsMasterDetails$DuplicateAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "(Lcom/intellij/execution/target/TargetEnvironmentsMasterDetails;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "duplicateSelected", "Lcom/intellij/execution/target/TargetEnvironmentConfiguration;", "getSelectedTarget", "update", "intellij.platform.execution.impl"})
    private final class DuplicateAction
    extends DumbAwareAction {
        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Presentation presentation2 = this.getTemplatePresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"templatePresentation");
            presentation2.setEnabled(this.getSelectedTarget() != null);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                TargetEnvironmentConfiguration targetEnvironmentConfiguration = this.duplicateSelected();
                if (targetEnvironmentConfiguration == null) break block0;
                TargetEnvironmentConfiguration targetEnvironmentConfiguration2 = targetEnvironmentConfiguration;
                boolean bl = false;
                boolean bl2 = false;
                TargetEnvironmentConfiguration copy2 = targetEnvironmentConfiguration2;
                boolean bl3 = false;
                TargetEnvironmentsMasterDetails.this.getTargetManager().addTarget(copy2);
                MasterDetailsComponent.MyNode newNode = TargetEnvironmentsMasterDetails.this.addTargetNode(copy2);
                TargetEnvironmentsMasterDetails.this.selectNodeInTree((DefaultMutableTreeNode)newNode, true, true);
            }
        }

        private final TargetEnvironmentConfiguration duplicateSelected() {
            TargetEnvironmentConfiguration targetEnvironmentConfiguration;
            TargetEnvironmentConfiguration targetEnvironmentConfiguration2 = this.getSelectedTarget();
            if (targetEnvironmentConfiguration2 != null) {
                TargetEnvironmentConfiguration targetEnvironmentConfiguration3 = targetEnvironmentConfiguration2;
                boolean bl = false;
                boolean bl2 = false;
                TargetEnvironmentConfiguration it = targetEnvironmentConfiguration3;
                boolean bl3 = false;
                targetEnvironmentConfiguration = (TargetEnvironmentConfiguration)TargetEnvironmentConfigurationKt.getTargetType((TargetEnvironmentConfiguration)it).duplicateConfig((ContributedConfigurationBase)it);
            } else {
                targetEnvironmentConfiguration = null;
            }
            return targetEnvironmentConfiguration;
        }

        private final TargetEnvironmentConfiguration getSelectedTarget() {
            Object object;
            MasterDetailsComponent.MyNode myNode = TargetEnvironmentsMasterDetails.this.getSelectedNode();
            if (!((myNode != null && (myNode = myNode.getConfigurable()) != null ? myNode.getEditableObject() : (object = null)) instanceof TargetEnvironmentConfiguration)) {
                object = null;
            }
            return (TargetEnvironmentConfiguration)object;
        }

        public DuplicateAction() {
            super(ExecutionBundle.message((String)"targets.details.action.duplicate.text", (Object[])new Object[0]), ExecutionBundle.message((String)"targets.details.action.duplicate.description", (Object[])new Object[0]), PlatformIcons.COPY_ICON);
            this.registerCustomShortcutSet(CommonShortcuts.getDuplicate(), (JComponent)TargetEnvironmentsMasterDetails.this.myTree);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eJ\b\u0010\u000f\u001a\u00020\bH\u0016R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/execution/target/TargetEnvironmentsMasterDetails$TargetEnvironmentNode;", "Lcom/intellij/openapi/ui/MasterDetailsComponent$MyNode;", "target", "Lcom/intellij/execution/target/TargetEnvironmentConfiguration;", "configurable", "Lcom/intellij/execution/target/TargetEnvironmentDetailsConfigurable;", "(Lcom/intellij/execution/target/TargetEnvironmentConfiguration;Lcom/intellij/execution/target/TargetEnvironmentDetailsConfigurable;)V", "configuredLanguages", "", "getConfiguredLanguages", "()Ljava/lang/String;", "computeIcon", "Ljavax/swing/Icon;", "expanded", "", "getDisplayName", "intellij.platform.execution.impl"})
    private static final class TargetEnvironmentNode
    extends MasterDetailsComponent.MyNode {
        private final TargetEnvironmentConfiguration target;

        @NotNull
        public String getDisplayName() {
            return this.target.getDisplayName();
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final String getConfiguredLanguages() {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.target.getRuntimes().resolvedConfigs();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                LanguageRuntimeConfiguration languageRuntimeConfiguration = (LanguageRuntimeConfiguration)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string = LanguageRuntimeConfigurationKt.getRuntimeType((LanguageRuntimeConfiguration)it).getDisplayName();
                collection.add(string);
            }
            return CollectionsKt.joinToString$default((Iterable)CollectionsKt.toSortedSet((Iterable)((List)destination$iv$iv)), null, null, null, (int)0, null, null, (int)63, null);
        }

        @Nullable
        public final Icon computeIcon(boolean expanded) {
            boolean bl;
            Object object = this.getConfigurable();
            if (object == null || (object = object.getIcon(expanded)) == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"this.configurable?.getIc\u2026(expanded) ?: return null");
            Object rawIcon = object;
            try {
                this.target.validateConfiguration();
                bl = true;
            }
            catch (RuntimeConfigurationException e) {
                bl = false;
            }
            boolean valid = bl;
            return valid ? rawIcon : LayeredIcon.create((Icon)rawIcon, (Icon)AllIcons.RunConfigurations.InvalidConfigurationLayer);
        }

        public TargetEnvironmentNode(@NotNull TargetEnvironmentConfiguration target2, @NotNull TargetEnvironmentDetailsConfigurable configurable2) {
            Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
            Intrinsics.checkNotNullParameter((Object)((Object)configurable2), (String)"configurable");
            super((NamedConfigurable)configurable2);
            this.target = target2;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JB\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/intellij/execution/target/TargetEnvironmentsMasterDetails$TargetEnvironmentRenderer;", "Lcom/intellij/ui/ColoredTreeCellRenderer;", "()V", "customizeCellRenderer", "", "tree", "Ljavax/swing/JTree;", "value", "", "selected", "", "expanded", "leaf", "row", "", "hasFocus", "intellij.platform.execution.impl"})
    private static final class TargetEnvironmentRenderer
    extends ColoredTreeCellRenderer {
        public void customizeCellRenderer(@NotNull JTree tree, @Nullable Object value2, boolean selected2, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            block2: {
                Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
                Object object = value2;
                if (!(object instanceof TargetEnvironmentNode)) {
                    object = null;
                }
                TargetEnvironmentNode targetEnvironmentNode = (TargetEnvironmentNode)((Object)object);
                if (targetEnvironmentNode == null) {
                    return;
                }
                TargetEnvironmentNode node = targetEnvironmentNode;
                this.setFont(UIUtil.getTreeFont());
                this.setIcon(node.computeIcon(expanded));
                this.append(node.getDisplayName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                String string = StringKt.nullize$default((String)node.getConfiguredLanguages(), (boolean)false, (int)1, null);
                if (string == null) break block2;
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String languages = string2;
                boolean bl3 = false;
                this.append("  ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
                this.append(languages, SimpleTextAttributes.GRAYED_ATTRIBUTES);
            }
        }
    }
}

