/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.applications;

import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffManagerEx;
import com.intellij.diff.DiffRequestFactory;
import com.intellij.diff.applications.DiffApplicationBase;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.chains.SimpleDiffRequestChain;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.ide.CliResult;
import com.intellij.idea.SplashManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.WindowWrapper;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.UIUtil;
import java.awt.Window;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DiffApplication
extends DiffApplicationBase {
    DiffApplication() {
        super("diff", 2, 3);
    }

    @Override
    @NotNull
    public String getUsageMessage() {
        String scriptName = ApplicationNamesInfo.getInstance().getScriptName();
        String string = DiffBundle.message((String)"diff.application.usage.parameters.and.description", (Object[])new Object[]{scriptName});
        if (string == null) {
            DiffApplication.$$$reportNull$$$0(0);
        }
        return string;
    }

    public int getRequiredModality() {
        return 3;
    }

    @Override
    @NotNull
    public Future<CliResult> processCommand(@NotNull List<String> args, @Nullable String currentDirectory) throws Exception {
        if (args == null) {
            DiffApplication.$$$reportNull$$$0(1);
        }
        List<String> filePaths = args.subList(1, args.size());
        List<VirtualFile> files2 = DiffApplication.findFilesOrThrow(filePaths, currentDirectory);
        Project project = DiffApplication.guessProject(files2);
        CompletableFuture<CliResult> future2 = new CompletableFuture<CliResult>();
        ApplicationManager.getApplication().invokeLater(() -> {
            SimpleDiffRequestChain chain = SimpleDiffRequestChain.fromProducer((DiffRequestProducer)new MyDiffRequestProducer(project, files2));
            chain.putUserData(DiffUserDataKeys.PLACE, (Object)"External");
            WindowWrapper.Mode mode = project != null ? WindowWrapper.Mode.FRAME : WindowWrapper.Mode.MODAL;
            DiffDialogHints dialogHints = new DiffDialogHints(mode, null, wrapper2 -> {
                Window window = wrapper2.getWindow();
                SplashManager.hideBeforeShow(window);
                UIUtil.runWhenWindowClosed((Window)window, () -> {
                    try {
                        for (VirtualFile file2 : files2) {
                            DiffApplication.saveIfNeeded(file2);
                        }
                    }
                    finally {
                        future2.complete(CliResult.OK);
                    }
                });
            });
            DiffManagerEx.getInstance().showDiffBuiltin(project, (DiffRequestChain)chain, dialogHints);
        });
        CompletableFuture<CliResult> completableFuture = future2;
        if (completableFuture == null) {
            DiffApplication.$$$reportNull$$$0(2);
        }
        return completableFuture;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/applications/DiffApplication";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsageMessage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/applications/DiffApplication";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "processCommand";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processCommand";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class MyDiffRequestProducer
    implements DiffRequestProducer {
        private final Project myProject;
        private final List<VirtualFile> myFiles;

        private MyDiffRequestProducer(@Nullable Project project, @NotNull List<VirtualFile> files2) {
            if (files2 == null) {
                MyDiffRequestProducer.$$$reportNull$$$0(0);
            }
            this.myProject = project;
            this.myFiles = files2;
        }

        @NotNull
        public String getName() {
            if (this.myFiles.size() == 3) {
                VirtualFile base = this.myFiles.get(2);
                if (base == null) {
                    String string = DiffBundle.message((String)"diff.files.dialog.title", (Object[])new Object[0]);
                    if (string == null) {
                        MyDiffRequestProducer.$$$reportNull$$$0(1);
                    }
                    return string;
                }
                String string = DiffRequestFactory.getInstance().getTitle(base);
                if (string == null) {
                    MyDiffRequestProducer.$$$reportNull$$$0(2);
                }
                return string;
            }
            String string = DiffRequestFactory.getInstance().getTitle(this.myFiles.get(0), this.myFiles.get(1));
            if (string == null) {
                MyDiffRequestProducer.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        public DiffRequest process(@NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException, ProcessCanceledException {
            if (context == null) {
                MyDiffRequestProducer.$$$reportNull$$$0(4);
            }
            if (indicator == null) {
                MyDiffRequestProducer.$$$reportNull$$$0(5);
            }
            if (this.myFiles.size() == 3) {
                List<VirtualFile> nonNullFiles = DiffApplicationBase.replaceNullsWithEmptyFile(this.myFiles);
                ContentDiffRequest contentDiffRequest = DiffRequestFactory.getInstance().createFromFiles(this.myProject, nonNullFiles.get(0), nonNullFiles.get(2), nonNullFiles.get(1));
                if (contentDiffRequest == null) {
                    MyDiffRequestProducer.$$$reportNull$$$0(6);
                }
                return contentDiffRequest;
            }
            ContentDiffRequest contentDiffRequest = DiffRequestFactory.getInstance().createFromFiles(this.myProject, this.myFiles.get(0), this.myFiles.get(1));
            if (contentDiffRequest == null) {
                MyDiffRequestProducer.$$$reportNull$$$0(7);
            }
            return contentDiffRequest;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "files";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/applications/DiffApplication$MyDiffRequestProducer";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/applications/DiffApplication$MyDiffRequestProducer";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "process";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 6: 
                case 7: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "process";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

