/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.quickFix;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.quickFix.NewFileLocation;
import com.intellij.codeInsight.daemon.quickFix.TargetDirectory;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtilCore;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.util.IconUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public abstract class AbstractCreateFileFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private static final int REFRESH_INTERVAL = 1000;
    protected static final String CURRENT_DIRECTORY_REF = ".";
    protected static final String PARENT_DIRECTORY_REF = "..";
    protected final String myNewFileName;
    protected final List<TargetDirectory> myDirectories;
    protected final String[] mySubPath;
    @PropertyKey(resourceBundle="messages.CodeInsightBundle")
    @NotNull
    protected final @PropertyKey(resourceBundle="messages.CodeInsightBundle") @NotNull String myKey;
    protected boolean myIsAvailable;
    protected long myIsAvailableTimeStamp;

    protected AbstractCreateFileFix(@Nullable PsiElement element2, @NotNull NewFileLocation newFileLocation, @NotNull String fixLocaleKey) {
        if (newFileLocation == null) {
            AbstractCreateFileFix.$$$reportNull$$$0(0);
        }
        if (fixLocaleKey == null) {
            AbstractCreateFileFix.$$$reportNull$$$0(1);
        }
        super(element2);
        this.myNewFileName = newFileLocation.getNewFileName();
        this.myDirectories = newFileLocation.getDirectories();
        this.mySubPath = newFileLocation.getSubPath();
        this.myKey = fixLocaleKey;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file2, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            AbstractCreateFileFix.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            AbstractCreateFileFix.$$$reportNull$$$0(3);
        }
        if (startElement == null) {
            AbstractCreateFileFix.$$$reportNull$$$0(4);
        }
        if (endElement == null) {
            AbstractCreateFileFix.$$$reportNull$$$0(5);
        }
        long current2 = System.currentTimeMillis();
        if ((ApplicationManager.getApplication().isUnitTestMode() || current2 - this.myIsAvailableTimeStamp > 1000L) && this.myDirectories.size() == 1) {
            PsiDirectory myDirectory = this.myDirectories.get(0).getDirectory();
            this.myIsAvailable &= myDirectory != null && myDirectory.getVirtualFile().findChild(this.myNewFileName) == null;
            this.myIsAvailableTimeStamp = current2;
        }
        return this.myIsAvailable;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file2, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            AbstractCreateFileFix.$$$reportNull$$$0(6);
        }
        if (file2 == null) {
            AbstractCreateFileFix.$$$reportNull$$$0(7);
        }
        if (startElement == null) {
            AbstractCreateFileFix.$$$reportNull$$$0(8);
        }
        if (endElement == null) {
            AbstractCreateFileFix.$$$reportNull$$$0(9);
        }
        if (this.isAvailable(project, null, file2)) {
            if (this.myDirectories.size() == 1) {
                this.apply(this.myStartElement.getProject(), this.myDirectories.get(0), editor);
            } else {
                List directories = ContainerUtil.filter(this.myDirectories, d -> d.getDirectory() != null);
                if (directories.isEmpty()) {
                    return;
                }
                if (editor == null || ApplicationManager.getApplication().isUnitTestMode()) {
                    this.apply(this.myStartElement.getProject(), (TargetDirectory)directories.get(0), editor);
                } else {
                    this.showOptionsPopup(project, editor, directories);
                }
            }
        }
    }

    private void apply(@NotNull Project project, @NotNull TargetDirectory directory, @Nullable Editor editor) {
        if (project == null) {
            AbstractCreateFileFix.$$$reportNull$$$0(10);
        }
        if (directory == null) {
            AbstractCreateFileFix.$$$reportNull$$$0(11);
        }
        this.myIsAvailableTimeStamp = 0L;
        PsiDirectory currentDirectory = directory.getDirectory();
        if (currentDirectory == null) {
            return;
        }
        try {
            for (String pathPart : directory.getPathToCreate()) {
                currentDirectory = AbstractCreateFileFix.findOrCreateSubdirectory(currentDirectory, pathPart);
            }
            for (String pathPart : this.mySubPath) {
                currentDirectory = AbstractCreateFileFix.findOrCreateSubdirectory(currentDirectory, pathPart);
            }
            if (currentDirectory == null) {
                if (editor != null) {
                    HintManager hintManager = HintManager.getInstance();
                    hintManager.showErrorHint(editor, CodeInsightBundle.message((String)"create.file.incorrect.path.hint", (Object[])new Object[]{this.myNewFileName}));
                }
                return;
            }
            this.apply(project, currentDirectory, editor);
        }
        catch (IncorrectOperationException e) {
            this.myIsAvailable = false;
        }
    }

    protected abstract void apply(@NotNull Project var1, @NotNull PsiDirectory var2, @Nullable Editor var3) throws IncorrectOperationException;

    @Nullable
    private static PsiDirectory findOrCreateSubdirectory(@Nullable PsiDirectory directory, @NotNull String subDirectoryName) {
        if (subDirectoryName == null) {
            AbstractCreateFileFix.$$$reportNull$$$0(12);
        }
        if (directory == null) {
            return null;
        }
        if (CURRENT_DIRECTORY_REF.equals(subDirectoryName)) {
            return directory;
        }
        if (PARENT_DIRECTORY_REF.equals(subDirectoryName)) {
            return directory.getParentDirectory();
        }
        PsiDirectory existingDirectory = directory.findSubdirectory(subDirectoryName);
        if (existingDirectory == null) {
            return directory.createSubdirectory(subDirectoryName);
        }
        return existingDirectory;
    }

    private void showOptionsPopup(final @NotNull Project project, final @NotNull Editor editor, List<TargetDirectory> directories) {
        if (project == null) {
            AbstractCreateFileFix.$$$reportNull$$$0(13);
        }
        if (editor == null) {
            AbstractCreateFileFix.$$$reportNull$$$0(14);
        }
        List<TargetDirectoryListItem> items = AbstractCreateFileFix.getTargetDirectoryListItems(directories);
        String filePath = this.myNewFileName;
        if (this.mySubPath.length > 0) {
            filePath = FileUtil.toSystemDependentName((String)(StringUtil.join((String[])this.mySubPath, (String)"/") + "/" + this.myNewFileName));
        }
        SimpleListCellRenderer renderer2 = SimpleListCellRenderer.create((label2, value2, index) -> {
            label2.setIcon(value2.getIcon());
            label2.setText(value2.getPresentablePath());
        });
        JBPopupFactory.getInstance().createPopupChooserBuilder(items).setSelectionMode(0).setTitle(CodeInsightBundle.message((String)this.myKey, (Object[])new Object[]{filePath})).setMovable(false).setResizable(false).setRequestFocus(true).setRenderer((ListCellRenderer)renderer2).setNamerForFiltering(item -> item.getPresentablePath()).setItemChosenCallback(chosenValue -> WriteCommandAction.writeCommandAction((Project)project).withName(CodeInsightBundle.message((String)"create.file.text", (Object[])new Object[]{this.myNewFileName})).run(() -> this.apply(project, chosenValue.getTarget(), editor))).addListener(new JBPopupListener(){

            public void onClosed(@NotNull LightweightWindowEvent event) {
                PsiFile file2;
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument())) != null) {
                    DaemonCodeAnalyzer.getInstance((Project)project).restart(file2);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInsight/daemon/quickFix/AbstractCreateFileFix$1", "onClosed"));
            }
        }).createPopup().showInBestPositionFor(editor);
    }

    @NotNull
    private static List<TargetDirectoryListItem> getTargetDirectoryListItems(List<TargetDirectory> directories) {
        List list2 = ContainerUtil.map(directories, targetDirectory -> {
            PsiDirectory d = targetDirectory.getDirectory();
            assert (d != null) : "Invalid PsiDirectory instances found";
            String presentablePath = AbstractCreateFileFix.getPresentableContentRootPath(d, targetDirectory.getPathToCreate());
            Icon icon2 = AbstractCreateFileFix.getContentRootIcon(d);
            return new TargetDirectoryListItem((TargetDirectory)targetDirectory, icon2, presentablePath);
        });
        if (list2 == null) {
            AbstractCreateFileFix.$$$reportNull$$$0(15);
        }
        return list2;
    }

    @NotNull
    private static Icon getContentRootIcon(@NotNull PsiDirectory directory) {
        if (directory == null) {
            AbstractCreateFileFix.$$$reportNull$$$0(16);
        }
        VirtualFile file2 = directory.getVirtualFile();
        Project project = directory.getProject();
        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)project);
        SourceFolder sourceFolder = projectFileIndex.getSourceFolder(file2);
        if (sourceFolder != null && sourceFolder.getFile() != null) {
            Icon icon2 = IconUtil.getIcon((VirtualFile)sourceFolder.getFile(), (int)0, (Project)project);
            if (icon2 == null) {
                AbstractCreateFileFix.$$$reportNull$$$0(17);
            }
            return icon2;
        }
        Icon icon3 = IconUtil.getIcon((VirtualFile)file2, (int)0, (Project)project);
        if (icon3 == null) {
            AbstractCreateFileFix.$$$reportNull$$$0(18);
        }
        return icon3;
    }

    @NotNull
    @NlsSafe
    private static String getPresentableContentRootPath(@NotNull PsiDirectory directory, String @NotNull [] pathToCreate) {
        if (directory == null) {
            AbstractCreateFileFix.$$$reportNull$$$0(19);
        }
        if (pathToCreate == null) {
            AbstractCreateFileFix.$$$reportNull$$$0(20);
        }
        VirtualFile f = directory.getVirtualFile();
        Project project = directory.getProject();
        Object path = f.getPath();
        if (pathToCreate.length > 0) {
            path = (String)path + "/" + StringUtil.join((String[])pathToCreate, (String)"/");
        }
        String presentablePath = f.getFileSystem().extractPresentableUrl((String)path);
        String string = ProjectUtilCore.displayUrlRelativeToProject((VirtualFile)f, (String)presentablePath, (Project)project, (boolean)true, (boolean)true);
        if (string == null) {
            AbstractCreateFileFix.$$$reportNull$$$0(21);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 15: 
            case 17: 
            case 18: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 15: 
            case 17: 
            case 18: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFileLocation";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixLocaleKey";
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 11: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subDirectoryName";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 15: 
            case 17: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/quickFix/AbstractCreateFileFix";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathToCreate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/quickFix/AbstractCreateFileFix";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetDirectoryListItems";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentRootIcon";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableContentRootPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findOrCreateSubdirectory";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "showOptionsPopup";
                break;
            }
            case 15: 
            case 17: 
            case 18: 
            case 21: {
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getContentRootIcon";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableContentRootPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 15: 
            case 17: 
            case 18: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class TargetDirectoryListItem {
        private final TargetDirectory myTargetDirectory;
        private final Icon myIcon;
        @Nls
        private final String myPresentablePath;

        public TargetDirectoryListItem(@NotNull TargetDirectory targetDirectory, Icon icon2, @NotNull @Nls String presentablePath) {
            if (targetDirectory == null) {
                TargetDirectoryListItem.$$$reportNull$$$0(0);
            }
            if (presentablePath == null) {
                TargetDirectoryListItem.$$$reportNull$$$0(1);
            }
            this.myTargetDirectory = targetDirectory;
            this.myIcon = icon2;
            this.myPresentablePath = presentablePath;
        }

        public Icon getIcon() {
            return this.myIcon;
        }

        @Nls
        private String getPresentablePath() {
            return this.myPresentablePath;
        }

        private TargetDirectory getTarget() {
            return this.myTargetDirectory;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "targetDirectory";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "presentablePath";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/daemon/quickFix/AbstractCreateFileFix$TargetDirectoryListItem";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

