/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.tooltips;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.TooltipAction;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface TooltipActionProvider {
    public static final ExtensionPointName<TooltipActionProvider> EP_NAME = ExtensionPointName.create((String)"com.intellij.daemon.tooltipActionProvider");
    public static final String SHOW_FIXES_KEY = "tooltips.show.actions.in.key";
    public static final boolean SHOW_FIXES_DEFAULT_VALUE = true;

    @Nullable
    public TooltipAction getTooltipAction(@NotNull HighlightInfo var1, @NotNull Editor var2, @NotNull PsiFile var3);

    @Nullable
    public static TooltipAction calcTooltipAction(@NotNull HighlightInfo info, @NotNull Editor editor) {
        if (info == null) {
            TooltipActionProvider.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            TooltipActionProvider.$$$reportNull$$$0(1);
        }
        if (!Registry.is((String)"ide.tooltip.show.with.actions")) {
            return null;
        }
        Project project = editor.getProject();
        if (project == null) {
            return null;
        }
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        if (file2 == null) {
            return null;
        }
        return EP_NAME.getExtensionList().stream().map(extension -> extension.getTooltipAction(info, editor, file2)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public static boolean isShowActions() {
        return PropertiesComponent.getInstance().getBoolean(SHOW_FIXES_KEY, true);
    }

    public static void setShowActions(boolean newValue2) {
        PropertiesComponent.getInstance().setValue(SHOW_FIXES_KEY, newValue2, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "info";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/daemon/impl/tooltips/TooltipActionProvider";
        objectArray[2] = "calcTooltipAction";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

