/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeEditor.printing;

import com.intellij.CommonBundle;
import com.intellij.codeEditor.printing.ExportToHTMLDialog;
import com.intellij.codeEditor.printing.ExportToHTMLSettings;
import com.intellij.codeEditor.printing.HTMLTextPainter;
import com.intellij.codeEditor.printing.PrintOption;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.file.PsiDirectoryFactory;
import it.unimi.dsi.fastutil.ints.Int2ObjectRBTreeMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectSortedMap;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ExportToHTMLManager {
    private static final Logger LOG = Logger.getInstance(ExportToHTMLManager.class);
    private IOException myLastException;

    ExportToHTMLManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    void executeExport(@NotNull DataContext dataContext) throws NoSuchFileException {
        block23: {
            block22: {
                if (dataContext == null) {
                    ExportToHTMLManager.$$$reportNull$$$0(0);
                }
                psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
                psiDirectory = null;
                if (psiFile != null) {
                    psiDirectory = psiFile.getContainingDirectory();
                } else {
                    psiElement = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
                    if (psiElement instanceof PsiDirectory) {
                        psiDirectory = (PsiDirectory)psiElement;
                    }
                }
                editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
                v0 = psiDirectory != null ? psiDirectory.getProject() : (project = editor != null ? editor.getProject() : (Project)CommonDataKeys.PROJECT.getData(dataContext));
                if (project == null) {
                    return;
                }
                shortFileName = null;
                directoryName = null;
                if (psiFile != null || psiDirectory != null) {
                    if (psiFile != null) {
                        shortFileName = psiFile.getVirtualFile().getName();
                        if (psiDirectory == null) {
                            psiDirectory = psiFile.getContainingDirectory();
                        }
                    }
                    if (psiDirectory != null) {
                        directoryName = psiDirectory.getVirtualFile().getPresentableUrl();
                    }
                }
                isSelectedTextEnabled = editor != null && editor.getSelectionModel().hasSelection() != false;
                exportToHTMLDialog = new ExportToHTMLDialog(shortFileName, directoryName, isSelectedTextEnabled, project);
                exportToHTMLSettings = ExportToHTMLSettings.getInstance(project);
                if (exportToHTMLSettings.OUTPUT_DIRECTORY == null) {
                    baseDir = Objects.requireNonNull(project).getBasePath();
                    exportToHTMLSettings.OUTPUT_DIRECTORY = baseDir != null ? baseDir + File.separator + "exportToHTML" : "";
                }
                exportToHTMLDialog.reset();
                if (!exportToHTMLDialog.showAndGet()) {
                    return;
                }
                try {
                    exportToHTMLDialog.apply();
                }
                catch (ConfigurationException e) {
                    Messages.showErrorDialog((Project)project, (String)e.getMessage(), (String)CommonBundle.getErrorTitle());
                }
                PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
                outDir = Paths.get(exportToHTMLSettings.OUTPUT_DIRECTORY, new String[0]);
                try {
                    if (exportToHTMLSettings.getPrintScope() == 4) ** GOTO lbl63
                    if (psiFile != null && psiFile.getText() != null) break block22;
                }
                catch (Throwable var14_19) {
                    VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)true, (boolean)false, (File[])new File[]{new File(exportToHTMLSettings.OUTPUT_DIRECTORY)});
                    throw var14_19;
                }
                VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)true, (boolean)false, (File[])new File[]{new File(exportToHTMLSettings.OUTPUT_DIRECTORY)});
                return;
            }
            try {
                textPainter = new HTMLTextPainter(psiFile, project, exportToHTMLSettings.PRINT_LINE_NUMBERS);
                if (exportToHTMLSettings.getPrintScope() == 2 && editor != null && editor.getSelectionModel().hasSelection()) {
                    firstLine = editor.getDocument().getLineNumber(editor.getSelectionModel().getSelectionStart());
                    textPainter.setSegment(editor.getSelectionModel().getSelectionStart(), editor.getSelectionModel().getSelectionEnd(), firstLine);
                }
                htmlFile = ExportToHTMLManager.doPaint(ExportToHTMLManager.constructOutputDirectory(psiFile.getContainingDirectory(), outDir), textPainter, null);
                if (exportToHTMLSettings.OPEN_IN_BROWSER) {
                    BrowserUtil.browse((Path)htmlFile);
                }
                break block23;
            }
            catch (IOException e) {
                ExportToHTMLManager.LOG.error((Throwable)e);
            }
            break block23;
lbl63:
            // 1 sources

            this.myLastException = null;
            exportRunnable = new ExportRunnable(exportToHTMLSettings, psiDirectory, outDir, project);
            ProgressManager.getInstance().runProcessWithProgressSynchronously((Runnable)exportRunnable, EditorBundle.message((String)"export.to.html.title", (Object[])new Object[0]), true, project);
            exception = this.myLastException;
            if (exception != null) {
                if (exception instanceof NoSuchFileException) {
                    throw (NoSuchFileException)exception;
                }
                ExportToHTMLManager.LOG.error((Throwable)exception);
            }
        }
        VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)true, (boolean)false, (File[])new File[]{new File(exportToHTMLSettings.OUTPUT_DIRECTORY)});
    }

    @NotNull
    private static Path doPaint(@NotNull Path outDir, @NotNull HTMLTextPainter textPainter, @Nullable Int2ObjectSortedMap<PsiReference> refMap) throws IOException {
        if (outDir == null) {
            ExportToHTMLManager.$$$reportNull$$$0(1);
        }
        if (textPainter == null) {
            ExportToHTMLManager.$$$reportNull$$$0(2);
        }
        Path htmlFile = outDir.resolve(ExportToHTMLManager.getHTMLFileName((PsiFileSystemItem)textPainter.getPsiFile()));
        try (BufferedWriter writer = Files.newBufferedWriter(htmlFile, new OpenOption[0]);){
            textPainter.paint(refMap, writer, true);
        }
        Path path = htmlFile;
        if (path == null) {
            ExportToHTMLManager.$$$reportNull$$$0(3);
        }
        return path;
    }

    private boolean exportPsiFile(@NotNull PsiFile psiFile, @NotNull Path outDir, Project project, Map<PsiFile, PsiFile> filesMap) {
        if (psiFile == null) {
            ExportToHTMLManager.$$$reportNull$$$0(4);
        }
        if (outDir == null) {
            ExportToHTMLManager.$$$reportNull$$$0(5);
        }
        if (psiFile instanceof PsiBinaryFile) {
            return true;
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            if (!psiFile.isValid()) {
                return;
            }
            Int2ObjectRBTreeMap refMap = null;
            for (PrintOption printOption : PrintOption.EP_NAME.getExtensionList()) {
                TreeMap<Integer, PsiReference> map2 = printOption.collectReferences(psiFile, filesMap);
                if (map2 == null) continue;
                refMap = new Int2ObjectRBTreeMap(map2);
            }
            try {
                ExportToHTMLManager.doPaint(ExportToHTMLManager.constructOutputDirectory(psiFile.getContainingDirectory(), outDir), new HTMLTextPainter(psiFile, project, ExportToHTMLSettings.getInstance((Project)project).PRINT_LINE_NUMBERS), refMap);
            }
            catch (NoSuchFileException e) {
                this.myLastException = e;
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        });
        return this.myLastException == null;
    }

    @NotNull
    private static Path constructOutputDirectory(@NotNull PsiDirectory directory, @NotNull Path outDir) throws IOException {
        if (directory == null) {
            ExportToHTMLManager.$$$reportNull$$$0(6);
        }
        if (outDir == null) {
            ExportToHTMLManager.$$$reportNull$$$0(7);
        }
        String qualifiedName = PsiDirectoryFactory.getInstance(directory.getProject()).getQualifiedName(directory, false);
        Path dir = outDir;
        if (!qualifiedName.isEmpty()) {
            dir = dir.resolve(qualifiedName.replace('.', File.separatorChar));
        }
        Files.createDirectories(dir, new FileAttribute[0]);
        Path path = dir;
        if (path == null) {
            ExportToHTMLManager.$$$reportNull$$$0(8);
        }
        return path;
    }

    private static void addToPsiFileList(@NotNull PsiDirectory psiDirectory, @NotNull List<PsiFile> fileList, boolean isRecursive, @NotNull Path outputDirectoryName) throws IOException {
        if (psiDirectory == null) {
            ExportToHTMLManager.$$$reportNull$$$0(9);
        }
        if (fileList == null) {
            ExportToHTMLManager.$$$reportNull$$$0(10);
        }
        if (outputDirectoryName == null) {
            ExportToHTMLManager.$$$reportNull$$$0(11);
        }
        if (!psiDirectory.isValid()) {
            return;
        }
        Collections.addAll(fileList, psiDirectory.getFiles());
        ExportToHTMLManager.generateIndexHtml(psiDirectory, isRecursive, outputDirectoryName);
        if (isRecursive) {
            for (PsiDirectory directory : psiDirectory.getSubdirectories()) {
                ExportToHTMLManager.addToPsiFileList(directory, fileList, true, outputDirectoryName);
            }
        }
    }

    private static void generateIndexHtml(PsiDirectory psiDirectory, boolean recursive, @NotNull Path outDir) throws IOException {
        if (outDir == null) {
            ExportToHTMLManager.$$$reportNull$$$0(12);
        }
        Path indexHtmlName = ExportToHTMLManager.constructOutputDirectory(psiDirectory, outDir).resolve("index.html");
        String title = PsiDirectoryFactory.getInstance(psiDirectory.getProject()).getQualifiedName(psiDirectory, true);
        try (BufferedWriter writer = Files.newBufferedWriter(indexHtmlName, new OpenOption[0]);){
            writer.write("<html><head><title>" + title + "</title></head><body>");
            if (recursive) {
                PsiDirectory[] directories;
                for (PsiDirectory psiDirectory2 : directories = psiDirectory.getSubdirectories()) {
                    writer.write("<a href=\"" + psiDirectory2.getName() + "/index.html\"><b>" + psiDirectory2.getName() + "</b></a><br />");
                }
            }
            PsiFile[] files2 = psiDirectory.getFiles();
            for (PsiDirectory psiDirectory3 : files2) {
                if (psiDirectory3 instanceof PsiBinaryFile) continue;
                writer.write("<a href=\"" + ExportToHTMLManager.getHTMLFileName((PsiFileSystemItem)psiDirectory3) + "\">" + psiDirectory3.getVirtualFile().getName() + "</a><br />");
            }
            writer.write("</body></html>");
        }
    }

    static String getHTMLFileName(@NotNull PsiFileSystemItem psiFile) {
        if (psiFile == null) {
            ExportToHTMLManager.$$$reportNull$$$0(13);
        }
        return psiFile.getVirtualFile().getNameSequence() + ".html";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outDir";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textPainter";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeEditor/printing/ExportToHTMLManager";
                break;
            }
            case 4: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiDirectory";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileList";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputDirectoryName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeEditor/printing/ExportToHTMLManager";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "doPaint";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "constructOutputDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "executeExport";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doPaint";
                break;
            }
            case 3: 
            case 8: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "exportPsiFile";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "constructOutputDirectory";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addToPsiFileList";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "generateIndexHtml";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getHTMLFileName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class ExportRunnable
    implements Runnable {
        private final ExportToHTMLSettings myExportToHTMLSettings;
        private final PsiDirectory myPsiDirectory;
        private final Path outDir;
        private final Project myProject;

        ExportRunnable(ExportToHTMLSettings exportToHTMLSettings, @NotNull PsiDirectory psiDirectory, Path outputDirectoryName, Project project) {
            if (outputDirectoryName == null) {
                ExportRunnable.$$$reportNull$$$0(0);
            }
            this.myExportToHTMLSettings = exportToHTMLSettings;
            this.myPsiDirectory = psiDirectory;
            this.outDir = outputDirectoryName;
            this.myProject = project;
        }

        @Override
        public void run() {
            ArrayList filesList = new ArrayList();
            boolean isRecursive = this.myExportToHTMLSettings.isIncludeSubdirectories();
            ApplicationManager.getApplication().runReadAction(() -> {
                try {
                    ExportToHTMLManager.addToPsiFileList(this.myPsiDirectory, filesList, isRecursive, this.outDir);
                }
                catch (IOException e) {
                    if (ExportToHTMLManager.this.myLastException == null) {
                        ExportToHTMLManager.this.myLastException = e;
                    }
                    LOG.error((Throwable)e);
                }
            });
            if (ExportToHTMLManager.this.myLastException != null) {
                return;
            }
            ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
            HashMap<PsiFile, PsiFile> filesMap = new HashMap<PsiFile, PsiFile>();
            for (PsiFile psiFile : filesList) {
                filesMap.put(psiFile, psiFile);
            }
            for (int i2 = 0; i2 < filesList.size(); ++i2) {
                PsiFile psiFile;
                psiFile = (PsiFile)filesList.get(i2);
                if (progressIndicator.isCanceled()) {
                    return;
                }
                progressIndicator.setText(EditorBundle.message((String)"export.to.html.generating.file.progress", (Object[])new Object[]{ExportToHTMLManager.getHTMLFileName((PsiFileSystemItem)psiFile)}));
                progressIndicator.setFraction((double)i2 / (double)filesList.size());
                if (ExportToHTMLManager.this.exportPsiFile(psiFile, this.outDir, this.myProject, filesMap)) continue;
                return;
            }
            if (this.myExportToHTMLSettings.OPEN_IN_BROWSER) {
                Object dirToShow = this.myExportToHTMLSettings.OUTPUT_DIRECTORY;
                if (!((String)dirToShow).endsWith(File.separator)) {
                    dirToShow = (String)dirToShow + File.separatorChar;
                }
                dirToShow = (String)dirToShow + PsiDirectoryFactory.getInstance(this.myProject).getQualifiedName(this.myPsiDirectory, false).replace('.', File.separatorChar);
                BrowserUtil.browse((String)dirToShow);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputDirectoryName", "com/intellij/codeEditor/printing/ExportToHTMLManager$ExportRunnable", "<init>"));
        }
    }
}

