/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.problemsView.toolWindow;

import com.intellij.analysis.problemsView.Problem;
import com.intellij.analysis.problemsView.toolWindow.HighlightingFileRoot;
import com.intellij.analysis.problemsView.toolWindow.HighlightingPanel$WhenMappings;
import com.intellij.analysis.problemsView.toolWindow.HighlightingPanel$sam$java_lang_Runnable$0;
import com.intellij.analysis.problemsView.toolWindow.Node;
import com.intellij.analysis.problemsView.toolWindow.ProblemNode;
import com.intellij.analysis.problemsView.toolWindow.ProblemNodeFinder;
import com.intellij.analysis.problemsView.toolWindow.ProblemsTreeModel;
import com.intellij.analysis.problemsView.toolWindow.ProblemsView;
import com.intellij.analysis.problemsView.toolWindow.ProblemsViewBundle;
import com.intellij.analysis.problemsView.toolWindow.ProblemsViewPanel;
import com.intellij.analysis.problemsView.toolWindow.ProblemsViewState;
import com.intellij.analysis.problemsView.toolWindow.Root;
import com.intellij.analysis.problemsView.toolWindow.Status;
import com.intellij.codeWithMe.ClientId;
import com.intellij.icons.AllIcons;
import com.intellij.ide.PowerSaveMode;
import com.intellij.ide.TreeExpander;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.ToggleOptionAction;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorMarkupModel;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.markup.ErrorStripeRenderer;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.SingleAlarm;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.JTree;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\t\u001a\u00020\nH\u0016J\n\u0010\u001d\u001a\u0004\u0018\u00010\nH\u0002J\b\u0010\u001e\u001a\u00020\u0015H\u0002J\u0012\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\"H\u0016J\n\u0010#\u001a\u0004\u0018\u00010$H\u0014J\u0012\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020(H\u0014J\n\u0010)\u001a\u0004\u0018\u00010*H\u0014J\b\u0010+\u001a\u00020\u0019H\u0016J\u000e\u0010,\u001a\u00020\u00192\u0006\u0010-\u001a\u00020.J\u0010\u0010/\u001a\u00020\u00192\u0006\u00100\u001a\u000201H\u0016J\u0010\u00102\u001a\u00020\u00192\u0006\u00103\u001a\u000204H\u0014J\u001a\u00105\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u00106\u001a\u000204H\u0002J\u001a\u00107\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u00106\u001a\u000204H\u0002J\b\u00108\u001a\u00020\u0019H\u0002J\b\u00109\u001a\u00020\u0019H\u0002J\b\u0010:\u001a\u00020\u0019H\u0002R(\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\t\u001a\u0004\u0018\u00010\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lcom/intellij/analysis/problemsView/toolWindow/HighlightingPanel;", "Lcom/intellij/analysis/problemsView/toolWindow/ProblemsViewPanel;", "Lcom/intellij/openapi/fileEditor/FileEditorManagerListener;", "Lcom/intellij/ide/PowerSaveMode$Listener;", "project", "Lcom/intellij/openapi/project/Project;", "state", "Lcom/intellij/analysis/problemsView/toolWindow/ProblemsViewState;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/analysis/problemsView/toolWindow/ProblemsViewState;)V", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "currentFile", "getCurrentFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "setCurrentFile", "(Lcom/intellij/openapi/vfs/VirtualFile;)V", "currentRoot", "Lcom/intellij/analysis/problemsView/toolWindow/HighlightingFileRoot;", "getCurrentRoot", "()Lcom/intellij/analysis/problemsView/toolWindow/HighlightingFileRoot;", "previousStatus", "Lcom/intellij/analysis/problemsView/toolWindow/Status;", "statusUpdateAlarm", "Lcom/intellij/util/SingleAlarm;", "fileClosed", "", "manager", "Lcom/intellij/openapi/fileEditor/FileEditorManager;", "fileOpened", "findCurrentFile", "getCurrentStatus", "getData", "", "dataId", "", "getSortFoldersFirst", "Lcom/intellij/openapi/actionSystem/ToggleOptionAction$Option;", "getToolWindowIcon", "Ljavax/swing/Icon;", "count", "", "getTreeExpander", "Lcom/intellij/ide/TreeExpander;", "powerSaveStateChanged", "selectHighlighter", "highlighter", "Lcom/intellij/openapi/editor/ex/RangeHighlighterEx;", "selectionChanged", "event", "Lcom/intellij/openapi/fileEditor/FileEditorManagerEvent;", "selectionChangedTo", "selected", "", "statusAnalyzing", "filtered", "statusComplete", "updateCurrentFile", "updateCurrentFileIfLocalId", "updateStatus", "intellij.platform.lang.impl"})
public final class HighlightingPanel
extends ProblemsViewPanel
implements FileEditorManagerListener,
PowerSaveMode.Listener {
    private final SingleAlarm statusUpdateAlarm;
    private Status previousStatus;

    @Override
    @Nullable
    protected ToggleOptionAction.Option getSortFoldersFirst() {
        return null;
    }

    @Override
    @Nullable
    protected TreeExpander getTreeExpander() {
        return null;
    }

    @Override
    @Nullable
    public Object getData(@NotNull String dataId) {
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
            return this.getCurrentFile();
        }
        return super.getData(dataId);
    }

    @Override
    @Nullable
    protected Icon getToolWindowIcon(int count) {
        boolean bl;
        block6: {
            if (ProblemsView.isProjectErrorsEnabled()) {
                return null;
            }
            HighlightingFileRoot highlightingFileRoot = this.getCurrentRoot();
            if (highlightingFileRoot == null) {
                return AllIcons.Toolwindows.ToolWindowProblemsEmpty;
            }
            HighlightingFileRoot root = highlightingFileRoot;
            Iterable $this$any$iv = root.getChildren(root.getFile());
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Integer severity;
                    Node it = (Node)((Object)element$iv);
                    boolean bl2 = false;
                    Node node = it;
                    if (!(node instanceof ProblemNode)) {
                        node = null;
                    }
                    ProblemNode problemNode = (ProblemNode)node;
                    Integer n = severity = problemNode != null ? Integer.valueOf(problemNode.getSeverity()) : null;
                    boolean bl3 = severity != null && severity >= HighlightSeverity.ERROR.myVal;
                    if (!bl3) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        boolean problem = bl;
        return problem ? AllIcons.Toolwindows.ToolWindowProblems : AllIcons.Toolwindows.ToolWindowProblemsEmpty;
    }

    @Override
    protected void selectionChangedTo(boolean selected2) {
        super.selectionChangedTo(selected2);
        if (selected2) {
            this.updateCurrentFile();
        }
    }

    public void powerSaveStateChanged() {
        this.statusUpdateAlarm.cancelAndRequest(true);
        this.updateToolWindowContent();
    }

    public void fileOpened(@NotNull FileEditorManager manager, @NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        this.updateCurrentFileIfLocalId();
    }

    public void fileClosed(@NotNull FileEditorManager manager, @NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        this.updateCurrentFileIfLocalId();
    }

    public void selectionChanged(@NotNull FileEditorManagerEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.updateCurrentFileIfLocalId();
    }

    private final void updateCurrentFileIfLocalId() {
        if (ClientId.Companion.isCurrentlyUnderLocalId()) {
            this.updateCurrentFile();
        }
    }

    private final void updateCurrentFile() {
        this.setCurrentFile(this.findCurrentFile());
    }

    @Nullable
    public final HighlightingFileRoot getCurrentRoot() {
        ProblemsTreeModel problemsTreeModel = this.getTreeModel();
        Intrinsics.checkNotNullExpressionValue((Object)problemsTreeModel, (String)"treeModel");
        Root root = problemsTreeModel.getRoot();
        if (!(root instanceof HighlightingFileRoot)) {
            root = null;
        }
        return (HighlightingFileRoot)root;
    }

    @Nullable
    public final VirtualFile getCurrentFile() {
        HighlightingFileRoot highlightingFileRoot = this.getCurrentRoot();
        return highlightingFileRoot != null ? highlightingFileRoot.getFile() : null;
    }

    public final void setCurrentFile(@Nullable VirtualFile file2) {
        if (file2 == null) {
            if (this.getCurrentRoot() == null) {
                return;
            }
            ProblemsTreeModel problemsTreeModel = this.getTreeModel();
            Intrinsics.checkNotNullExpressionValue((Object)problemsTreeModel, (String)"treeModel");
            problemsTreeModel.setRoot(null);
        } else {
            HighlightingFileRoot highlightingFileRoot = this.getCurrentRoot();
            if (Intrinsics.areEqual((Object)(highlightingFileRoot != null ? highlightingFileRoot.getFile() : null), (Object)file2)) {
                return;
            }
            ProblemsTreeModel problemsTreeModel = this.getTreeModel();
            Intrinsics.checkNotNullExpressionValue((Object)problemsTreeModel, (String)"treeModel");
            problemsTreeModel.setRoot(new HighlightingFileRoot(this, file2));
            Intrinsics.checkNotNullExpressionValue((Object)TreeUtil.promiseSelectFirstLeaf((JTree)((JTree)this.getTree())), (String)"TreeUtil.promiseSelectFirstLeaf(tree)");
        }
        this.powerSaveStateChanged();
    }

    public final void selectHighlighter(@NotNull RangeHighlighterEx highlighter) {
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        Object object = this.getCurrentRoot();
        if (object == null || (object = ((HighlightingFileRoot)object).findProblem(highlighter)) == null) {
            return;
        }
        Object problem = object;
        TreeUtil.promiseSelect((JTree)((JTree)this.getTree()), (TreeVisitor)new ProblemNodeFinder((Problem)problem));
    }

    private final VirtualFile findCurrentFile() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        if (project.isDisposed()) {
            return null;
        }
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this.getProject());
        if (fileEditorManager == null || (fileEditorManager = fileEditorManager.getSelectedEditor()) == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)fileEditorManager, (String)"FileEditorManager.getIns\u2026ctedEditor ?: return null");
        FileEditorManager fileEditor = fileEditorManager;
        VirtualFile file2 = fileEditor.getFile();
        if (file2 != null) {
            return file2;
        }
        FileEditorManager fileEditorManager2 = fileEditor;
        if (!(fileEditorManager2 instanceof TextEditor)) {
            fileEditorManager2 = null;
        }
        TextEditor textEditor = (TextEditor)fileEditorManager2;
        if (textEditor == null) {
            return null;
        }
        TextEditor textEditor2 = textEditor;
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        Editor editor = textEditor2.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"textEditor.editor");
        return fileDocumentManager.getFile(editor.getDocument());
    }

    private final void updateStatus() {
        Status status = this.getCurrentStatus();
        if (Intrinsics.areEqual((Object)this.previousStatus, (Object)status) ^ true) {
            this.previousStatus = status;
            Tree tree = this.getTree();
            Intrinsics.checkNotNullExpressionValue((Object)tree, (String)"tree");
            StatusText statusText = tree.getEmptyText();
            Intrinsics.checkNotNullExpressionValue((Object)statusText, (String)"tree.emptyText");
            statusText.setText(status.getTitle());
            CharSequence charSequence = status.getDetails();
            boolean bl = false;
            if (charSequence.length() > 0) {
                Tree tree2 = this.getTree();
                Intrinsics.checkNotNullExpressionValue((Object)tree2, (String)"tree");
                tree2.getEmptyText().appendLine(status.getDetails());
            }
        }
        if (status.getRequest()) {
            SingleAlarm.cancelAndRequest$default(this.statusUpdateAlarm, false, 1, null);
        }
    }

    private final Status getCurrentStatus() {
        Status status;
        VirtualFile virtualFile = this.getCurrentFile();
        if (virtualFile == null) {
            String string = ProblemsViewBundle.message("problems.view.highlighting.no.selected.file", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ProblemsViewBundle.messa\u2026ghting.no.selected.file\")");
            return new Status(string, null, false, 6, null);
        }
        VirtualFile file2 = virtualFile;
        if (PowerSaveMode.isEnabled()) {
            String string = ProblemsViewBundle.message("problems.view.highlighting.power.save.mode", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ProblemsViewBundle.messa\u2026ighting.power.save.mode\")");
            return new Status(string, null, false, 6, null);
        }
        Document document = ProblemsView.getDocument(this.getProject(), file2);
        if (document == null) {
            return HighlightingPanel.statusAnalyzing$default(this, file2, false, 2, null);
        }
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"ProblemsView.getDocument\u2026urn statusAnalyzing(file)");
        Document document2 = document;
        Editor editor = EditorFactory.getInstance().editors(document2, this.getProject()).findFirst().orElse(null);
        if (editor == null) {
            return HighlightingPanel.statusAnalyzing$default(this, file2, false, 2, null);
        }
        Editor editor2 = editor;
        MarkupModel markupModel = editor2.getMarkupModel();
        if (!(markupModel instanceof EditorMarkupModel)) {
            markupModel = null;
        }
        EditorMarkupModel editorMarkupModel = (EditorMarkupModel)markupModel;
        if (editorMarkupModel == null) {
            return HighlightingPanel.statusAnalyzing$default(this, file2, false, 2, null);
        }
        EditorMarkupModel model2 = editorMarkupModel;
        ErrorStripeRenderer errorStripeRenderer = model2.getErrorStripeRenderer();
        if (errorStripeRenderer == null || (errorStripeRenderer = errorStripeRenderer.getStatus()) == null) {
            return HighlightingPanel.statusComplete$default(this, file2, false, 2, null);
        }
        Intrinsics.checkNotNullExpressionValue((Object)errorStripeRenderer, (String)"model.errorStripeRendere\u2026turn statusComplete(file)");
        ErrorStripeRenderer status2 = errorStripeRenderer;
        switch (HighlightingPanel$WhenMappings.$EnumSwitchMapping$0[status2.getAnalyzingType().ordinal()]) {
            case 1: {
                status = new Status(status2.getTitle(), status2.getDetails(), true);
                break;
            }
            case 2: {
                Collection collection = this.getState().getHideBySeverity();
                boolean bl = false;
                status = this.statusComplete(file2, !collection.isEmpty());
                break;
            }
            case 3: {
                Collection collection = this.getState().getHideBySeverity();
                boolean bl = false;
                status = this.statusAnalyzing(file2, !collection.isEmpty());
                break;
            }
            default: {
                status = HighlightingPanel.statusAnalyzing$default(this, file2, false, 2, null);
            }
        }
        return status;
    }

    private final Status statusAnalyzing(VirtualFile file2, boolean filtered2) {
        String string = ProblemsViewBundle.message("problems.view.highlighting.problems.analyzing", file2.getName());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ProblemsViewBundle.messa\u2026ms.analyzing\", file.name)");
        String title = string;
        if (filtered2) {
            String string2 = ProblemsViewBundle.message("problems.view.highlighting.problems.not.found.filter", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"ProblemsViewBundle.messa\u2026oblems.not.found.filter\")");
            String details = string2;
            return new Status(title, details, true);
        }
        return new Status(title, null, true, 2, null);
    }

    static /* synthetic */ Status statusAnalyzing$default(HighlightingPanel highlightingPanel, VirtualFile virtualFile, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return highlightingPanel.statusAnalyzing(virtualFile, bl);
    }

    private final Status statusComplete(VirtualFile file2, boolean filtered2) {
        String string = ProblemsViewBundle.message("problems.view.highlighting.problems.not.found", file2.getName());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ProblemsViewBundle.messa\u2026ms.not.found\", file.name)");
        String title = string;
        if (filtered2) {
            String string2 = ProblemsViewBundle.message("problems.view.highlighting.problems.not.found.filter", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"ProblemsViewBundle.messa\u2026oblems.not.found.filter\")");
            String details = string2;
            return new Status(title, details, false, 4, null);
        }
        return new Status(title, null, false, 6, null);
    }

    static /* synthetic */ Status statusComplete$default(HighlightingPanel highlightingPanel, VirtualFile virtualFile, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return highlightingPanel.statusComplete(virtualFile, bl);
    }

    public HighlightingPanel(@NotNull Project project, @NotNull ProblemsViewState state) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        super(project, state, ProblemsViewBundle.messagePointer("problems.view.highlighting", new Object[0]));
        Function0 function0 = (Function0)new Function0<Unit>(this){

            public final void invoke() {
                HighlightingPanel.access$updateStatus((HighlightingPanel)((Object)this.receiver));
            }
        };
        Runnable runnable2 = new HighlightingPanel$sam$java_lang_Runnable$0(function0);
        ModalityState modalityState = ModalityState.stateForComponent((Component)((Component)((Object)this)));
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"stateForComponent(this)");
        this.statusUpdateAlarm = new SingleAlarm(runnable2, 200, modalityState, (Disposable)this);
        Tree tree = this.getTree();
        Intrinsics.checkNotNullExpressionValue((Object)tree, (String)"tree");
        tree.setShowsRootHandles(false);
        this.updateCurrentFile();
        project.getMessageBus().connect((Disposable)this).subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)this);
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication()");
        application.getMessageBus().connect((Disposable)this).subscribe(PowerSaveMode.TOPIC, (Object)this);
    }

    public static final /* synthetic */ void access$updateStatus(HighlightingPanel $this) {
        $this.updateStatus();
    }
}

