/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.extract.method;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrGdkMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrStatementOwner;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.refactoring.GrRefactoringError;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringBundle;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringUtil;
import org.jetbrains.plugins.groovy.refactoring.extract.ExtractUtil;
import org.jetbrains.plugins.groovy.refactoring.extract.GroovyExtractChooser;
import org.jetbrains.plugins.groovy.refactoring.extract.InitialInfo;
import org.jetbrains.plugins.groovy.refactoring.extract.ParameterInfo;
import org.jetbrains.plugins.groovy.refactoring.extract.method.ExtractMethodInfoHelper;
import org.jetbrains.plugins.groovy.refactoring.extract.method.GroovyExtractMethodDialog;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrIntroduceHandlerBase;

public class GroovyExtractMethodHandler
implements RefactoringActionHandler {
    private static final Logger LOG = Logger.getInstance(GroovyExtractMethodHandler.class);

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, @Nullable DataContext dataContext) {
        if (project == null) {
            GroovyExtractMethodHandler.$$$reportNull$$$0(0);
        }
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        SelectionModel model = editor.getSelectionModel();
        if (model.hasSelection()) {
            this.invokeImpl(project, editor, file, model.getSelectionStart(), model.getSelectionEnd());
        } else {
            List<GrExpression> expressions = GrIntroduceHandlerBase.collectExpressions(file, editor, editor.getCaretModel().getOffset(), true);
            Callback callback = new Callback(project, editor, file);
            if (expressions.size() == 1) {
                callback.pass(expressions.get(0));
            } else if (expressions.isEmpty()) {
                model.selectLineAtCaret();
                this.invokeImpl(project, editor, file, model.getSelectionStart(), model.getSelectionEnd());
            } else {
                IntroduceTargetChooser.showChooser((Editor)editor, expressions, (Pass)callback, GrIntroduceHandlerBase.GR_EXPRESSION_RENDERER);
            }
        }
    }

    private void invokeImpl(Project project, Editor editor, PsiFile file, int startOffset, int endOffset) {
        try {
            InitialInfo initialInfo = GroovyExtractChooser.invoke(project, editor, file, startOffset, endOffset, true);
            if (GroovyExtractMethodHandler.findConflicts(initialInfo)) {
                return;
            }
            this.performRefactoring(initialInfo, editor);
        }
        catch (GrRefactoringError e) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)e.getMessage(), (String)GroovyExtractMethodHandler.getRefactoringName(), (String)"refactoring.extractMethod");
        }
    }

    private static boolean findConflicts(InitialInfo info) {
        GrStatement[] statements2;
        final MultiMap conflicts = new MultiMap();
        final PsiElement declarationOwner = info.getContext().getParent();
        GroovyRecursiveElementVisitor visitor2 = new GroovyRecursiveElementVisitor(){

            @Override
            public void visitReferenceExpression(@NotNull GrReferenceExpression referenceExpression) {
                if (referenceExpression == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitReferenceExpression(referenceExpression);
                GroovyResolveResult resolveResult2 = referenceExpression.advancedResolve();
                PsiElement resolveContext = resolveResult2.getCurrentFileResolveContext();
                if (!(resolveContext == null || resolveContext instanceof GrImportStatement || PsiTreeUtil.isAncestor((PsiElement)declarationOwner, (PsiElement)resolveContext, (boolean)true) || this.skipResult(resolveResult2))) {
                    conflicts.putValue((Object)referenceExpression, (Object)GroovyRefactoringBundle.message("ref.0.will.not.be.resolved.outside.of.current.context", referenceExpression.getText()));
                }
            }

            private boolean skipResult(GroovyResolveResult result2) {
                PsiElement element = result2.getElement();
                if (element instanceof PsiMethod) {
                    PsiClass aClass;
                    String name = ((PsiMethod)element).getName();
                    if (!name.startsWith("print")) {
                        return false;
                    }
                    if (element instanceof GrGdkMethod) {
                        element = ((GrGdkMethod)element).getStaticMethod();
                    }
                    if ((aClass = ((PsiMethod)element).getContainingClass()) != null) {
                        String qname = aClass.getQualifiedName();
                        return "org.codehaus.groovy.runtime.DefaultGroovyMethods".equals(qname);
                    }
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "org/jetbrains/plugins/groovy/refactoring/extract/method/GroovyExtractMethodHandler$1", "visitReferenceExpression"));
            }
        };
        for (GrStatement statement : statements2 = info.getStatements()) {
            statement.accept(visitor2);
        }
        return !BaseRefactoringProcessor.processConflicts((Project)info.getProject(), (MultiMap)conflicts);
    }

    private void performRefactoring(@NotNull InitialInfo initialInfo, @Nullable Editor editor) {
        PsiClass owner;
        if (initialInfo == null) {
            GroovyExtractMethodHandler.$$$reportNull$$$0(1);
        }
        LOG.assertTrue((owner = PsiUtil.getContextClass(initialInfo.getContext())) != null);
        ExtractMethodInfoHelper helper = this.getSettings(initialInfo, owner);
        if (helper == null) {
            return;
        }
        CommandProcessor.getInstance().executeCommand(helper.getProject(), () -> WriteAction.run(() -> {
            GroovyExtractMethodHandler.createMethod(helper, owner);
            GrStatementOwner declarationOwner = helper.getStringPartInfo() == null ? GroovyRefactoringUtil.getDeclarationOwner(helper.getStatements()[0]) : null;
            GrStatement realStatement = ExtractUtil.replaceStatement(declarationOwner, helper);
            if (editor != null) {
                PsiDocumentManager.getInstance((Project)helper.getProject()).commitDocument(editor.getDocument());
                editor.getSelectionModel().removeSelection();
                editor.getCaretModel().moveToOffset(ExtractUtil.getCaretOffset(realStatement));
            }
        }), GroovyExtractMethodHandler.getRefactoringName(), null);
    }

    private static void createMethod(ExtractMethodInfoHelper helper, PsiClass owner) {
        GrMethod method = ExtractUtil.createMethod(helper);
        PsiElement anchor = GroovyExtractMethodHandler.calculateAnchorToInsertBefore(owner, helper.getContext());
        GrMethod newMethod = (GrMethod)owner.addBefore((PsiElement)method, anchor);
        GroovyExtractMethodHandler.renameParameterOccurrences(newMethod, helper);
        JavaCodeStyleManager.getInstance((Project)newMethod.getProject()).shortenClassReferences((PsiElement)newMethod);
        PsiElement prev = newMethod.getPrevSibling();
        if (!PsiUtil.isLineFeed(prev)) {
            newMethod.getParent().getNode().addLeaf(GroovyTokenTypes.mNLS, (CharSequence)"\n", newMethod.getNode());
        }
    }

    @Nullable
    protected ExtractMethodInfoHelper getSettings(@NotNull InitialInfo initialInfo, PsiClass owner) {
        GroovyExtractMethodDialog dialog;
        if (initialInfo == null) {
            GroovyExtractMethodHandler.$$$reportNull$$$0(2);
        }
        if (!(dialog = new GroovyExtractMethodDialog(initialInfo, owner)).showAndGet()) {
            return null;
        }
        return dialog.getHelper();
    }

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, DataContext dataContext) {
        if (project == null) {
            GroovyExtractMethodHandler.$$$reportNull$$$0(3);
        }
        if (elements == null) {
            GroovyExtractMethodHandler.$$$reportNull$$$0(4);
        }
    }

    @Nullable
    private static PsiElement calculateAnchorToInsertBefore(PsiClass owner, PsiElement startElement) {
        while (startElement != null && !GroovyExtractMethodHandler.isEnclosingDefinition(owner, startElement)) {
            if (startElement.getParent() instanceof GroovyFile) {
                return startElement.getNextSibling();
            }
            PsiElement parent2 = (startElement = startElement.getParent()).getParent();
            if (!(parent2 instanceof GroovyFile) || ((GroovyFile)parent2).getScriptClass() != owner) continue;
            return startElement.getNextSibling();
        }
        return startElement == null ? null : startElement.getNextSibling();
    }

    private static boolean isEnclosingDefinition(PsiClass owner, PsiElement startElement) {
        if (owner instanceof GrTypeDefinition) {
            GrTypeDefinition definition = (GrTypeDefinition)owner;
            return startElement.getParent() == definition.getBody();
        }
        return false;
    }

    private static void renameParameterOccurrences(GrMethod method, ExtractMethodInfoHelper helper) throws IncorrectOperationException {
        GrOpenBlock block = method.getBlock();
        if (block == null) {
            return;
        }
        GrStatement[] statements2 = block.getStatements();
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(helper.getProject());
        for (ParameterInfo info : helper.getParameterInfos()) {
            final String oldName = info.getOriginalName();
            String newName = info.getName();
            final ArrayList result2 = new ArrayList();
            if (oldName.equals(newName)) continue;
            for (GrStatement statement : statements2) {
                statement.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(){

                    public void visitElement(@NotNull PsiElement element) {
                        GrReferenceExpression expr;
                        if (element == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        super.visitElement(element);
                        if (element instanceof GrReferenceExpression && !(expr = (GrReferenceExpression)element).isQualified() && oldName.equals(expr.getReferenceName())) {
                            result2.add(expr);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/refactoring/extract/method/GroovyExtractMethodHandler$2", "visitElement"));
                    }
                });
                for (GrExpression expr : result2) {
                    expr.replaceWithExpression(factory.createExpressionFromText(newName), false);
                }
            }
        }
    }

    @Nls(capitalization=Nls.Capitalization.Title)
    static String getRefactoringName() {
        return GroovyRefactoringBundle.message("extract.method.title", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialInfo";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/refactoring/extract/method/GroovyExtractMethodHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "performRefactoring";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getSettings";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private final class Callback
    extends Pass<GrExpression> {
        private final Project project;
        private final Editor editor;
        private final PsiFile file;

        private Callback(Project project, Editor editor, PsiFile file) {
            this.project = project;
            this.editor = editor;
            this.file = file;
        }

        public void pass(@NotNull GrExpression selectedValue) {
            if (selectedValue == null) {
                Callback.$$$reportNull$$$0(0);
            }
            TextRange range = selectedValue.getTextRange();
            GroovyExtractMethodHandler.this.invokeImpl(this.project, this.editor, this.file, range.getStartOffset(), range.getEndOffset());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedValue", "org/jetbrains/plugins/groovy/refactoring/extract/method/GroovyExtractMethodHandler$Callback", "pass"));
        }
    }
}

