/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.mvc;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.libraries.AddCustomLibraryDialog;
import com.intellij.openapi.roots.ui.configuration.libraries.CustomLibraryDescription;
import com.intellij.openapi.roots.ui.configuration.libraries.LibraryPresentationManager;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainerFactory;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.config.GroovyLibraryDescription;
import org.jetbrains.plugins.groovy.mvc.MvcActionBase;
import org.jetbrains.plugins.groovy.mvc.MvcFramework;
import org.jetbrains.plugins.groovy.mvc.MvcModuleStructureUtil;

public class MvcUpgradeAction
extends MvcActionBase {
    @Override
    protected void actionPerformed(@NotNull AnActionEvent e, @NotNull Module module, @NotNull MvcFramework framework) {
        if (e == null) {
            MvcUpgradeAction.$$$reportNull$$$0(0);
        }
        if (module == null) {
            MvcUpgradeAction.$$$reportNull$$$0(1);
        }
        if (framework == null) {
            MvcUpgradeAction.$$$reportNull$$$0(2);
        }
        GroovyLibraryDescription description = framework.createLibraryDescription();
        AddCustomLibraryDialog dialog = AddCustomLibraryDialog.createDialog((CustomLibraryDescription)description, (Module)module, modifiableRootModel -> MvcUpgradeAction.removeOldMvcSdk(framework, modifiableRootModel));
        dialog.setTitle(GroovyBundle.message("mvc.framework.0.change.sdk.version.title", framework.getDisplayName()));
        if (dialog.showAndGet()) {
            module.putUserData(MvcFramework.UPGRADE, (Object)Boolean.TRUE);
            module.putUserData(MvcModuleStructureUtil.LAST_MVC_VERSION, null);
        }
    }

    public static void removeOldMvcSdk(MvcFramework framework, ModifiableRootModel model) {
        LibraryPresentationManager presentationManager = LibraryPresentationManager.getInstance();
        for (OrderEntry entry : model.getOrderEntries()) {
            VirtualFile[] files;
            if (!(entry instanceof LibraryOrderEntry)) continue;
            Library library = ((LibraryOrderEntry)entry).getLibrary();
            LibrariesContainer container = LibrariesContainerFactory.createContainer((ModifiableRootModel)model);
            if (library == null || !presentationManager.isLibraryOfKind(Arrays.asList(files = container.getLibraryFiles(library, OrderRootType.CLASSES)), framework.getLibraryKind())) continue;
            model.removeOrderEntry(entry);
        }
    }

    @Override
    protected void updateView(AnActionEvent event, @NotNull MvcFramework framework, @NotNull Module module) {
        if (framework == null) {
            MvcUpgradeAction.$$$reportNull$$$0(3);
        }
        if (module == null) {
            MvcUpgradeAction.$$$reportNull$$$0(4);
        }
        event.getPresentation().setEnabledAndVisible(framework.isUpgradeActionSupported(module));
        event.getPresentation().setIcon(framework.getIcon());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "framework";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/mvc/MvcUpgradeAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "updateView";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

