/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.util;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0019\n\u0002\u0010\f\n\u0002\b\u0003\u001a\u001c\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\n\u0010\u0004\u001a\u00020\u0005\"\u00020\u0006H\u0002\u001a\u000e\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\t"}, d2={"isValidContent", "", "text", "", "escapedChars", "", "", "isValidDoubleQuotedStringContent", "isValidSingleQuotedStringContent", "intellij.groovy.psi"})
public final class StringUtilKt {
    public static final boolean isValidSingleQuotedStringContent(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return StringUtilKt.isValidContent(text, '\'', '\n');
    }

    public static final boolean isValidDoubleQuotedStringContent(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return StringUtilKt.isValidContent(text, '\"', '$', '\n');
    }

    private static final boolean isValidContent(String text, char ... escapedChars) {
        int length = text.length();
        int idx = 0;
        while (idx < length) {
            char nextCh;
            char ch = text.charAt(idx);
            if (ArraysKt.contains((char[])escapedChars, (char)ch)) {
                return false;
            }
            if (ch == '\\' && idx + 1 < length && ((nextCh = text.charAt(idx + 1)) == '\\' || ArraysKt.contains((char[])escapedChars, (char)nextCh))) {
                idx += 2;
                continue;
            }
            ++idx;
        }
        return true;
    }
}

