/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion.closureParameters;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.impl.compiled.ClsMethodImpl;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.completion.closureParameters.ClosureParameterInfo;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrSignature;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrClosureSignatureUtil;

public class ClosureDescriptor {
    private final List<ClosureParameterInfo> myParams = new ArrayList<ClosureParameterInfo>();
    private Map myMethod;
    @NonNls
    private static final String KEY_NAME = "name";
    @NonNls
    private static final String KEY_PARAMS = "params";
    @NonNls
    private static final String KEY_CONSTRUCTOR = "constructor";

    public List<ClosureParameterInfo> getParameters() {
        return Collections.unmodifiableList(this.myParams);
    }

    public void addParameter(@Nullable @NlsSafe String type2, @NlsSafe String name) {
        this.myParams.add(new ClosureParameterInfo(type2, name));
    }

    public void setMethod(Map method) {
        this.myMethod = method;
    }

    public boolean isMethodApplicable(PsiMethod method, GroovyPsiElement place) {
        String name = String.valueOf(this.myMethod.get(KEY_NAME));
        if (name == null || !name.equals(method.getName())) {
            return false;
        }
        ArrayList<PsiType> types = new ArrayList<PsiType>();
        Object params = this.myMethod.get(KEY_PARAMS);
        if (params instanceof Map) {
            boolean first = true;
            for (Object paramName : ((Map)params).keySet()) {
                Object value = ((Map)params).get(paramName);
                boolean isNamed = first && value instanceof List;
                first = false;
                String typeName = isNamed ? "java.util.Map" : String.valueOf(value);
                types.add(ClosureDescriptor.convertToPsiType(typeName, place));
            }
        } else if (params instanceof List) {
            for (Object param : (List)params) {
                PsiTypeParameterList typeParameterList = method.getTypeParameterList();
                types.add(ClosureDescriptor.convertToPsiType(String.valueOf(param), (PsiElement)(typeParameterList != null ? typeParameterList : method)));
            }
        }
        boolean isConstructor = Boolean.TRUE.equals(this.myMethod.get(KEY_CONSTRUCTOR));
        MethodSignature signature = MethodSignatureUtil.createMethodSignature((String)name, (PsiType[])types.toArray(PsiType.createArray((int)types.size())), (PsiTypeParameter[])method.getTypeParameters(), (PsiSubstitutor)PsiSubstitutor.EMPTY, (boolean)isConstructor);
        GrSignature closureSignature = GrClosureSignatureUtil.createSignature(signature);
        if (method instanceof ClsMethodImpl) {
            method = ((ClsMethodImpl)method).getSourceMirrorMethod();
        }
        Object[] parameters2 = method.getParameterList().getParameters();
        PsiType[] typeArray = (PsiType[])ContainerUtil.map((Object[])parameters2, parameter -> parameter.getType(), (Object[])PsiType.createArray((int)parameters2.length));
        return GrClosureSignatureUtil.isSignatureApplicable(Collections.singletonList(closureSignature), typeArray, place);
    }

    private static PsiType convertToPsiType(@NlsSafe String type2, @NotNull PsiElement place) {
        if (place == null) {
            ClosureDescriptor.$$$reportNull$$$0(0);
        }
        return JavaPsiFacade.getElementFactory((Project)place.getProject()).createTypeFromText(type2, place);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/plugins/groovy/lang/completion/closureParameters/ClosureDescriptor", "convertToPsiType"));
    }
}

