/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.util.PairProcessor;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.plugins.groovy.dsl.GroovyClassDescriptor;
import org.jetbrains.plugins.groovy.dsl.GroovyDslFileIndex;
import org.jetbrains.plugins.groovy.dsl.holders.CustomMembersHolder;
import org.jetbrains.plugins.groovy.lang.completion.ClosureCompleter;
import org.jetbrains.plugins.groovy.lang.completion.closureParameters.ClosureDescriptor;
import org.jetbrains.plugins.groovy.lang.completion.closureParameters.ClosureParameterInfo;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;

public class GdslClosureCompleter
extends ClosureCompleter {
    @Override
    protected List<ClosureParameterInfo> getParameterInfos(InsertionContext context, PsiMethod method, PsiSubstitutor substitutor, PsiElement place) {
        ArrayList<ClosureDescriptor> descriptors = new ArrayList<ClosureDescriptor>();
        GrReferenceExpression ref = (GrReferenceExpression)place;
        PsiType qtype = PsiImplUtil.getQualifierType(ref);
        if (qtype == null) {
            return null;
        }
        GrExpression qualifier = (GrExpression)ref.getQualifier();
        if (qualifier != null) {
            PsiType type2 = qualifier.getType();
            if (type2 == null) {
                return null;
            }
            GdslClosureCompleter.processExecutors(qtype, ref, descriptors);
        } else {
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)context.getProject());
            for (PsiElement parent2 = ref.getParent(); parent2 != null; parent2 = parent2.getParent()) {
                if (parent2 instanceof GrClosableBlock) {
                    GdslClosureCompleter.processExecutors((PsiType)TypesUtil.createTypeByFQClassName("groovy.lang.Closure", ref), ref, descriptors);
                    continue;
                }
                if (!(parent2 instanceof GrTypeDefinition)) continue;
                GdslClosureCompleter.processExecutors((PsiType)factory.createType((PsiClass)((GrTypeDefinition)parent2), PsiType.EMPTY_ARRAY), ref, descriptors);
            }
        }
        for (ClosureDescriptor descriptor : descriptors) {
            if (!descriptor.isMethodApplicable(method, ref)) continue;
            return descriptor.getParameters();
        }
        return null;
    }

    private static void processExecutors(PsiType qtype, GrReferenceExpression ref, List<ClosureDescriptor> descriptors) {
        GroovyDslFileIndex.processExecutors(qtype, ref, (PairProcessor<? super CustomMembersHolder, ? super GroovyClassDescriptor>)((PairProcessor)(holder, descriptor) -> {
            holder.consumeClosureDescriptors((GroovyClassDescriptor)descriptor, descriptors::add);
            return true;
        }));
    }
}

