/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.dsl.holders;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.dsl.CustomMembersGenerator;
import org.jetbrains.plugins.groovy.dsl.GroovyClassDescriptor;
import org.jetbrains.plugins.groovy.dsl.holders.CustomMembersHolder;
import org.jetbrains.plugins.groovy.dsl.holders.DeclarationType;
import org.jetbrains.plugins.groovy.extensions.NamedArgumentDescriptor;
import org.jetbrains.plugins.groovy.lang.completion.closureParameters.ClosureDescriptor;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightMethodBuilder;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightVariable;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public class NonCodeMembersHolder
implements CustomMembersHolder {
    private static final Logger LOG = Logger.getInstance(NonCodeMembersHolder.class);
    public static final Key<String> DOCUMENTATION = Key.create((String)"GdslDocumentation");
    public static final Key<String> DOCUMENTATION_URL = Key.create((String)"GdslDocumentationUrl");
    private final List<PsiVariable> myVariables = new ArrayList<PsiVariable>();
    private final List<PsiMethod> myMethods = new ArrayList<PsiMethod>();
    private final List<ClosureDescriptor> myClosureDescriptors = new ArrayList<ClosureDescriptor>();

    public static NonCodeMembersHolder generateMembers(List<Map> methods, PsiFile place) {
        Map map2 = (Map)CachedValuesManager.getCachedValue((PsiElement)place, () -> {
            ConcurrentMap map1 = ContainerUtil.createConcurrentSoftMap();
            return CachedValueProvider.Result.create((Object)map1, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
        NonCodeMembersHolder result2 = (NonCodeMembersHolder)map2.get(methods);
        if (result2 == null) {
            result2 = new NonCodeMembersHolder(methods, (PsiElement)place);
            map2.put(methods, result2);
        }
        return result2;
    }

    public NonCodeMembersHolder() {
    }

    private NonCodeMembersHolder(List<Map> data, PsiElement place) {
        PsiManager manager = place.getManager();
        for (Map prop : data) {
            Object decltype = prop.get("declarationType");
            if (decltype == DeclarationType.CLOSURE) {
                ClosureDescriptor closureDescriptor = NonCodeMembersHolder.createClosureDescriptor(prop);
                if (closureDescriptor == null) continue;
                this.myClosureDescriptors.add(closureDescriptor);
                continue;
            }
            if (decltype == DeclarationType.VARIABLE) {
                this.myVariables.add(NonCodeMembersHolder.createVariable(prop, place, manager));
                continue;
            }
            this.myMethods.add(NonCodeMembersHolder.createMethod(prop, place, manager));
        }
    }

    public void addDeclaration(@NotNull PsiElement element) {
        if (element == null) {
            NonCodeMembersHolder.$$$reportNull$$$0(0);
        }
        if (element instanceof PsiMethod) {
            this.myMethods.add((PsiMethod)element);
        } else if (element instanceof PsiVariable) {
            this.myVariables.add((PsiVariable)element);
        } else {
            LOG.error("Unknown declaration: " + element);
        }
    }

    private static PsiVariable createVariable(Map prop, PsiElement place, PsiManager manager) {
        String name = String.valueOf(prop.get("name"));
        String type2 = String.valueOf(prop.get("type"));
        return new GrLightVariable(manager, name, type2, Collections.emptyList(), (PsiElement)place.getContainingFile());
    }

    @Nullable
    private static ClosureDescriptor createClosureDescriptor(@NonNls Map prop) {
        ClosureDescriptor closure = new ClosureDescriptor();
        Object method = prop.get("method");
        if (!(method instanceof Map)) {
            return null;
        }
        closure.setMethod((Map)method);
        Object closureParams = prop.get("params");
        if (closureParams instanceof Map) {
            boolean first = true;
            for (Object paramName : ((Map)closureParams).keySet()) {
                Object value = ((Map)closureParams).get(paramName);
                boolean isNamed = first && value instanceof List;
                first = false;
                String typeName = isNamed ? "java.util.Map" : String.valueOf(value);
                closure.addParameter(typeName, String.valueOf(paramName));
            }
        }
        return closure;
    }

    private static GrLightMethodBuilder createMethod(@NonNls Map prop, PsiElement place, PsiManager manager) {
        PsiClass foundClass;
        Object qName;
        Object docUrl;
        Object doc;
        Object toThrow;
        Object bindsTo;
        String name = String.valueOf(prop.get("name"));
        GrLightMethodBuilder method = new GrLightMethodBuilder(manager, name).addModifier("public");
        if (Boolean.TRUE.equals(prop.get("constructor"))) {
            method.setConstructor(true);
        } else {
            method.setReturnType(NonCodeMembersHolder.convertToPsiType(String.valueOf(prop.get("type")), place));
        }
        Object params = prop.get("params");
        if (params instanceof Map) {
            boolean first = true;
            for (Object paramName : ((Map)params).keySet()) {
                Object value = ((Map)params).get(paramName);
                boolean isNamed = first && value instanceof List;
                first = false;
                String typeName = isNamed ? "java.util.Map" : String.valueOf(value);
                method.addParameter(String.valueOf(paramName), NonCodeMembersHolder.convertToPsiType(typeName, place));
                if (!isNamed) continue;
                HashMap<String, NamedArgumentDescriptor> namedParams = new HashMap<String, NamedArgumentDescriptor>();
                for (Object o : (List)value) {
                    if (!(o instanceof CustomMembersGenerator.ParameterDescriptor)) continue;
                    namedParams.put(((CustomMembersGenerator.ParameterDescriptor)o).name, ((CustomMembersGenerator.ParameterDescriptor)o).descriptor);
                }
                method.setNamedParameters(namedParams);
            }
        }
        if (Boolean.TRUE.equals(prop.get("isStatic"))) {
            method.addModifier("static");
        }
        if ((bindsTo = prop.get("bindsTo")) instanceof PsiElement) {
            method.setNavigationElement((PsiElement)bindsTo);
        }
        if ((toThrow = prop.get("throws")) instanceof List) {
            for (Object o : (List)toThrow) {
                PsiType psiType = NonCodeMembersHolder.convertToPsiType(String.valueOf(o), place);
                if (!(psiType instanceof PsiClassType)) continue;
                method.addException((PsiClassType)psiType);
            }
        }
        if ((doc = prop.get("doc")) instanceof String) {
            method.putUserData(DOCUMENTATION, (String)doc);
        }
        if ((docUrl = prop.get("docUrl")) instanceof String) {
            method.putUserData(DOCUMENTATION_URL, (String)docUrl);
        }
        if ((qName = prop.get("containingClass")) instanceof String && (foundClass = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass((String)qName, place.getResolveScope())) != null) {
            method.setContainingClass(foundClass);
        }
        return method;
    }

    private static PsiType convertToPsiType(String type2, PsiElement place) {
        return JavaPsiFacade.getElementFactory((Project)place.getProject()).createTypeFromText(type2, place);
    }

    @Override
    public boolean processMembers(GroovyClassDescriptor descriptor, PsiScopeProcessor _processor, ResolveState state) {
        String hint = ResolveUtil.getNameHint(_processor);
        ElementClassHint classHint = (ElementClassHint)_processor.getHint(ElementClassHint.KEY);
        if (ResolveUtil.shouldProcessMethods(classHint)) {
            for (PsiMethod psiMethod : this.myMethods) {
                if (!NonCodeMembersHolder.checkName(hint, (PsiNamedElement)psiMethod) || _processor.execute((PsiElement)psiMethod, state)) continue;
                return false;
            }
        }
        if (ResolveUtil.shouldProcessProperties(classHint)) {
            for (PsiVariable psiVariable : this.myVariables) {
                if (!NonCodeMembersHolder.checkName(hint, (PsiNamedElement)psiVariable) || _processor.execute((PsiElement)psiVariable, state)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean checkName(String hint, PsiNamedElement declaration) {
        if (hint != null && !NonCodeMembersHolder.isConstructor((PsiElement)declaration)) {
            return hint.equals(declaration.getName());
        }
        return true;
    }

    private static boolean isConstructor(PsiElement declaration) {
        return declaration instanceof PsiMethod && ((PsiMethod)declaration).isConstructor();
    }

    @Override
    public void consumeClosureDescriptors(GroovyClassDescriptor descriptor, Consumer<? super ClosureDescriptor> consumer) {
        this.myClosureDescriptors.forEach(consumer);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/dsl/holders/NonCodeMembersHolder", "addDeclaration"));
    }
}

