/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.compiler;

import com.intellij.DynamicBundle;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Locale;
import java.util.Objects;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.StyleContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.incremental.groovy.GreclipseSettings;
import org.jetbrains.plugins.groovy.GroovyBundle;

public class GreclipseConfigurable
implements Configurable {
    private final GreclipseSettings mySettings;
    private TextFieldWithBrowseButton myJarPath;
    private RawCommandLineEditor myCmdLineParams;
    private JBCheckBox myGenerateDebugInfo;
    private JPanel myPanel;

    public GreclipseConfigurable(GreclipseSettings settings) {
        this.mySettings = settings;
        this.$$$setupUI$$$();
        FileChooserDescriptor descriptor = new FileChooserDescriptor(false, false, true, true, false, false);
        this.myJarPath.addBrowseFolderListener(null, GroovyBundle.message("configurable.greclipse.path.chooser.description", new Object[0]), null, descriptor);
    }

    public String getDisplayName() {
        return null;
    }

    @Nullable
    public JComponent createComponent() {
        return this.myPanel;
    }

    public boolean isModified() {
        return !Objects.equals(this.getExternalizableJarPath(), this.mySettings.greclipsePath) || !Objects.equals(this.myCmdLineParams.getText(), this.mySettings.cmdLineParams) || !Comparing.equal((Object)this.myGenerateDebugInfo.isSelected(), (Object)this.mySettings.debugInfo);
    }

    public void apply() throws ConfigurationException {
        this.mySettings.greclipsePath = this.getExternalizableJarPath();
        this.mySettings.cmdLineParams = this.myCmdLineParams.getText();
        this.mySettings.debugInfo = this.myGenerateDebugInfo.isSelected();
    }

    @NotNull
    private String getExternalizableJarPath() {
        String string = FileUtil.toSystemIndependentName((String)this.myJarPath.getText());
        if (string == null) {
            GreclipseConfigurable.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void reset() {
        this.myJarPath.setText(FileUtil.toSystemDependentName((String)this.mySettings.greclipsePath));
        this.myCmdLineParams.setText(this.mySettings.cmdLineParams);
        this.myGenerateDebugInfo.setSelected(this.mySettings.debugInfo);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/compiler/GreclipseConfigurable", "getExternalizableJarPath"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        RawCommandLineEditor rawCommandLineEditor;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/GroovyBundle", GreclipseConfigurable.class).getString("configurable.greclipse.border.title"), (int)0, (int)0, (Font)this.$$$getFont$$$(null, -1, -1, jPanel.getFont()), null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/GroovyBundle", GreclipseConfigurable.class).getString("configurable.greclipse.path.label"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myJarPath = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton.setText("");
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 7, 0, null, new Dimension(150, -1), null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/GroovyBundle", GreclipseConfigurable.class).getString("configurable.greclipse.command.line.params.label"));
        jPanel.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myCmdLineParams = rawCommandLineEditor = new RawCommandLineEditor();
        jPanel.add((Component)rawCommandLineEditor, new GridConstraints(1, 1, 1, 1, 0, 1, 7, 0, null, null, null));
        this.myGenerateDebugInfo = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/GroovyBundle", GreclipseConfigurable.class).getString("configurable.greclipse.debug.checkbox"));
        jPanel.add((Component)jBCheckBox, new GridConstraints(2, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ Font $$$getFont$$$(String string, int n, int n2, Font font) {
        Font font2;
        if (font == null) {
            return null;
        }
        String string2 = string == null ? font.getName() : ((font2 = new Font(string, 0, 10)).canDisplay('a') && font2.canDisplay('1') ? string : font.getName());
        Font font3 = new Font(string2, n >= 0 ? n : font.getStyle(), n2 >= 0 ? n2 : font.getSize());
        boolean bl = System.getProperty("os.name", "").toLowerCase(Locale.ENGLISH).startsWith("mac");
        Font font4 = bl ? new Font(font3.getFamily(), font3.getStyle(), font3.getSize()) : new StyleContext().getFont(font3.getFamily(), font3.getStyle(), font3.getSize());
        return font4 instanceof FontUIResource ? font4 : new FontUIResource(font4);
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

