/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeStyle;

import com.intellij.application.options.CodeStyle;
import com.intellij.configurationStore.Property;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.codeStyle.ImportsLayoutSettings;
import com.intellij.psi.codeStyle.PackageEntry;
import com.intellij.psi.codeStyle.PackageEntryTable;
import org.jetbrains.annotations.NotNull;

public class GroovyCodeStyleSettings
extends CustomCodeStyleSettings
implements ImportsLayoutSettings {
    public int STATIC_FIELDS_ORDER_WEIGHT = 1;
    public int FIELDS_ORDER_WEIGHT = 2;
    public int CONSTRUCTORS_ORDER_WEIGHT = 3;
    public int STATIC_METHODS_ORDER_WEIGHT = 4;
    public int METHODS_ORDER_WEIGHT = 5;
    public int STATIC_INNER_CLASSES_ORDER_WEIGHT = 6;
    public int INNER_CLASSES_ORDER_WEIGHT = 7;
    public boolean USE_FLYING_GEESE_BRACES = false;
    public boolean SPACE_IN_NAMED_ARGUMENT_BEFORE_COLON = false;
    public boolean SPACE_IN_NAMED_ARGUMENT = true;
    public boolean ALIGN_MULTILINE_LIST_OR_MAP = true;
    public boolean SPACE_WITHIN_LIST_OR_MAP = false;
    public boolean ALIGN_NAMED_ARGS_IN_MAP = true;
    @Property(externalName="space_before_closure_left_brace")
    public boolean SPACE_BEFORE_CLOSURE_LBRACE = true;
    public boolean SPACE_WITHIN_GSTRING_INJECTION_BRACES = false;
    public boolean SPACE_WITHIN_TUPLE_EXPRESSION = false;
    public boolean INDENT_LABEL_BLOCKS = true;
    public boolean SPACE_AROUND_REGEX_OPERATORS = true;
    public boolean SPACE_BEFORE_ASSERT_SEPARATOR = false;
    public boolean SPACE_AFTER_ASSERT_SEPARATOR = true;
    public boolean USE_FQ_CLASS_NAMES = false;
    public boolean USE_FQ_CLASS_NAMES_IN_JAVADOC = true;
    public boolean USE_SINGLE_CLASS_IMPORTS = true;
    public boolean INSERT_INNER_CLASS_IMPORTS = false;
    public int CLASS_COUNT_TO_USE_IMPORT_ON_DEMAND = 5;
    public int NAMES_COUNT_TO_USE_IMPORT_ON_DEMAND = 3;
    public final PackageEntryTable PACKAGES_TO_USE_IMPORT_ON_DEMAND = new PackageEntryTable();
    @Property(externalName="imports_layout")
    public PackageEntryTable IMPORT_LAYOUT_TABLE = new PackageEntryTable();
    public boolean LAYOUT_STATIC_IMPORTS_SEPARATELY = true;
    public int IMPORT_ANNOTATION_WRAP = 2;

    private void initImportsByDefault() {
        this.PACKAGES_TO_USE_IMPORT_ON_DEMAND.addEntry(new PackageEntry(false, "java.awt", false));
        this.PACKAGES_TO_USE_IMPORT_ON_DEMAND.addEntry(new PackageEntry(false, "javax.swing", false));
        this.IMPORT_LAYOUT_TABLE.addEntry(PackageEntry.ALL_OTHER_IMPORTS_ENTRY);
        this.IMPORT_LAYOUT_TABLE.addEntry(PackageEntry.BLANK_LINE_ENTRY);
        this.IMPORT_LAYOUT_TABLE.addEntry(new PackageEntry(false, "javax", true));
        this.IMPORT_LAYOUT_TABLE.addEntry(new PackageEntry(false, "java", true));
        this.IMPORT_LAYOUT_TABLE.addEntry(PackageEntry.BLANK_LINE_ENTRY);
        this.IMPORT_LAYOUT_TABLE.addEntry(PackageEntry.ALL_OTHER_STATIC_IMPORTS_ENTRY);
    }

    public GroovyCodeStyleSettings(CodeStyleSettings container) {
        super("GroovyCodeStyleSettings", container);
        this.initImportsByDefault();
    }

    public int getNamesCountToUseImportOnDemand() {
        return this.NAMES_COUNT_TO_USE_IMPORT_ON_DEMAND;
    }

    public void setNamesCountToUseImportOnDemand(int value) {
        this.NAMES_COUNT_TO_USE_IMPORT_ON_DEMAND = value;
    }

    public int getClassCountToUseImportOnDemand() {
        return this.CLASS_COUNT_TO_USE_IMPORT_ON_DEMAND;
    }

    public void setClassCountToUseImportOnDemand(int value) {
        this.CLASS_COUNT_TO_USE_IMPORT_ON_DEMAND = value;
    }

    public boolean isInsertInnerClassImports() {
        return this.INSERT_INNER_CLASS_IMPORTS;
    }

    public void setInsertInnerClassImports(boolean value) {
        this.INSERT_INNER_CLASS_IMPORTS = value;
    }

    public boolean isUseSingleClassImports() {
        return this.USE_SINGLE_CLASS_IMPORTS;
    }

    public void setUseSingleClassImports(boolean value) {
        this.USE_SINGLE_CLASS_IMPORTS = value;
    }

    public boolean isUseFqClassNames() {
        return this.USE_FQ_CLASS_NAMES;
    }

    public void setUseFqClassNames(boolean value) {
        this.USE_FQ_CLASS_NAMES = value;
    }

    public PackageEntryTable getImportLayoutTable() {
        return this.IMPORT_LAYOUT_TABLE;
    }

    public PackageEntryTable getPackagesToUseImportOnDemand() {
        return this.PACKAGES_TO_USE_IMPORT_ON_DEMAND;
    }

    public boolean isLayoutStaticImportsSeparately() {
        return this.LAYOUT_STATIC_IMPORTS_SEPARATELY;
    }

    public void setLayoutStaticImportsSeparately(boolean value) {
        this.LAYOUT_STATIC_IMPORTS_SEPARATELY = value;
    }

    protected void importLegacySettings(@NotNull CodeStyleSettings rootSettings) {
        if (rootSettings == null) {
            GroovyCodeStyleSettings.$$$reportNull$$$0(0);
        }
        this.STATIC_FIELDS_ORDER_WEIGHT = rootSettings.STATIC_FIELDS_ORDER_WEIGHT;
        this.FIELDS_ORDER_WEIGHT = rootSettings.FIELDS_ORDER_WEIGHT;
        this.CONSTRUCTORS_ORDER_WEIGHT = rootSettings.CONSTRUCTORS_ORDER_WEIGHT;
        this.STATIC_METHODS_ORDER_WEIGHT = rootSettings.STATIC_METHODS_ORDER_WEIGHT;
        this.METHODS_ORDER_WEIGHT = rootSettings.METHODS_ORDER_WEIGHT;
        this.STATIC_INNER_CLASSES_ORDER_WEIGHT = rootSettings.STATIC_INNER_CLASSES_ORDER_WEIGHT;
        this.INNER_CLASSES_ORDER_WEIGHT = rootSettings.INNER_CLASSES_ORDER_WEIGHT;
    }

    @NotNull
    public static GroovyCodeStyleSettings getInstance(@NotNull PsiFile file) {
        if (file == null) {
            GroovyCodeStyleSettings.$$$reportNull$$$0(1);
        }
        GroovyCodeStyleSettings groovyCodeStyleSettings = (GroovyCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)file, GroovyCodeStyleSettings.class);
        if (groovyCodeStyleSettings == null) {
            GroovyCodeStyleSettings.$$$reportNull$$$0(2);
        }
        return groovyCodeStyleSettings;
    }

    @NotNull
    public static GroovyCodeStyleSettings getInstance(@NotNull Editor editor) {
        if (editor == null) {
            GroovyCodeStyleSettings.$$$reportNull$$$0(3);
        }
        GroovyCodeStyleSettings groovyCodeStyleSettings = (GroovyCodeStyleSettings)CodeStyle.getSettings((Editor)editor).getCustomSettings(GroovyCodeStyleSettings.class);
        if (groovyCodeStyleSettings == null) {
            GroovyCodeStyleSettings.$$$reportNull$$$0(4);
        }
        return groovyCodeStyleSettings;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootSettings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/codeStyle/GroovyCodeStyleSettings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/codeStyle/GroovyCodeStyleSettings";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "importLegacySettings";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

