/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.confusing;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntheticElement;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyQuickFixFactory;
import org.jetbrains.plugins.groovy.lang.psi.GrNamedElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.GrTopStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.packaging.GrPackageDefinition;
import org.jetbrains.plugins.groovy.lang.resolve.ExpectedPackageNameProviderKt;

public class GrPackageInspection
extends BaseInspection {
    public boolean myCheckScripts = true;

    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return GroovyBundle.message("inspection.message.package.name.mismatch", new Object[0]);
    }

    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        optionsPanel.addCheckbox(GroovyBundle.message("gr.package.inspection.check.scripts", new Object[0]), "myCheckScripts");
        return optionsPanel;
    }

    @Override
    @NotNull
    protected BaseInspectionVisitor buildVisitor() {
        return new BaseInspectionVisitor(){

            @Override
            public void visitFile(@NotNull GroovyFileBase file) {
                String actual;
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!(file instanceof GroovyFile)) {
                    return;
                }
                if (!GrPackageInspection.this.myCheckScripts && file.isScript()) {
                    return;
                }
                String expectedPackage = ExpectedPackageNameProviderKt.inferExpectedPackageName((GroovyFile)file);
                if (!expectedPackage.equals(actual = file.getPackageName())) {
                    PsiElement toHighlight = GrPackageInspection.getElementToHighlight((GroovyFile)file);
                    if (toHighlight == null) {
                        return;
                    }
                    this.registerError(toHighlight, GroovyBundle.message("inspection.message.package.name.mismatch.actual.0.expected.1", actual, expectedPackage), new LocalQuickFix[]{new ChangePackageQuickFix(expectedPackage), GroovyQuickFixFactory.getInstance().createGrMoveToDirFix(actual)}, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/groovy/codeInspection/confusing/GrPackageInspection$1", "visitFile"));
            }
        };
    }

    @Nullable
    private static PsiElement getElementToHighlight(GroovyFile file) {
        PsiClass[] classes2;
        GrPackageDefinition packageDefinition = file.getPackageDefinition();
        if (packageDefinition != null) {
            return packageDefinition;
        }
        for (PsiClass aClass : classes2 = file.getClasses()) {
            if (aClass instanceof SyntheticElement || !(aClass instanceof GrTypeDefinition)) continue;
            return ((GrTypeDefinition)aClass).getNameIdentifierGroovy();
        }
        GrTopStatement[] statements2 = file.getTopStatements();
        if (statements2.length > 0) {
            GrTopStatement first = statements2[0];
            if (first instanceof GrNamedElement) {
                return ((GrNamedElement)((Object)first)).getNameIdentifierGroovy();
            }
            return first;
        }
        return null;
    }

    public static class ChangePackageQuickFix
    implements LocalQuickFix {
        private final String myNewPackageName;

        public ChangePackageQuickFix(String newPackageName) {
            this.myNewPackageName = newPackageName;
        }

        @NotNull
        public String getFamilyName() {
            String string = GroovyBundle.message("fix.package.name", new Object[0]);
            if (string == null) {
                ChangePackageQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                ChangePackageQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                ChangePackageQuickFix.$$$reportNull$$$0(2);
            }
            PsiFile file = descriptor.getPsiElement().getContainingFile();
            ((GroovyFile)file).setPackageName(this.myNewPackageName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/groovy/codeInspection/confusing/GrPackageInspection$ChangePackageQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/confusing/GrPackageInspection$ChangePackageQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

