/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInsight;

import com.intellij.codeInsight.daemon.DaemonBundle;
import com.intellij.codeInsight.daemon.impl.GutterIconTooltipHelper;
import com.intellij.codeInsight.daemon.impl.LineMarkerNavigator;
import com.intellij.codeInsight.daemon.impl.MarkerType;
import com.intellij.codeInsight.daemon.impl.PsiElementListNavigator;
import com.intellij.codeInsight.navigation.BackgroundUpdaterTask;
import com.intellij.ide.util.MethodCellRenderer;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadActionProcessor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.presentation.java.ClassPresentationUtil;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.PsiElementProcessorAdapter;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import gnu.trove.THashSet;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrReflectedMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrTraitMethod;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;

public final class GroovyMarkerTypes {
    static final MarkerType OVERRIDING_PROPERTY_TYPE = new MarkerType("OVERRIDING_PROPERTY_TYPE", psiElement -> {
        PsiElement parent2 = psiElement.getParent();
        if (!(parent2 instanceof GrField)) {
            return null;
        }
        GrField field = (GrField)parent2;
        List<GrAccessorMethod> accessors = GroovyPropertyUtils.getFieldAccessors(field);
        StringBuilder builder = new StringBuilder();
        builder.append("<html><body>");
        int count = 0;
        String sep = "";
        for (GrAccessorMethod method : accessors) {
            PsiMethod[] superMethods = method.findSuperMethods(false);
            count += superMethods.length;
            if (superMethods.length == 0) continue;
            PsiMethod superMethod = superMethods[0];
            boolean isAbstract = method.hasModifierProperty("abstract");
            boolean isSuperAbstract = superMethod.hasModifierProperty("abstract");
            @NonNls String key = isSuperAbstract && !isAbstract ? "method.implements.in" : "method.overrides.in";
            builder.append(sep);
            sep = "<br>";
            GroovyMarkerTypes.composeText((PsiElement[])superMethods, DaemonBundle.message((String)key, (Object[])new Object[0]), builder);
        }
        if (count == 0) {
            return null;
        }
        builder.append("</html></body>");
        return builder.toString();
    }, new LineMarkerNavigator(){

        public void browse(MouseEvent e, PsiElement element) {
            PsiElement parent2 = element.getParent();
            if (!(parent2 instanceof GrField)) {
                return;
            }
            GrField field = (GrField)parent2;
            List<GrAccessorMethod> accessors = GroovyPropertyUtils.getFieldAccessors(field);
            ArrayList superMethods = new ArrayList();
            for (GrAccessorMethod method : accessors) {
                Collections.addAll(superMethods, method.findSuperMethods(false));
            }
            if (superMethods.isEmpty()) {
                return;
            }
            PsiMethod[] supers = superMethods.toArray(PsiMethod.EMPTY_ARRAY);
            boolean showMethodNames = !PsiUtil.allMethodsHaveSameSignature((PsiMethod[])supers);
            PsiElementListNavigator.openTargets((MouseEvent)e, (NavigatablePsiElement[])supers, (String)DaemonBundle.message((String)"navigation.title.super.method", (Object[])new Object[]{field.getName()}), (String)DaemonBundle.message((String)"navigation.findUsages.title.super.method", (Object[])new Object[]{field.getName()}), (ListCellRenderer)new MethodCellRenderer(showMethodNames));
        }
    });
    static final MarkerType OVERRIDEN_PROPERTY_TYPE = new MarkerType("OVERRIDEN_PROPERTY_TYPE", element -> {
        PsiElement parent2 = element.getParent();
        if (!(parent2 instanceof GrField)) {
            return null;
        }
        List<GrAccessorMethod> accessors = GroovyPropertyUtils.getFieldAccessors((GrField)parent2);
        PsiElementProcessor.CollectElementsWithLimit processor = new PsiElementProcessor.CollectElementsWithLimit(5);
        for (GrAccessorMethod method : accessors) {
            OverridingMethodsSearch.search((PsiMethod)method).forEach((Processor)new PsiElementProcessorAdapter((PsiElementProcessor)processor));
        }
        if (processor.isOverflow()) {
            return DaemonBundle.message((String)"method.is.overridden.too.many", (Object[])new Object[0]);
        }
        PsiMethod[] overridings = (PsiMethod[])processor.toArray((PsiElement[])new PsiMethod[processor.getCollection().size()]);
        if (overridings.length == 0) {
            return null;
        }
        Comparator comparator2 = new MethodCellRenderer(false).getComparator();
        Arrays.sort(overridings, comparator2);
        String start = DaemonBundle.message((String)"method.is.overriden.header", (Object[])new Object[0]);
        String pattern = "&nbsp;&nbsp;&nbsp;&nbsp;{1}";
        return GutterIconTooltipHelper.composeText((PsiElement[])overridings, (String)start, (String)pattern);
    }, new LineMarkerNavigator(){

        public void browse(MouseEvent e, PsiElement element) {
            PsiElement parent2 = element.getParent();
            if (!(parent2 instanceof GrField)) {
                return;
            }
            if (DumbService.isDumb((Project)element.getProject())) {
                DumbService.getInstance((Project)element.getProject()).showDumbModeNotification(GroovyBundle.message("popup.content.navigation.to.overriding.classes.unavailable", new Object[0]));
                return;
            }
            GrField field = (GrField)parent2;
            THashSet result2 = new THashSet();
            Processor collectProcessor = Processors.cancelableCollectProcessor((Collection)result2);
            if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ApplicationManager.getApplication().runReadAction(() -> {
                for (GrAccessorMethod method : GroovyPropertyUtils.getFieldAccessors(field)) {
                    OverridingMethodsSearch.search((PsiMethod)method).forEach(collectProcessor);
                }
            }), JavaAnalysisBundle.message((String)"searching.for.overriding.methods", (Object[])new Object[0]), true, field.getProject(), (JComponent)e.getComponent())) {
                return;
            }
            PsiMethod[] overridings = result2.toArray(PsiMethod.EMPTY_ARRAY);
            if (overridings.length == 0) {
                return;
            }
            String title = DaemonBundle.message((String)"navigation.title.overrider.method", (Object[])new Object[]{field.getName(), overridings.length});
            boolean showMethodNames = !PsiUtil.allMethodsHaveSameSignature((PsiMethod[])overridings);
            MethodCellRenderer renderer = new MethodCellRenderer(showMethodNames);
            Arrays.sort(overridings, renderer.getComparator());
            PsiElementListNavigator.openTargets((MouseEvent)e, (NavigatablePsiElement[])overridings, (String)title, (String)GroovyBundle.message("overriding.methods.of.0", field.getName()), (ListCellRenderer)renderer);
        }
    });
    public static final MarkerType GR_OVERRIDING_METHOD = new MarkerType("GR_OVERRIDING_METHOD", (Function)((NullableFunction)element -> {
        PsiElement parent2 = element.getParent();
        if (!(parent2 instanceof GrMethod)) {
            return null;
        }
        GrMethod method = (GrMethod)parent2;
        Set<PsiMethod> superMethods = GroovyMarkerTypes.collectSuperMethods(method);
        if (superMethods.isEmpty()) {
            return null;
        }
        PsiMethod superMethod = superMethods.iterator().next();
        boolean isAbstract = method.hasModifierProperty("abstract");
        boolean isSuperAbstract = superMethod.hasModifierProperty("abstract");
        boolean sameSignature = superMethod.getSignature(PsiSubstitutor.EMPTY).equals(method.getSignature(PsiSubstitutor.EMPTY));
        String key = isSuperAbstract && !isAbstract ? (sameSignature ? "method.implements" : "method.implements.in") : (sameSignature ? "method.overrides" : "method.overrides.in");
        return GutterIconTooltipHelper.composeText(superMethods, (String)"", (String)DaemonBundle.message((String)key, (Object[])new Object[0]));
    }), new LineMarkerNavigator(){

        public void browse(MouseEvent e, PsiElement element) {
            PsiElement parent2 = element.getParent();
            if (!(parent2 instanceof GrMethod)) {
                return;
            }
            GrMethod method = (GrMethod)parent2;
            Set<PsiMethod> superMethods = GroovyMarkerTypes.collectSuperMethods(method);
            if (superMethods.isEmpty()) {
                return;
            }
            PsiElementListNavigator.openTargets((MouseEvent)e, (NavigatablePsiElement[])superMethods.toArray(PsiMethod.EMPTY_ARRAY), (String)DaemonBundle.message((String)"navigation.title.super.method", (Object[])new Object[]{method.getName()}), (String)DaemonBundle.message((String)"navigation.findUsages.title.super.method", (Object[])new Object[]{method.getName()}), (ListCellRenderer)new MethodCellRenderer(true));
        }
    });
    public static final MarkerType GR_OVERRIDDEN_METHOD = new MarkerType("GR_OVERRIDEN_METHOD", (Function)((NullableFunction)element -> {
        PsiElement parent2 = element.getParent();
        if (!(parent2 instanceof GrMethod)) {
            return null;
        }
        GrMethod method = (GrMethod)parent2;
        final PsiElementProcessor.CollectElementsWithLimit processor = new PsiElementProcessor.CollectElementsWithLimit(5);
        for (GrMethod m : org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil.getMethodOrReflectedMethods(method)) {
            OverridingMethodsSearch.search((PsiMethod)m).forEach((Processor)new ReadActionProcessor<PsiMethod>(){

                public boolean processInReadAction(PsiMethod method) {
                    if (method instanceof GrTraitMethod) {
                        return true;
                    }
                    return processor.execute((PsiElement)method);
                }
            });
        }
        boolean isAbstract = method.hasModifierProperty("abstract");
        if (processor.isOverflow()) {
            return isAbstract ? DaemonBundle.message((String)"method.is.implemented.too.many", (Object[])new Object[0]) : DaemonBundle.message((String)"method.is.overridden.too.many", (Object[])new Object[0]);
        }
        PsiMethod[] overridings = (PsiMethod[])processor.toArray((PsiElement[])new PsiMethod[processor.getCollection().size()]);
        if (overridings.length == 0) {
            return null;
        }
        Comparator comparator2 = new MethodCellRenderer(false).getComparator();
        Arrays.sort(overridings, comparator2);
        String start = isAbstract ? DaemonBundle.message((String)"method.is.implemented.header", (Object[])new Object[0]) : DaemonBundle.message((String)"method.is.overriden.header", (Object[])new Object[0]);
        String pattern = "&nbsp;&nbsp;&nbsp;&nbsp;{1}";
        return GutterIconTooltipHelper.composeText((PsiElement[])overridings, (String)start, (String)pattern);
    }), new LineMarkerNavigator(){

        public void browse(MouseEvent e, PsiElement element) {
            PsiElement parent2 = element.getParent();
            if (!(parent2 instanceof GrMethod)) {
                return;
            }
            if (DumbService.isDumb((Project)element.getProject())) {
                DumbService.getInstance((Project)element.getProject()).showDumbModeNotification(GroovyBundle.message("popup.content.navigation.to.overriding.classes.unavailable", new Object[0]));
                return;
            }
            GrMethod method = (GrMethod)parent2;
            final PsiElementProcessor.CollectElementsWithLimit collectProcessor = new PsiElementProcessor.CollectElementsWithLimit(2, (Collection)new THashSet());
            if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ApplicationManager.getApplication().runReadAction(() -> {
                for (GrMethod m : org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil.getMethodOrReflectedMethods(method)) {
                    OverridingMethodsSearch.search((PsiMethod)m).forEach((Processor)new ReadActionProcessor<PsiMethod>(){

                        public boolean processInReadAction(PsiMethod psiMethod) {
                            if (psiMethod instanceof GrReflectedMethod) {
                                psiMethod = ((GrReflectedMethod)psiMethod).getBaseMethod();
                            }
                            return collectProcessor.execute((PsiElement)psiMethod);
                        }
                    });
                }
            }), JavaAnalysisBundle.message((String)"searching.for.overriding.methods", (Object[])new Object[0]), true, method.getProject(), (JComponent)e.getComponent())) {
                return;
            }
            PsiMethod[] overridings = (PsiMethod[])collectProcessor.toArray((PsiElement[])PsiMethod.EMPTY_ARRAY);
            if (overridings.length == 0) {
                return;
            }
            MethodCellRenderer renderer = new MethodCellRenderer(!PsiUtil.allMethodsHaveSameSignature((PsiMethod[])overridings));
            Arrays.sort(overridings, renderer.getComparator());
            OverridingMethodsUpdater methodsUpdater = new OverridingMethodsUpdater(method, (PsiElementListCellRenderer)renderer);
            PsiElementListNavigator.openTargets((MouseEvent)e, (NavigatablePsiElement[])overridings, (String)methodsUpdater.getCaption(overridings.length), (String)GroovyBundle.message("overriding.methods.of.0", method.getName()), (ListCellRenderer)renderer, (BackgroundUpdaterTask)methodsUpdater);
        }
    });

    private GroovyMarkerTypes() {
    }

    private static Set<PsiMethod> collectSuperMethods(GrMethod method) {
        HashSet<PsiMethod> superMethods = new HashSet<PsiMethod>();
        for (GrMethod m : org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil.getMethodOrReflectedMethods(method)) {
            for (PsiMethod superMethod : m.findSuperMethods(false)) {
                if (superMethod instanceof GrReflectedMethod) {
                    superMethod = ((GrReflectedMethod)superMethod).getBaseMethod();
                }
                superMethods.add(superMethod);
            }
        }
        return superMethods;
    }

    private static StringBuilder composeText(PsiElement @NotNull [] elements, String pattern, StringBuilder result2) {
        if (elements == null) {
            GroovyMarkerTypes.$$$reportNull$$$0(0);
        }
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        for (PsiElement element : elements) {
            String methodName = ((PsiMethod)element).getName();
            PsiClass aClass = ((PsiMethod)element).getContainingClass();
            String className = aClass == null ? "" : ClassPresentationUtil.getNameForClass((PsiClass)aClass, (boolean)true);
            names.add(MessageFormat.format(pattern, methodName, className));
        }
        @NonNls String sep = "";
        for (String name : names) {
            result2.append(sep);
            sep = "<br>";
            result2.append(name);
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "org/jetbrains/plugins/groovy/codeInsight/GroovyMarkerTypes", "composeText"));
    }

    private static class OverridingMethodsUpdater
    extends BackgroundUpdaterTask {
        private final GrMethod myMethod;

        OverridingMethodsUpdater(GrMethod method, PsiElementListCellRenderer renderer) {
            super(method.getProject(), JavaAnalysisBundle.message((String)"searching.for.overriding.methods", (Object[])new Object[0]), OverridingMethodsUpdater.createComparatorWrapper((Comparator)renderer.getComparator()));
            this.myMethod = method;
        }

        @Nls
        public String getCaption(int size) {
            return this.myMethod.hasModifierProperty("abstract") ? DaemonBundle.message((String)"navigation.title.implementation.method", (Object[])new Object[]{this.myMethod.getName(), size}) : DaemonBundle.message((String)"navigation.title.overrider.method", (Object[])new Object[]{this.myMethod.getName(), size});
        }

        public void run(final @NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                OverridingMethodsUpdater.$$$reportNull$$$0(0);
            }
            super.run(indicator);
            for (GrMethod method : org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil.getMethodOrReflectedMethods(this.myMethod)) {
                OverridingMethodsSearch.search((PsiMethod)method).forEach((Processor)new CommonProcessors.CollectProcessor<PsiMethod>(){

                    public boolean process(PsiMethod psiMethod) {
                        if (!this.updateComponent(PsiImplUtil.handleMirror((PsiElement)psiMethod))) {
                            indicator.cancel();
                        }
                        indicator.checkCanceled();
                        return true;
                    }
                });
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/groovy/codeInsight/GroovyMarkerTypes$OverridingMethodsUpdater", "run"));
        }
    }
}

